/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class TestStatsTab
extends BaseProcedureTab {
    private static final double MINLIMIT_SIG_LEVEL = 0.0;
    private static final double MAXLIMIT_SIG_LEVEL = 1.0;
    private static final double DEFAULT_SIG_LEVEL = 0.05;
    private static int MAXLIMIT_CHECKBOX = 270;
    private static final String CHI_SIGLEVEL_KEY = "chi_square_sig_key";
    private static final String COLUMN_SIGLEVEL1_KEY = "column_sig1_key";
    private static final String COLUMN_SIGLEVEL2_KEY = "column_sig2_key";
    private JCheckBox mTTestsCheck;
    private JCheckBox mZTestsCheck;
    private SpssMultiLineCheckBox mTTestsEstimateCheck;
    private JCheckBox mColumnAdjustCheck;
    private JCheckBox mChiSquareCheck;
    private FloatTextField mColumnSigLevelField1;
    private FloatTextField mColumnSigLevelField2;
    private JRadioButton mInSeparateTblRadio;
    private JRadioButton mInMainTblRadio;
    private JCheckBox mDisplaySigCheck;
    private JCheckBox mUseAPACheck;
    private JRadioButton mBonfRadio;
    private JRadioButton mBenjRadio;
    private SpssButtonGroup mSigGroup;
    private SpssButtonGroup mAdjustGroup;
    private FloatTextField mChiSquareSigLevelField;
    private JCheckBox mUseSubtotalsCheck;
    private JCheckBox mIncludeMultiCheck;
    private JLabel mChiSquareSigLevelLabel;
    private JLabel mColumnSigLevelLabel;
    private JTextArea[] mInfoArea;

    public TestStatsTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_table_sig_tests";
    }

    @Override
    public void reset() {
        super.reset();
        double d = 0.05;
        this.mColumnSigLevelField1.setText(String.valueOf(d));
        this.mColumnSigLevelField2.setText("");
        this.mChiSquareCheck.setSelected(false);
        this.mChiSquareSigLevelField.setText(String.valueOf(d));
        this.mTTestsCheck.setSelected(false);
        this.mColumnAdjustCheck.setSelected(true);
        this.mTTestsEstimateCheck.setSelected(false);
        this.mZTestsCheck.setSelected(false);
        this.mUseSubtotalsCheck.setSelected(false);
        this.mIncludeMultiCheck.setSelected(true);
        this.mChiSquareSigLevelLabel.setEnabled(false);
        this.mChiSquareSigLevelField.setEnabled(false);
        this.mTTestsEstimateCheck.setEnabled(false);
        this.mSigGroup.setSelected(this.mInSeparateTblRadio.getModel(), true);
        this.mInSeparateTblRadio.setEnabled(false);
        this.mInMainTblRadio.setEnabled(false);
        this.mDisplaySigCheck.setEnabled(false);
        this.mDisplaySigCheck.setSelected(false);
        this.mUseAPACheck.setEnabled(false);
        this.mUseAPACheck.setSelected(false);
        this.mColumnSigLevelLabel.setEnabled(false);
        this.mColumnSigLevelField1.setEnabled(false);
        this.mColumnSigLevelField2.setEnabled(false);
        this.mTTestsEstimateCheck.setEnabled(false);
        this.mColumnAdjustCheck.setEnabled(false);
        this.setEnableForAdjustGroup(false);
        this.mAdjustGroup.setSelected(this.mBonfRadio.getModel(), true);
    }

    @Override
    public boolean validateTab() {
        boolean bl = true;
        if (this.mColumnSigLevelField1.isEnabled()) {
            bl = this.mColumnSigLevelField1.checkRange(true);
        }
        if (this.mColumnSigLevelField2.isEnabled()) {
            bl = this.mColumnSigLevelField2.checkRange(false);
        }
        if (bl && this.mChiSquareSigLevelField.isEnabled()) {
            bl = this.mChiSquareSigLevelField.checkRange(true);
        }
        if (bl && this.mColumnSigLevelField1.isEnabled() && this.mColumnSigLevelField2.isEnabled() && this.mColumnSigLevelField2.getText().length() > 0) {
            bl = this.checkTwoSigEqual();
        }
        return bl;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString(CHI_SIGLEVEL_KEY, this.mChiSquareSigLevelField.getText());
        dialogDataModel.putString(COLUMN_SIGLEVEL1_KEY, this.mColumnSigLevelField1.getText());
        dialogDataModel.putString(COLUMN_SIGLEVEL2_KEY, this.mColumnSigLevelField2.getText());
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        if (dialogDataModel.getString(CHI_SIGLEVEL_KEY) != null || dialogDataModel.getString(COLUMN_SIGLEVEL1_KEY) != null) {
            this.mChiSquareSigLevelField.setText(dialogDataModel.getString(CHI_SIGLEVEL_KEY));
            this.mColumnSigLevelField1.setText(dialogDataModel.getString(COLUMN_SIGLEVEL1_KEY));
            this.mColumnSigLevelField2.setText(dialogDataModel.getString(COLUMN_SIGLEVEL2_KEY));
        }
        if (this.mChiSquareCheck.isSelected()) {
            this.mChiSquareCheck.getAction().actionPerformed(new ActionEvent(this.mChiSquareCheck, 1, ""));
        }
        if (this.mTTestsCheck.isSelected()) {
            this.mTTestsCheck.getAction().actionPerformed(new ActionEvent(this.mTTestsCheck, 1, ""));
        }
        if (this.mZTestsCheck.isSelected()) {
            this.mZTestsCheck.getAction().actionPerformed(new ActionEvent(this.mZTestsCheck, 1, ""));
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupTestPanel();
        this.setupInfoPanel();
        this.setFocusTraversalPolicy();
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        if (this.mChiSquareCheck.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SIGTEST TYPE=CHISQUARE ALPHA="));
            stringBuffer.append(this.mChiSquareSigLevelField.getText());
            stringBuffer.append(" INCLUDEMRSETS=");
            stringBuffer.append(this.mIncludeMultiCheck.isSelected() ? "YES" : "NO");
            stringBuffer.append(" CATEGORIES=");
            stringBuffer.append(this.mUseSubtotalsCheck.isSelected() ? "SUBTOTALS" : "ALLVISIBLE");
        }
        if (this.mTTestsCheck.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COMPARETEST TYPE=MEAN ALPHA="));
            stringBuffer.append(this.getAlphaSyntaxValue());
            stringBuffer.append(" ADJUST=");
            if (this.mColumnAdjustCheck.isSelected()) {
                stringBuffer.append(this.mBonfRadio.isSelected() ? "BONFERRONI" : "BH");
            } else {
                stringBuffer.append("NONE");
            }
            stringBuffer.append(" ORIGIN=COLUMN");
            stringBuffer.append(" INCLUDEMRSETS=");
            stringBuffer.append(this.mIncludeMultiCheck.isSelected() ? "YES" : "NO");
            stringBuffer.append(" CATEGORIES=");
            stringBuffer.append(this.mUseSubtotalsCheck.isSelected() ? "SUBTOTALS" : "ALLVISIBLE");
            stringBuffer.append(" MEANSVARIANCE=");
            stringBuffer.append(this.mTTestsEstimateCheck.isSelected() ? "TESTEDCATS" : "ALLCATS");
            stringBuffer.append(" MERGE=");
            stringBuffer.append(this.mInSeparateTblRadio.isSelected() ? "NO" : "YES");
            if (this.mInMainTblRadio.isSelected()) {
                stringBuffer.append(" STYLE=").append(this.mUseAPACheck.isSelected() ? "APA" : "SIMPLE");
            }
            stringBuffer.append(" SHOWSIG=");
            stringBuffer.append(this.mDisplaySigCheck.isEnabled() && this.mDisplaySigCheck.isSelected() ? "YES" : "NO");
        }
        if (this.mZTestsCheck.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/COMPARETEST TYPE=PROP ALPHA="));
            stringBuffer.append(this.getAlphaSyntaxValue());
            stringBuffer.append(" ADJUST=");
            if (this.mColumnAdjustCheck.isSelected()) {
                stringBuffer.append(this.mBonfRadio.isSelected() ? "BONFERRONI" : "BH");
            } else {
                stringBuffer.append("NONE");
            }
            stringBuffer.append(" ORIGIN=COLUMN");
            stringBuffer.append(" INCLUDEMRSETS=");
            stringBuffer.append(this.mIncludeMultiCheck.isSelected() ? "YES" : "NO");
            stringBuffer.append(" CATEGORIES=");
            stringBuffer.append(this.mUseSubtotalsCheck.isSelected() ? "SUBTOTALS" : "ALLVISIBLE");
            stringBuffer.append(" MERGE=");
            stringBuffer.append(this.mInSeparateTblRadio.isSelected() ? "NO" : "YES");
            if (this.mInMainTblRadio.isSelected()) {
                stringBuffer.append(" STYLE=").append(this.mUseAPACheck.isSelected() ? "APA" : "SIMPLE");
            }
            stringBuffer.append(" SHOWSIG=");
            stringBuffer.append(this.mDisplaySigCheck.isEnabled() && this.mDisplaySigCheck.isSelected() ? "YES" : "NO");
        }
    }

    private String getAlphaSyntaxValue() {
        String string = null;
        String string2 = this.mColumnSigLevelField1.getText();
        String string3 = null;
        if (this.mColumnSigLevelField2.isEnabled()) {
            string3 = this.mColumnSigLevelField2.getText();
        }
        if (string2.length() > 0) {
            string = string3 != null && string3.length() > 0 ? string2 + "," + string3 : string2;
        }
        return string;
    }

    private void setupTestPanel() {
        JPanel jPanel = this.setupTopPanel();
        JPanel jPanel2 = this.setChiSquarePanel();
        this.mUseSubtotalsCheck = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_USE_SUBTOTALS_CHECK"));
        this.mIncludeMultiCheck = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_INCLUDE_MULTI_CHECK"));
        this.mIncludeMultiCheck.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = this.isSmallScreen() ? new Insets(n2, insets.left, insets.bottom, insets.right) : new Insets(n2 * 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mUseSubtotalsCheck, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mIncludeMultiCheck, gridBagConstraints, 0, 5, 2, 1, n, insets2);
        insets2 = new Insets(n2, insets.left, n2, 0);
        DialogUtil.addUsingGBL(this, new JSeparator(), gridBagConstraints, 0, 3, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(this, new JSeparator(), gridBagConstraints, 0, 6, 2, 1, n, insets2);
    }

    private JPanel setupTopPanel() {
        this.mColumnSigLevelLabel = DialogUtil.createLabel(this.mParent, "IDS_SIG_LEVEL", 0);
        this.mColumnSigLevelField1 = new FloatTextField(0.0, 1.0, 2, true){

            public void focusLost(FocusEvent focusEvent) {
                TestStatsTab.this.setEnableForSigLevelField2();
                super.focusLost(focusEvent);
            }
        };
        this.mColumnSigLevelField1.setIncludeMinRange(false);
        this.mColumnSigLevelField1.setIncludeMaxRange(false);
        this.mColumnSigLevelLabel.setLabelFor((Component)this.mColumnSigLevelField1);
        this.mColumnSigLevelField2 = new FloatTextField(0.0, 1.0, 2, true){

            public void focusLost(FocusEvent focusEvent) {
                TestStatsTab.this.setEnableForSigLevelField2();
                super.focusLost(focusEvent);
            }
        };
        this.mColumnSigLevelField2.setIncludeMinRange(false);
        this.mColumnSigLevelField2.setIncludeMaxRange(false);
        this.mColumnAdjustCheck = new JCheckBox(this.createToggleButtonAction("IDS_T_TESTS_ADJUST_CHECK"));
        this.mColumnAdjustCheck.setSelected(true);
        this.mBonfRadio = new JRadioButton(this.createToggleButtonAction("IDS_COLUMN_ADJUST_BONF"));
        this.mBenjRadio = new JRadioButton(this.createToggleButtonAction("IDS_COLUMN_ADJUST_BENJ"));
        this.mAdjustGroup = new SpssButtonGroup();
        this.mAdjustGroup.add(this.mBonfRadio);
        this.mAdjustGroup.add(this.mBenjRadio);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COLUMN_TITLE")));
        JPanel jPanel2 = this.setTestsPanel();
        JPanel jPanel3 = this.setSignificancePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        Insets insets = new Insets(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.7;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        Insets insets2 = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets3 = (Insets)DialogUtil.getStandardControlInsets().clone();
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        insets3.left += 3;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mColumnSigLevelLabel, gridBagConstraints, 0, 0, 2, 1, n, insets3);
        insets.left += 10;
        insets.bottom += 2;
        DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mColumnSigLevelField1, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets3.left -= 12;
        DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mColumnSigLevelField2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets3.left += 130;
        int n3 = 13;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mColumnAdjustCheck, gridBagConstraints, 2, 0, 2, 1, n3, insets3);
        insets3.left += 10;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mBonfRadio, gridBagConstraints, 2, 1, 1, 1, n3, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mBenjRadio, gridBagConstraints, 3, 1, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 2, 1, n, insets);
        return jPanel;
    }

    private boolean checkTwoSigEqual() {
        double d;
        double d2;
        boolean bl = true;
        if (this.mColumnSigLevelField2.isEnabled() && this.mColumnSigLevelField1.getText().length() > 0 && this.mColumnSigLevelField2.getText().length() > 0 && (d2 = Double.parseDouble(this.mColumnSigLevelField1.getText())) == (d = Double.parseDouble(this.mColumnSigLevelField2.getText()))) {
            SPSSTextField.showWarningDialog((JComponent)this.mColumnSigLevelField2, (String)this.getResString("IDS_SIG_TWO_VALUES_ALERT"), (String)this.mParent.getTitle());
            this.mColumnSigLevelField2.requestFocusInWindow();
            bl = false;
        }
        return bl;
    }

    private JPanel setTestsPanel() {
        this.setMaxLimitByRes();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COLUMN_TESTS_TITLE")));
        this.mTTestsCheck = new JCheckBox(this.createToggleButtonAction("IDS_T_TESTS_CHECK"));
        this.mTTestsEstimateCheck = new SpssMultiLineCheckBox(new ToggleButtonAction(this.mParent, "IDS_TESTS_ESTIMATE_CHECK"), MAXLIMIT_CHECKBOX);
        this.mTTestsEstimateCheck.setSelected(false);
        this.mZTestsCheck = new JCheckBox(this.createToggleButtonAction("IDS_Z_TESTS_CHECK"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        DialogUtil.addUsingGBL(jPanel, this.mTTestsCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mZTestsCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.left += 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTTestsEstimateCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void setMaxLimitByRes() {
        if (this.isSmallScreen()) {
            MAXLIMIT_CHECKBOX = 330;
        }
    }

    private JPanel setSignificancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SIG_TITLE")));
        this.mInSeparateTblRadio = new JRadioButton(this.createToggleButtonAction("IDS_SIG_SEP_TBL_RADIO"));
        this.mInMainTblRadio = new JRadioButton(this.createToggleButtonAction("IDS_SIG_MAIN_TBL_RADIO"));
        this.mDisplaySigCheck = new JCheckBox(this.createToggleButtonAction("IDS_SIG_SEP_TBL_CHECK"));
        this.mUseAPACheck = new JCheckBox(this.createToggleButtonAction("IDS_SIG_USE_APA_CHECK"));
        this.mUseAPACheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TestStatsTab.this.setEnableForSigLevelField2();
            }
        });
        this.mInSeparateTblRadio.setSelected(true);
        this.mInMainTblRadio.setSelected(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        Insets insets3 = (Insets)insets2.clone();
        insets3.top += 3;
        DialogUtil.addUsingGBL(jPanel, this.mInSeparateTblRadio, gridBagConstraints, 0, 0, 1, 1, 18, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mInMainTblRadio, gridBagConstraints, 0, 2, 1, 1, 18, insets3);
        insets2.left += 10;
        DialogUtil.addUsingGBL(jPanel, this.mDisplaySigCheck, gridBagConstraints, 0, 1, 1, 1, 18, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mUseAPACheck, gridBagConstraints, 0, 3, 1, 1, 18, insets2);
        this.mSigGroup = new SpssButtonGroup();
        this.mSigGroup.add(this.mInSeparateTblRadio);
        this.mSigGroup.add(this.mInMainTblRadio);
        return jPanel;
    }

    private JPanel setChiSquarePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mChiSquareCheck = new JCheckBox(this.createToggleButtonAction("IDS_CHI_SQUARE_CHECK"));
        this.mChiSquareSigLevelField = new FloatTextField(0.0, 1.0, 2, true);
        this.mChiSquareSigLevelField.setIncludeMaxRange(false);
        this.mChiSquareSigLevelField.setIncludeMinRange(false);
        this.mChiSquareSigLevelLabel = DialogUtil.createLabel(this.mParent, "IDS_SIG_LEVEL", 1);
        this.mChiSquareSigLevelLabel.setLabelFor((Component)this.mChiSquareSigLevelField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mChiSquareCheck, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        DialogUtil.addUsingGBL(jPanel, this.mChiSquareSigLevelLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = insets.left;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mChiSquareSigLevelField, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private void setupInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        String string = this.getInfoString();
        String[] stringArray = string.split("\n");
        JLabel[] jLabelArray = new JLabel[stringArray.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mInfoArea = new JTextArea[5];
        for (int i = 0; i < stringArray.length; ++i) {
            this.mInfoArea[i] = new JTextArea(stringArray[i]);
            this.mInfoArea[i].setMaximumSize(this.mInfoArea[i].getPreferredSize());
            this.mInfoArea[i].setOpaque(false);
            this.mInfoArea[i].setFocusable(true);
            this.mInfoArea[i].setEditable(false);
            this.mInfoArea[i].setEnabled(true);
            this.mInfoArea[i].setLineWrap(true);
            this.mInfoArea[i].setWrapStyleWord(true);
            this.mInfoArea[i].setSelectionStart(0);
            this.mInfoArea[i].setSelectionEnd(this.mInfoArea[i].getText().length());
            jLabelArray[i] = new JLabel("-");
            jLabelArray[i].setVerticalAlignment(1);
            DialogUtil.addUsingGBL(jPanel2, jLabelArray[i], gridBagConstraints, 0, i, 1, 1, n, insets);
            DialogUtil.addUsingGBL(jPanel2, this.mInfoArea[i], gridBagConstraints, 1, i, 1, 1, n, insets);
        }
        insets.left += 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 7, 2, 1, n, DialogUtil.getStandardControlInsets());
    }

    private String getInfoString() {
        String string = this.getResString("IDS_TEST_INFO");
        if (this.isSmallScreen()) {
            string = string.replaceAll("\\n\\n", "\\\n");
        }
        return string;
    }

    private ToggleButtonAction createToggleButtonAction(String string) {
        return new ToggleButtonAction(this.mParent, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    boolean bl = ((JCheckBox)object).isSelected();
                    if (object == TestStatsTab.this.mChiSquareCheck) {
                        TestStatsTab.this.mChiSquareSigLevelLabel.setEnabled(bl);
                        TestStatsTab.this.mChiSquareSigLevelField.setEnabled(bl);
                    } else if (object == TestStatsTab.this.mTTestsCheck || object == TestStatsTab.this.mZTestsCheck) {
                        boolean bl2 = TestStatsTab.this.mZTestsCheck.isSelected();
                        boolean bl3 = TestStatsTab.this.mTTestsCheck.isSelected();
                        TestStatsTab.this.mTTestsEstimateCheck.setEnabled(bl3);
                        TestStatsTab.this.setEnableForColumnCommonCtrls(bl2 || bl3);
                        TestStatsTab.this.mInSeparateTblRadio.setEnabled(bl3 || bl2);
                        TestStatsTab.this.mInMainTblRadio.setEnabled(bl3 || bl2);
                        TestStatsTab.this.mDisplaySigCheck.setEnabled(TestStatsTab.this.mInSeparateTblRadio.isEnabled() && TestStatsTab.this.mInSeparateTblRadio.isSelected());
                        TestStatsTab.this.mUseAPACheck.setEnabled(TestStatsTab.this.mInMainTblRadio.isEnabled() && TestStatsTab.this.mInMainTblRadio.isSelected());
                        TestStatsTab.this.setEnableForSigLevelField2();
                    } else if (object == TestStatsTab.this.mColumnAdjustCheck) {
                        TestStatsTab.this.setEnableForAdjustGroup(bl);
                    }
                } else if (object == TestStatsTab.this.mInSeparateTblRadio || object == TestStatsTab.this.mInMainTblRadio) {
                    TestStatsTab.this.mDisplaySigCheck.setEnabled(TestStatsTab.this.mInSeparateTblRadio.isSelected());
                    TestStatsTab.this.mUseAPACheck.setEnabled(TestStatsTab.this.mInMainTblRadio.isSelected());
                    TestStatsTab.this.setEnableForSigLevelField2();
                }
            }
        };
    }

    private void setEnableForColumnCommonCtrls(boolean bl) {
        this.mColumnSigLevelLabel.setEnabled(bl);
        this.mColumnSigLevelField1.setEnabled(bl);
        this.mColumnSigLevelField2.setEnabled(bl);
        this.setEnableForSigLevelField2();
        this.mColumnAdjustCheck.setEnabled(bl);
        this.setEnableForAdjustGroup(bl);
    }

    private void setEnableForSigLevelField2() {
        if (this.mColumnSigLevelField1.isEnabled()) {
            if (this.mColumnSigLevelField1.getText().length() == 0 || this.mUseAPACheck.isEnabled() && this.mUseAPACheck.isSelected()) {
                this.mColumnSigLevelField2.setEnabled(false);
            } else {
                this.mColumnSigLevelField2.setEnabled(true);
            }
        } else {
            this.mColumnSigLevelField2.setEnabled(false);
        }
    }

    private void setEnableForAdjustGroup(boolean bl) {
        boolean bl2 = this.mColumnAdjustCheck.isSelected();
        this.mBonfRadio.setEnabled(bl2 && bl);
        this.mBenjRadio.setEnabled(bl2 && bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mTTestsCheck);
        this.mComponentOrder.add(this.mTTestsEstimateCheck);
        this.mComponentOrder.add(this.mZTestsCheck);
        this.mComponentOrder.add(this.mSigGroup);
        this.mComponentOrder.add(this.mDisplaySigCheck);
        this.mComponentOrder.add(this.mUseAPACheck);
        this.mComponentOrder.add(this.mColumnSigLevelField1);
        this.mComponentOrder.add(this.mColumnSigLevelField2);
        this.mComponentOrder.add(this.mColumnAdjustCheck);
        this.mComponentOrder.add(this.mAdjustGroup);
        this.mComponentOrder.add(this.mChiSquareCheck);
        this.mComponentOrder.add(this.mChiSquareSigLevelField);
        this.mComponentOrder.add(this.mUseSubtotalsCheck);
        this.mComponentOrder.add(this.mIncludeMultiCheck);
        this.mComponentOrder.addAll(Arrays.asList(this.mInfoArea));
    }

    private boolean isSmallScreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        return dimension.getWidth() <= 800.0 || dimension.getHeight() <= 600.0;
    }
}

