/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TreeDragAdapter;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.ctables.AbstractListTableArrowButton;
import com.spss.java_client.ui.dialogs.ctables.CTablesMainDlg;
import com.spss.java_client.ui.dialogs.ctables.SummaryDisplayBaseTable;
import com.spss.java_client.ui.dialogs.ctables.SummaryStatTree;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.canvas.ICanvasVariable;
import com.spss.uitools.canvas.tables.NodeSelections;
import com.spss.uitools.canvas.tables.StatFormat;
import com.spss.uitools.canvas.tables.StatPack;
import com.spss.uitools.canvas.tables.TableCanvas;
import com.spss.uitools.canvas.tables.TreeNode;
import com.spss.uitools.canvas.tables.undo.SummaryStatEdit;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.border.ComponentTitledPane;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.ITableStats;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class SummaryStatSubDlg
extends BaseSubDialog
implements ITableStats,
TableModelListener {
    private static final String SUMMARY_SRC_LIST = "IDS_SUMMARY_SRC_LIST";
    private static final String SUMMARY_TOTAL_SRC_LIST = "IDS_SUMMARY_TOTAL_SRC_LIST";
    private static final int[] NUMERIC_CATS = new int[]{0, 23, 24, 25, 1, 26, 27, 28, 200, 2, 35, 36, 37, 3, 47, 48, 49, 4, 104, 105, 106, 5, 95, 96, 97, 6, 59, 60, 61, 9, 38, 39, 40, 10, 50, 51, 52, 11, 107, 108, 109, 12, 98, 99, 100, 13, 62, 63, 64, 16, 41, 42, 43, 17, 53, 54, 55, 18, 110, 111, 112, 19, 101, 102, 103, 20, 65, 66, 67, 7, 83, 84, 85, 8, 71, 72, 73, 14, 86, 87, 88, 15, 74, 75, 52, 21, 89, 90, 91, 22, 77, 78, 79};
    private static final int[] NUMERIC_CAT_TOTALS = new int[]{0, 23, 24, 25, 1, 26, 27, 28, 2, 35, 36, 37, 3, 47, 48, 49, 4, 104, 105, 106, 5, 95, 96, 97, 6, 59, 60, 61, 300, 301, 337, 338, 302, 340, 341, 303, 304, 305, 306, 352, 353, 307, 354, 355, 308, 356, 357, 309, 358, 359, 310, 360, 361, 311, 312, 313, 314, 343, 344, 345, 315, 29, 30, 31, 201, 316, 32, 33, 34, 202, 317, 318, 325, 326, 327, 319, 349, 350, 351, 320, 113, 114, 115, 321, 334, 335, 336, 322, 346, 347, 348, 9, 38, 39, 40, 10, 50, 51, 52, 11, 107, 108, 109, 12, 98, 99, 100, 13, 62, 63, 64, 16, 41, 42, 43, 17, 53, 54, 55, 18, 110, 111, 112, 19, 101, 102, 103, 20, 65, 66, 67, 7, 83, 84, 85, 8, 71, 72, 73, 323, 331, 332, 333, 324, 328, 329, 330, 14, 86, 87, 88, 15, 74, 75, 52, 21, 89, 90, 91, 22, 77, 78, 79};
    private static final int[] STRING_CATS = new int[]{0, 23, 24, 25, 1, 26, 27, 28, 2, 35, 36, 37, 3, 47, 48, 49, 4, 104, 105, 106, 5, 95, 96, 97, 6, 59, 60, 61, 9, 38, 39, 40, 10, 50, 51, 52, 11, 107, 108, 109, 12, 98, 99, 100, 13, 62, 63, 64, 16, 41, 42, 43, 17, 53, 54, 55, 18, 110, 111, 112, 19, 101, 102, 103, 20, 65, 66, 67, 7, 83, 84, 85, 8, 71, 72, 73, 14, 86, 87, 88, 15, 74, 75, 52, 21, 89, 90, 91, 22, 77, 78, 79};
    private static final int[] MRVAR_CATS = new int[]{0, 23, 24, 25, 1, 26, 27, 28, 200, 400, 2, 35, 36, 37, 3, 47, 48, 49, 4, 104, 105, 106, 5, 95, 96, 97, 6, 59, 60, 61, 401, 402, 403, 404, 405, 408, 409, 410, 411, 412, 415, 416, 417, 418, 419, 9, 38, 39, 40, 10, 50, 51, 52, 11, 107, 108, 109, 12, 98, 99, 100, 13, 62, 63, 64, 16, 41, 42, 43, 17, 53, 54, 55, 18, 110, 111, 112, 19, 101, 102, 103, 20, 65, 66, 67, 7, 83, 84, 85, 8, 71, 72, 73, 406, 407, 413, 414, 420, 421, 14, 86, 87, 88, 15, 74, 75, 52, 21, 89, 90, 91, 22, 77, 78, 79};
    private static final int[] SCALE_VARS = new int[]{0, 23, 24, 25, 1, 26, 27, 28, 200, 300, 301, 337, 338, 312, 302, 340, 341, 303, 304, 305, 306, 352, 353, 307, 354, 355, 308, 356, 357, 309, 358, 359, 310, 360, 361, 311, 313, 314, 343, 344, 345, 315, 29, 30, 31, 201, 316, 32, 33, 34, 202, 317, 2, 35, 36, 37, 3, 47, 48, 49, 4, 104, 105, 106, 5, 95, 96, 97, 6, 59, 60, 61, 318, 325, 326, 327, 319, 349, 350, 351, 320, 113, 114, 115, 321, 334, 335, 336, 322, 346, 347, 348, 9, 38, 39, 40, 10, 50, 51, 52, 11, 107, 108, 109, 12, 98, 99, 100, 13, 62, 63, 64, 16, 41, 42, 43, 17, 53, 54, 55, 18, 110, 111, 112, 19, 101, 102, 103, 20, 65, 66, 67, 7, 83, 84, 85, 8, 71, 72, 73, 323, 331, 332, 333, 324, 328, 329, 330, 14, 86, 87, 88, 15, 74, 75, 76, 21, 89, 90, 91, 22, 77, 78, 79};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_LABEL = 1;
    private static final int COLUMN_FORMAT = 2;
    private static final int COLUMN_DECIMAL = 3;
    private SummaryStatTree mSummarySrcTree;
    private SummaryDisplayTable mSummaryTargetTable;
    private SummaryListTableArrowButton mSideArrowButton;
    private SummaryListTableArrowButton mUpArrowButton;
    private SummaryListTableArrowButton mDownArrowButton;
    private JCheckBox mSummaryTotalCheck;
    private StatPack.StatType mStatType;
    private SummaryTotalInnerPanel mTotalInnerPanel;
    private ComponentTitledPane mTitledPane;
    private boolean mHasTotalPane;
    private NodeSelections mSelections;
    private ICanvasVariable mCanvasVar;
    private JLabel mVariableLabel;
    private ApplySelectionAction mApplySelectionAction;
    private ApplyAllAction mApplyAllAction;
    private boolean mCanApplyAllEnabled;
    private FloatTextField mConfidenceIntervalLevelEdit;
    private String mInitConfidenceIntervalLevelValue = "95";
    private boolean mDirtyFlag = false;

    public SummaryStatSubDlg(CTablesMainDlg cTablesMainDlg, NodeSelections nodeSelections) {
        super(cTablesMainDlg, cTablesMainDlg.getResString("IDS_SUMMARY_STAT_TITLE"), false);
        if (nodeSelections.mSelectedNodes == null || nodeSelections.mSelectedNodes.length == 0) {
            throw new NoSuchElementException("TreeNode selections");
        }
        this.mStatType = nodeSelections.mSelectedNodes[0].getStatType();
        this.mSelections = nodeSelections;
        boolean bl = this.mHasTotalPane = this.mStatType != StatPack.StatType.eST_Scale;
        if (nodeSelections.mSelectedNodes[0].hasTotalsSubtotalInCompExp()) {
            this.mHasTotalPane = false;
        }
        String string = this.getResString("IDS_SELECTED_VAR_LABEL").trim();
        if (this.mSelections.mSelectedNodes.length > 1) {
            string = MessageFormat.format(string, this.getResString("IDS_MULTIPLE_VARS"));
        } else {
            this.mCanvasVar = this.mSelections.mSelectedNodes[0].getNodeVar();
            string = MessageFormat.format(string, this.mSelections.mSelectedNodes[0].getNodeLabel());
        }
        this.mVariableLabel.setText(string);
        this.mCanApplyAllEnabled = cTablesMainDlg.getAssignVarsTab().hasMorethanSelectedOnSrcDimension(this.mStatType, this.mSelections.mSelectedNodes);
        this.mApplyAllAction.setEnabled(this.mCanApplyAllEnabled);
        this.mTitledPane.setVisible(this.mHasTotalPane);
        this.pack();
        if (this.mHasTotalPane) {
            boolean bl2 = this.mSelections.mSelectedNodes[0].getTotalsStatistics().size() > 0;
            this.mSummaryTotalCheck.setSelected(bl2);
            this.mTotalInnerPanel.setChildrenEnabled(bl2);
        }
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_summary_stats";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    public String getConfidenceIntervalLevel() {
        return this.mConfidenceIntervalLevelEdit.getText();
    }

    public void setInitialConfidenceIntervalLevel(String string) {
        this.mInitConfidenceIntervalLevelValue = string;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.loadAvailableStats(this.mStatType);
        TreeNode treeNode = this.mSelections.mSelectedNodes[0];
        Vector vector = treeNode.getStatistics();
        this.moveToDisplay(vector, this.mSummarySrcTree, this.mSummaryTargetTable);
        Vector vector2 = treeNode.getTotalsStatistics();
        if (vector2.size() == 0) {
            vector2 = vector;
        }
        this.moveToDisplay(vector2, this.mTotalInnerPanel.mSummaryTotalSrcTree, this.mTotalInnerPanel.mSummaryTotalTargetTable);
        this.mSummarySrcTree.selectNode(this.mSummarySrcTree.getBranchNodes()[0], false);
        this.mTotalInnerPanel.mSummaryTotalSrcTree.selectNode(this.mTotalInnerPanel.mSummaryTotalSrcTree.getBranchNodes()[0], false);
        this.mConfidenceIntervalLevelEdit.setText(this.mInitConfidenceIntervalLevelValue);
        this.mSummarySrcTree.requestFocusInWindow();
        this.mDirtyFlag = false;
        this.mSummaryTargetTable.setDirtyTable(false);
        this.mTotalInnerPanel.mSummaryTotalTargetTable.setDirtyTable(false);
    }

    @Override
    protected void init() {
        Object[] objectArray = new String[]{this.getResString("IDS_STAT_NAME"), this.getResString("IDS_STAT_LABEL"), this.getResString("IDS_STAT_FORMAT"), this.getResString("IDS_STAT_DECIMALS")};
        super.init();
        this.setupSummaryPanel(this.mViewPanel);
        this.setupSummaryTotalPanel(this.mViewPanel);
        this.setupConfidenceIntervalPanel(this.mViewPanel);
        this.mSummaryTargetTable.setModel(new DefaultTableModel((Object[][])null, objectArray));
        this.mTotalInnerPanel.mSummaryTotalTargetTable.setModel(new DefaultTableModel((Object[][])null, objectArray));
        this.mSummaryTargetTable.setupCellRenderer();
        this.mTotalInnerPanel.mSummaryTotalTargetTable.setupCellRenderer();
        this.mSummaryTargetTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.mTotalInnerPanel.mSummaryTotalTargetTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.setFocusTraversalPolicy();
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mApplySelectionAction = new ApplySelectionAction();
        JButton jButton = new JButton(this.mApplySelectionAction);
        this.mApplyAllAction = new ApplyAllAction();
        JButton jButton2 = new JButton(this.mApplyAllAction);
        JButton jButton3 = new JButton(new CloseAction());
        JButton jButton4 = new JButton((Action)this.createHelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
                jPanel.add(jButton4);
            }
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void moveToDisplay(Vector<StatPack> vector, SummaryStatTree summaryStatTree, SummaryDisplayTable summaryDisplayTable) {
        for (StatPack statPack : vector) {
            Object[] objectArray = this.createTableRowData(statPack, false);
            ((DefaultTableModel)summaryDisplayTable.getModel()).addRow(objectArray);
            for (StatPack statPack2 : vector) {
                DefaultMutableTreeNode defaultMutableTreeNode = summaryStatTree.searchNode(statPack2);
                if (defaultMutableTreeNode == null) continue;
                summaryStatTree.removeNode(defaultMutableTreeNode, false);
            }
        }
        summaryDisplayTable.getSelectionModel().setSelectionInterval(summaryDisplayTable.getSelectedRowCount() - 1, summaryDisplayTable.getSelectedRowCount() - 1);
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        JComponent jComponent = null;
        if (component instanceof SummaryStatTree) {
            SummaryStatTree summaryStatTree = (SummaryStatTree)component;
            if (summaryStatTree == this.mSummarySrcTree) {
                jComponent = this.mSummaryTargetTable;
            } else if (summaryStatTree == this.mTotalInnerPanel.mSummaryTotalSrcTree) {
                jComponent = this.mTotalInnerPanel.mSummaryTotalTargetTable;
            }
            TreeDragAdapter treeDragAdapter = new TreeDragAdapter(summaryStatTree, dragPane, "SummaryStatTree");
            summaryStatTree.addMouseListener((MouseListener)((Object)treeDragAdapter));
            summaryStatTree.addMouseMotionListener((MouseMotionListener)((Object)treeDragAdapter));
            dragPane.addDropListener((IDropListener)new SummaryTreeDropListener(summaryStatTree, iVarMoveHandler, jComponent));
        } else if (component instanceof PlainTable) {
            PlainTable plainTable = (PlainTable)component;
            if (plainTable == this.mSummaryTargetTable) {
                jComponent = this.mSummarySrcTree;
            } else if (plainTable == this.mTotalInnerPanel.mSummaryTotalTargetTable) {
                jComponent = this.mTotalInnerPanel.mSummaryTotalSrcTree;
            }
            PlainTableDragAdapter plainTableDragAdapter = new PlainTableDragAdapter(plainTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(plainTable, plainTableDragAdapter);
            dragPane.addDropListener((IDropListener)new SummaryTableDropListener(plainTable, iVarMoveHandler, jComponent));
            plainTable.getModel().addTableModelListener(this);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private JPanel setupSummaryPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        String string = this.getResString("IDS_SELECTED_VAR_LABEL");
        this.mVariableLabel = new JLabel(string);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_STAT_LIST");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DISPLAY");
        this.mSideArrowButton = new SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mUpArrowButton = new SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation.up);
        this.mDownArrowButton = new SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mSummarySrcTree = new SummaryStatTree();
        this.mSummaryTargetTable = new SummaryDisplayTable();
        this.setupCommonPanel(jPanel2, this.mSideArrowButton, this.mUpArrowButton, this.mDownArrowButton, this.mSummarySrcTree, this.mSummaryTargetTable, jLabel, jLabel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel2;
    }

    private void setupSummaryTotalPanel(JPanel jPanel) {
        this.mTotalInnerPanel = new SummaryTotalInnerPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_TOTAL_CHECK"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                SummaryStatSubDlg.this.mTotalInnerPanel.setChildrenEnabled(((JCheckBox)object).isSelected());
            }
        };
        this.mSummaryTotalCheck = new JCheckBox(toggleButtonAction);
        this.mSummaryTotalCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SummaryStatSubDlg.this.mDirtyFlag = true;
            }
        });
        this.mTitledPane = new ComponentTitledPane((JComponent)this.mSummaryTotalCheck, (JPanel)this.mTotalInnerPanel, DialogUtil.getGroupBoxInnerMargin());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTitledPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private JPanel setupConfidenceIntervalPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CONFI_INTERVALS_GROUP")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CONFI_INTERVALS_LEVEL");
        this.mConfidenceIntervalLevelEdit = new FloatTextField(0.0, 100.0, 2, true){

            public boolean checkRange() {
                SummaryStatSubDlg.this.mDirtyFlag = true;
                return super.checkRange(false);
            }
        };
        this.mConfidenceIntervalLevelEdit.setIncludeMinRange(false);
        this.mConfidenceIntervalLevelEdit.setIncludeMaxRange(false);
        jLabel.setLabelFor((Component)this.mConfidenceIntervalLevelEdit);
        this.mConfidenceIntervalLevelEdit.setColumns(6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(3, n2, 3, n2 / 2);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mConfidenceIntervalLevelEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, null);
        return jPanel2;
    }

    private void setupCommonPanel(JPanel jPanel, SummaryListTableArrowButton summaryListTableArrowButton, SummaryListTableArrowButton summaryListTableArrowButton2, SummaryListTableArrowButton summaryListTableArrowButton3, SummaryStatTree summaryStatTree, JTable jTable, JLabel jLabel, JLabel jLabel2) {
        summaryListTableArrowButton.registerComponents(summaryStatTree, SpssArrowButton.ButtonOrientation.right);
        summaryListTableArrowButton.registerComponents(jTable, SpssArrowButton.ButtonOrientation.left);
        summaryListTableArrowButton2.setEnabled(false);
        summaryListTableArrowButton3.setEnabled(false);
        summaryListTableArrowButton2.registerComponents(jTable, SpssArrowButton.ButtonOrientation.up);
        summaryListTableArrowButton3.registerComponents(jTable, SpssArrowButton.ButtonOrientation.down);
        jLabel.setLabelFor(summaryStatTree);
        jLabel2.setLabelFor(jTable);
        JScrollPane jScrollPane = new JScrollPane(summaryStatTree);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 200));
        JScrollPane jScrollPane2 = new JScrollPane(jTable);
        jScrollPane2.setPreferredSize(new Dimension(580, 200));
        jScrollPane2.setMinimumSize(new Dimension(580, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 2, n, insets);
        gridBagConstraints = new GridBagConstraints();
        Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
        insets2.bottom = DialogUtil.getStandardButtonInsets().bottom;
        n = 18;
        DialogUtil.addUsingGBL(jPanel, summaryListTableArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, 0);
        insets3.left = 6;
        DialogUtil.addUsingGBL(jPanel, summaryListTableArrowButton2, gridBagConstraints, 3, 1, 1, 1, n, insets3);
        Insets insets4 = new Insets(0, 20, insets2.bottom, 0);
        insets4.left = 6;
        DialogUtil.addUsingGBL(jPanel, summaryListTableArrowButton3, gridBagConstraints, 3, 2, 1, 1, n, insets4);
    }

    private void loadAvailableStats(StatPack.StatType statType) {
        int[] nArray;
        int[] nArray2;
        switch (statType) {
            case eST_CategoricalNumeric: {
                nArray2 = NUMERIC_CATS;
                nArray = NUMERIC_CAT_TOTALS;
                break;
            }
            case eST_CategoricalString: {
                nArray2 = STRING_CATS;
                nArray = STRING_CATS;
                break;
            }
            case eST_Scale: {
                nArray2 = SCALE_VARS;
                nArray = SCALE_VARS;
                break;
            }
            case eST_MultipleResponse: {
                nArray2 = MRVAR_CATS;
                nArray = MRVAR_CATS;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.mSummarySrcTree.loadTreeModel(nArray2, this.mCanvasVar);
        this.mTotalInnerPanel.mSummaryTotalSrcTree.loadTreeModel(nArray, this.mCanvasVar);
    }

    private StatPack createStatPack(Object[] objectArray) {
        StatHolder statHolder = (StatHolder)objectArray[0];
        StatFormat statFormat = ((SummaryDisplayBaseTable.StatFormatItem)objectArray[2]).mStatFormat;
        return new StatPack(statHolder.mStat, objectArray[0].toString(), statFormat, ((Integer)objectArray[3]).intValue(), statHolder.mOrderIdx);
    }

    private Object[] createTableRowData(StatPack statPack, boolean bl) {
        Object[] objectArray = new Object[]{new StatHolder(statPack.getStatName(), statPack.getStatValue(), statPack.getOrderIndex()), bl ? statPack.getDefaultDisplayStatLabel() : statPack.getStatLabel(), new SummaryDisplayBaseTable.StatFormatItem(statPack.getStatFormat(), statPack.getDecimals()), statPack.getDecimals()};
        return objectArray;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummarySrcTree);
        vector.add(this.mSideArrowButton);
        vector.add(this.mSummaryTargetTable);
        vector.add(this.mUpArrowButton);
        vector.add(this.mDownArrowButton);
        if (this.mHasTotalPane) {
            vector.add(this.mSummaryTotalCheck);
            vector.add(this.mTotalInnerPanel.mSummaryTotalSrcTree);
            vector.add(this.mTotalInnerPanel.mTotalSideArrowButton);
            vector.add(this.mTotalInnerPanel.mSummaryTotalTargetTable);
            vector.add(this.mTotalInnerPanel.mTotalUpArrowButton);
            vector.add(this.mTotalInnerPanel.mTotalDownArrowButton);
        }
        vector.add(this.mConfidenceIntervalLevelEdit);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private int findInsertIndex(PlainList plainList, StatPack statPack) {
        int n = 0;
        int n2 = statPack.getStatValue();
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            StatPack statPack2 = (StatPack)defaultListModel.get(i);
            int n3 = statPack2.getStatValue();
            if (n2 >= n3) continue;
            n = i;
            break;
        }
        return n;
    }

    private Vector<StatPack> getStatistics() {
        Vector<StatPack> vector = new Vector<StatPack>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mSummaryTargetTable.getModel();
        Vector<Vector> vector2 = defaultTableModel.getDataVector();
        for (Vector vector3 : vector2) {
            StatHolder statHolder = (StatHolder)vector3.get(0);
            Integer n = Integer.valueOf(vector3.get(3).toString());
            StatFormat statFormat = ((SummaryDisplayBaseTable.StatFormatItem)vector3.get((int)2)).mStatFormat;
            vector.add(new StatPack(statHolder.mStat, vector3.get(1).toString(), statFormat, n.intValue()));
        }
        return vector;
    }

    private Vector<StatPack> getTotalsStatistics() {
        Vector<StatPack> vector = new Vector<StatPack>();
        if (!this.mHasTotalPane || !this.mSummaryTotalCheck.isSelected()) {
            return vector;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mTotalInnerPanel.mSummaryTotalTargetTable.getModel();
        Vector<Vector> vector2 = defaultTableModel.getDataVector();
        for (Vector vector3 : vector2) {
            StatHolder statHolder = (StatHolder)vector3.get(0);
            Integer n = Integer.valueOf(vector3.get(3).toString());
            StatFormat statFormat = ((SummaryDisplayBaseTable.StatFormatItem)vector3.get((int)2)).mStatFormat;
            vector.add(new StatPack(statHolder.mStat, vector3.get(1).toString(), statFormat, n.intValue()));
        }
        return vector;
    }

    private void updateCmdButtons() {
        boolean bl;
        boolean bl2 = bl = this.mSummaryTargetTable.getRowCount() > 0;
        if (bl && this.mHasTotalPane && this.mSummaryTotalCheck.isSelected()) {
            bl = this.mTotalInnerPanel.mSummaryTotalTargetTable.getRowCount() > 0;
        }
        this.mApplySelectionAction.setEnabled(bl);
        this.mApplyAllAction.setEnabled(bl & this.mCanApplyAllEnabled);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        int n = tableModelEvent.getColumn();
        if (!(object instanceof DefaultTableModel)) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)object;
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            this.updateCmdButtons();
        } else if (tableModelEvent.getType() == 0 && n == 2) {
            SummaryDisplayTable summaryDisplayTable = this.mSummaryTargetTable.getModel() == defaultTableModel ? this.mSummaryTargetTable : this.mTotalInnerPanel.mSummaryTotalTargetTable;
            summaryDisplayTable.repaint();
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", SummaryStatSubDlg.this.getResString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SummaryStatSubDlg.this.mDirtyFlag) {
                Object[] objectArray = new Object[]{UIToolResUtil.getString((String)"IDS_CONTINUE"), UIToolResUtil.getString((String)"IDS_CANCEL")};
                int n = JOptionPane.showOptionDialog((Component)((Object)SummaryStatSubDlg.this), SummaryStatSubDlg.this.getResString("IDS_NOT_APPLY_ALERT_MSG"), SummaryStatSubDlg.this.getTitle(), 2, 2, null, objectArray, objectArray[1]);
                if (n == 0) {
                    SummaryStatSubDlg.this.dispose();
                } else {
                    return;
                }
            }
            SummaryStatSubDlg.this.dispose();
        }
    }

    class ApplyAllAction
    extends AbstractAction {
        ApplyAllAction() {
            this.putValue("Name", SummaryStatSubDlg.this.getResString("IDS_APPLY_ALL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", SummaryStatSubDlg.this.getDlgAccessKey("IDK_APPLY_ALL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SummaryStatSubDlg.this.mSummaryTargetTable.isEditing()) {
                SummaryStatSubDlg.this.mSummaryTargetTable.getCellEditor().stopCellEditing();
            } else if (SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.isEditing()) {
                SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.getCellEditor().stopCellEditing();
            }
            Vector vector = SummaryStatSubDlg.this.getStatistics();
            Vector vector2 = SummaryStatSubDlg.this.getTotalsStatistics();
            Container container = SummaryStatSubDlg.this.getParent();
            if (!(container instanceof CTablesMainDlg)) {
                return;
            }
            CTablesMainDlg cTablesMainDlg = (CTablesMainDlg)((Object)container);
            cTablesMainDlg.getAssignVarsTab().saveStatsToAllNodes(SummaryStatSubDlg.this.mStatType, vector, vector2);
            cTablesMainDlg.getAssignVarsTab().postSummaryStatApply(SummaryStatSubDlg.this.mConfidenceIntervalLevelEdit.getText());
            SummaryStatSubDlg.this.mDirtyFlag = false;
            SummaryStatSubDlg.this.mSummaryTargetTable.setDirtyTable(false);
            SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.setDirtyTable(false);
        }
    }

    class ApplySelectionAction
    extends AbstractAction {
        ApplySelectionAction() {
            this.putValue("Name", SummaryStatSubDlg.this.getResString("IDS_APPLY_SELECTION"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", SummaryStatSubDlg.this.getDlgAccessKey("IDK_APPLY_SELECTION_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SummaryStatSubDlg.this.mSummaryTargetTable.isEditing()) {
                SummaryStatSubDlg.this.mSummaryTargetTable.getCellEditor().stopCellEditing();
            } else if (SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.isEditing()) {
                SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.getCellEditor().stopCellEditing();
            }
            Vector vector = SummaryStatSubDlg.this.getStatistics();
            Vector vector2 = SummaryStatSubDlg.this.getTotalsStatistics();
            Container container = SummaryStatSubDlg.this.getParent();
            if (!(container instanceof CTablesMainDlg)) {
                return;
            }
            CTablesMainDlg cTablesMainDlg = (CTablesMainDlg)((Object)container);
            TableCanvas tableCanvas = cTablesMainDlg.getAssignVarsTab().getTableCanvas();
            new SummaryStatEdit(tableCanvas.getUndoManager(), tableCanvas, SummaryStatSubDlg.this.mSelections, vector, vector2);
            cTablesMainDlg.getAssignVarsTab().postSummaryStatApply(SummaryStatSubDlg.this.mConfidenceIntervalLevelEdit.getText());
            SummaryStatSubDlg.this.mDirtyFlag = false;
            SummaryStatSubDlg.this.mSummaryTargetTable.setDirtyTable(false);
            SummaryStatSubDlg.this.mTotalInnerPanel.mSummaryTotalTargetTable.setDirtyTable(false);
        }
    }

    private class SummaryListTableArrowButton
    extends AbstractListTableArrowButton {
        public SummaryListTableArrowButton() {
        }

        public SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        protected boolean moveSelectedRowsToList(int[] nArray, PlainTable plainTable, Object object) {
            if (object instanceof SummaryStatTree) {
                ((SummaryStatTree)object).clearSelection();
            }
            ArrayList<StatPack> arrayList = new ArrayList<StatPack>();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                StatHolder statHolder = (StatHolder)plainTable.getValueAt(n, 0);
                String string = plainTable.getValueAt(n, 1).toString();
                SummaryDisplayBaseTable.StatFormatItem statFormatItem = (SummaryDisplayBaseTable.StatFormatItem)plainTable.getValueAt(n, 2);
                Integer n2 = (Integer)plainTable.getValueAt(n, 3);
                Object[] objectArray = new Object[]{statHolder, string, statFormatItem, n2};
                StatPack statPack = SummaryStatSubDlg.this.createStatPack(objectArray);
                arrayList.add(statPack);
                ((DefaultTableModel)plainTable.getModel()).removeRow(n);
                plainTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
            Collections.reverse(arrayList);
            for (StatPack statPack : arrayList) {
                if (object instanceof PlainList) {
                    int n = SummaryStatSubDlg.this.findInsertIndex((PlainList)object, statPack);
                    ((DefaultListModel)((PlainList)object).getModel()).insertElementAt(statPack, n);
                    ((PlainList)object).addSelectionInterval(n, n);
                    continue;
                }
                if (!(object instanceof SummaryStatTree)) continue;
                ((SummaryStatTree)object).insertNode(statPack, true);
            }
            SummaryStatSubDlg.this.mDirtyFlag = true;
            return true;
        }

        @Override
        protected void moveSelectedListItemToTable(Object object, Object object2, PlainTable plainTable) {
            if ((object2 instanceof PlainList || object2 instanceof SummaryStatTree) && object instanceof StatPack) {
                StatPack statPack = (StatPack)object;
                Object[] objectArray = SummaryStatSubDlg.this.createTableRowData(statPack, true);
                ((DefaultTableModel)plainTable.getModel()).addRow(objectArray);
                if (object2 instanceof PlainList) {
                    ((DefaultListModel)((PlainList)object2).getModel()).removeElement(object);
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = ((SummaryStatTree)object2).searchNode(statPack);
                    ((SummaryStatTree)object2).removeNode(defaultMutableTreeNode, true);
                }
            }
            SummaryStatSubDlg.this.mDirtyFlag = true;
        }

        @Override
        protected void updateOtherControls() {
            SummaryStatSubDlg.this.updateCmdButtons();
        }
    }

    private class SummaryTableDropListener
    extends AbstractTableDropListener {
        public SummaryTableDropListener(PlainTable plainTable, Component component) {
            super(plainTable, component);
        }

        public SummaryTableDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
            super(plainTable, iVarMoveHandler, component);
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            Serializable serializable;
            if (jComponent instanceof PlainTable && object instanceof Vector) {
                serializable = (Vector)object;
                Iterator iterator = ((Vector)serializable).iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    ((DefaultTableModel)((PlainTable)this.mDropTarget).getModel()).insertRow(n++, objectArray);
                }
            } else if (jComponent instanceof SummaryStatTree && object instanceof Vector) {
                ((PlainTable)this.mDropTarget).clearSelection();
                serializable = (Vector)object;
                Iterator iterator = ((Vector)serializable).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof StatPack)) continue;
                    StatPack statPack = (StatPack)e;
                    Object[] objectArray = SummaryStatSubDlg.this.createTableRowData(statPack, true);
                    ((DefaultTableModel)((PlainTable)this.mDropTarget).getModel()).insertRow(n++, objectArray);
                    ((PlainTable)this.mDropTarget).getSelectionModel().addSelectionInterval(n - 1, n - 1);
                }
            }
            serializable = (PlainTable)this.mDropTarget;
            SwingUtilities.invokeLater(new Runnable((PlainTable)serializable){
                final /* synthetic */ PlainTable val$varTable;
                {
                    this.val$varTable = plainTable;
                }

                @Override
                public void run() {
                    this.val$varTable.requestFocus();
                }
            });
            SummaryStatSubDlg.this.mDirtyFlag = true;
        }
    }

    private class SummaryTreeDropListener
    extends AbstractDropListener {
        private Component mRegisteredSource;

        public SummaryTreeDropListener(SummaryStatTree summaryStatTree, Component component) {
            super(summaryStatTree);
            this.mRegisteredSource = component;
        }

        public SummaryTreeDropListener(SummaryStatTree summaryStatTree, IVarMoveHandler iVarMoveHandler, Component component) {
            super(summaryStatTree, iVarMoveHandler);
            this.mRegisteredSource = component;
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            PlainTable.TransferData transferData;
            Vector<Object[]> vector;
            boolean bl = false;
            if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((SummaryStatTree)this.mDropTarget).isDragSupported())) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof PlainTable.TransferData && (vector = (transferData = (PlainTable.TransferData)object).getVectorData()) != null && vector.size() > 0) {
                bl = true;
            }
            return bl;
        }

        @Override
        protected void showDropFeedback(Point point) {
        }

        @Override
        protected void setHighlightBorder(boolean bl) {
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            boolean bl;
            Component component = dropEvent.getSource();
            if (this.mLastPosition != null) {
                this.mLastPosition = null;
                if (this.mTimer != null) {
                    this.mTimer.stop();
                }
            }
            this.setHighlightBorder(false);
            boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            if (bl && this.mDropTarget != null && component instanceof PlainTable) {
                PlainTable plainTable = (PlainTable)component;
                Object object = dropEvent.getTransferData();
                if (object == null) {
                    return;
                }
                if (!(object instanceof PlainTable.TransferData)) {
                    assert (false);
                    return;
                }
                PlainTable.TransferData transferData = (PlainTable.TransferData)object;
                Vector<Object[]> vector = transferData.getVectorData();
                int[] nArray = transferData.getSelectedRows();
                this.importData(vector, plainTable, -1);
                if (!this.mSwapFlag) {
                    this.finish(plainTable, vector.size(), nArray, -1);
                }
                this.mSwapFlag = false;
            }
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
            if (jComponent instanceof PlainTable) {
                DefaultTableModel defaultTableModel = ((PlainTable)jComponent).getDefaultTableModel();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    defaultTableModel.removeRow(nArray[i]);
                }
            }
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            if (!(object instanceof Vector)) {
                return;
            }
            final SummaryStatTree summaryStatTree = (SummaryStatTree)this.mDropTarget;
            summaryStatTree.clearSelection();
            for (Object e : (Vector)object) {
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                StatPack statPack = SummaryStatSubDlg.this.createStatPack(objectArray);
                summaryStatTree.insertNode(statPack, true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    summaryStatTree.requestFocusInWindow();
                }
            });
            SummaryStatSubDlg.this.mDirtyFlag = true;
        }
    }

    private class SummaryTotalInnerPanel
    extends JPanel {
        private SummaryStatTree mSummaryTotalSrcTree;
        private SummaryDisplayTable mSummaryTotalTargetTable;
        private JLabel mSummaryTotalStatLabel;
        private JLabel mSummaryTotalDisplayLabel;
        private SummaryListTableArrowButton mTotalSideArrowButton;
        private SummaryListTableArrowButton mTotalUpArrowButton;
        private SummaryListTableArrowButton mTotalDownArrowButton;

        public SummaryTotalInnerPanel() {
            super(new GridBagLayout(), true);
            this.mTotalSideArrowButton = new SummaryListTableArrowButton();
            this.mTotalUpArrowButton = new SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation.up);
            this.mTotalDownArrowButton = new SummaryListTableArrowButton(SpssArrowButton.ButtonOrientation.down);
            this.mSummaryTotalSrcTree = new SummaryStatTree();
            this.mSummaryTotalStatLabel = new JLabel(SummaryStatSubDlg.this.getResString("IDS_STAT_LIST"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mSummaryTotalStatLabel.setDisplayedMnemonic(SummaryStatSubDlg.this.getDlgAccessKey("IDK_STAT_LIST_TOTAL_KEY"));
            }
            this.mSummaryTotalDisplayLabel = new JLabel(SummaryStatSubDlg.this.getResString("IDS_DISPLAY"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mSummaryTotalDisplayLabel.setDisplayedMnemonic(SummaryStatSubDlg.this.getDlgAccessKey("IDK_DISPLAY_TOTAL_KEY"));
            }
            this.mSummaryTotalTargetTable = new SummaryDisplayTable();
            SummaryStatSubDlg.this.setupCommonPanel(this, this.mTotalSideArrowButton, this.mTotalUpArrowButton, this.mTotalDownArrowButton, this.mSummaryTotalSrcTree, this.mSummaryTotalTargetTable, this.mSummaryTotalStatLabel, this.mSummaryTotalDisplayLabel);
            this.setChildrenEnabled(false);
        }

        public void setChildrenEnabled(boolean bl) {
            this.mSummaryTotalSrcTree.setEnabled(bl);
            this.mSummaryTotalTargetTable.setEnabled(bl);
            this.mSummaryTotalStatLabel.setEnabled(bl);
            this.mSummaryTotalDisplayLabel.setEnabled(bl);
            this.mTotalSideArrowButton.setEnabled(bl);
            if (bl) {
                this.mTotalUpArrowButton.setEnableState(this.mSummaryTotalTargetTable, SpssArrowButton.ButtonOrientation.up);
                this.mTotalDownArrowButton.setEnableState(this.mSummaryTotalTargetTable, SpssArrowButton.ButtonOrientation.down);
            } else {
                this.mTotalUpArrowButton.setEnabled(bl);
                this.mTotalDownArrowButton.setEnabled(bl);
            }
        }
    }

    public static class StatHolder {
        String mName;
        int mStat;
        int mOrderIdx;

        StatHolder(String string, int n, int n2) {
            this.mName = string;
            this.mStat = n;
            this.mOrderIdx = n2;
        }

        public String toString() {
            return this.mName;
        }
    }

    private class SummaryDisplayTable
    extends SummaryDisplayBaseTable {
        private SummaryDisplayTable() {
        }

        @Override
        public SummaryDisplayBaseTable.DisplayColumnType getDisplayColumnTypes(int n) {
            SummaryDisplayBaseTable.DisplayColumnType displayColumnType = null;
            switch (n) {
                case 0: {
                    displayColumnType = SummaryDisplayBaseTable.DisplayColumnType.eColumnStatName;
                    break;
                }
                case 1: {
                    displayColumnType = SummaryDisplayBaseTable.DisplayColumnType.eColumnStatLabel;
                    break;
                }
                case 2: {
                    displayColumnType = SummaryDisplayBaseTable.DisplayColumnType.eColumnStatFormat;
                    break;
                }
                case 3: {
                    displayColumnType = SummaryDisplayBaseTable.DisplayColumnType.eColumnStatDecimals;
                }
            }
            return displayColumnType;
        }

        @Override
        public int getColumnIndex(SummaryDisplayBaseTable.DisplayColumnType displayColumnType) {
            int n = -1;
            if (displayColumnType == SummaryDisplayBaseTable.DisplayColumnType.eColumnStatName) {
                n = 0;
            } else if (displayColumnType == SummaryDisplayBaseTable.DisplayColumnType.eColumnStatLabel) {
                n = 1;
            } else if (displayColumnType == SummaryDisplayBaseTable.DisplayColumnType.eColumnStatFormat) {
                n = 2;
            } else if (displayColumnType == SummaryDisplayBaseTable.DisplayColumnType.eColumnStatDecimals) {
                n = 3;
            }
            return n;
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            SummaryStatSubDlg.this.mDirtyFlag = true;
            return super.editCellAt(n, n2, eventObject);
        }
    }
}

