/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.canvas.tables.StatFormat;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.res.ITableStats;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public abstract class SummaryDisplayBaseTable
extends PlainTable
implements ITableStats {
    private static final int DECIMAL_SPINNER_MIN = 0;
    private static final int DECIMAL_SPINNER_MAX = 16;
    private boolean mDirtyTable;

    public SummaryDisplayBaseTable() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setFont(jTableHeader.getFont().deriveFont(1));
        this.setRowHeight(this.getRowHeight() + 3);
        this.getTableHeader().setReorderingAllowed(false);
    }

    public abstract DisplayColumnType getDisplayColumnTypes(int var1);

    public abstract int getColumnIndex(DisplayColumnType var1);

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.getDisplayColumnTypes(n2) == DisplayColumnType.eColumnStatDecimals) {
            return !this.isAutoFormatRow(n);
        }
        return n2 > 0;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        if (n2 == this.getColumnIndex(DisplayColumnType.eColumnStatFormat)) {
            Object object = this.getValueAt(n, this.getColumnIndex(DisplayColumnType.eColumnStatDecimals));
            Object object2 = this.isAutoFormatRow(n) ? Integer.valueOf(0) : object;
            this.updateFormatCombo(tableCellEditor.getCellEditorValue(), n, object2);
        }
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        TableCellEditor tableCellEditor = null;
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        if (tableColumn.getCellEditor() != null) {
            tableCellEditor = tableColumn.getCellEditor();
            if (tableCellEditor instanceof SpinnerCellEditor) {
                ((SpinnerCellEditor)tableCellEditor).setRow(n);
            }
        } else {
            DisplayColumnType displayColumnType = this.getDisplayColumnTypes(n2);
            if (displayColumnType == DisplayColumnType.eColumnStatLabel) {
                tableCellEditor = new DefaultCellEditor(new JTextField());
            } else if (displayColumnType == DisplayColumnType.eColumnStatFormat) {
                Object[] objectArray = new Object[]{this.getModel().getValueAt(n, n2)};
                JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
                jComboBox.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SummaryDisplayBaseTable.this.mDirtyTable = true;
                    }
                });
                tableCellEditor = new DefaultCellEditor(jComboBox);
            } else if (displayColumnType == DisplayColumnType.eColumnStatDecimals) {
                tableCellEditor = new SpinnerCellEditor(this, n, 0, 0, 16, 1);
            }
            tableColumn.setCellEditor(tableCellEditor);
        }
        return tableCellEditor;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        double d = this.getTableHeader().getHeaderRect(n2).getWidth();
        Object object = this.getValueAt(n, n2);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d2 = fontMetrics.getStringBounds(object.toString(), this.getGraphics()).getWidth();
        if (d2 >= d) {
            string = object.toString();
        }
        return string == null ? null : string;
    }

    public boolean isDirtyTable() {
        return this.mDirtyTable;
    }

    public void setDirtyTable(boolean bl) {
        this.mDirtyTable = bl;
    }

    public void setupCellRenderer() {
        SummaryTableCellRenderer summaryTableCellRenderer = new SummaryTableCellRenderer();
        SummaryTableCellRenderer summaryTableCellRenderer2 = new SummaryTableCellRenderer();
        summaryTableCellRenderer2.setBackground(SystemColor.control);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            DisplayColumnType displayColumnType = this.getDisplayColumnTypes(i);
            if (displayColumnType == DisplayColumnType.eColumnStatName) {
                tableColumn.setCellRenderer(summaryTableCellRenderer2);
                continue;
            }
            tableColumn.setCellRenderer(summaryTableCellRenderer);
        }
    }

    public void updateFormatCombo(Object object, int n, Object object2) {
        TableCellEditor tableCellEditor = this.getCellEditor(n, this.getColumnIndex(DisplayColumnType.eColumnStatFormat));
        if (tableCellEditor instanceof DefaultCellEditor) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
            JComboBox jComboBox = (JComboBox)defaultCellEditor.getComponent();
            Integer n2 = (Integer)object2;
            StatFormatItem statFormatItem = (StatFormatItem)this.getValueAt(n, this.getColumnIndex(DisplayColumnType.eColumnStatFormat));
            StatFormat statFormat = statFormatItem.mStatFormat;
            int n3 = object == null ? jComboBox.getSelectedIndex() : -1;
            jComboBox.removeAllItems();
            StatFormat[] statFormatArray = StatFormat.values();
            StatFormatItem statFormatItem2 = null;
            for (StatFormat statFormat2 : statFormatArray) {
                StatFormatItem statFormatItem3 = new StatFormatItem(statFormat2, n2);
                jComboBox.addItem(statFormatItem3);
                if (statFormat != statFormat2) continue;
                statFormatItem2 = statFormatItem3;
            }
            if (n3 > -1) {
                jComboBox.setSelectedIndex(n3);
            } else if (statFormatItem2 != null) {
                jComboBox.setSelectedItem(statFormatItem2);
            } else {
                jComboBox.setSelectedItem(object);
            }
            this.setValueAt(jComboBox.getSelectedItem(), n, this.getColumnIndex(DisplayColumnType.eColumnStatFormat));
        }
    }

    public boolean isAutoFormatRow(int n) {
        StatFormatItem statFormatItem = (StatFormatItem)this.getValueAt(n, this.getColumnIndex(DisplayColumnType.eColumnStatFormat));
        return statFormatItem.mStatFormat == StatFormat.eSF_Auto;
    }

    public static class StatFormatItem {
        StatFormat mStatFormat;
        Integer mDecimals;
        String mStrRep;

        public StatFormatItem(StatFormat statFormat, int n) {
            this.mStatFormat = statFormat;
            this.mDecimals = n;
            this.mStrRep = StatFormatItem.getFormatForDialog(this.mStatFormat, this.mDecimals);
        }

        public String toString() {
            return this.mStrRep;
        }

        private static String getFormatForDialog(StatFormat statFormat, Integer n) {
            String string = StatFormatItem.getFormatString(statFormat, n.byteValue());
            switch (statFormat) {
                case eSF_CCA: 
                case eSF_CCB: 
                case eSF_CCC: 
                case eSF_CCD: 
                case eSF_CCE: {
                    string = StatFormat.getStatFormatAsString((StatFormat)statFormat) + ": " + string;
                    break;
                }
            }
            return string;
        }

        private static String getFormatString(StatFormat statFormat, byte by) {
            FormatType formatType;
            String string = null;
            short s = (short)(10 + by);
            switch (statFormat) {
                case eSF_nnnn: {
                    formatType = FormatType.F;
                    break;
                }
                case eSF_nnnn_pct: {
                    formatType = FormatType.PERCENT;
                    break;
                }
                case eSF_N_nnnn: {
                    formatType = FormatType.F;
                    break;
                }
                case eSF_nnnn_paren: {
                    formatType = FormatType.F;
                    break;
                }
                case eSF_nnnn_neg_paren: {
                    formatType = FormatType.F;
                    break;
                }
                case eSF_nnnn_pct_paren: {
                    formatType = FormatType.PERCENT;
                    break;
                }
                case eSF_nnnn_comma: {
                    formatType = FormatType.COMMA;
                    break;
                }
                case eSF_nnnn_dot: {
                    formatType = FormatType.DOT;
                    break;
                }
                case eSF_nnnn_dollar: {
                    formatType = FormatType.DOLLAR;
                    break;
                }
                case eSF_CCA: {
                    formatType = FormatType.CCA;
                    break;
                }
                case eSF_CCB: {
                    formatType = FormatType.CCB;
                    break;
                }
                case eSF_CCC: {
                    formatType = FormatType.CCC;
                    break;
                }
                case eSF_CCD: {
                    formatType = FormatType.CCD;
                    break;
                }
                case eSF_CCE: {
                    formatType = FormatType.CCE;
                    break;
                }
                case eSF_Auto: {
                    string = UIToolResUtil.getString((String)"IDS_AUTO_FORMAT");
                    return string;
                }
                default: {
                    assert (false);
                    return string;
                }
            }
            string = StatFormatItem.valueToString(1234.1234567891236, formatType, s, by);
            if (StatFormat.eSF_nnnn_neg_paren == statFormat || StatFormat.eSF_nnnn_paren == statFormat || StatFormat.eSF_nnnn_pct_paren == statFormat) {
                string = "(" + string + ")";
                if (StatFormat.eSF_nnnn_neg_paren == statFormat) {
                    string = string + UIToolResUtil.getString((String)"IDS_NEG_VALUE");
                }
            } else if (StatFormat.eSF_N_nnnn == statFormat) {
                string = "N=" + string;
            }
            return string;
        }

        public static String valueToString(double d, FormatType formatType, short s, byte by) {
            OBS oBS = new OBS(0.0);
            oBS.setNum(d);
            SPSS_Format sPSS_Format = new SPSS_Format(formatType, s, by);
            String string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c)) continue;
                string = string.replace(c, 'n');
            }
            String string2 = string = string.trim();
            return string2;
        }
    }

    private class SpinnerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        private JSpinner mSpinner;
        private SummaryDisplayBaseTable mTable;
        private int mRow;

        public SpinnerCellEditor(SummaryDisplayBaseTable summaryDisplayBaseTable2, int n, int n2, int n3, int n4, int n5) {
            this.mSpinner = new NumberSpinner(n2, n3, n4, true, n5);
            JComponent jComponent = this.mSpinner.getEditor();
            if (jComponent instanceof JSpinner.DefaultEditor) {
                JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
                defaultEditor.getTextField().setHorizontalAlignment(10);
                Insets insets = defaultEditor.getTextField().getMargin();
                insets.left = 0;
                defaultEditor.getTextField().setMargin(insets);
            }
            this.mSpinner.addChangeListener(this);
            this.mTable = summaryDisplayBaseTable2;
            this.mRow = n;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            try {
                if (object instanceof String && object.toString().length() > 0) {
                    this.mSpinner.setValue(Integer.valueOf(object.toString()));
                } else {
                    this.mSpinner.setValue(0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.mSpinner.setValue(0);
            }
            this.mSpinner.setFont(SummaryDisplayBaseTable.this.getFont());
            return this.mSpinner;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mSpinner.getValue();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.mTable.updateFormatCombo(this.getCellEditorValue(), this.mRow, this.getCellEditorValue());
            SummaryDisplayBaseTable.this.mDirtyTable = true;
        }

        public void setRow(int n) {
            this.mRow = n;
        }
    }

    class SummaryTableCellRenderer
    extends DefaultTableCellRenderer {
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        SummaryTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(!jTable.isEnabled() ? SystemColor.gray : Color.black);
            if (n2 == SummaryDisplayBaseTable.this.getColumnIndex(DisplayColumnType.eColumnStatName)) {
                if (bl2) {
                    this.setBorder(this.mHighLightBorder);
                } else {
                    this.setBorder(BorderFactory.createEtchedBorder());
                }
            } else if (n2 == SummaryDisplayBaseTable.this.getColumnIndex(DisplayColumnType.eColumnStatDecimals) && ((SummaryDisplayBaseTable)jTable).isAutoFormatRow(n)) {
                this.setText("");
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            this.setOpaque(true);
            return component;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    public static enum DisplayColumnType {
        eColumnStatName,
        eColumnStatLabel,
        eColumnStatFormat,
        eColumnStatDecimals;

    }
}

