/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.uitools.canvas.CanvasValue;
import com.spss.uitools.canvas.CanvasVariable;
import com.spss.uitools.canvas.ICanvasVariable;
import com.spss.uitools.canvas.ICanvasVariableFactory;
import com.spss.uitools.canvas.IVarInfoLoader;
import java.text.Format;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;

public class SpssCanvasVariableFactory
implements ICanvasVariableFactory,
IVarInfoLoader {
    private static SpssCanvasVariableFactory sFactory = null;

    public static SpssCanvasVariableFactory getFactory() {
        if (sFactory == null) {
            sFactory = new SpssCanvasVariableFactory();
        }
        return sFactory;
    }

    public ICanvasVariable makeVariable(Object object) throws IllegalArgumentException {
        SpssMRVariable spssMRVariable;
        if (!(object instanceof ISpssVariable)) {
            throw new IllegalArgumentException("Bad variable class: " + object.toString());
        }
        ISpssVariable iSpssVariable = (ISpssVariable)object;
        ICanvasVariable.Measurement measurement = iSpssVariable instanceof SpssMRVariable ? ((spssMRVariable = (SpssMRVariable)iSpssVariable).getMRVarType() == SpssMRVariable.MRVarType.dichotomies ? ICanvasVariable.Measurement.mrDichotomous : ICanvasVariable.Measurement.mrCategorical) : ICanvasVariable.Measurement.valueOf((String)iSpssVariable.getDisplayMeasurementLevel().name());
        boolean bl = iSpssVariable.getDisplayMeasurementLevel() == iSpssVariable.getMeasurementLevel();
        CanvasVariable canvasVariable = new CanvasVariable((int)iSpssVariable.getType(), measurement, bl);
        canvasVariable.setName(iSpssVariable.getName());
        canvasVariable.setLabel(iSpssVariable.getLabel());
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        CellValueFormatter cellValueFormatter = new CellValueFormatter();
        canvasVariable.setFormat(cellValueFormatter.buildFormatter(sPSS_Format));
        canvasVariable.setSerializedFormat(sPSS_Format.asInt());
        this.setValueLabels(iSpssVariable, canvasVariable);
        this.setupMissingValues(iSpssVariable, (ICanvasVariable)canvasVariable);
        Icon icon = iSpssVariable.getCustomIcon();
        canvasVariable.setIcon(icon != null ? icon : VariableList.getStandardIcon(iSpssVariable));
        return canvasVariable;
    }

    public Icon loadIcon(int n, ICanvasVariable.Measurement measurement, int n2) {
        SpssVariable spssVariable;
        if (measurement == ICanvasVariable.Measurement.mrCategorical || measurement == ICanvasVariable.Measurement.mrDichotomous) {
            spssVariable = new SpssMRVariable((IValueLabelMap)new ValueLabelMap());
            SpssMRVariable.MRVarType mRVarType = measurement == ICanvasVariable.Measurement.mrCategorical ? SpssMRVariable.MRVarType.categories : SpssMRVariable.MRVarType.dichotomies;
            ((SpssMRVariable)spssVariable).setMRVarType(mRVarType);
            spssVariable.setMeasurementLevel(MeasurementLevel.nominal);
        } else {
            spssVariable = new SpssVariable();
            MeasurementLevel measurementLevel = measurement == ICanvasVariable.Measurement.nominal ? MeasurementLevel.nominal : (measurement == ICanvasVariable.Measurement.ordinal ? MeasurementLevel.ordinal : MeasurementLevel.scale);
            spssVariable.setMeasurementLevel(measurementLevel);
        }
        spssVariable.setType((short)n);
        spssVariable.setFormat(new SPSS_Format(n2));
        return VariableList.getStandardIcon((ISpssVariable)spssVariable);
    }

    public Format buildTextFormat(int n) {
        CellValueFormatter cellValueFormatter = new CellValueFormatter();
        return cellValueFormatter.buildFormatter(new SPSS_Format(n));
    }

    private void setupMissingValues(ISpssVariable iSpssVariable, ICanvasVariable iCanvasVariable) {
        OBS[] oBSArray = new OBS[]{new OBS(), new OBS(), new OBS()};
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
        int n = Math.abs(rule.value());
        CanvasValue[] canvasValueArray = new CanvasValue[3];
        if (n > 0) {
            canvasValueArray[0] = oBSArray[0].isString() ? new CanvasValue(oBSArray[0].getString()) : new CanvasValue(oBSArray[0].getNum());
            if (n > 1) {
                canvasValueArray[1] = oBSArray[1].isString() ? new CanvasValue(oBSArray[1].getString()) : new CanvasValue(oBSArray[1].getNum());
                if (n > 2) {
                    canvasValueArray[2] = oBSArray[2].isString() ? new CanvasValue(oBSArray[2].getString()) : new CanvasValue(oBSArray[2].getNum());
                }
            }
        }
        iCanvasVariable.setMissingValues(rule.value(), canvasValueArray[0], canvasValueArray[1], canvasValueArray[2]);
    }

    private void setValueLabels(ISpssVariable iSpssVariable, CanvasVariable canvasVariable) {
        try {
            TreeMap<CanvasValue, String> treeMap = new TreeMap<CanvasValue, String>();
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            int n = 0;
            Set set = iValueLabelMap.getValueLabelEntries();
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                String string = (String)entry.getValue();
                if (oBS.isEmpty()) continue;
                CanvasValue canvasValue = oBS.isString() ? new CanvasValue(oBS.getString()) : (iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() ? new CanvasValue((double)ValueFormatter.convertDateDoubleToLong((double)oBS.getNum())) : new CanvasValue(oBS.getNum()));
                canvasValue.setIsMissing(iSpssVariable.isMissing(oBS));
                if (!canvasValue.isMissing()) {
                    ++n;
                }
                treeMap.put(canvasValue, string);
            }
            if (n == 0 && iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.scale) {
                String string = ResUtil.getCommonDlgString("IDS_CATEGORY_NUM");
                if (iSpssVariable.getFormat().getFormatType().isStringFormat()) {
                    treeMap.put(new CanvasValue("1"), String.format(string, 1));
                    treeMap.put(new CanvasValue("2"), String.format(string, 2));
                } else {
                    treeMap.put(new CanvasValue(1.0), String.format(string, 1));
                    treeMap.put(new CanvasValue(2.0), String.format(string, 2));
                }
                canvasVariable.setIsDefaultCategories(true);
            }
            canvasVariable.setValueLabels(treeMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SpssCanvasVariableFactory() {
        CanvasVariable.setVarInfoLoader((IVarInfoLoader)this);
    }
}

