/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.util.AccessibilityUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OptionsTab
extends BaseProcedureTab
implements ItemListener {
    private static final int TEXT_FIELD_COLS = 6;
    private static final String UNITS_COMBO_KEY = "IDS_UNITS_COMBO";
    private static final String EMPTY_TEXT_KEY = "IDS_EMPTY_TEXT";
    private static final String STATS_NOT_COMP_KEY = "IDS_STATS_NC";
    private static final String MIN_WIDTH_KEY = "IDS_MIN_WIDTH";
    private static final String MAX_WIDTH_KEY = "IDS_MAX_WIDTH";
    private static final String HIDE_SMALL = "IDS_HIDE_SMALL";
    private static final String LESS_THAN = "IDS_LESS_THAN";
    private static final double PT_MIN = 15.0;
    private static final double PT_MAX = 2000.0;
    private static final double IN_MIN = 0.209;
    private static final double IN_MAX = 27.77;
    private static final double CM_MIN = 0.53;
    private static final double CM_MAX = 70.555;
    private SpssButtonGroup mEmptyCellsGroup;
    private JRadioButton mZeroRadio;
    private JRadioButton mBlankRadio;
    private JRadioButton mTextRadio;
    private ContextEnabledTextField mEmptyTextEdit;
    private ContextEnabledTextField mStatsNotComp;
    private SpssButtonGroup mWidthGroup;
    private JRadioButton mTableLookRadio;
    private JRadioButton mCustomRadio;
    private JLabel mMinLabel;
    private JLabel mMaxLabel;
    private FloatTextField mMinWidthEdit;
    private FloatTextField mMaxWidthEdit;
    private JComboBox mUnitsCombo;
    private SpssButtonGroup mMissingGroup;
    private JRadioButton mVarByVarRadio;
    private JCheckBox mDupResponsesCheck;
    private JButton mTableStyleButton;
    private JCheckBox mHideSmallCheck;
    private JLabel mLessThanLabel;
    private IntTextField mLessThanEdit;
    private JCheckBox mUseEffectBaseVarCheck;
    private JLabel mSrcListLabel;
    private JLabel mTargetListLabel;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private UnitType mCurrentUnits = UnitType.inches;
    BaseProcedureDialog mParentProcedureDialog;
    public static final String TARGETLIST_WEIGHT_KEY = "OPTIONS_TARGET_LIST_WEIGHT";

    public OptionsTab(BaseProcedureDialog baseProcedureDialog, boolean bl) {
        super(baseProcedureDialog, bl);
        this.mParentProcedureDialog = baseProcedureDialog;
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_table_general";
    }

    @Override
    public void reset() {
        super.reset();
        this.mZeroRadio.setSelected(true);
        this.mEmptyTextEdit.setText("");
        this.mStatsNotComp.setText(".");
        this.mTableLookRadio.setSelected(true);
        this.mUnitsCombo.setSelectedIndex(0);
        this.mMinWidthEdit.setText("36");
        this.mMaxWidthEdit.setText("72");
        this.mVarByVarRadio.setSelected(true);
        this.mDupResponsesCheck.setSelected(false);
        this.mHideSmallCheck.setSelected(false);
        this.mLessThanLabel.setEnabled(false);
        this.mLessThanEdit.setEnabled(false);
        this.mLessThanEdit.setText("5");
        this.enableMinMaxCtrls(false);
        this.mEmptyTextEdit.setEnabled(false);
        this.mUseEffectBaseVarCheck.setSelected(false);
        this.enableEffectiveBaseCtrls(false);
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
    }

    public void setupListDragAdapters(DragPane dragPane, IVarMoveHandler iVarMoveHandler) {
        if (dragPane != null) {
            DialogUtil.addDragAdapters(dragPane, this.mSrcVarList, iVarMoveHandler);
            DialogUtil.addDragAdapters(dragPane, this.mTargetVarList, iVarMoveHandler);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mHideSmallCheck) {
            this.updateState();
        } else if (object == this.mUseEffectBaseVarCheck) {
            this.enableEffectiveBaseCtrls(this.mUseEffectBaseVarCheck.isSelected());
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (object == this.mZeroRadio) {
            this.mEmptyTextEdit.setEnabled(false);
        } else if (object == this.mBlankRadio) {
            this.mEmptyTextEdit.setEnabled(false);
        } else if (object == this.mTextRadio) {
            this.mEmptyTextEdit.setEnabled(true);
        } else if (object == this.mTableLookRadio) {
            this.enableMinMaxCtrls(false);
        } else if (object == this.mCustomRadio) {
            this.enableMinMaxCtrls(true);
        } else if (object == this.mUnitsCombo) {
            this.handleUnitChange();
        }
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.mCurrentUnits = ((ComboItem)this.mUnitsCombo.getSelectedItem()).mUnit;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupLeftPane();
        this.setupRightPane();
        this.setupLowerPane();
        this.setupEffectiveBasePane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TABLE_STYLE_BUTTON_CTABLES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsTab.this.runConditionalSubDialog();
            }
        };
        this.mTableStyleButton = new JButton(toggleButtonAction);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mTableStyleButton, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.fill = 2;
        this.mDupResponsesCheck = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_COUNT_DUP_CHECK"));
        DialogUtil.addUsingGBL(this, this.mDupResponsesCheck, gridBagConstraints, 0, 4, 2, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParent, HIDE_SMALL);
        this.mHideSmallCheck = new JCheckBox(toggleButtonAction);
        this.mHideSmallCheck.addItemListener(this);
        DialogUtil.addUsingGBL(this, this.mHideSmallCheck, gridBagConstraints, 0, 5, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 6, 1, 1, n, new Insets(0, 0, 0, 0));
        this.mLessThanLabel = new JLabel(this.getResString(LESS_THAN));
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 18;
        DialogUtil.addUsingGBL(jPanel, this.mLessThanLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mLessThanEdit = new IntTextField(2, Integer.MAX_VALUE, true);
        this.mLessThanEdit.setAction((Action)new TextFieldAction(this.mParent, LESS_THAN));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLessThanEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mLessThanEdit.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                OptionsTab.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                OptionsTab.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                OptionsTab.this.updateState();
            }
        });
        this.setFocusTraversalPolicy();
    }

    private boolean runConditionalSubDialog() {
        TableStyleDlg tableStyleDlg = new TableStyleDlg(this.mParentProcedureDialog, TableStyleDlg.ConditionalFormatDlgType.CTables);
        tableStyleDlg.setVisible(true);
        return tableStyleDlg.wasContinuePressed();
    }

    private void updateState() {
        this.mLessThanLabel.setEnabled(this.mHideSmallCheck.isSelected());
        this.mLessThanEdit.setEnabled(this.mHideSmallCheck.isSelected());
    }

    protected void setupLeftPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2);
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DATA_CELL_GROUP")));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.getResString("IDS_EMPTY_CELLS"));
        jLabel.setHorizontalAlignment(0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 10, insets);
        this.mZeroRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_ZERO_RADIO"));
        DialogUtil.addUsingGBL(jPanel, this.mZeroRadio, gridBagConstraints, 1, 0, 2, 1, 22, insets);
        this.mBlankRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_BLANK_RADIO"));
        DialogUtil.addUsingGBL(jPanel, this.mBlankRadio, gridBagConstraints, 1, 1, 2, 1, 22, insets);
        this.mTextRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TEXT_RADIO"));
        DialogUtil.addUsingGBL(jPanel, this.mTextRadio, gridBagConstraints, 1, 2, 1, 1, 22, insets);
        this.mEmptyTextEdit = new ContextEnabledTextField(6);
        this.mEmptyTextEdit.setAction((Action)new TextFieldAction(this.mParent, EMPTY_TEXT_KEY));
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mEmptyTextEdit, gridBagConstraints, 2, 2, 1, 1, 21, insets);
        this.mEmptyTextEdit.setEnabled(false);
        this.mEmptyCellsGroup = new SpssButtonGroup();
        this.mEmptyCellsGroup.add(this.mZeroRadio);
        this.mEmptyCellsGroup.add(this.mBlankRadio);
        this.mEmptyCellsGroup.add(this.mTextRadio);
        AccessibilityUtil.setAccessibleText((Component)this.mZeroRadio, (Object)(this.getResString("IDS_EMPTY_CELLS") + this.mZeroRadio.getText()));
        AccessibilityUtil.setAccessibleText((Component)this.mBlankRadio, (Object)(this.getResString("IDS_EMPTY_CELLS") + this.mBlankRadio.getText()));
        AccessibilityUtil.setAccessibleText((Component)this.mTextRadio, (Object)(this.getResString("IDS_EMPTY_CELLS") + this.mTextRadio.getText()));
        AccessibilityUtil.setAccessibleText((Component)this.mEmptyTextEdit, (Object)this.getResString("IDS_EMPTY_CELLS"));
        this.mZeroRadio.setSelected(true);
        this.mZeroRadio.addItemListener(this);
        this.mBlankRadio.addItemListener(this);
        this.mTextRadio.addItemListener(this);
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(n2 * 2, 0, 0, n2 * 2);
        JLabel jLabel2 = DialogUtil.createMultiLineLabel(this.mParent, "IDS_STATS_NOT_COMP", 80);
        AccessibilityUtil.setAccessibleText((Component)jLabel2, (Object)((SpssMultiLineLabel)jLabel2).getLabelText());
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 3, 1, 1, 10, insets);
        this.mStatsNotComp = new ContextEnabledTextField(6);
        jLabel2.setLabelFor((Component)this.mStatsNotComp);
        this.mStatsNotComp.setAction((Action)new TextFieldAction(this.mParent, STATS_NOT_COMP_KEY));
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStatsNotComp, gridBagConstraints, 1, 3, 2, 1, 21, insets2);
    }

    protected void setupRightPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, 0);
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DATA_COLUMN_GROUP")));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        this.mTableLookRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_TABLELOOK_RADIO"));
        DialogUtil.addUsingGBL(jPanel, this.mTableLookRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mCustomRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_CUSTOM_RADIO"));
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mWidthGroup = new SpssButtonGroup();
        this.mWidthGroup.add(this.mTableLookRadio);
        this.mWidthGroup.add(this.mCustomRadio);
        this.mTableLookRadio.setSelected(true);
        this.mTableLookRadio.addItemListener(this);
        this.mCustomRadio.addItemListener(this);
        insets.bottom += 3;
        gridBagConstraints.fill = 0;
        this.mMinLabel = DialogUtil.createLabel(this.mParent, "IDS_MIN_LABEL");
        this.mMinLabel.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, this.mMinLabel, gridBagConstraints, 0, 2, 1, 1, 22, insets);
        this.mMaxLabel = DialogUtil.createLabel(this.mParent, "IDS_MAX_LABEL");
        this.mMaxLabel.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, this.mMaxLabel, gridBagConstraints, 0, 3, 1, 1, 22, insets);
        this.mMinWidthEdit = new FloatTextField(0.0, Double.MAX_VALUE, 4, true);
        this.mMinWidthEdit.setAction((Action)new TextFieldAction(this.mParent, MIN_WIDTH_KEY));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinWidthEdit, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mMaxWidthEdit = new FloatTextField(0.0, Double.MAX_VALUE, 4, true);
        this.mMaxWidthEdit.setAction((Action)new TextFieldAction(this.mParent, MAX_WIDTH_KEY));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxWidthEdit, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mMinLabel.setLabelFor((Component)this.mMinWidthEdit);
        this.mMaxLabel.setLabelFor((Component)this.mMaxWidthEdit);
        this.mMinWidthEdit.setColumns(6);
        this.mMaxWidthEdit.setColumns(6);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        n = 22;
        Insets insets2 = new Insets(7, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_UNITS_LABEL");
        jLabel.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 5, 1, 1, 10, insets);
        Vector<ComboItem> vector = new Vector<ComboItem>();
        vector.add(new ComboItem(this.getResString("IDS_POINTS"), UnitType.points));
        vector.add(new ComboItem(this.getResString("IDS_INCHES"), UnitType.inches));
        vector.add(new ComboItem(this.getResString("IDS_CENTIMETERS"), UnitType.centimeters));
        this.mUnitsCombo = new JComboBox(vector);
        this.mUnitsCombo.setAction(new ComboboxAction(this.mParent, UNITS_COMBO_KEY));
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUnitsCombo, gridBagConstraints, 1, 5, 1, 1, 21, insets);
        jLabel.setLabelFor(this.mUnitsCombo);
        this.mUnitsCombo.setSelectedIndex(0);
        this.mUnitsCombo.addItemListener(this);
    }

    protected void setupLowerPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, 0);
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MISSING_VALUES_GROUP")));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets = DialogUtil.getStandardControlInsets();
        String string = "IDS_VAR_BY_VAR_RADIO";
        this.mVarByVarRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mParent, string), 180);
        DialogUtil.addUsingGBL(jPanel, this.mVarByVarRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        String string2 = "IDS_LISTWISE_RADIO";
        SpssMultiLineRadioButton spssMultiLineRadioButton = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mParent, string2), 200);
        DialogUtil.addUsingGBL(jPanel, spssMultiLineRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mMissingGroup = new SpssButtonGroup();
        this.mMissingGroup.add(this.mVarByVarRadio);
        this.mMissingGroup.add(spssMultiLineRadioButton);
        this.mVarByVarRadio.setSelected(true);
    }

    private void setupEffectiveBasePane() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new NumericVarFilter());
        this.mSrcVarList.setSuppressAlert(true);
        this.mSrcVarList.loadFromActiveDataset();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        Dimension dimension = (Dimension)this.mSrcVarList.getMinimumSize().clone();
        dimension.width += 100;
        dimension.height -= 85;
        jScrollPane.setPreferredSize(dimension);
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setIdentifier(TARGETLIST_WEIGHT_KEY);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        Dimension dimension2 = (Dimension)this.mTargetVarList.getMinimumSize().clone();
        dimension2.width += 50;
        jScrollPane2.setPreferredSize(dimension2);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setSelectedIndex(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, 0);
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EFFECTIVE_BASE_GROUP")));
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getStandardControlInsets();
        this.mUseEffectBaseVarCheck = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_USE_EFF_VAR_CHECK"));
        this.mUseEffectBaseVarCheck.addItemListener(this);
        if (this.mSrcVarList.getModel().getSize() == 0) {
            this.mUseEffectBaseVarCheck.setEnabled(false);
        }
        DialogUtil.addUsingGBL(jPanel, this.mUseEffectBaseVarCheck, gridBagConstraints, 0, 0, 3, 1, n, new Insets(0, 0, 0, 3));
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        gridBagConstraints.fill = 2;
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_USE_EFF_SRCVAR_LABEL");
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        this.mTargetListLabel = DialogUtil.createLabel(this.mParent, "IDS_USE_EFF_TARGETVAR_LABEL");
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        Insets insets4 = new Insets(0, insets3.left, 0, insets3.right);
        insets4.left += 20;
        insets4.right += 20;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 2, 1, 1, n, null);
    }

    @Override
    public boolean validateTab() {
        String string = null;
        Object object = null;
        String string2 = this.mMinWidthEdit.getText();
        String string3 = this.mMaxWidthEdit.getText();
        if (string2.length() > 0 && string3.length() > 0) {
            double d = Double.parseDouble(string2);
            double d2 = Double.parseDouble(string3);
            if (this.mCustomRadio.isSelected()) {
                if (d > d2) {
                    string = this.getResString("ERR_MIN_MAX_VALID");
                    object = this.mMinWidthEdit;
                } else {
                    ComboItem comboItem = (ComboItem)this.mUnitsCombo.getSelectedItem();
                    UnitType unitType = comboItem.mUnit;
                    if (unitType == UnitType.points) {
                        if (d < 15.0) {
                            String string4 = this.getResString("ERR_MIN_TOO_LOW");
                            string = String.format(string4, DialogUtil.formatDouble(15.0), this.getResString("IDS_POINTS"));
                            object = this.mMinWidthEdit;
                        } else if (d2 > 2000.0) {
                            String string5 = this.getResString("ERR_MAX_TOO_HIGH");
                            string = String.format(string5, DialogUtil.formatDouble(2000.0), this.getResString("IDS_POINTS"));
                            object = this.mMaxWidthEdit;
                        }
                    } else if (unitType == UnitType.inches) {
                        if (d < 0.209) {
                            String string6 = this.getResString("ERR_MIN_TOO_LOW");
                            string = String.format(string6, DialogUtil.formatDouble(0.209), this.getResString("IDS_INCHES"));
                            object = this.mMinWidthEdit;
                        } else if (d2 > 27.77) {
                            String string7 = this.getResString("ERR_MAX_TOO_HIGH");
                            string = String.format(string7, DialogUtil.formatDouble(27.77), this.getResString("IDS_INCHES"));
                            object = this.mMaxWidthEdit;
                        }
                    } else if (unitType == UnitType.centimeters) {
                        if (d < 0.53) {
                            String string8 = this.getResString("ERR_MIN_TOO_LOW");
                            string = String.format(string8, DialogUtil.formatDouble(0.53), this.getResString("IDS_CENTIMETERS"));
                            object = this.mMinWidthEdit;
                        } else if (d2 > 70.555) {
                            String string9 = this.getResString("ERR_MAX_TOO_HIGH");
                            string = String.format(string9, DialogUtil.formatDouble(70.555), this.getResString("IDS_CENTIMETERS"));
                            object = this.mMaxWidthEdit;
                        }
                    }
                }
            }
        } else if (string2.length() == 0) {
            string = this.getResString("ERR_MIN_EMPTY");
            object = this.mMinWidthEdit;
        } else if (string3.length() == 0) {
            string = this.getResString("ERR_MAX_EMPTY");
            object = this.mMaxWidthEdit;
        }
        if (string == null && this.mHideSmallCheck.isSelected() && this.mLessThanEdit.getText().length() == 0) {
            string = this.getResString("ERR_LESS_THAN_EMPTY");
            object = this.mLessThanEdit;
        }
        if (this.mUseEffectBaseVarCheck.isSelected() && this.mTargetVarList.getModel().getSize() == 0) {
            string = this.getResString("ERR_WEIGHT_VAR_EMPTY");
            object = this.mSrcVarList;
        }
        if (string != null) {
            SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)VersionInfo.getAppVersionString());
            FloatTextField floatTextField = object;
            SwingUtilities.invokeLater(new Runnable((JComponent)floatTextField){
                final /* synthetic */ JComponent val$focusComp;
                {
                    this.val$focusComp = jComponent;
                }

                @Override
                public void run() {
                    this.val$focusComp.requestFocusInWindow();
                    if (this.val$focusComp instanceof SPSSTextField) {
                        ((SPSSTextField)this.val$focusComp).selectAll();
                    }
                }
            });
            return false;
        }
        return true;
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        String string;
        boolean bl = false;
        if (!(this.mZeroRadio.isSelected() && this.mStatsNotComp.getText().equals(".") && this.mTableLookRadio.isSelected() && this.mUnitsCombo.getSelectedIndex() == 0)) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/FORMAT EMPTY="));
            if (this.mZeroRadio.isSelected()) {
                stringBuffer.append("ZERO");
            } else if (this.mBlankRadio.isSelected()) {
                stringBuffer.append("BLANK");
            } else if (this.mTextRadio.isSelected()) {
                stringBuffer.append(CharacterUtil.smartQuote((String)this.mEmptyTextEdit.getText()));
            }
            stringBuffer.append(" MISSING=");
            string = CharacterUtil.smartQuote((String)this.mStatsNotComp.getText());
            stringBuffer.append(string.length() > 0 ? string : "''");
            if (this.mCustomRadio.isSelected()) {
                stringBuffer.append(" MINCOLWIDTH=");
                stringBuffer.append(this.mMinWidthEdit.getText());
                stringBuffer.append(" MAXCOLWIDTH=");
                stringBuffer.append(this.mMaxWidthEdit.getText());
                stringBuffer.append(" UNITS=");
                ComboItem comboItem = (ComboItem)this.mUnitsCombo.getSelectedItem();
                UnitType unitType = comboItem.mUnit;
                if (unitType == UnitType.points) {
                    stringBuffer.append("POINTS\n");
                } else if (unitType == UnitType.inches) {
                    stringBuffer.append("INCHES\n");
                } else if (unitType == UnitType.centimeters) {
                    stringBuffer.append("CM\n");
                }
            } else {
                stringBuffer.append('\n');
            }
            bl = true;
        }
        if (this.mDupResponsesCheck.isSelected()) {
            string = this.mDupResponsesCheck.isSelected() ? "YES" : "NO";
            stringBuffer.append(SyntaxUtil.getSubCommand("/MRSETS COUNTDUPLICATES=" + string)).append("\n");
            bl = true;
        }
        if (this.mHideSmallCheck.isSelected() && this.mLessThanEdit.getText().length() > 0) {
            string = this.mLessThanEdit.getText();
            stringBuffer.append(SyntaxUtil.getSubCommand(String.format("/HIDESMALLCOUNTS COUNT=%s\n", string)));
        }
        if (bl || !this.mVarByVarRadio.isSelected()) {
            string = this.mVarByVarRadio.isSelected() ? "VARIABLE" : "LISTWISE";
            stringBuffer.append(SyntaxUtil.getSingleParameterSubCommand("SMISSING", string));
        }
        if (this.mUseEffectBaseVarCheck.isSelected() && this.mTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/WEIGHT VARIABLE="));
            stringBuffer.append(this.mTargetVarList.getVariablesStringList());
            stringBuffer.append('\n');
        }
    }

    private void enableMinMaxCtrls(boolean bl) {
        this.mMinLabel.setEnabled(bl);
        this.mMaxLabel.setEnabled(bl);
        this.mMinWidthEdit.setEnabled(bl);
        this.mMaxWidthEdit.setEnabled(bl);
    }

    private void enableEffectiveBaseCtrls(boolean bl) {
        this.mSrcListLabel.setEnabled(bl);
        this.mSrcVarList.setEnabled(bl);
        this.mArrowButton.setEnabled(bl);
        this.mTargetListLabel.setEnabled(bl);
        this.mTargetVarList.setEnabled(bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mEmptyCellsGroup);
        this.mComponentOrder.add(this.mEmptyTextEdit);
        this.mComponentOrder.add(this.mStatsNotComp);
        this.mComponentOrder.add(this.mWidthGroup);
        this.mComponentOrder.add(this.mMinWidthEdit);
        this.mComponentOrder.add(this.mMaxWidthEdit);
        this.mComponentOrder.add(this.mUnitsCombo);
        this.mComponentOrder.add(this.mMissingGroup);
        this.mComponentOrder.add(this.mUseEffectBaseVarCheck);
        this.mComponentOrder.add(this.mSrcVarList);
        this.mComponentOrder.add(this.mArrowButton);
        this.mComponentOrder.add(this.mTargetVarList);
        this.mComponentOrder.add(this.mTableStyleButton);
        this.mComponentOrder.add(this.mDupResponsesCheck);
        this.mComponentOrder.add(this.mHideSmallCheck);
        this.mComponentOrder.add(this.mLessThanEdit);
    }

    void handleUnitChange() {
        UnitType unitType = ((ComboItem)this.mUnitsCombo.getSelectedItem()).mUnit;
        if (this.mCurrentUnits != unitType) {
            double d = Double.parseDouble(this.mMinWidthEdit.getText());
            double d2 = Double.parseDouble(this.mMaxWidthEdit.getText());
            double d3 = 1.0;
            if (this.mCurrentUnits == UnitType.points) {
                d3 = unitType == UnitType.inches ? 0.013889 : 0.035278;
            } else if (this.mCurrentUnits == UnitType.inches) {
                d3 = unitType == UnitType.points ? 72.0 : 2.54;
            } else if (this.mCurrentUnits == UnitType.centimeters) {
                d3 = unitType == UnitType.points ? 28.34646 : 0.393701;
            }
            d = (double)((int)(1000.0 * (d * d3 + 5.0E-4))) * 0.001;
            d2 = (double)((int)(1000.0 * (d2 * d3 + 5.0E-4))) * 0.001;
            this.mCurrentUnits = unitType;
            if (this.mCurrentUnits == UnitType.points) {
                d = Math.min(Math.max(d, 15.0), 2000.0);
                d2 = Math.max(Math.min(d2, 2000.0), 15.0);
            } else if (this.mCurrentUnits == UnitType.inches) {
                d = Math.min(Math.max(d, 0.209), 27.77);
                d2 = Math.max(Math.min(d2, 27.77), 0.209);
            } else if (this.mCurrentUnits == UnitType.centimeters) {
                d = Math.min(Math.max(d, 0.53), 70.555);
                d2 = Math.max(Math.min(d2, 70.555), 0.53);
            }
            this.mMinWidthEdit.setText(DialogUtil.formatDouble(d));
            this.mMaxWidthEdit.setText(DialogUtil.formatDouble(d2));
        }
    }

    private class NumericVarFilter
    implements IVarFilter {
        private NumericVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            FormatType formatType = iSpssVariable.getFormat().getFormatType();
            return formatType != null && formatType.isNumericFormat();
        }
    }

    class ComboItem {
        String mText;
        UnitType mUnit;

        ComboItem(String string, UnitType unitType) {
            this.mText = string;
            this.mUnit = unitType;
        }

        public String toString() {
            return this.mText;
        }
    }

    static enum UnitType {
        points,
        inches,
        centimeters;

    }
}

