/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.CategoriesList;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.drag_drop.ExpressionTextAreaDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.ctables.CategoriesTable;
import com.spss.shared.core_tools.format.ExtendedSimpleDateFormat;
import com.spss.uitools.canvas.ICanvasVariable;
import com.spss.uitools.canvas.tables.CatBag;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.ListToolTip;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.EncodingValidator;
import com.spss.uitools.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.nio.charset.CoderResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ExpressionTab
extends BaseProcedureTab
implements ListToolTip.CustomTooltipCallback {
    private static final int MAX__LABEL_BYTES = 200;
    private static Icon sTotalCatIcon;
    private static Icon sOtherCatIcon;
    private JLabel mVarLabel;
    private ContextEnabledTextField mCompCatLabelField;
    private PlainList mSrcCatList;
    private PlainList mSrcTotalsList;
    private ExpressionAreaArrowButton mCatExpressionArrowButton;
    private ExpressionAreaArrowButton mTotalExpressionArrowButton;
    private ExpressionBuilderTextArea mExpressionArea;
    private DCCalcWidget mOperatorPanel;
    private JCheckBox mHideCatCheck;
    private TextAreaKeyListener mTextAreaKeyListener;
    private CategoriesTable mCategoriesTable;
    private ICanvasVariable mVariable;

    public ExpressionTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "";
    }

    public void setVarLabel(String string) {
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            this.mVarLabel.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            this.mVarLabel.setText(string);
        }
        Dimension dimension = this.mVarLabel.getPreferredSize();
        dimension.width = 500;
        this.mVarLabel.setMinimumSize(dimension);
        this.mVarLabel.setPreferredSize(dimension);
    }

    public String getCompCatLabel() {
        return this.mCompCatLabelField.getText();
    }

    public String getExpression() {
        return this.mExpressionArea.getText();
    }

    public boolean getHideCat() {
        return this.mHideCatCheck.isSelected();
    }

    public void setHideCat(boolean bl) {
        this.mHideCatCheck.setSelected(bl);
    }

    public void setTraversalPolicyForAreaKeyListener(DialogFocusTraversalPolicy dialogFocusTraversalPolicy) {
        this.mTextAreaKeyListener.setTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void loadCurrentState(CategoriesTable categoriesTable, boolean bl, boolean bl2, boolean bl3, String string) {
        this.loadSrcLists(categoriesTable, bl, bl2, bl3, string);
        this.mSrcCatList.setSelectedIndex(0);
        this.mCategoriesTable = categoriesTable;
    }

    public void loadValues(String string, String string2, boolean bl) {
        this.mCompCatLabelField.setText(string);
        this.mExpressionArea.setText(string2);
        this.mHideCatCheck.setSelected(bl);
    }

    public Icon getTotalCatIcon() {
        if (sTotalCatIcon == null) {
            sTotalCatIcon = new ImageIcon(this.getResImageURL("IDI_EXPRESS_TAB_TOTAL_IMAGE"));
        }
        return sTotalCatIcon;
    }

    public Icon getOtherCatIcon() {
        if (sOtherCatIcon == null) {
            sOtherCatIcon = new ImageIcon(this.getResImageURL("IDI_EXPRESS_TAB_OTHER_IMAGE"));
        }
        return sOtherCatIcon;
    }

    public void enableContinue() {
        ((BaseSubDialog)this.mParent).enableContinue(this.mCompCatLabelField.getText().length() > 0 && this.mExpressionArea.getText().length() > 0 && this.isCharPresent((JTextComponent)((Object)this.mExpressionArea), '?'));
    }

    public String generateUniqueIdForCompCat() {
        int n = 1;
        ArrayList<CatBag> arrayList = this.mCategoriesTable.getAllRowsByFlag(128);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (CatBag catBag : arrayList) {
            String string = catBag.getName();
            String string2 = string.replace("&cat", "").trim();
            arrayList2.add(Integer.parseInt(string2));
        }
        if (arrayList2.size() > 0) {
            for (int i = 1; i < 100; ++i) {
                if (arrayList2.contains(i)) continue;
                n = i;
                break;
            }
        }
        return "&cat" + n;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupPanel();
        if (this.mParent.getGlassPane() instanceof DragPane) {
            PostCategoryLabelTextAreaDropListener postCategoryLabelTextAreaDropListener = new PostCategoryLabelTextAreaDropListener(this.mCompCatLabelField);
            ExpressionBuilderUtil.addExpTextDragAdapter((DragPane)this.mParent.getGlassPane(), this.mCompCatLabelField, (ExpressionTextAreaDropListener)postCategoryLabelTextAreaDropListener);
            DCExpressionTextAreaDropListener dCExpressionTextAreaDropListener = new DCExpressionTextAreaDropListener(this.mExpressionArea);
            ExpressionBuilderUtil.addExpTextDragAdapter((DragPane)this.mParent.getGlassPane(), this.mExpressionArea, (ExpressionTextAreaDropListener)dCExpressionTextAreaDropListener);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.mParent.getGlassPane(), this.mSrcCatList);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.mParent.getGlassPane(), this.mSrcTotalsList);
        }
        this.setComponentOrder();
    }

    @Override
    protected boolean validateTab() {
        Object object;
        Object object2;
        EncodingValidator encodingValidator;
        boolean bl = true;
        String string = this.getResString("ERR_EXPRESS_TAB_MSG");
        if (!this.mExpressionArea.validateContents()) {
            bl = false;
        }
        if (!(encodingValidator = new EncodingValidator(ComponentState.getCurrentCharset(), 120)).validateString(this.mCompCatLabelField.getText())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean bl = encodingValidator.getResult().equals(CoderResult.OVERFLOW);
                    if (bl) {
                        SpssAlertOptionPane.showInformationMessageDialog(ExpressionTab.this, "Label text must be 1 to 120 bytes.", VersionInfo.getAppVersionString());
                    } else {
                        String string = "ERR_STRING_UNMAPPABLE_MSG";
                        String string2 = UIToolResUtil.getString((String)string);
                        SpssAlertOptionPane.showInformationMessageDialog(ExpressionTab.this, string2, VersionInfo.getAppVersionString());
                    }
                }
            });
            return false;
        }
        String string2 = this.mVariable.getName();
        String string3 = this.mExpressionArea.getText();
        if (string3.equals("")) {
            return true;
        }
        if ((this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrCategorical || this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrDichotomous) && (object2 = (IVariableSet)(object = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId())).getMultiResponseVariableMap().get(this.mVariable.getName())) != null) {
            string2 = (String)object2.getVariableNames(IVariableSet.ChangeCase.kNoChange).get(0);
        }
        if (!(!bl || XmlStringUtil.charCountBalanced((String)string3, (char)'(', (char)')') && XmlStringUtil.charCountBalanced((String)string3, (char)'[', (char)']'))) {
            bl = false;
        }
        object = this.getSourceCats(string3);
        if ((bl && this.mVariable.getVarType() > 0 || bl && this.mVariable.getVarType() == 0 && this.mVariable.getFormat() instanceof ExtendedSimpleDateFormat) && (object2 = this.isStringValueQuoted((Vector<String>)object)) != null) {
            bl = false;
            string = object2;
        }
        if (bl && (object2 = this.isValidExpression(string3, string2)) != null) {
            bl = false;
            string = object2;
        }
        if (bl && (object2 = this.isExcludedCategoriesUsed((Vector<String>)object)) != null) {
            bl = false;
            string = object2;
        }
        if (!bl && string != null) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private String isStringValueQuoted(Vector<String> vector) {
        String string = null;
        for (String string2 : vector) {
            if (string2.startsWith("'") && string2.endsWith("'")) continue;
            string = this.getResString("ERR_EXPRESS_TAB_NOTQuoted");
            break;
        }
        return string;
    }

    private String isExcludedCategoriesUsed(Vector<String> vector) {
        String string = null;
        Vector<String> vector2 = new Vector<String>();
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcCatList.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            DCCatBag object = (DCCatBag)((Object)defaultListModel.get(i));
            if (this.mVariable.getVarType() == 0) {
                vector2.add(UIToolResUtil.removeLocale((String)object.getFormattedValue()));
                continue;
            }
            vector2.add(object.getFormattedValue());
        }
        for (String string2 : vector) {
            String string3 = string2.replaceAll("'", "");
            if (vector2.contains(string3)) continue;
            string = this.getResString("ERR_EXPRESS_TAB_NOEXCLUDED");
            break;
        }
        return string;
    }

    private Vector<String> getSourceCats(String string) {
        Vector<String> vector = new Vector<String>();
        if (this.mVariable.getVarType() == 0) {
            string = string.replaceAll("\\p{javaWhitespace}", "");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "]");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("SUBTOTAL[") >= 0 || string2.indexOf("[") < 0) continue;
            String string3 = string2.substring(string2.indexOf("[") + 1);
            string3 = string3.trim();
            vector.add(string3);
        }
        return vector;
    }

    private String isValidExpression(String object, String string) {
        Object object2;
        Object object3 = null;
        if (this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrDichotomous) {
            object2 = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
            if (object2.getVariable(object2.findVarIndex(string)).getType() == 0) {
                object = this.replaceAllCats((String)object, string);
                object = ((String)object).replaceAll("\\[", "");
                object = ((String)object).replaceAll("\\]", "");
            } else {
                object = this.replaceAllCats((String)object, "LENGTH(" + string + ")");
                object = ((String)object).replaceAll("\\[\\p{javaWhitespace}*[\\p{Alnum}+\\s+]+\\p{javaWhitespace}*\\]", "LENGTH(" + string + ")");
            }
        } else if (this.mVariable.getVarType() > 0) {
            object = this.replaceAllCats((String)object, string);
            object = ((String)object).replaceAll("\\[\\p{javaWhitespace}*'[\\p{Alnum}+\\s+]+'\\p{javaWhitespace}*\\]", string);
            object = ((String)object).replaceAll("\\p{javaWhitespace}*", "");
        } else if (this.mVariable.getVarType() == 0 && (this.mVariable.getFormat() instanceof ExtendedSimpleDateFormat || this.mVariable.getFormat() instanceof SimpleDateFormat)) {
            object = this.replaceAllCats((String)object, string);
            object = ((String)object).replaceAll("\\[\\p{javaWhitespace}*'[\\p{Alnum}+\\s+[-/\\.:]+]+'\\p{javaWhitespace}*\\]", string);
            object = ((String)object).replaceAll("\\p{javaWhitespace}*", "");
        } else {
            object = this.replaceAllCats((String)object, string);
            object = ((String)object).replaceAll("\\[\\w*\\.*\\w+\\]", string);
        }
        object2 = this.preValidate((String)object);
        if (object2 != null && !((String)object2).startsWith(string)) {
            object3 = object2;
        } else {
            ExpressionValidator expressionValidator;
            if (object2 != null && ((String)object2).equals(string + "+")) {
                object = object2;
            }
            if (!(expressionValidator = new ExpressionValidator()).validatePostComputeCatExpression((String)object, null, this.mVariable.getVarType() > 0)) {
                object3 = expressionValidator.checkPComputeError();
            }
        }
        return object3;
    }

    private String replaceAllCats(String string, String string2) {
        string = string.replaceAll("MISSING", string2);
        string = string.replaceAll("OTHERNM", string2);
        string = string.replaceAll("SUBTOTAL\\[\\d+\\]", string2);
        string = string.replaceAll("TOTAL", string2);
        return string;
    }

    private String preValidate(String string) {
        String string2 = string.trim().replaceAll(" ", "");
        if (string2.startsWith("+") || string2.startsWith("-") || string2.startsWith("*") || string2.startsWith("/")) {
            return "The sequence of operators found is invalid.  Check the expression for omitted or extra operands, operators, and parentheses.";
        }
        if (string2.indexOf("++") > 0 || string2.indexOf("+-") > 0 || string2.indexOf("-+") > 0 || string2.indexOf("--") > 0 || string2.indexOf("*+") > 0 || string2.indexOf("*-") > 0 || string2.indexOf("/+") > 0 || string2.indexOf("/-") > 0) {
            return "The sequence of operators found is invalid.  Check the expression for omitted or extra operands, operators, and parentheses.";
        }
        if (this.mVariable.getVarType() > 0 && (string2.endsWith("+") || string2.endsWith("-") || string2.endsWith("*") || string2.endsWith("/"))) {
            return this.mVariable.getName() + "+";
        }
        return null;
    }

    private void initVars() {
        this.mCompCatLabelField = new ContextEnabledTextField(18);
        this.mCompCatLabelField.setDocument((Document)ContextEnabledTextField.createLimitBytesDocument((int)200));
        this.mCompCatLabelField.getDocument().addDocumentListener(new TextDocumentListener());
        this.mCompCatLabelField.setMinimumSize(this.mCompCatLabelField.getPreferredSize());
        this.mSrcCatList = new PlainList("");
        this.mSrcCatList.setModel(new DefaultListModel());
        this.mSrcCatList.setSelectionMode(0);
        this.mSrcCatList.setCellRenderer(new SrcListCellRenderer());
        this.mSrcTotalsList = new PlainList("");
        this.mSrcTotalsList.setModel(new DefaultListModel());
        this.mSrcTotalsList.setSelectionMode(0);
        this.mSrcTotalsList.setCellRenderer(new SrcListCellRenderer());
        ((ListToolTip)this.mSrcTotalsList.createToolTip()).setCustomTooltipCallback((ListToolTip.CustomTooltipCallback)this);
        this.mExpressionArea = new ExpressionBuilderTextArea(3, 30);
        this.mExpressionArea.getDocument().addDocumentListener(new TextDocumentListener());
        this.mExpressionArea.setMaximumSize(this.mExpressionArea.getPreferredSize());
        this.mExpressionArea.setLineWrap(true);
        this.mCatExpressionArrowButton = new DCExpressionAreaArrowButton();
        this.mTotalExpressionArrowButton = new DCExpressionAreaArrowButton();
        this.mOperatorPanel = new DCCalcWidget((JTextArea)((Object)this.mExpressionArea));
        this.mHideCatCheck = new JCheckBox(new ToggleButtonAction(this.mParent, "IDS_EXPRESS_TAB_HIDE_CAT"));
        this.mCatExpressionArrowButton.registerComponents(this.mSrcCatList, SpssArrowButton.ButtonOrientation.right);
        this.mCatExpressionArrowButton.registerComponents((JComponent)((Object)this.mExpressionArea), SpssArrowButton.ButtonOrientation.left);
        this.mTotalExpressionArrowButton.registerComponents(this.mSrcTotalsList, SpssArrowButton.ButtonOrientation.right);
        this.mTotalExpressionArrowButton.registerComponents((JComponent)((Object)this.mExpressionArea), SpssArrowButton.ButtonOrientation.left);
        this.mTextAreaKeyListener = new TextAreaKeyListener((JTextArea)((Object)this.mExpressionArea), this.mParent, null, true);
        this.mExpressionArea.addKeyListener(this.mTextAreaKeyListener);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putArray("", new Object[0]);
    }

    private void setComponentOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCompCatLabelField);
        vector.add(this.mSrcCatList);
        vector.add(this.mSrcTotalsList);
        vector.add(this.mCatExpressionArrowButton);
        vector.add(this.mTotalExpressionArrowButton);
        vector.add((Object)this.mExpressionArea);
        vector.add(this.mOperatorPanel.getDefaultFocusButton());
        vector.add(this.mHideCatCheck);
        this.setComponentOrder(vector);
    }

    private void loadSrcLists(CategoriesTable categoriesTable, boolean bl, boolean bl2, boolean bl3, String string) {
        CatBag catBag;
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcCatList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mSrcTotalsList.getModel();
        if (defaultListModel.getSize() > 0) {
            defaultListModel.removeAllElements();
        }
        if (defaultListModel2.getSize() > 0) {
            defaultListModel2.removeAllElements();
        }
        int n = 1;
        for (int i = 0; i < categoriesTable.getRowCount(); ++i) {
            catBag = (CatBag)categoriesTable.getValueAt(i, 0);
            DCCatBag dCCatBag = new DCCatBag(catBag);
            if (categoriesTable.isTheRowByFlag(i, 2)) {
                if (!bl3) continue;
                defaultListModel2.addElement(new SubtotalCatBag(dCCatBag, n));
                ++n;
                continue;
            }
            if (categoriesTable.isTheRowByFlag(i, 128)) continue;
            defaultListModel.addElement(dCCatBag);
        }
        if (bl3 && string != null && !string.equals("")) {
            defaultListModel2.addElement(new DCCatBag(string, string, Double.NaN, 4, this.getTotalCatIcon()));
        }
        if (bl) {
            String string2 = this.getResString("IDS_CATSTOTALS_MISS");
            catBag = new DCCatBag(string2, string2, Double.NaN, 8, CategoriesList.sMissingIcon);
            defaultListModel.addElement(catBag);
        }
        if (bl2) {
            String string3 = this.getResString("IDS_CATSTOTALS_OTHER");
            catBag = new DCCatBag(string3, string3, Double.NaN, 8192, this.getOtherCatIcon());
            defaultListModel.addElement(catBag);
        }
    }

    private void setupPanel() {
        JPanel jPanel = this.setupTopPanel();
        JPanel jPanel2 = this.setupLeftPanel();
        JPanel jPanel3 = this.setupRightPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        insets = new Insets(n, 0, 105, 0);
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 1, 1, 1, n2, insets);
    }

    private JPanel setupTopPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mVarLabel = new JLabel(" ");
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_EXPRESS_TAB_COMPCAT_LABEL");
        jLabel.setLabelFor((Component)this.mCompCatLabelField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        Insets insets2 = new Insets(n, n, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mVarLabel, gridBagConstraints, 0, 0, 2, 1, n2, insets2);
        insets2 = new Insets(n, n, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2 = new Insets(n, insets.left, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCompCatLabelField, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupLeftPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_EXPRESS_TAB_CAT_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_EXPRESS_TAB_TOTALS_LABEL");
        jLabel.setLabelFor(this.mSrcCatList);
        jLabel2.setLabelFor(this.mSrcTotalsList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcCatList);
        jScrollPane.setViewportView(this.mSrcCatList);
        jScrollPane.setPreferredSize(new Dimension(180, 130));
        jScrollPane.setMinimumSize(new Dimension(180, 130));
        JScrollPane jScrollPane2 = new JScrollPane(this.mSrcTotalsList);
        jScrollPane2.setViewportView(this.mSrcTotalsList);
        jScrollPane2.setPreferredSize(new Dimension(150, 100));
        jScrollPane2.setMinimumSize(new Dimension(150, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(n, n, 0, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        insets2 = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2 = new Insets(n, n, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        insets2 = new Insets(0, n, n, n);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCatExpressionArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        n2 = 10;
        DialogUtil.addUsingGBL(jPanel, this.mTotalExpressionArrowButton, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_EXPRESS_TAB_EXPRESS_LABEL");
        jLabel.setLabelFor((Component)((Object)this.mExpressionArea));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mExpressionArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, 0, 0);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        insets2 = new Insets(0, n, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2 = new Insets(n, n, n, n);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mOperatorPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mHideCatCheck, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        return jPanel;
    }

    private boolean isCharPresent(JTextComponent jTextComponent, char c) {
        boolean bl = false;
        if (jTextComponent.getText().length() > 0) {
            bl = jTextComponent.getText().indexOf(c) == -1;
        }
        return bl;
    }

    public ListCellRenderer getCustomizeTooltipRenderer() {
        return new SrcListCellRenderer(true);
    }

    public void setVariable(ICanvasVariable iCanvasVariable) {
        this.mVariable = iCanvasVariable;
    }

    private String parseNumericValue(String string) {
        String string2 = this.mVariable.getVarType() == 0 && !(this.mVariable.getFormat() instanceof ExtendedSimpleDateFormat) && !(this.mVariable.getFormat() instanceof SimpleDateFormat) ? "[" + UIToolResUtil.removeLocale((String)string) + "]" : "['" + string + "']";
        return string2;
    }

    private class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExpressionTab.this.enableContinue();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExpressionTab.this.enableContinue();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class DCExpressionTextAreaDropListener
    extends ExpressionTextAreaDropListener {
        public DCExpressionTextAreaDropListener(ExpressionBuilderTextArea expressionBuilderTextArea) {
            super(expressionBuilderTextArea);
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            PlainList.TransferData transferData;
            Object[] objectArray;
            boolean bl = false;
            if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof PlainList.TransferData && (objectArray = (transferData = (PlainList.TransferData)object).getVariables()) != null && objectArray.length > 0 && this.mDropTarget instanceof JTextArea) {
                if (objectArray.length > 1) {
                    return false;
                }
                if (objectArray[0] instanceof DCCatBag || objectArray[0] instanceof SubtotalCatBag) {
                    return true;
                }
            }
            return bl;
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            Object[] objectArray;
            final JTextArea jTextArea = (JTextArea)this.mDropTarget;
            if (object instanceof Object[] && ((Object[])object).length == 1 && jComponent instanceof PlainList && (objectArray = (Object[])object)[0] instanceof DCCatBag) {
                DCCatBag dCCatBag = (DCCatBag)((Object)objectArray[0]);
                String string = dCCatBag.getInsertString();
                if (ExpressionTab.this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrDichotomous) {
                    string = string.replaceAll("'", "");
                }
                jTextArea.insert(string, n);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextArea.requestFocus();
                }
            });
        }
    }

    private class PostCategoryLabelTextAreaDropListener
    extends ExpressionTextAreaDropListener {
        public PostCategoryLabelTextAreaDropListener(ContextEnabledTextField contextEnabledTextField) {
            super(contextEnabledTextField);
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            PlainList.TransferData transferData;
            Object[] objectArray;
            boolean bl = false;
            if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof PlainList.TransferData && (objectArray = (transferData = (PlainList.TransferData)object).getVariables()) != null && objectArray.length > 0 && this.mDropTarget instanceof JTextField) {
                if (objectArray.length > 1) {
                    return false;
                }
                if (objectArray[0] instanceof DCCatBag || objectArray[0] instanceof SubtotalCatBag) {
                    return true;
                }
            }
            return bl;
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            Object[] objectArray;
            final JTextField jTextField = (JTextField)this.mDropTarget;
            if (object instanceof Object[] && ((Object[])object).length == 1 && jComponent instanceof PlainList && (objectArray = (Object[])object)[0] instanceof DCCatBag) {
                DCCatBag dCCatBag = (DCCatBag)((Object)objectArray[0]);
                String string = jTextField.getText();
                int n2 = jTextField.getCaret().getDot();
                if (dCCatBag.hasFlag(2)) {
                    jTextField.setText(string.substring(0, n2) + dCCatBag.getLabel() + string.substring(n2));
                } else if (dCCatBag.hasFlag(4)) {
                    jTextField.setText(string.substring(0, n2) + "TOTAL" + string.substring(n2));
                } else if (dCCatBag.hasFlag(8)) {
                    jTextField.setText(string.substring(0, n2) + "MISSING" + string.substring(n2));
                } else if (dCCatBag.hasFlag(8192)) {
                    jTextField.setText(string.substring(0, n2) + "OTHERNM" + string.substring(n2));
                } else if (ExpressionTab.this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrDichotomous) {
                    String string2 = dCCatBag.getInsertString().replaceAll("'", "");
                    jTextField.setText(string.substring(0, n2) + "&" + string2 + string.substring(n2));
                } else {
                    jTextField.setText(string.substring(0, n2) + "&" + dCCatBag.getInsertString() + string.substring(n2));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.requestFocus();
                }
            });
        }
    }

    private class DCExpressionAreaArrowButton
    extends ExpressionAreaArrowButton {
        private DCExpressionAreaArrowButton() {
        }

        @Override
        public void insertTextIntoTargetArea(JTextComponent jTextComponent, Object object) {
            if (object instanceof DCCatBag) {
                DCCatBag dCCatBag = (DCCatBag)((Object)object);
                jTextComponent.getHighlighter().removeAllHighlights();
                String string = dCCatBag.getInsertString();
                if (ExpressionTab.this.mVariable.getMeasurement() == ICanvasVariable.Measurement.mrDichotomous) {
                    string = string.replaceAll("'", "");
                }
                jTextComponent.replaceSelection(string);
            }
            jTextComponent.requestFocus();
        }
    }

    private class DCCatBag
    extends CatBag {
        public DCCatBag() {
        }

        public DCCatBag(CatBag catBag) {
            super(catBag.getFormattedValue(), catBag.getLabel(), catBag.getRawValue(), catBag.getCatFlags(), catBag.getIcon());
        }

        public DCCatBag(String string, String string2, double d, int n, Icon icon) {
            super(string, string2, d, n, icon);
        }

        public String toString() {
            String string = !Double.isNaN(this.getRawValue()) ? this.getLabel() + (this.getFormattedValue() != null ? " (" + this.getFormattedValue() + ")" : "") : this.getLabel();
            return string;
        }

        public String getInsertString() {
            String string = this.hasFlag(8) ? "MISSING" : (this.hasFlag(4) ? "TOTAL" : (this.hasFlag(8192) ? "OTHERNM" : ExpressionTab.this.parseNumericValue(this.getFormattedValue())));
            return string;
        }
    }

    private class SubtotalCatBag
    extends DCCatBag {
        private int mOrderingNum;

        public SubtotalCatBag(CatBag catBag, int n) {
            super(catBag);
            this.mOrderingNum = n;
        }

        @Override
        public String toString() {
            return this.getLabel() + " (" + this.getLabel() + " #" + this.mOrderingNum + ")";
        }

        @Override
        public String getInsertString() {
            return "SUBTOTAL[" + this.mOrderingNum + "]";
        }

        public String getTooltipText(CategoriesTable categoriesTable) {
            String string = null;
            String string2 = this.getFormattedValue();
            String[] stringArray = string2.split("\\...");
            if (stringArray.length == 2) {
                int n = categoriesTable.getRowIndexForFormattedValue(stringArray[0]);
                int n2 = categoriesTable.getRowIndexForFormattedValue(stringArray[1]);
                if (n > -1 && n2 > -1) {
                    String string3 = categoriesTable.concatCategoryLabels(n, n2);
                    string = this.getLabel() + "(" + this.getLabel() + '#' + this.mOrderingNum + ':' + string3 + ')';
                }
            }
            return string;
        }
    }

    private class SrcListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean mForTooltip;

        SrcListCellRenderer() {
            this.setOpaque(true);
        }

        SrcListCellRenderer(boolean bl) {
            this();
            this.mForTooltip = bl;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof DCCatBag) {
                DCCatBag dCCatBag = (DCCatBag)((Object)object);
                this.setIcon(dCCatBag.getIcon());
                if (!this.mForTooltip) {
                    this.setText(dCCatBag.toString());
                } else if (dCCatBag instanceof SubtotalCatBag) {
                    this.setText(((SubtotalCatBag)dCCatBag).getTooltipText(ExpressionTab.this.mCategoriesTable));
                }
            }
            if (bl) {
                if (jList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    private class DCCalcWidget
    extends CalcWidget {
        private JButton mSquareBracketButton;

        public DCCalcWidget(JTextArea jTextArea) {
            super(jTextArea);
        }

        @Override
        protected void initOperatorMap() {
            operatorMap = new HashMap();
            operatorMap.put(1, "+");
            operatorMap.put(2, "-");
            operatorMap.put(3, "*");
            operatorMap.put(4, "/");
            operatorMap.put(5, "**");
        }

        @Override
        protected void populateButtonGroupVector() {
            this.mButtonsGroup.addElement(this.mPlusButton);
            this.mButtonsGroup.addElement(this.mMinusButton);
            this.mButtonsGroup.addElement(this.mMultiplicationButton);
            this.mButtonsGroup.addElement(this.mDivisionButton);
            this.mButtonsGroup.addElement(this.mDoubleCrossButton);
            this.mPlusButton.addKeyListener(this.mArrowKeyListener);
            this.mMinusButton.addKeyListener(this.mArrowKeyListener);
            this.mMultiplicationButton.addKeyListener(this.mArrowKeyListener);
            this.mDivisionButton.addKeyListener(this.mArrowKeyListener);
            this.mDoubleCrossButton.addKeyListener(this.mArrowKeyListener);
            if (this.mCalcType == CalcWidget.CalcType.eRelationalOperator || this.mCalcType == CalcWidget.CalcType.eRelationalWithTilde) {
                this.mButtonsGroup.addElement(this.mRoundBracketButton);
                this.mButtonsGroup.addElement(this.mSquareBracketButton);
                this.mRoundBracketButton.addKeyListener(this.mArrowKeyListener);
                this.mSquareBracketButton.addKeyListener(this.mArrowKeyListener);
            }
        }

        @Override
        protected void init() {
            this.setupCalcPanel();
            this.setBorder(BorderFactory.createTitledBorder(ExpressionTab.this.getResString("IDS_EXPRESS_TAB_OPERATOR")));
            this.populateButtonGroupVector();
        }

        @Override
        protected void setupCalcPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            Insets insets = new Insets(n2, n2, n2, n2);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(this, this.setupOperatorPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
            n = 24;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(this, this.setupRelationalPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        }

        @Override
        protected JPanel setupOperatorPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            int n = 10;
            Insets insets = new Insets(0, 0, 0, 4);
            this.mPlusButton = this.createButtonWithAction((String)operatorMap.get(1));
            DialogUtil.addUsingGBL(jPanel, this.mPlusButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
            this.mMinusButton = this.createButtonWithAction((String)operatorMap.get(2));
            DialogUtil.addUsingGBL(jPanel, this.mMinusButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            this.mMultiplicationButton = this.createButtonWithAction((String)operatorMap.get(3));
            DialogUtil.addUsingGBL(jPanel, this.mMultiplicationButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
            this.mDivisionButton = this.createButtonWithAction((String)operatorMap.get(4));
            DialogUtil.addUsingGBL(jPanel, this.mDivisionButton, gridBagConstraints, 3, 0, 1, 1, n, insets);
            this.mDoubleCrossButton = this.createButtonWithAction((String)operatorMap.get(5));
            DialogUtil.addUsingGBL(jPanel, this.mDoubleCrossButton, gridBagConstraints, 4, 0, 1, 1, n, insets);
            return jPanel;
        }

        @Override
        protected JPanel setupRelationalPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            int n = 10;
            Insets insets = new Insets(0, 0, 0, 4);
            this.mRoundBracketButton = this.createButtonWithAction("( )");
            DialogUtil.addUsingGBL(jPanel, this.mRoundBracketButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
            this.mSquareBracketButton = this.createButtonWithAction("[ ]");
            DialogUtil.addUsingGBL(jPanel, this.mSquareBracketButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
            return jPanel;
        }
    }
}

