/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.uitools.canvas.tables.CatBag;
import com.spss.uitools.canvas.tables.ITreeNodeFlags;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class CategoriesTable
extends PlainTable
implements ITreeNodeFlags {
    protected static final int COLUMN_VALUES = 0;
    protected static final int COLUMN_LABEL = 1;

    public CategoriesTable() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setFont(jTableHeader.getFont().deriveFont(1));
        this.setRowHeight(this.getRowHeight() + 3);
        this.setAutoscrolls(true);
        this.setCellSelectionEnabled(true);
    }

    public void setupCellRenderer() {
        CategoriesTableCellRenderer categoriesTableCellRenderer = new CategoriesTableCellRenderer();
        categoriesTableCellRenderer.setBackground(SystemColor.control);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(categoriesTableCellRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(new CategoriesTableCellRenderer());
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 > 0 && (this.isTheRowByFlag(n, 2) || this.isTheRowByFlag(n, 128));
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        TableCellEditor tableCellEditor = null;
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        if (tableColumn.getCellEditor() != null) {
            tableCellEditor = tableColumn.getCellEditor();
        } else if (n2 == 1) {
            tableCellEditor = new DefaultCellEditor(new JTextField());
            tableColumn.setCellEditor(tableCellEditor);
        }
        return tableCellEditor;
    }

    public CatBag getCatBagAt(int n) {
        return (CatBag)this.getValueAt(n, 0);
    }

    public boolean isTheRowByFlag(int n, int n2) {
        boolean bl = false;
        if (this.getRowCount() > 0) {
            CatBag catBag = this.getCatBagAt(n);
            bl = catBag.hasFlag(n2);
        }
        return bl;
    }

    public ArrayList<CatBag> getAllRowsByFlag(int n) {
        ArrayList<CatBag> arrayList = new ArrayList<CatBag>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            CatBag catBag = this.getCatBagAt(i);
            if (!catBag.hasFlag(n)) continue;
            arrayList.add(catBag);
        }
        return arrayList;
    }

    public boolean isHideCatRow(int n) {
        CatBag catBag = this.getCatBagAt(n);
        return catBag.hasFlag(48);
    }

    public String getTheLabelByFlag(int n, int n2) {
        String string = null;
        if (this.isTheRowByFlag(n, n2)) {
            string = (String)this.getValueAt(n, 1);
        }
        return string;
    }

    public String getTheValueByFlag(int n, int n2) {
        String string = null;
        if (this.isTheRowByFlag(n, n2)) {
            CatBag catBag = this.getCatBagAt(n);
            string = catBag.getFormattedValue();
        }
        return string;
    }

    public boolean hasTheRowByFlag(int[] nArray, int n) {
        boolean bl = false;
        if (nArray == null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.isTheRowByFlag(i, n)) continue;
                bl = true;
                break;
            }
        } else {
            for (int n2 : nArray) {
                if (!this.isTheRowByFlag(n2, n)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean allTheRowsByFlag(int[] nArray, int n) {
        boolean bl = false;
        if (nArray.length > 0) {
            bl = true;
            for (int n2 : nArray) {
                if (this.isTheRowByFlag(n2, n)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public String shareSameLabelByFlag(int[] nArray, int n) {
        String string = null;
        String string2 = null;
        if (this.allTheRowsByFlag(nArray, n)) {
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                String string3 = this.getTheLabelByFlag(nArray[i], n);
                if (i == 0) {
                    string2 = string3;
                    continue;
                }
                if (string2.equals(string3)) continue;
                bl = false;
                break;
            }
            if (bl) {
                string = string2;
            }
        }
        return string;
    }

    public String shareSameValueByFlag(int[] nArray, int n) {
        String string = null;
        String string2 = null;
        if (this.allTheRowsByFlag(nArray, n)) {
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                String string3 = this.getTheValueByFlag(nArray[i], n);
                if (i == 0) {
                    string2 = string3;
                    continue;
                }
                if (string2.equals(string3)) continue;
                bl = false;
                break;
            }
            if (bl) {
                string = string2;
            }
        }
        return string;
    }

    public boolean shareSameHideByFlag(int[] nArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.allTheRowsByFlag(nArray, n)) {
            boolean bl3 = true;
            for (int i = 0; i < nArray.length; ++i) {
                boolean bl4 = this.isTheRowByFlag(nArray[i], n2);
                if (i == 0) {
                    bl2 = bl4;
                    continue;
                }
                if (bl4 == bl2) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                bl = bl2;
            }
        }
        return bl;
    }

    public int getRowIndexForFormattedValue(String string) {
        int n = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            CatBag catBag = this.getCatBagAt(i);
            if (!catBag.getFormattedValue().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public CatBag findCatBagForFormattedValue(String string) {
        CatBag catBag = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            CatBag catBag2 = this.getCatBagAt(i);
            if (!catBag2.getFormattedValue().equals(string)) continue;
            catBag = catBag2;
            break;
        }
        return catBag;
    }

    public void makesureDeleteAffectedRows(ArrayList<CatBag> arrayList) {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            CatBag catBag = this.getCatBagAt(i);
            boolean bl = false;
            for (CatBag catBag2 : arrayList) {
                if (catBag2 != catBag) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.getDefaultTableModel().removeRow(i);
        }
    }

    public int getSubtotalOrderingNum(CatBag catBag) {
        int n = -1;
        if (!catBag.hasFlag(2)) {
            return n;
        }
        ArrayList<CatBag> arrayList = this.getAllRowsByFlag(2);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != catBag) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public String concatCategoryLabels(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 >= n) {
            for (int i = n; i <= n2; ++i) {
                String string = this.getCatBagAt(i).getLabel();
                stringBuffer.append(string);
                stringBuffer.append(',');
            }
        } else {
            for (int i = n; i >= n2; --i) {
                String string = this.getCatBagAt(i).getLabel();
                stringBuffer.append(string);
                stringBuffer.append(',');
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ArrayList<CatBag> getAffectedCompRowsInTable(Vector<Object> vector, String string) {
        ArrayList<CatBag> arrayList = new ArrayList<CatBag>();
        if (!this.hasTheRowByFlag(null, 128)) {
            return arrayList;
        }
        if (vector != null) {
            for (Object object : vector) {
                if (!(object instanceof Object[])) continue;
                Object[] objectArray = (Object[])object;
                CatBag catBag = (CatBag)objectArray[0];
                this.scanExpressionForEach(catBag, arrayList, string);
            }
        } else {
            for (int i = 0; i < this.getRowCount(); ++i) {
                CatBag catBag = this.getCatBagAt(i);
                this.scanExpressionForEach(catBag, arrayList, string);
            }
        }
        return arrayList;
    }

    public ArrayList<CatBag> getAffectedCompRowsInTable(int[] nArray, String string) {
        ArrayList<CatBag> arrayList = new ArrayList<CatBag>();
        if (!this.hasTheRowByFlag(null, 128)) {
            return arrayList;
        }
        for (int n : nArray) {
            CatBag catBag = this.getCatBagAt(n);
            this.scanExpressionForEach(catBag, arrayList, string);
        }
        return arrayList;
    }

    public ArrayList<CatBag> getAffectedCompRowsInTableBySubtotal(String string) {
        ArrayList<CatBag> arrayList = new ArrayList<CatBag>();
        if (!this.hasTheRowByFlag(null, 128)) {
            return arrayList;
        }
        this.scanExpressionForEach(null, arrayList, string);
        return arrayList;
    }

    public void updateAssociatedCats(String string, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = this.getUsedCategories(string);
        for (int i = 0; i < this.getRowCount(); ++i) {
            CatBag catBag = this.getCatBagAt(i);
            String string2 = catBag.getFormattedValue();
            if ((bl2 || !arrayList.contains(string2)) && (!bl2 || !arrayList.contains("'" + string2 + "'"))) continue;
            if (bl && !catBag.hasFlag(32)) {
                catBag.addFlag(32);
                continue;
            }
            if (bl || !catBag.hasFlag(32)) continue;
            catBag.removeFlag(32);
        }
    }

    public ArrayList<String> getUsedCategories(String string) {
        String string2 = this.getSubtotalExcludedExpression(string);
        ArrayList<String> arrayList = this.getRelatedCategories(string2);
        if (string2.indexOf("TOTAL") >= 0) {
            arrayList.add("TOTAL");
        }
        if (string.indexOf("MISSING") >= 0) {
            arrayList.add("MISSING");
        }
        if (string.indexOf("OTHERNM") >= 0) {
            arrayList.add("OTHERNM");
        }
        return arrayList;
    }

    public void getAffectedSubtotalCompsInTable(ArrayList<CatBag> arrayList, ArrayList<CatBag> arrayList2, boolean bl) {
        if (!this.hasTheRowByFlag(null, 130)) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            CatBag catBag = this.getCatBagAt(i);
            this.scanExpressionForEachSubtotal(catBag, arrayList, arrayList2, bl);
        }
    }

    private void scanExpressionForEach(CatBag catBag, ArrayList<CatBag> arrayList, String string) {
        if (catBag != null) {
            if (catBag.hasFlag(128)) {
                return;
            }
            if (string == null || string.length() == 0) {
                string = catBag.getFormattedValue();
            }
            this.scanExpressionsOfCompCats(arrayList, string, true);
        } else {
            this.scanExpressionsOfCompCats(arrayList, string, false);
        }
    }

    private void scanExpressionForEachSubtotal(CatBag catBag, ArrayList<CatBag> arrayList, ArrayList<CatBag> arrayList2, boolean bl) {
        if (catBag != null && catBag.hasFlag(2)) {
            String string = null;
            int n = this.getSubtotalOrderingNum(catBag);
            if (n > -1) {
                string = "SUBTOTAL[" + n + "]";
            }
            this.scanExpressionsOfCompCats(arrayList, string, false);
            if (arrayList.size() > 0) {
                try {
                    arrayList2.add(bl ? (CatBag)catBag.clone() : catBag);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        }
    }

    private void scanExpressionsOfCompCats(ArrayList<CatBag> arrayList, String string, boolean bl) {
        ArrayList<CatBag> arrayList2 = this.getAllRowsByFlag(128);
        block0: for (CatBag catBag : arrayList2) {
            Object object;
            CatBag catBag2;
            String string2 = catBag.getFormattedValue();
            if (bl) {
                catBag2 = this.getUsedCategories(string2);
                if (!catBag2.contains(string) || arrayList.contains(object = this.findCatBagForFormattedValue(string2))) continue;
                arrayList.add((CatBag)object);
                continue;
            }
            if (string2.indexOf("SUBTOTAL") > -1 && string.indexOf("SUBTOTAL") > -1) {
                int n = Integer.parseInt(string.substring(string.indexOf("[") + 1, string.length() - 1));
                object = this.getIndexInExpression(string2);
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    if (n2 < n) continue;
                    CatBag catBag3 = this.findCatBagForFormattedValue(string2);
                    if (arrayList.contains(catBag3)) continue block0;
                    arrayList.add(catBag3);
                    continue block0;
                }
                continue;
            }
            if (string2.indexOf(string) <= -1 || arrayList.contains(catBag2 = this.findCatBagForFormattedValue(string2))) continue;
            arrayList.add(catBag2);
        }
    }

    private Vector<Integer> getIndexInExpression(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        String string2 = string.substring(string.indexOf("SUBTOTAL") + 9);
        int n = Integer.parseInt(string2.substring(0, string2.indexOf("]")));
        vector.add(n);
        while (string2.indexOf("SUBTOTAL") > -1) {
            string2 = string2.substring(string2.indexOf("SUBTOTAL") + 9);
            n = Integer.parseInt(string2.substring(0, string2.indexOf("]")));
            vector.add(n);
        }
        return vector;
    }

    private String getSubtotalExcludedExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string;
        int n = string2.indexOf("SUBTOTAL[");
        while (n >= 0) {
            String string3 = string2.substring(0, n);
            stringBuffer.append(string3);
            String string4 = string2.substring(n);
            int n2 = string4.indexOf("]");
            string2 = string4.substring(n2 + 1);
            n = string2.indexOf("SUBTOTAL[");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private ArrayList<String> getRelatedCategories(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("[");
        while (n >= 0) {
            int n2 = string.indexOf("]");
            String string2 = string.substring(n + 1, n2).trim();
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
            string = string.substring(n2 + 1);
            n = string.indexOf("[");
        }
        return arrayList;
    }

    private String getCompCatTooltip(String string, Font font) {
        String string2 = null;
        double d = this.getColumnModel().getColumn(0).getMaxWidth();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        double d2 = fontMetrics.getStringBounds(string, this.getGraphics()).getWidth();
        if (d2 + 40.0 >= d) {
            string2 = string;
        }
        return string2;
    }

    public ArrayList<CatBag> getAffectedCompRowsInTableByOtherNM() {
        ArrayList<CatBag> arrayList = new ArrayList<CatBag>();
        if (!this.hasTheRowByFlag(null, 128)) {
            return arrayList;
        }
        ArrayList<CatBag> arrayList2 = this.getAllRowsByFlag(128);
        for (CatBag catBag : arrayList2) {
            CatBag catBag2;
            String string = catBag.getFormattedValue();
            ArrayList<String> arrayList3 = this.getUsedCategories(string);
            if (!arrayList3.contains("OTHERNM") || arrayList.contains(catBag2 = this.findCatBagForFormattedValue(string))) continue;
            arrayList.add(catBag2);
        }
        return arrayList;
    }

    private class CategoriesTableCellRenderer
    extends DefaultTableCellRenderer {
        private CategoriesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(jTable instanceof CategoriesTable)) assert (false);
            if (((CategoriesTable)jTable).isTheRowByFlag(n, 130)) {
                this.setFont(this.getFont().deriveFont(2));
            }
            if (object instanceof CatBag) {
                this.setIcon(((CatBag)object).getIcon());
                this.setIconTextGap(24);
                this.setBorder(BorderFactory.createEtchedBorder());
                if (((CatBag)object).hasFlag(128)) {
                    this.setToolTipText(CategoriesTable.this.getCompCatTooltip(((CatBag)object).getFormattedValue(), this.getFont()));
                } else {
                    this.setToolTipText(null);
                }
            }
            if (CategoriesTable.this.hasTheRowByFlag(null, 130) && ((CategoriesTable)jTable).isHideCatRow(n)) {
                this.setForeground(Color.gray);
                this.setEnabled(false);
            } else {
                this.setForeground(Color.black);
                this.setEnabled(jTable.isEnabled());
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            return component;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

