/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.ctables.AssignVarsTab;
import com.spss.java_client.ui.dialogs.ctables.OptionsTab;
import com.spss.java_client.ui.dialogs.ctables.ResetQueryDlg;
import com.spss.java_client.ui.dialogs.ctables.TestStatsTab;
import com.spss.java_client.ui.dialogs.ctables.TitlesTab;
import com.spss.java_client.ui.dialogs.ctables.res.CTablesResBundle;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.uitools.canvas.ICanvasVariable;
import com.spss.uitools.canvas.tables.BaseTableCanvas;
import com.spss.uitools.canvas.tables.TableCanvas;
import com.spss.uitools.canvas.tables.TreeNode;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class CTablesMainDlg
extends BaseTabbedDialog {
    private static final String CANVAS_KEY = "Canvas";
    private static final String CANVAS2_KEY = "Canvas2";
    private static final String VERSION_KEY = "canvas_version";
    private AssignVarsTab mAssignVarsTab;
    private TitlesTab mTitlesTab;
    private TestStatsTab mTestStatsTab;
    private OptionsTab mOptionsTab;
    private static boolean mIsPre24 = false;

    public CTablesMainDlg(JFrame jFrame) {
        super(jFrame, false, CTablesResBundle.getDefaultResourceBundleName(), CTablesResBundle.getImageFolder(), StatsHelp.Book.BASE);
        this.secondInit(jFrame);
        mIsPre24 = false;
    }

    private void secondInit(Component component) {
        this.setTitle(this.getResString("IDS_CTABLES_WINDOW_TITLE"));
        this.pack();
        this.setLocationRelativeTo(component);
        this.mAssignVarsTab.doPostPackUpdate();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = "* " + this.getResString("IDS_CTABLES_WINDOW_TITLE") + ".\n";
        stringBuffer.append(string);
        stringBuffer.append(SyntaxUtil.getCommand("CTABLES"));
        this.mOptionsTab.generateSyntax(stringBuffer);
        this.mAssignVarsTab.generateSyntax(stringBuffer);
        this.mTitlesTab.generateSyntax(stringBuffer);
        this.mTestStatsTab.generateSyntax(stringBuffer);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string2 = TableStyleDlg.generateSyntax(dialogDataModel, TableStyleDlg.ConditionalFormatDlgType.CTables);
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_tables_cust_tables";
    }

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        BaseSpssTab baseSpssTab = (BaseSpssTab)this.mTabbedPane.getSelectedComponent();
        if (baseSpssTab == this.mAssignVarsTab) {
            baseSpssTab.setEnabled(true);
            FocusTraversalPolicy focusTraversalPolicy = this.mAssignVarsTab.getFocusTraversalPolicy();
            baseSpssTab.setFocusable(true);
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(focusTraversalPolicy);
        } else {
            super.stateChanged(changeEvent);
        }
    }

    @Override
    public void pack() {
        Component component = this.getGlassPane();
        JPanel jPanel = new JPanel();
        jPanel.setVisible(false);
        jPanel.setOpaque(false);
        this.setGlassPane(jPanel);
        super.pack();
        this.setGlassPane(component);
        this.mOptionsTab.setupListDragAdapters((DragPane)this.getGlassPane(), this.mVarMoveHandler);
        this.mAssignVarsTab.setupCanvasDragAdapters();
    }

    @Override
    public void reset() {
        ResetQueryDlg resetQueryDlg = new ResetQueryDlg(this, this.mResBundle);
        ResetQueryDlg.ResetType resetType = resetQueryDlg.getResetType();
        if (resetType.equals((Object)ResetQueryDlg.ResetType.all)) {
            super.reset();
        } else if (resetType.equals((Object)ResetQueryDlg.ResetType.current)) {
            ((BaseProcedureTab)this.mTabbedPane.getSelectedComponent()).reset();
        }
    }

    public void resetAll() {
        super.reset();
    }

    public AssignVarsTab getAssignVarsTab() {
        return this.mAssignVarsTab;
    }

    public LinkedList<ICanvasVariable> getCanvasVariablesByName(String string) {
        return this.mAssignVarsTab.getTableCanvas().getCanvasVariablesByName(string);
    }

    @Override
    public void dispose() {
        super.dispose();
        BaseTableCanvas.setClipboard(null);
        TreeNode.clearStaticDefaultStats();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void loadDialogState() {
        ByteArrayInputStream byteArrayInputStream;
        DataInputStream dataInputStream;
        boolean bl;
        Object object;
        this.mAssignVarsTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mTitlesTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mTestStatsTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mOptionsTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mTitlesTab.setVisible(false);
        this.mTestStatsTab.setVisible(false);
        this.mOptionsTab.setVisible(false);
        int n = TableCanvas.CANVAS_VERSION_1;
        Object object2 = this.getDialogDataModel().getObject(CANVAS_KEY);
        if (!(object2 instanceof byte[])) {
            object2 = this.getDialogDataModel().getObject(CANVAS2_KEY);
            object = this.getDialogDataModel().getInteger(VERSION_KEY);
            n = object != null ? (Integer)object : TableCanvas.CANVAS_VERSION_2;
        }
        Object object3 = object = object2 instanceof byte[] ? (byte[])object2 : null;
        if (object != null && ((byte[])object).length > 0 && !(bl = this.mAssignVarsTab.serializeCanvasIn(dataInputStream = new DataInputStream(byteArrayInputStream = new ByteArrayInputStream((byte[])object)), n))) {
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream((byte[])object);
            DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
            mIsPre24 = true;
            this.mAssignVarsTab.serializeCanvasIn(dataInputStream2, n, mIsPre24);
        }
        super.loadDialogState();
    }

    @Override
    protected void saveDialogState() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = false;
        bl = mIsPre24 ? this.mAssignVarsTab.serializeCanvasOut(dataOutputStream, mIsPre24) : this.mAssignVarsTab.serializeCanvasOut(dataOutputStream);
        if (bl) {
            this.getDialogDataModel().putObject(CANVAS2_KEY, byteArrayOutputStream.toByteArray());
            this.getDialogDataModel().putInteger(VERSION_KEY, TableCanvas.CANVAS_VERSION_2);
        }
        this.mAssignVarsTab.saveTabState(this.getDialogDataModel());
        this.mTitlesTab.saveTabState(this.getDialogDataModel());
        this.mTestStatsTab.saveTabState(this.getDialogDataModel());
        this.mOptionsTab.saveTabState(this.getDialogDataModel());
        super.saveDialogState();
    }

    @Override
    protected void init() {
        super.init();
        this.mAssignVarsTab = new AssignVarsTab(this, true);
        this.mTitlesTab = new TitlesTab(this, true);
        this.mTestStatsTab = new TestStatsTab(this, true);
        this.mOptionsTab = new OptionsTab(this, true);
        this.addTab(this.getResString("IDS_ASSIGN_VARS_TAB_TITLE"), this.mAssignVarsTab);
        this.addTab(this.getResString("IDS_TITLES_TAB_TITLE"), this.mTitlesTab);
        this.addTab(this.getResString("IDS_TEST_STATS_TAB_TITLE"), this.mTestStatsTab);
        this.addTab(this.getResString("IDS_OPTIONS_TAB_TITLE"), this.mOptionsTab);
        this.mTabbedPane.addChangeListener(this);
    }

    @Override
    protected boolean canSwitchTab() {
        boolean bl = true;
        Component component = this.mTabbedPane.getSelectedComponent();
        if (component instanceof TestStatsTab) {
            bl = ((TestStatsTab)component).validateTab();
        } else if (component instanceof OptionsTab) {
            bl = ((OptionsTab)component).validateTab();
        }
        return bl;
    }
}

