/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.ui.controls.CategoriesList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ResourceAccessor;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.ctables.CTablesMainDlg;
import com.spss.java_client.ui.dialogs.ctables.CatsAndTotalsSubDlg;
import com.spss.java_client.ui.dialogs.ctables.SpssCanvasVariableFactory;
import com.spss.java_client.ui.dialogs.ctables.SummaryStatSubDlg;
import com.spss.java_client.ui.dialogs.ctables.TableVarDragAdapter;
import com.spss.java_client.ui.dialogs.ctables.undo.CatPositionEdit;
import com.spss.java_client.ui.dialogs.ctables.undo.StatPositionEdit;
import com.spss.java_client.ui.dialogs.ctables.undo.StatSrcComboEdit;
import com.spss.java_client.ui.dialogs.ctables.undo.StatVisibilityEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.canvas.ICanvasVariable;
import com.spss.uitools.canvas.tables.BaseTableCanvas;
import com.spss.uitools.canvas.tables.CanvasState;
import com.spss.uitools.canvas.tables.ICanvasChangeConnector;
import com.spss.uitools.canvas.tables.ITableSelectionHandler;
import com.spss.uitools.canvas.tables.LayerCanvas;
import com.spss.uitools.canvas.tables.NodeSelections;
import com.spss.uitools.canvas.tables.StatPack;
import com.spss.uitools.canvas.tables.TableCanvas;
import com.spss.uitools.canvas.tables.TableCanvasChangeEvent;
import com.spss.uitools.canvas.tables.TableDimension;
import com.spss.uitools.canvas.tables.TreeNode;
import com.spss.uitools.canvas.tables.undo.SummaryStatEdit;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.IResourceAccessor;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;

public class AssignVarsTab
extends BaseProcedureTab
implements ItemListener,
ICanvasChangeConnector {
    private static final String CONFI_LEVEL_KEY = "IDS_CONFI_LEVEL";
    private static ImageIcon sLayersIcon = null;
    private static ImageIcon sLayersCheckedIcon = null;
    private TableCanvas mCanvas;
    private JPanel mLayerPane;
    private LayerCanvas mLayerCanvas;
    private CanvasState mCanvasState;
    private JLabel mSrcListLabel;
    private SrcVariableList mSrcVarList;
    private CategoriesList mCategoriesList;
    private JSplitPane mLeftSplitPane;
    private SpssButtonGroup mViewButtonGroup;
    private JToggleButton mCompactViewToggleButton;
    private JToggleButton mLayerCanvasCheck;
    private JButton mSummaryStatsButton;
    private JButton mCatsAndTotalsButton;
    private JLabel mStatPosLabel;
    private JComboBox mStatPosCombo;
    private JLabel mStatSrcLabel;
    private JComboBox mStatSrcCombo;
    private JCheckBox mHideStatCheck;
    private JLabel mCatPosLabel;
    private JComboBox mCatPosCombo;
    private SpssButtonGroup mShowAsLayerGroup;
    private JRadioButton mShowEachCatAsLayerRadio;
    private JRadioButton mShowCombCatAsLayerRadio;
    private AbstractAction mSummaryStatsAction;
    private AbstractAction mCatsAndTotalsAction;
    private CanvasPanelDialogFocusTraversalPolicy mTraversalPolicy = null;
    private boolean mSupportCompCat = true;
    private static int PostCategoryIndex = 1;
    private SummaryStatSubDlg mSummaryStatSubDlg;
    private String mConfidenceIntervalLevel = "95";

    public AssignVarsTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        this.mLayerCanvas.setSelectionHandler(this.mCanvas.getSelectionHandler());
        this.mCanvas.addChangeConnector((ICanvasChangeConnector)this);
        this.mLayerCanvas.addChangeConnector((ICanvasChangeConnector)this);
        this.mCanvas.updateFont();
        this.mLayerCanvas.updateFont();
        this.mSrcVarList.getInputMap().put(ResUtil.getShortcut("edit_copy"), "copyAction");
        this.mSrcVarList.getActionMap().put("copyAction", new VarsCopyAction(this.mCanvas.findMenuCopyAction()));
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(this.mCanvas.getResources().getDlgAccessKey("IDK_ROWS_KEY"), 8), "row_focus_action");
        this.getActionMap().put("row_focus_action", new CanvasFocusAction("row_focus_action", true));
        inputMap.put(KeyStroke.getKeyStroke(this.mCanvas.getResources().getDlgAccessKey("IDK_COLUMNS_KEY"), 8), "col_focus_action");
        this.getActionMap().put("col_focus_action", new CanvasFocusAction("col_focus_action", false));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_table_assign_vars";
    }

    @Override
    public void reset() {
        super.reset();
        this.mCanvas.reset();
        this.mLayerCanvas.reset();
        this.mCanvasState.reset();
        this.mSrcVarList.loadFromActiveDataset(true);
        this.mCanvas.getUndoManager().discardAllEdits();
        this.mShowEachCatAsLayerRadio.setEnabled(false);
        this.mShowCombCatAsLayerRadio.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mStatPosCombo.setSelectedIndex(1);
        this.mHideStatCheck.setSelected(false);
        this.mStatSrcCombo.setSelectedIndex(-1);
        this.mCatPosCombo.setSelectedIndex(0);
        CatsAndTotalsSubDlg.reset();
        this.updateLowerControls();
        this.updateOKPasteButtons();
        BaseTableCanvas.setClipboard(null);
        TreeNode.clearStaticDefaultStats();
        PostCategoryIndex = 1;
        this.mConfidenceIntervalLevel = "95";
        if (this.mSummaryStatSubDlg != null && this.mSummaryStatSubDlg.isVisible()) {
            this.mSummaryStatSubDlg.setVisible(false);
            this.mSummaryStatSubDlg.dispose();
        }
    }

    public void reloadSrcList() {
        this.mSrcVarList.removeAllVarFilters();
        this.mSrcVarList.loadFromActiveDataset(true);
        this.mSrcVarList.setSelectedIndex(0);
        this.mCanvas.getUndoManager().discardAllEdits();
    }

    public TableCanvas getTableCanvas() {
        return this.mCanvas;
    }

    public IVariableSet getVariableSet(String string) {
        return this.mSrcVarList.getVariableSet(string);
    }

    public ISpssVariable getVariablebyType(int n) {
        ISpssVariable iSpssVariable = null;
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            iSpssVariable = this.mSrcVarList.getModel().getElementAt(i);
            if (n == 0 && this.mSrcVarList.getModel().getElementAt(i).getType() == 0) {
                return iSpssVariable;
            }
            if (n <= 0 || this.mSrcVarList.getModel().getElementAt(i).getType() <= 0) continue;
            return iSpssVariable;
        }
        return iSpssVariable;
    }

    public void setSupportCompCat(boolean bl) {
        this.mSupportCompCat = bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (this.mStatSrcCombo == itemEvent.getSource()) {
            Object object = this.mStatSrcCombo.getSelectedItem();
            if (object instanceof StatItem) {
                StatItem statItem = (StatItem)object;
                new StatSrcComboEdit(this.mCanvas.getUndoManager(), this, this.mCanvasState, this.mStatSrcCombo, statItem.getDimension());
                this.mCanvas.checkOverflow();
            }
        } else if (this.mStatPosCombo == itemEvent.getSource()) {
            Object object = this.mStatPosCombo.getSelectedItem();
            if (object instanceof StatItem) {
                StatItem statItem = (StatItem)object;
                new StatPositionEdit(this.mCanvas.getUndoManager(), this, this.mCanvasState, this.mStatPosCombo, statItem.getDimension());
                this.mCanvas.checkOverflow();
            }
        } else if (this.mCatPosCombo == itemEvent.getSource()) {
            Object object = this.mCatPosCombo.getSelectedItem();
            if (object instanceof CatPosItem) {
                CatPosItem catPosItem = (CatPosItem)object;
                new CatPositionEdit(this.mCanvas.getUndoManager(), this, this.mCanvasState, this.mCatPosCombo, catPosItem.getComperimeterState());
                this.mCanvas.checkOverflow();
            }
        } else if (this.mHideStatCheck == itemEvent.getSource()) {
            new StatVisibilityEdit(this.mCanvas.getUndoManager(), this, this.mCanvasState, this.mHideStatCheck);
            this.mCanvas.checkOverflow();
        }
    }

    public void canvasChanged(TableCanvasChangeEvent tableCanvasChangeEvent) {
        if (tableCanvasChangeEvent.getDimType().equals((Object)TableDimension.Type.layers)) {
            boolean bl = tableCanvasChangeEvent.getVariableCount() > 1;
            boolean bl2 = tableCanvasChangeEvent.getVariableCount() > 0;
            this.mLayerCanvasCheck.setIcon(bl2 ? sLayersCheckedIcon : sLayersIcon);
            this.mShowEachCatAsLayerRadio.setEnabled(bl);
            this.mShowCombCatAsLayerRadio.setEnabled(bl);
            this.mCanvas.repaint();
        }
        this.updateLowerControls();
        this.updateOKPasteButtons();
    }

    public void selectionChanged(TableDimension.Type type, TreeNode[] treeNodeArray) {
        this.updateStatsAndCatsButtons(type, treeNodeArray);
    }

    public boolean hasScaleVariables(TableDimension.Type type) {
        if (type.equals((Object)TableDimension.Type.rows) || type.equals((Object)TableDimension.Type.columns)) {
            return this.mCanvas.hasScaleVariables(type);
        }
        if (type.equals((Object)TableDimension.Type.layers)) {
            return this.mLayerCanvas.hasScaleVariables(type);
        }
        return false;
    }

    public boolean setNodeView(TableCanvas.NodeView nodeView) {
        this.mViewButtonGroup.setSelected(this.mCompactViewToggleButton.getModel(), true);
        this.mCanvas.setNodeView(nodeView);
        return true;
    }

    public void updateLowerControls() {
        boolean bl = this.mCanvas.getNodeCount() > 0;
        boolean bl2 = this.mLayerCanvas.getNodeCount() > 0;
        boolean bl3 = this.mCanvas.getNodeCount(TableDimension.Type.rows) > 0;
        boolean bl4 = this.mCanvas.getNodeCount(TableDimension.Type.columns) > 0;
        boolean bl5 = bl || bl2;
        boolean bl6 = bl3 && bl4 || bl3 && bl2 || bl2 && bl4;
        this.reloadStatSourceCombo(bl3, bl4, bl2);
        this.reloadCatPositionCombo();
        boolean bl7 = this.mCanvas.hasScaleVariables(TableDimension.Type.rows) || this.mCanvas.hasScaleVariables(TableDimension.Type.columns) || this.mLayerCanvas.hasScaleVariables(TableDimension.Type.layers);
        NodeSelections nodeSelections = this.mCanvas.getNodeSelections();
        if (nodeSelections.mSelectedNodes.length == 0) {
            nodeSelections = this.mLayerCanvas.getNodeSelections();
        }
        TableDimension.Type type = nodeSelections.mDimension != null ? nodeSelections.mDimension.getDimensionType() : TableDimension.Type.none;
        this.updateStatsAndCatsButtons(type, nodeSelections.mSelectedNodes);
        this.mStatPosLabel.setEnabled(bl5);
        this.mStatPosCombo.setEnabled(bl5);
        this.mHideStatCheck.setEnabled(bl5);
        this.mStatSrcLabel.setEnabled(bl6 && !bl7);
        this.mStatSrcCombo.setEnabled(bl6 && !bl7);
        this.mCatPosLabel.setEnabled(this.mCatPosCombo.getItemCount() > 1);
        this.mCatPosCombo.setEnabled(this.mCatPosCombo.getItemCount() > 1);
    }

    private boolean catsMatchByType(TreeNode[] treeNodeArray) {
        if (treeNodeArray == null || treeNodeArray.length == 0) {
            return false;
        }
        int n = -1;
        for (TreeNode treeNode : treeNodeArray) {
            boolean bl;
            boolean bl2 = bl = treeNode.getNodeVar().getMeasurement() == ICanvasVariable.Measurement.mrCategorical || treeNode.getNodeVar().getMeasurement() == ICanvasVariable.Measurement.mrDichotomous;
            if (n == -1) {
                if (bl) {
                    n = 2;
                    continue;
                }
                if (treeNode.getNodeVar().getVarType() == 0) {
                    n = 0;
                    continue;
                }
                n = 1;
                continue;
            }
            if (n == 2 && !bl) {
                return false;
            }
            if (n == 0 && treeNode.getNodeVar().getVarType() != 0) {
                return false;
            }
            if (n != 1 || treeNode.getNodeVar().getVarType() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean serializeCanvasOut(DataOutputStream dataOutputStream) {
        boolean bl = true;
        try {
            dataOutputStream.writeUTF(this.mCanvas.getNodeView().name());
            dataOutputStream.writeUTF(this.mCanvasState.getStatSource().name());
            dataOutputStream.writeUTF(this.mCanvasState.getStatPosition().name());
            dataOutputStream.writeUTF(this.mCanvasState.getCatPosition().name());
            dataOutputStream.writeBoolean(this.mCanvasState.getStatsHidden());
            dataOutputStream.writeBoolean(this.mLayerCanvasCheck.isSelected());
        }
        catch (IOException iOException) {
            bl = false;
            iOException.printStackTrace();
        }
        if (bl) {
            bl = this.mCanvas.serializeOut(dataOutputStream);
        }
        if (bl) {
            bl = this.mLayerCanvas.serializeOut(dataOutputStream);
        }
        return bl;
    }

    public boolean serializeCanvasOut(DataOutputStream dataOutputStream, boolean bl) {
        boolean bl2 = true;
        try {
            dataOutputStream.writeUTF(this.mCanvas.getNodeView().name());
            dataOutputStream.writeUTF(this.mCanvasState.getStatSource().name());
            dataOutputStream.writeUTF(this.mCanvasState.getStatPosition().name());
            dataOutputStream.writeUTF(this.mCanvasState.getCatPosition().name());
            dataOutputStream.writeBoolean(this.mCanvasState.getStatsHidden());
            dataOutputStream.writeBoolean(this.mLayerCanvasCheck.isSelected());
        }
        catch (IOException iOException) {
            bl2 = false;
            iOException.printStackTrace();
        }
        if (bl2) {
            bl2 = this.mCanvas.serializeOut(dataOutputStream, bl);
        }
        if (bl2) {
            bl2 = this.mLayerCanvas.serializeOut(dataOutputStream, bl);
        }
        return bl2;
    }

    public boolean serializeCanvasIn(DataInputStream dataInputStream, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        TableDimension.Type type = TableDimension.Type.columns;
        TableDimension.Type type2 = TableDimension.Type.columns;
        CanvasState.ComperimeterState comperimeterState = CanvasState.ComperimeterState.defaultState;
        boolean bl4 = false;
        try {
            TableCanvas.NodeView nodeView = TableCanvas.NodeView.valueOf((String)dataInputStream.readUTF());
            if (nodeView.equals((Object)TableCanvas.NodeView.compact)) {
                this.mCanvas.setNodeView(TableCanvas.NodeView.compact);
                this.mCompactViewToggleButton.setSelected(true);
            }
            type = TableDimension.Type.valueOf((String)dataInputStream.readUTF());
            type2 = TableDimension.Type.valueOf((String)dataInputStream.readUTF());
            comperimeterState = CanvasState.ComperimeterState.valueOf((String)dataInputStream.readUTF());
            bl4 = dataInputStream.readBoolean();
            bl2 = dataInputStream.readBoolean();
            if (bl2) {
                this.mLayerCanvasCheck.setSelected(true);
                this.mLayerCanvasCheck.getAction().actionPerformed(new ActionEvent(this.mLayerCanvasCheck, 0, "buttonPressed"));
            }
        }
        catch (IOException iOException) {
            bl3 = false;
            iOException.printStackTrace();
        }
        if (bl3) {
            bl3 = this.mCanvas.serializeIn(dataInputStream, n, bl);
        }
        if (bl3) {
            bl3 = this.mLayerCanvas.serializeIn(dataInputStream, n, bl);
        }
        if (!CommandLine.isClementineCaller()) {
            this.pruneStaleNodes();
        }
        if (bl3) {
            boolean bl5 = this.mLayerCanvas.getNodeCount() > 0;
            bl2 = this.mCanvas.getNodeCount(TableDimension.Type.rows) > 0;
            boolean bl6 = this.mCanvas.getNodeCount(TableDimension.Type.columns) > 0;
            this.reloadStatSourceCombo(bl2, bl6, bl5);
            for (int i = 0; i < this.mStatSrcCombo.getModel().getSize(); ++i) {
                StatItem statItem = (StatItem)this.mStatSrcCombo.getModel().getElementAt(i);
                if (!statItem.mSourceDim.equals((Object)type)) continue;
                this.mStatSrcCombo.setSelectedIndex(i);
                break;
            }
            this.mShowEachCatAsLayerRadio.setEnabled(bl5);
            this.mShowCombCatAsLayerRadio.setEnabled(bl5);
        }
        if (bl3 && !type2.equals((Object)TableDimension.Type.columns)) {
            for (int i = 0; i < this.mStatPosCombo.getModel().getSize(); ++i) {
                StatItem statItem = (StatItem)this.mStatPosCombo.getModel().getElementAt(i);
                if (!statItem.mSourceDim.equals((Object)type2)) continue;
                this.mStatPosCombo.setSelectedIndex(i);
                break;
            }
        }
        if (bl3 && !comperimeterState.equals((Object)CanvasState.ComperimeterState.defaultState)) {
            this.reloadCatPositionCombo();
            for (int i = 0; i < this.mCatPosCombo.getModel().getSize(); ++i) {
                CatPosItem catPosItem = (CatPosItem)this.mCatPosCombo.getModel().getElementAt(i);
                if (!catPosItem.getComperimeterState().equals((Object)comperimeterState)) continue;
                this.mCatPosCombo.setSelectedIndex(i);
                break;
            }
        }
        if (bl3) {
            this.mHideStatCheck.setSelected(bl4);
        }
        this.updateLowerControls();
        this.updateOKPasteButtons();
        return bl3;
    }

    public boolean serializeCanvasIn(DataInputStream dataInputStream, int n) {
        boolean bl;
        boolean bl2 = true;
        TableDimension.Type type = TableDimension.Type.columns;
        TableDimension.Type type2 = TableDimension.Type.columns;
        CanvasState.ComperimeterState comperimeterState = CanvasState.ComperimeterState.defaultState;
        boolean bl3 = false;
        try {
            TableCanvas.NodeView nodeView = TableCanvas.NodeView.valueOf((String)dataInputStream.readUTF());
            if (nodeView.equals((Object)TableCanvas.NodeView.compact)) {
                this.mCanvas.setNodeView(TableCanvas.NodeView.compact);
                this.mCompactViewToggleButton.setSelected(true);
            }
            type = TableDimension.Type.valueOf((String)dataInputStream.readUTF());
            type2 = TableDimension.Type.valueOf((String)dataInputStream.readUTF());
            comperimeterState = CanvasState.ComperimeterState.valueOf((String)dataInputStream.readUTF());
            bl3 = dataInputStream.readBoolean();
            bl = dataInputStream.readBoolean();
            if (bl) {
                this.mLayerCanvasCheck.setSelected(true);
                this.mLayerCanvasCheck.getAction().actionPerformed(new ActionEvent(this.mLayerCanvasCheck, 0, "buttonPressed"));
            }
        }
        catch (IOException iOException) {
            bl2 = false;
            iOException.printStackTrace();
        }
        if (bl2) {
            bl2 = this.mCanvas.serializeIn(dataInputStream, n);
        }
        if (bl2) {
            bl2 = this.mLayerCanvas.serializeIn(dataInputStream, n);
        }
        if (!CommandLine.isClementineCaller()) {
            this.pruneStaleNodes();
        }
        if (bl2) {
            boolean bl4 = this.mLayerCanvas.getNodeCount() > 0;
            bl = this.mCanvas.getNodeCount(TableDimension.Type.rows) > 0;
            boolean bl5 = this.mCanvas.getNodeCount(TableDimension.Type.columns) > 0;
            this.reloadStatSourceCombo(bl, bl5, bl4);
            for (int i = 0; i < this.mStatSrcCombo.getModel().getSize(); ++i) {
                StatItem statItem = (StatItem)this.mStatSrcCombo.getModel().getElementAt(i);
                if (!statItem.mSourceDim.equals((Object)type)) continue;
                this.mStatSrcCombo.setSelectedIndex(i);
                break;
            }
            this.mShowEachCatAsLayerRadio.setEnabled(bl4);
            this.mShowCombCatAsLayerRadio.setEnabled(bl4);
        }
        if (bl2 && !type2.equals((Object)TableDimension.Type.columns)) {
            for (int i = 0; i < this.mStatPosCombo.getModel().getSize(); ++i) {
                StatItem statItem = (StatItem)this.mStatPosCombo.getModel().getElementAt(i);
                if (!statItem.mSourceDim.equals((Object)type2)) continue;
                this.mStatPosCombo.setSelectedIndex(i);
                break;
            }
        }
        if (bl2 && !comperimeterState.equals((Object)CanvasState.ComperimeterState.defaultState)) {
            this.reloadCatPositionCombo();
            for (int i = 0; i < this.mCatPosCombo.getModel().getSize(); ++i) {
                CatPosItem catPosItem = (CatPosItem)this.mCatPosCombo.getModel().getElementAt(i);
                if (!catPosItem.getComperimeterState().equals((Object)comperimeterState)) continue;
                this.mCatPosCombo.setSelectedIndex(i);
                break;
            }
        }
        if (bl2) {
            this.mHideStatCheck.setSelected(bl3);
        }
        this.updateLowerControls();
        this.updateOKPasteButtons();
        return bl2;
    }

    public boolean hasMorethanSelectedOnSrcDimension(StatPack.StatType statType, TreeNode[] treeNodeArray) {
        boolean bl = false;
        TableDimension tableDimension = this.getStatSrcDimension();
        Vector vector = tableDimension.getAllNodes();
        for (TreeNode treeNode : vector) {
            if (statType != treeNode.getStatType()) continue;
            boolean bl2 = false;
            for (TreeNode treeNode2 : treeNodeArray) {
                if (treeNode != treeNode2) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void saveStatsToAllNodes(StatPack.StatType statType, Vector<StatPack> vector, Vector<StatPack> vector2) {
        TableDimension tableDimension = this.getStatSrcDimension();
        new SummaryStatEdit(this.mCanvas.getUndoManager(), tableDimension, statType, vector, vector2);
    }

    public int findStatComboIndex(JComboBox jComboBox, Object object) {
        int n = -1;
        for (int i = 0; i < jComboBox.getModel().getSize(); ++i) {
            JLabel jLabel;
            Object e = jComboBox.getModel().getElementAt(i);
            if (e instanceof StatItem) {
                jLabel = (StatItem)e;
                if (!jLabel.mSourceDim.equals(object)) continue;
                n = i;
                break;
            }
            if (!(e instanceof CatPosItem)) continue;
            jLabel = (CatPosItem)e;
            if (!((CatPosItem)jLabel).mState.equals(object)) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.mCanvasState = new CanvasState();
        this.setupTopPane();
        this.setupCenterPane();
        this.setupLowerPane();
        this.setupRightLayerPane();
        this.updateContextMenu();
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        this.mSrcVarList.loadFromActiveDataset(true);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    AssignVarsTab.this.onCopyVars();
                }
            }
        });
        this.setFocusTraversalPolicy(false);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.mConfidenceIntervalLevel = dialogDataModel.getString(CONFI_LEVEL_KEY) != null ? dialogDataModel.getString(CONFI_LEVEL_KEY) : "95";
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString(CONFI_LEVEL_KEY, this.mConfidenceIntervalLevel);
    }

    protected void setupCanvasDragAdapters() {
        this.mCanvas.updateUI();
        this.mLayerCanvas.updateUI();
        DragPane dragPane = this.mCanvas.findDragPane();
        if (dragPane != null) {
            TableVarDragAdapter tableVarDragAdapter = new TableVarDragAdapter(this.mSrcVarList, dragPane, "TableVarList");
            DialogUtil.modifyMouseInputListeners(this.mSrcVarList, tableVarDragAdapter);
        }
    }

    protected void pruneStaleNodes() {
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(DataMgr.getDataMgr().getActiveDocumentId());
        if (iSpssDataSrc == null) {
            return;
        }
        this.pruneStaleNodesFromDimension(iSpssDataSrc, TableDimension.Type.rows);
        this.pruneStaleNodesFromDimension(iSpssDataSrc, TableDimension.Type.columns);
        this.pruneStaleNodesFromDimension(iSpssDataSrc, TableDimension.Type.layers);
    }

    private void pruneStaleNodesFromDimension(ISpssDataSrc iSpssDataSrc, TableDimension.Type type) {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        TableDimension tableDimension = type == TableDimension.Type.layers ? this.mLayerCanvas.getDimension(type) : this.mCanvas.getDimension(type);
        Vector vector2 = tableDimension.getAllNodes();
        for (TreeNode treeNode : vector2) {
            String string = treeNode.getNodeVar().getName();
            if (iSpssDataSrc.findVarIndex(string) >= 0) continue;
            boolean bl = false;
            if (string.startsWith("$")) {
                Vector vector3 = iSpssDataSrc.getVariableSets(ISpssDataSrc.VarSetsType.kMultipleResponseSets);
                for (IVariableSet iVariableSet : vector3) {
                    if (!iVariableSet.getName(IVariableSet.ChangeCase.kNoChange).equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            vector.add(treeNode);
        }
        if (vector.size() > 0) {
            tableDimension.removeNodes(vector.toArray(new TreeNode[vector.size()]));
        }
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        Vector vector = new Vector();
        this.mCanvas.buildUniqueNodeList(vector, false);
        this.mLayerCanvas.buildUniqueNodeList(vector, false);
        StringBuffer stringBuffer2 = null;
        CanvasState canvasState = this.mCanvas.getCanvasState();
        CanvasState.ComperimeterState comperimeterState = canvasState.getCatPosition();
        if (this.mSupportCompCat) {
            stringBuffer2 = this.mCanvas.generatePComputeSyntax(vector, comperimeterState);
        }
        this.mCanvas.generateVLabelsSyntax(stringBuffer, vector);
        if (stringBuffer2 != null) {
            stringBuffer.append('\n');
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append("  /TABLE");
        if (this.mCanvas.getDimension(TableDimension.Type.rows).getNodeCount() > 0) {
            stringBuffer.append(" ");
            this.mCanvas.generateSyntax(stringBuffer, this.mCanvas.getDimension(TableDimension.Type.rows));
        }
        if (this.mCanvas.getDimension(TableDimension.Type.columns).getNodeCount() > 0) {
            stringBuffer.append(" BY ");
            this.mCanvas.generateSyntax(stringBuffer, this.mCanvas.getDimension(TableDimension.Type.columns));
        }
        if (this.mLayerCanvas.getDimension(TableDimension.Type.layers).getNodeCount() > 0) {
            if (this.mCanvas.getDimension(TableDimension.Type.columns).getNodeCount() == 0) {
                stringBuffer.append(" BY");
            }
            stringBuffer.append(" BY ");
            this.mLayerCanvas.setUseNesting(this.mShowCombCatAsLayerRadio.isSelected());
            this.mLayerCanvas.generateSyntax(stringBuffer, this.mLayerCanvas.getDimension(TableDimension.Type.layers));
        }
        TableDimension.Type type = canvasState.getStatPosition();
        if (canvasState.getStatsHidden() || type == TableDimension.Type.rows) {
            stringBuffer.append("\n  /SLABELS");
            if (type == TableDimension.Type.rows) {
                stringBuffer.append(" POSITION=ROW");
            }
            if (canvasState.getStatsHidden()) {
                stringBuffer.append(" VISIBLE=NO");
            }
        }
        if (comperimeterState != CanvasState.ComperimeterState.defaultState) {
            stringBuffer.append("\n  /CLABELS");
            stringBuffer.append(comperimeterState == CanvasState.ComperimeterState.rowsInColumns ? " ROWLABELS=OPPOSITE" : " COLLABELS=OPPOSITE");
        }
        this.mCanvas.buildUniqueNodeList(vector, true);
        this.mLayerCanvas.buildUniqueNodeList(vector, true);
        this.mCanvas.generateCategoriesSyntax(stringBuffer, vector, comperimeterState);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand(String.format("/CRITERIA CILEVEL=%s", this.mConfidenceIntervalLevel)));
    }

    protected int getPostCategoryIndex() {
        return PostCategoryIndex++;
    }

    private void setupTopPane() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_VAR_LABEL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 25;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets.top += 3;
        insets.bottom += 3;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mViewButtonGroup = new SpssButtonGroup();
        this.mViewButtonGroup.setToggleBehaveAsRadioGroup(true);
        JToggleButton jToggleButton = new JToggleButton(new NormalButtonAction());
        jToggleButton.setIcon(new ImageIcon(this.getResImageURL("IDI_NORMAL_VIEW_ENABLED_IMAGE")));
        jToggleButton.setDisabledIcon(new ImageIcon(this.getResImageURL("IDI_NORMAL_VIEW_DISABLED_IMAGE")));
        this.mViewButtonGroup.add(jToggleButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 25;
        DialogUtil.addUsingGBL(jPanel, jToggleButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mCompactViewToggleButton = new JToggleButton(new CompactButtonAction());
        this.mCompactViewToggleButton.setIcon(new ImageIcon(this.getResImageURL("IDI_COMPACT_VIEW_ENABLED_IMAGE")));
        this.mCompactViewToggleButton.setDisabledIcon(new ImageIcon(this.getResImageURL("IDI_COMPACT_VIEW_DISABLED_IMAGE")));
        this.mViewButtonGroup.add(this.mCompactViewToggleButton);
        insets.right += 12;
        DialogUtil.addUsingGBL(jPanel, this.mCompactViewToggleButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        jToggleButton.setSelected(true);
        this.mLayerCanvasCheck = new JToggleButton(new LayersButtonAction());
        if (sLayersIcon == null) {
            sLayersIcon = new ImageIcon(this.getResImageURL("IDI_LAYERS_VIEW_ENABLED_IMAGE"));
        }
        if (sLayersCheckedIcon == null) {
            sLayersCheckedIcon = new ImageIcon(this.getResImageURL("IDI_LAYERS_VIEW_CHECKED_IMAGE"));
        }
        this.mLayerCanvasCheck.setIcon(sLayersIcon);
        this.mLayerCanvasCheck.setDisabledIcon(new ImageIcon(this.getResImageURL("IDI_LAYERS_VIEW_DISABLED_IMAGE")));
        insets.right = 0;
        insets.left = 30;
        DialogUtil.addUsingGBL(jPanel, this.mLayerCanvasCheck, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
    }

    private void setupCenterPane() {
        this.mLeftSplitPane = this.setupLists();
        this.mCanvas = new TableCanvas(this.mCanvasState, (IResourceAccessor)new ResourceAccessor(this.mParent));
        this.mSummaryStatsAction = new SummaryStatsAction();
        this.mCatsAndTotalsAction = new CatsAndTotalsAction();
        new CanvasMouseAdapter((BaseTableCanvas)this.mCanvas);
        this.mCanvas.setPreferences(PrefsMgr.getPrefsMgr().getUIUserPrefs().node("dialog_settings").node("ctables"));
        JScrollPane jScrollPane = new JScrollPane((Component)this.mCanvas);
        Dimension dimension = this.mCanvas.getPreferredSize();
        dimension.width += 4;
        dimension.height += 4;
        jScrollPane.setPreferredSize(dimension);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("general");
        boolean bl = preferences.getBoolean("var_list_display", true);
        BaseTableCanvas.setDefaultEmptyLabelStatus((boolean)bl);
        this.setLabelDefaults();
        JSplitPane jSplitPane = new JSplitPane(1, this.mLeftSplitPane, jScrollPane);
        jSplitPane.setDividerLocation(140);
        jSplitPane.setDividerSize(jSplitPane.getDividerSize() - 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jSplitPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void setLabelDefaults() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("output_labels");
        Preferences preferences3 = preferences.node("general");
        String string = preferences2.get("pivot_labeling_variables", PrefDefaults.DEF_TABLE_VARS);
        int n = string.equals(IOptionConstants.PIVOT_LABELING_VARIABLES_VALUES[0]) ? 32 : (string.equals(IOptionConstants.PIVOT_LABELING_VARIABLES_VALUES[1]) ? 16 : 48);
        String string2 = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS);
        if (string2.equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0])) {
            n |= 0x40;
        }
        TreeNode.setVarLabelDefaults((int)n);
        string = preferences2.get("pivot_labeling_variable_values", PrefDefaults.DEF_TABLE_VALUES);
        if (string.equals(IOptionConstants.PIVOT_LABELING_VARIABLE_VALUES_VALUES[0])) {
            TreeNode.setCatLabelDefaults((int)1024);
        } else if (string.equals(IOptionConstants.PIVOT_LABELING_VARIABLE_VALUES_VALUES[1])) {
            TreeNode.setCatLabelDefaults((int)512);
        } else {
            TreeNode.setCatLabelDefaults((int)1536);
        }
    }

    private void setupLowerPane() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.setupDefinePanel(jPanel);
        this.setupSummaryStatsPane(jPanel);
        this.setupCategoryPositionPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private void setupDefinePanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, n2);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DEFINE_GROUP")));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        n = 21;
        insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        insets.left = 3;
        insets.right = 3;
        this.mSummaryStatsButton = new JButton(this.mSummaryStatsAction);
        this.mSummaryStatsButton.setIcon(new ImageIcon(this.getResImageURL("IDI_SUMM_DLG_ENABLED_IMAGE")));
        this.mSummaryStatsButton.setDisabledIcon(new ImageIcon(this.getResImageURL("IDI_SUMM_DLG_DISABLED_IMAGE")));
        this.mSummaryStatsButton.setHorizontalAlignment(10);
        this.mSummaryStatsButton.setRolloverEnabled(true);
        DialogUtil.addUsingGBL(jPanel2, this.mSummaryStatsButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.bottom = n2;
        this.mCatsAndTotalsButton = new JButton(this.mCatsAndTotalsAction);
        this.mCatsAndTotalsButton.setIcon(new ImageIcon(this.getResImageURL("IDI_CATS_DLG_ENABLED_IMAGE")));
        this.mCatsAndTotalsButton.setDisabledIcon(new ImageIcon(this.getResImageURL("IDI_CATS_DLG_DISABLED_IMAGE")));
        this.mCatsAndTotalsButton.setHorizontalAlignment(10);
        this.mCatsAndTotalsButton.setRolloverEnabled(true);
        DialogUtil.addUsingGBL(jPanel2, this.mCatsAndTotalsButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel2);
    }

    private void setupSummaryStatsPane(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, n2);
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SUM_STATS_GROUP")));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 21;
        insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left += n2;
        insets.top += n2;
        insets.right += n2;
        insets.bottom += n2;
        this.mStatPosLabel = DialogUtil.createLabel(this.mParent, "IDS_STAT_POS_LABEL");
        this.mStatPosLabel.setHorizontalAlignment(4);
        DialogUtil.addUsingGBL(jPanel2, this.mStatPosLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mStatSrcLabel = DialogUtil.createLabel(this.mParent, "IDS_STAT_SRC_LABEL");
        this.mStatSrcLabel.setHorizontalAlignment(4);
        DialogUtil.addUsingGBL(jPanel2, this.mStatSrcLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Object[] objectArray = new Object[]{new StatItem(this.getResString("IDS_ROWS"), TableDimension.Type.rows), new StatItem(this.getResString("IDS_COLUMNS"), TableDimension.Type.columns)};
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mStatPosCombo = new JComboBox<Object>(objectArray);
        DialogUtil.addUsingGBL(jPanel2, this.mStatPosCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mStatPosLabel.setLabelFor(this.mStatPosCombo);
        this.mStatPosCombo.setSelectedIndex(1);
        this.mStatPosCombo.addItemListener(this);
        Object[] objectArray2 = new Object[]{new StatItem(this.getResString("IDS_LAYER_VARIABLES"), TableDimension.Type.layers), new StatItem(this.getResString("IDS_COLUMN_VARIABLES"), TableDimension.Type.columns), new StatItem(this.getResString("IDS_ROW_VARIABLES"), TableDimension.Type.rows)};
        this.mStatSrcCombo = new JComboBox<Object>(objectArray2);
        this.mStatSrcCombo.setPreferredSize(new Dimension(150, this.mStatSrcCombo.getPreferredSize().height));
        DialogUtil.addUsingGBL(jPanel2, this.mStatSrcCombo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mStatSrcLabel.setLabelFor(this.mStatSrcCombo);
        this.mStatSrcCombo.addItemListener(this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.mHideStatCheck = new JCheckBox(new HideStatsAction());
        DialogUtil.addUsingGBL(jPanel2, this.mHideStatCheck, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mHideStatCheck.addItemListener(this);
    }

    private void setupCategoryPositionPane(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 21;
        insets = DialogUtil.getStandardControlInsets();
        this.mCatPosLabel = DialogUtil.createLabel(this.mParent, "IDS_CAT_POS_LABEL");
        DialogUtil.addUsingGBL(jPanel2, this.mCatPosLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Object[] objectArray = new Object[]{new CatPosItem(this.getResString("IDS_CAT_POS_DEFAULT"), CanvasState.ComperimeterState.defaultState), new CatPosItem(this.getResString("IDS_CAT_POS_ROW"), CanvasState.ComperimeterState.rowsInColumns), new CatPosItem(this.getResString("IDS_CAT_POS_COL"), CanvasState.ComperimeterState.columnsInRows)};
        this.mCatPosCombo = new JComboBox<Object>(objectArray);
        DialogUtil.addUsingGBL(jPanel2, this.mCatPosCombo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mCatPosLabel.setLabelFor(this.mCatPosCombo);
        this.mCatPosCombo.addItemListener(this);
    }

    private JSplitPane setupLists() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.setContextMenuFlags(this.mSrcVarList.getContextMenuFlags() | 8);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_CATEGORIES_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mCategoriesList = new CategoriesList(this.mSrcVarList){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                super.valueChanged(listSelectionEvent);
                boolean bl = AssignVarsTab.this.mLayerCanvasCheck.isSelected();
                AssignVarsTab.this.setFocusTraversalPolicy(bl);
            }
        };
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        dimension.height = 1;
        this.mCategoriesList.setMinimumSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(this.mCategoriesList);
        jScrollPane2.setPreferredSize(this.mCategoriesList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mCategoriesList.setBackground(SystemColor.control);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerLocation(270);
        return jSplitPane;
    }

    private void setupRightLayerPane() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        this.mLayerCanvas = new LayerCanvas(this.mCanvasState, (IResourceAccessor)new ResourceAccessor(this.mParent), this.mCanvas.getUndoManager());
        this.mCanvasState.setLayerCanvas(this.mLayerCanvas);
        new CanvasMouseAdapter((BaseTableCanvas)this.mLayerCanvas);
        JScrollPane jScrollPane = new JScrollPane((Component)this.mLayerCanvas);
        jScrollPane.setPreferredSize(new Dimension(140, 132));
        jScrollPane.setMinimumSize(new Dimension(140, 132));
        Insets insets = new Insets(0, 1, 0, 1);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setupLayerOutputPane(jPanel);
        insets = new Insets(0, 1, 0, 0);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jPanel.setVisible(false);
        this.mLayerPane = jPanel;
    }

    private void setupLayerOutputPane(JPanel jPanel) {
        this.mShowAsLayerGroup = new SpssButtonGroup();
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LAYER_GROUP")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 1, 2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Insets insets2 = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets2.left = 0;
        insets2.right = 0;
        String string = "IDS_LAYER_EACH";
        this.mShowEachCatAsLayerRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mParent, string), 100);
        this.mShowEachCatAsLayerRadio.setHorizontalAlignment(10);
        this.mShowAsLayerGroup.add(this.mShowEachCatAsLayerRadio);
        this.mShowEachCatAsLayerRadio.setSelected(true);
        this.mShowEachCatAsLayerRadio.setEnabled(false);
        this.mShowEachCatAsLayerRadio.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel2, this.mShowEachCatAsLayerRadio, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        String string2 = "IDS_LAYER_COMB";
        this.mShowCombCatAsLayerRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mParent, string2), 100);
        this.mShowCombCatAsLayerRadio.setHorizontalAlignment(10);
        this.mShowCombCatAsLayerRadio.setEnabled(false);
        this.mShowAsLayerGroup.add(this.mShowCombCatAsLayerRadio);
        this.mShowCombCatAsLayerRadio.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel2, this.mShowCombCatAsLayerRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    void updateOKPasteButtons() {
        boolean bl = this.mCanvas.getNodeCount() > 0;
        boolean bl2 = this.mLayerCanvas.getNodeCount() > 0;
        ((CTablesMainDlg)this.mParent).enableOkPaste(bl || bl2);
    }

    private TableDimension getStatSrcDimension() {
        TableDimension.Type type = this.mCanvasState.getStatSource();
        TableDimension tableDimension = type.equals((Object)TableDimension.Type.layers) ? this.mCanvasState.getLayerCanvas().getDimension(type) : this.mCanvasState.getTableCanvas().getDimension(type);
        return tableDimension;
    }

    private void setFocusTraversalPolicy(boolean bl) {
        JComponent jComponent;
        this.mComponentOrder.removeAllElements();
        if (this.mParent instanceof CTablesMainDlg) {
            CTablesMainDlg cTablesMainDlg = (CTablesMainDlg)this.mParent;
            jComponent = cTablesMainDlg.getTabbedPane();
            this.mComponentOrder.add(jComponent);
        }
        this.mComponentOrder.add(this.mSrcVarList);
        int n = this.mLeftSplitPane.getLastDividerLocation();
        if (n > 0 && this.mCategoriesList.getModel().getSize() > 0) {
            this.mComponentOrder.add(this.mCategoriesList);
        }
        this.mComponentOrder.add(this.mCanvas);
        this.mComponentOrder.add(this.mViewButtonGroup);
        this.mComponentOrder.add(this.mLayerCanvasCheck);
        if (bl) {
            this.mComponentOrder.add(this.mLayerCanvas);
            this.mComponentOrder.add(this.mShowAsLayerGroup);
        }
        this.mComponentOrder.add(this.mSummaryStatsButton);
        this.mComponentOrder.add(this.mCatsAndTotalsButton);
        this.mComponentOrder.add(this.mStatPosCombo);
        this.mComponentOrder.add(this.mHideStatCheck);
        this.mComponentOrder.add(this.mStatSrcCombo);
        this.mComponentOrder.add(this.mCatPosCombo);
        jComponent = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponentOrder.add(component);
        }
        this.mTraversalPolicy = null;
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (this.mTraversalPolicy == null) {
            this.mTraversalPolicy = new CanvasPanelDialogFocusTraversalPolicy(this.mComponentOrder);
        }
        return this.mTraversalPolicy;
    }

    public void postSummaryStatApply(String string) {
        this.mConfidenceIntervalLevel = string;
        this.mCanvas.checkOverflow();
        this.mCanvas.recalcLayout();
        this.mCanvas.repaint();
    }

    private void reloadStatSourceCombo(boolean bl, boolean bl2, boolean bl3) {
        String string;
        boolean bl4;
        this.mStatSrcCombo.removeItemListener(this);
        Object object = this.mStatSrcCombo.getSelectedItem();
        this.mStatSrcCombo.removeAllItems();
        StatItem statItem = null;
        StatItem statItem2 = null;
        StatItem statItem3 = null;
        boolean bl5 = bl || bl2 || bl3;
        boolean bl6 = bl4 = bl5 && this.mCanvasState.getStatSource().equals((Object)TableDimension.Type.none);
        if (bl3) {
            string = this.getResString("IDS_LAYER_VARIABLES");
            statItem = new StatItem(string + "  ", TableDimension.Type.layers);
            this.mStatSrcCombo.addItem(statItem);
        } else if (this.mCanvasState.getStatSource().equals((Object)TableDimension.Type.layers)) {
            bl4 = true;
        }
        if (bl2) {
            string = this.getResString("IDS_COLUMN_VARIABLES");
            statItem2 = new StatItem(string + "  ", TableDimension.Type.columns);
            this.mStatSrcCombo.addItem(statItem2);
        } else if (this.mCanvasState.getStatSource().equals((Object)TableDimension.Type.columns)) {
            bl4 = true;
        }
        if (bl) {
            string = this.getResString("IDS_ROW_VARIABLES");
            statItem3 = new StatItem(string + "  ", TableDimension.Type.rows);
            this.mStatSrcCombo.addItem(statItem3);
        } else if (this.mCanvasState.getStatSource().equals((Object)TableDimension.Type.rows)) {
            bl4 = true;
        }
        if (bl4) {
            if (bl3) {
                this.mStatSrcCombo.setSelectedItem(statItem);
                this.mCanvasState.setStatSource(TableDimension.Type.layers);
            } else if (bl2) {
                this.mStatSrcCombo.setSelectedItem(statItem2);
                this.mCanvasState.setStatSource(TableDimension.Type.columns);
            } else if (bl) {
                this.mStatSrcCombo.setSelectedItem(statItem3);
                this.mCanvasState.setStatSource(TableDimension.Type.rows);
            }
        } else if (object instanceof StatItem) {
            this.mStatSrcCombo.setSelectedItem(object);
        }
        if (this.mCanvas.hasScaleVariables(TableDimension.Type.rows)) {
            this.mStatSrcCombo.setSelectedItem(statItem3);
            this.mCanvasState.setStatSource(TableDimension.Type.rows);
        } else if (this.mCanvas.hasScaleVariables(TableDimension.Type.columns)) {
            this.mStatSrcCombo.setSelectedItem(statItem2);
            this.mCanvasState.setStatSource(TableDimension.Type.columns);
        } else if (this.mCanvas.hasScaleVariables(TableDimension.Type.layers)) {
            this.mStatSrcCombo.setSelectedItem(statItem);
            this.mCanvasState.setStatSource(TableDimension.Type.layers);
        }
        this.mStatSrcCombo.addItemListener(this);
    }

    private void reloadCatPositionCombo() {
        this.mCatPosCombo.removeItemListener(this);
        boolean bl = this.mCanvas.hasScaleVariables(TableDimension.Type.rows);
        boolean bl2 = this.mCanvas.hasScaleVariables(TableDimension.Type.columns);
        boolean bl3 = this.mCanvas.hasCatVariables(TableDimension.Type.rows);
        boolean bl4 = this.mCanvas.hasCatVariables(TableDimension.Type.columns);
        boolean bl5 = this.mCanvas.hasCommonLeafCats(TableDimension.Type.rows);
        boolean bl6 = this.mCanvas.hasCommonLeafCats(TableDimension.Type.columns);
        Object object = this.mCatPosCombo.getSelectedItem();
        this.mCatPosCombo.removeAllItems();
        CatPosItem catPosItem = new CatPosItem(this.getResString("IDS_CAT_POS_DEFAULT") + "  ", CanvasState.ComperimeterState.defaultState);
        this.mCatPosCombo.addItem(catPosItem);
        boolean bl7 = catPosItem.equals(object);
        if (bl3 && !bl && bl5) {
            CatPosItem catPosItem2 = new CatPosItem(this.getResString("IDS_CAT_POS_ROW") + "  ", CanvasState.ComperimeterState.rowsInColumns);
            bl7 |= catPosItem2.equals(object);
            this.mCatPosCombo.addItem(catPosItem2);
        } else if (this.mCanvasState.getCatPosition().equals((Object)CanvasState.ComperimeterState.rowsInColumns)) {
            this.mCatPosCombo.setSelectedItem(catPosItem);
            this.mCanvasState.setCatPosition(CanvasState.ComperimeterState.defaultState);
        }
        if (bl4 && !bl2 && bl6) {
            CatPosItem catPosItem3 = new CatPosItem(this.getResString("IDS_CAT_POS_COL") + "  ", CanvasState.ComperimeterState.columnsInRows);
            bl7 |= catPosItem3.equals(object);
            this.mCatPosCombo.addItem(catPosItem3);
        } else if (this.mCanvasState.getCatPosition().equals((Object)CanvasState.ComperimeterState.columnsInRows)) {
            this.mCatPosCombo.setSelectedItem(catPosItem);
            this.mCanvasState.setCatPosition(CanvasState.ComperimeterState.defaultState);
        }
        if (bl7) {
            this.mCatPosCombo.setSelectedItem(object);
        }
        if (this.mCatPosCombo.getItemCount() < 2) {
            this.mCatPosCombo.setEnabled(false);
        }
        this.mCatPosCombo.addItemListener(this);
    }

    private void updateStatsAndCatsButtons(TableDimension.Type type, TreeNode[] treeNodeArray) {
        boolean bl;
        boolean bl2 = type.equals((Object)this.mCanvasState.getStatSource());
        boolean bl3 = bl = treeNodeArray.length > 0;
        if (treeNodeArray.length == 1 && treeNodeArray[0].isRootNode()) {
            bl = false;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (TreeNode treeNode : treeNodeArray) {
            if (treeNode.getNodeVar() == null) continue;
            if (treeNode.getNodeVar().isCategorical()) {
                if (treeNode.getNodeVar().isMultipleResponse()) {
                    bl6 = true;
                } else {
                    bl5 = true;
                }
                if (treeNode.findScaleParent() == null && treeNode.isLeaf()) continue;
                bl7 = true;
                continue;
            }
            bl4 = true;
        }
        boolean bl8 = bl5 && bl4 || bl5 && bl6 || bl4 && bl6;
        int n = this.catsMatchByType(treeNodeArray) ? 1 : 0;
        this.mSummaryStatsAction.setEnabled(bl && bl2 && !bl8 && !bl7);
        this.mCatsAndTotalsAction.setEnabled(bl && !bl4 && n != 0);
    }

    private void updateContextMenu() {
        this.mCanvas.getCanvasContextMenu().insertSeparator(0);
        this.mCanvas.getCanvasContextMenu().insertMenuItem(this.mCatsAndTotalsAction, 0);
        this.mCanvas.getCanvasContextMenu().insertMenuItem(this.mSummaryStatsAction, 0);
        this.mLayerCanvas.getCanvasContextMenu().insertSeparator(0);
        this.mLayerCanvas.getCanvasContextMenu().insertMenuItem(this.mCatsAndTotalsAction, 0);
        this.mLayerCanvas.getCanvasContextMenu().insertMenuItem(this.mSummaryStatsAction, 0);
        VarsCopyAction varsCopyAction = new VarsCopyAction(this.mCanvas.findMenuCopyAction());
        Component[] componentArray = new Component[]{new JPopupMenu.Separator(), new JMenuItem(varsCopyAction)};
        this.mSrcVarList.setAdditonalMenuItems(componentArray);
    }

    private void onCopyVars() {
        int n = this.mSrcVarList.getSelectedIndices().length;
        if (n == 0) {
            return;
        }
        SpssCanvasVariableFactory spssCanvasVariableFactory = SpssCanvasVariableFactory.getFactory();
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        ICanvasVariable[] iCanvasVariableArray = new ICanvasVariable[iSpssVariableArray.length];
        TreeNode treeNode = new TreeNode(0, 0, null, null);
        for (int i = iSpssVariableArray.length - 1; i >= 0; --i) {
            iCanvasVariableArray[i] = spssCanvasVariableFactory.makeVariable(iSpssVariableArray[i]);
            TreeNode treeNode2 = TableDimension.createNewTreeNode(null, (ICanvasVariable)iCanvasVariableArray[i]);
            treeNode.insertChild(treeNode2, -1);
        }
        BaseTableCanvas.setClipboard((TreeNode)treeNode);
    }

    public void doPostPackUpdate() {
        this.updateLowerControls();
    }

    class CanvasPanelDialogFocusTraversalPolicy
    extends DialogFocusTraversalPolicy {
        public CanvasPanelDialogFocusTraversalPolicy(Vector<Object> vector) {
            super(vector, false);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component == AssignVarsTab.this.mCanvas && AssignVarsTab.this.mCanvas.getSelectionHandler().getFocusDimension().getDimensionType() == TableDimension.Type.rows) {
                TableDimension tableDimension = AssignVarsTab.this.mCanvas.getDimension(TableDimension.Type.columns);
                AssignVarsTab.this.mCanvas.getSelectionHandler().setFocusNode(tableDimension, tableDimension.getRootNode());
                return AssignVarsTab.this.mCanvas;
            }
            return super.getComponentAfter(container, component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component == AssignVarsTab.this.mCanvas && AssignVarsTab.this.mCanvas.getSelectionHandler().getFocusDimension().getDimensionType() == TableDimension.Type.columns) {
                TableDimension tableDimension = AssignVarsTab.this.mCanvas.getDimension(TableDimension.Type.rows);
                AssignVarsTab.this.mCanvas.getSelectionHandler().setFocusNode(tableDimension, tableDimension.getRootNode());
                return AssignVarsTab.this.mCanvas;
            }
            return super.getComponentBefore(container, component);
        }
    }

    class CanvasFocusAction
    extends AbstractAction {
        private boolean mRows;

        public CanvasFocusAction(String string, boolean bl) {
            super(string);
            this.mRows = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ITableSelectionHandler iTableSelectionHandler = AssignVarsTab.this.mCanvas.getSelectionHandler();
            if (this.mRows) {
                if (iTableSelectionHandler.getFocusDimension().getDimensionType() == TableDimension.Type.columns) {
                    TableDimension tableDimension = AssignVarsTab.this.mCanvas.getDimension(TableDimension.Type.rows);
                    iTableSelectionHandler.setFocusNode(tableDimension, tableDimension.getRootNode());
                }
            } else if (iTableSelectionHandler.getFocusDimension().getDimensionType() == TableDimension.Type.rows) {
                TableDimension tableDimension = AssignVarsTab.this.mCanvas.getDimension(TableDimension.Type.columns);
                iTableSelectionHandler.setFocusNode(tableDimension, tableDimension.getRootNode());
            }
            AssignVarsTab.this.mCanvas.requestFocus();
        }
    }

    class VarsCopyAction
    extends AbstractAction {
        public VarsCopyAction(Action action) {
            this.putValue("Name", action.getValue("Name"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", action.getValue("MnemonicKey"));
                this.putValue("AcceleratorKey", action.getValue("AcceleratorKey"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssignVarsTab.this.onCopyVars();
        }
    }

    class CanvasMouseAdapter
    extends MouseAdapter {
        private BaseTableCanvas mCanvas;

        public CanvasMouseAdapter(BaseTableCanvas baseTableCanvas) {
            this.mCanvas = baseTableCanvas;
            this.mCanvas.addMouseListener((MouseListener)this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                if (OSInfo.getOSType() == OSInfo.OSType.MAC && mouseEvent.getButton() == 3) {
                    return;
                }
                TableDimension.HitTestInfo hitTestInfo = this.mCanvas.hitTestCanvas(mouseEvent.getPoint(), false);
                TreeNode treeNode = hitTestInfo.getNode();
                if (treeNode != null && !treeNode.isRootNode() && AssignVarsTab.this.mSummaryStatsAction.isEnabled()) {
                    AssignVarsTab.this.mSummaryStatsButton.doClick();
                }
                mouseEvent.consume();
            }
        }
    }

    class CatPosItem
    extends JLabel {
        protected CanvasState.ComperimeterState mState;

        public CatPosItem(String string, CanvasState.ComperimeterState comperimeterState) {
            super(string);
            this.mState = comperimeterState;
        }

        public CanvasState.ComperimeterState getComperimeterState() {
            return this.mState;
        }

        @Override
        public String toString() {
            return this.getText();
        }

        public boolean equals(Object object) {
            if (object instanceof CatPosItem) {
                CatPosItem catPosItem = (CatPosItem)object;
                return this.mState.equals((Object)catPosItem.mState);
            }
            return super.equals(object);
        }
    }

    class StatItem
    extends JLabel {
        protected TableDimension.Type mSourceDim;

        StatItem(String string, TableDimension.Type type) {
            super(string);
            this.mSourceDim = type;
        }

        TableDimension.Type getDimension() {
            return this.mSourceDim;
        }

        @Override
        public String toString() {
            return this.getText();
        }

        public boolean equals(Object object) {
            if (object instanceof StatItem) {
                StatItem statItem = (StatItem)object;
                return this.mSourceDim.equals((Object)statItem.mSourceDim);
            }
            return super.equals(object);
        }
    }

    class HideStatsAction
    extends AbstractAction {
        HideStatsAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_HIDE"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_HIDE_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssignVarsTab.this.mCanvasState.setStatsHidden(AssignVarsTab.this.mHideStatCheck.isSelected());
            AssignVarsTab.this.updateLowerControls();
        }
    }

    class CatsAndTotalsAction
    extends AbstractAction {
        CatsAndTotalsAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_CATS_DLG_LABEL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_CATS_DLG_LABEL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NodeSelections nodeSelections = AssignVarsTab.this.mCanvas.getNodeSelections();
            if (nodeSelections.mDimension == null) {
                return;
            }
            Vector<StatPack> vector = new Vector<StatPack>();
            TableDimension tableDimension = AssignVarsTab.this.getStatSrcDimension();
            Vector vector2 = tableDimension.getAllStatisticNodes();
            if (tableDimension == nodeSelections.mDimension) {
                for (TreeNode object2 : nodeSelections.mSelectedNodes) {
                    tableDimension.getStatistics(object2, vector, false, false);
                }
            } else {
                tableDimension.getStatistics(null, vector, false, false);
            }
            TreeNode[] treeNodeArray = AssignVarsTab.this.mCanvas.getAllMatchingNodesByVarName(nodeSelections.mSelectedNodes);
            TreeNode[] treeNodeArray2 = AssignVarsTab.this.mLayerCanvas.getAllMatchingNodesByVarName(nodeSelections.mSelectedNodes);
            TreeNode[] treeNodeArray3 = new TreeNode[treeNodeArray.length + treeNodeArray2.length];
            System.arraycopy(treeNodeArray, 0, treeNodeArray3, 0, treeNodeArray.length);
            System.arraycopy(treeNodeArray2, 0, treeNodeArray3, treeNodeArray.length, treeNodeArray2.length);
            CatsAndTotalsSubDlg catsAndTotalsSubDlg = new CatsAndTotalsSubDlg((CTablesMainDlg)AssignVarsTab.this.mParent, nodeSelections, treeNodeArray3, vector, AssignVarsTab.this.mSupportCompCat);
            catsAndTotalsSubDlg.setLastCompCatStatPacks(((TreeNode)vector2.get(0)).getStatistics());
            catsAndTotalsSubDlg.setVisible(true);
            AssignVarsTab.this.mCanvas.checkOverflow();
            AssignVarsTab.this.mCanvas.recalcLayout();
            AssignVarsTab.this.mCanvas.repaint();
        }
    }

    class SummaryStatsAction
    extends AbstractAction {
        SummaryStatsAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_SUMM_DLG_LABEL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_SUMM_DLG_LABEL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NodeSelections nodeSelections = AssignVarsTab.this.mCanvas.getNodeSelections();
            AssignVarsTab.this.mSummaryStatSubDlg = new SummaryStatSubDlg((CTablesMainDlg)AssignVarsTab.this.mParent, nodeSelections);
            AssignVarsTab.this.mSummaryStatSubDlg.setInitialConfidenceIntervalLevel(AssignVarsTab.this.mConfidenceIntervalLevel);
            AssignVarsTab.this.mSummaryStatSubDlg.setVisible(true);
        }
    }

    class LayersButtonAction
    extends AbstractAction {
        LayersButtonAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_LAYERS"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_LAYERS_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            boolean bl = jToggleButton.isSelected();
            AssignVarsTab.this.mLayerPane.setVisible(bl);
            AssignVarsTab.this.setFocusTraversalPolicy(bl);
            Dimension dimension = AssignVarsTab.this.mCanvas.getPreferredSize();
            Dimension dimension2 = AssignVarsTab.this.mCanvas.getParent().getParent().getSize();
            Dimension dimension3 = AssignVarsTab.this.mLayerCanvas.getPreferredSize();
            dimension2.width = bl ? (dimension2.width -= dimension3.width + 10) : (dimension2.width += dimension3.width);
            dimension2.height = dimension.height;
            AssignVarsTab.this.mCanvas.setPreferredSize(dimension2);
            AssignVarsTab.this.invalidate();
        }
    }

    class CompactButtonAction
    extends AbstractAction {
        CompactButtonAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_COMPACT"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_COMPACT_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssignVarsTab.this.mCanvas.setNodeView(TableCanvas.NodeView.compact);
        }
    }

    class NormalButtonAction
    extends AbstractAction {
        NormalButtonAction() {
            this.putValue("Name", AssignVarsTab.this.getResString("IDS_NORMAL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", AssignVarsTab.this.getDlgAccessKey("IDK_NORMAL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssignVarsTab.this.mCanvas.setNodeView(TableCanvas.NodeView.full);
        }
    }
}

