/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.ctables.SummaryStatTree;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public abstract class AbstractListTableArrowButton
extends ComponentsArrowButton {
    public AbstractListTableArrowButton() {
        this(SpssArrowButton.ButtonOrientation.right);
    }

    public AbstractListTableArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
        super(buttonOrientation);
    }

    public void setEnableState(JComponent jComponent, SpssArrowButton.ButtonOrientation buttonOrientation) {
        if (jComponent instanceof PlainTable) {
            ListSelectionModel listSelectionModel = ((PlainTable)jComponent).getSelectionModel();
            if (buttonOrientation == SpssArrowButton.ButtonOrientation.up || buttonOrientation == SpssArrowButton.ButtonOrientation.down) {
                int n = listSelectionModel.getMinSelectionIndex();
                int n2 = listSelectionModel.getMaxSelectionIndex();
                int n3 = ((PlainTable)jComponent).getRowCount();
                if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
                    this.setEnabled(n > 0);
                } else {
                    this.setEnabled(n2 > -1 && n2 < n3 - 1);
                }
            } else {
                this.setEnabled(listSelectionModel.getMinSelectionIndex() > -1);
            }
        } else if (jComponent instanceof PlainList) {
            this.setEnabled(jComponent.isEnabled() && ((PlainList)jComponent).getSelectedIndices().length > 0);
        } else if (jComponent instanceof SummaryStatTree) {
            this.setEnabled(jComponent.isEnabled() && ((SummaryStatTree)jComponent).isSelectedNodeToValidMove());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("arrowPressed".equals(actionEvent.getActionCommand())) {
            JComponent jComponent;
            ComponentsArrowButton.ComponentHolder componentHolder = (ComponentsArrowButton.ComponentHolder)this.getSourceVarHolder();
            ComponentsArrowButton.ComponentHolder componentHolder2 = (ComponentsArrowButton.ComponentHolder)this.getTargetVarHolder();
            if (componentHolder != null && componentHolder2 != null) {
                JComponent jComponent2 = this.getSrcHolderComponent();
                JComponent jComponent3 = this.getTargetHolderComponent();
                if (jComponent2 instanceof PlainList && jComponent3 instanceof PlainTable) {
                    Object[] objectArray;
                    PlainList plainList = (PlainList)jComponent2;
                    PlainTable plainTable = (PlainTable)jComponent3;
                    for (Object object : objectArray = ((PlainList)jComponent2).getSelectedValues()) {
                        this.moveSelectedListItemToTable(object, plainList, plainTable);
                    }
                    this.updateOtherControls();
                    plainTable.setRowSelectionInterval(plainTable.getRowCount() - 1 - (objectArray.length - 1), plainTable.getRowCount() - 1);
                    plainTable.scrollRectToVisible(plainTable.getCellRect(plainTable.getRowCount() - 1, 0, false));
                    final PlainTable n = plainTable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            n.requestFocusInWindow();
                        }
                    });
                } else if (jComponent2 instanceof PlainTable && jComponent3 instanceof PlainList) {
                    PlainTable plainTable = (PlainTable)jComponent2;
                    PlainList plainList = (PlainList)jComponent3;
                    int[] nArray = plainTable.getSelectedRows();
                    int plainTable2 = 0;
                    plainList.clearSelection();
                    boolean bl2 = true;
                    bl2 = this.moveSelectedRowsToList(nArray, plainTable, plainList);
                    this.updateOtherControls();
                    if (!bl2) {
                        return;
                    }
                    plainList.ensureIndexIsVisible(plainTable2);
                    final PlainList plainList2 = plainList;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plainList2.requestFocusInWindow();
                        }
                    });
                } else if (jComponent2 instanceof SummaryStatTree && jComponent3 instanceof PlainTable) {
                    SummaryStatTree summaryStatTree = (SummaryStatTree)jComponent2;
                    PlainTable plainTable = (PlainTable)jComponent3;
                    Vector<Object> vector = ((SummaryStatTree)jComponent2).getSelectedValues();
                    for (Object object : vector) {
                        this.moveSelectedListItemToTable(object, summaryStatTree, plainTable);
                    }
                    this.updateOtherControls();
                    plainTable.setRowSelectionInterval(plainTable.getRowCount() - 1 - (vector.size() - 1), plainTable.getRowCount() - 1);
                    plainTable.scrollRectToVisible(plainTable.getCellRect(plainTable.getRowCount() - 1, 0, false));
                    final PlainTable plainTable2 = plainTable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plainTable2.requestFocusInWindow();
                        }
                    });
                } else if (jComponent2 instanceof PlainTable && jComponent3 instanceof SummaryStatTree) {
                    PlainTable plainTable = (PlainTable)jComponent2;
                    SummaryStatTree summaryStatTree = (SummaryStatTree)jComponent3;
                    int[] nArray = plainTable.getSelectedRows();
                    boolean bl = false;
                    summaryStatTree.clearSelection();
                    boolean bl2 = true;
                    bl2 = this.moveSelectedRowsToList(nArray, plainTable, summaryStatTree);
                    this.updateOtherControls();
                    if (!bl2) {
                        return;
                    }
                    final SummaryStatTree summaryStatTree2 = summaryStatTree;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            summaryStatTree2.requestFocusInWindow();
                        }
                    });
                }
            } else if (componentHolder != null && (jComponent = this.getSrcHolderComponent()) instanceof PlainTable) {
                PlainTable plainTable = (PlainTable)jComponent;
                SpssArrowButton.ButtonOrientation buttonOrientation = this.getArrowOrientation();
                DialogUtil.moveSelectedRow(plainTable, buttonOrientation == SpssArrowButton.ButtonOrientation.up);
                this.updateEnable(componentHolder);
                this.updateOtherControls();
            }
        }
    }

    protected abstract boolean moveSelectedRowsToList(int[] var1, PlainTable var2, Object var3);

    protected abstract void moveSelectedListItemToTable(Object var1, Object var2, PlainTable var3);

    protected void updateOtherControls() {
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
        if (srcDestHolder != null) {
            SpssArrowButton.ButtonOrientation buttonOrientation = this.getArrowOrientation();
            JComponent jComponent = this.getSrcHolderComponent();
            this.setEnableState(jComponent, buttonOrientation);
        }
    }
}

