/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.conjoint.generate_dlg;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GenerateOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String HOLD_CASE_CHECK = "IDS_OPTION_HOLD_CASE_CHECK";
    static final String RANDOM_CHECK = "IDS_OPTION_RANDOM_CHECK";
    static final String MIN_CASE_TEXT = "IDS_OPTION_MIN_CASE_TEXT";
    static final String HOLD_TEXT = "IDS_OPTION_HOLD_TEXT";
    private IntTextField mMinCaseText;
    private IntTextField mHoldCaseText;
    private JCheckBox mHoldCheck;
    private JCheckBox mRandomCheck;

    public GenerateOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_ORTHO_OPTION_SUB_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mHoldCaseText.setOpaque(this.mHoldCheck.isSelected());
        this.mHoldCaseText.setEnabled(this.mHoldCheck.isSelected());
        this.mRandomCheck.setEnabled(this.mHoldCheck.isSelected());
        if (this.mHoldCheck.isSelected()) {
            this.enableContinue(this.mHoldCaseText.getText().length() > 0);
            this.mHoldCaseText.requestFocus();
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mHoldCaseText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mHoldCaseText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mHoldCaseText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_orth_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.mRandomCheck.setEnabled(false);
        this.mRandomCheck.setSelected(false);
        this.mHoldCaseText.setText("");
        this.mHoldCaseText.setEnabled(false);
        this.mHoldCaseText.setOpaque(false);
        this.enableContinue(true);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMinCaseText);
        vector.add(this.mHoldCheck);
        vector.add(this.mHoldCaseText);
        vector.add(this.mRandomCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, HOLD_CASE_CHECK);
        this.mHoldCheck = new JCheckBox(controlAction);
        this.mHoldCheck.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, RANDOM_CHECK);
        this.mRandomCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mParentDlg, MIN_CASE_TEXT);
        this.mMinCaseText = new IntTextField(2, 99, true);
        this.mMinCaseText.setAction((Action)controlAction);
        this.mMinCaseText.setColumns(2);
        controlAction = new TextFieldAction(this.mParentDlg, HOLD_TEXT);
        this.mHoldCaseText = new IntTextField(2, 99, true);
        this.mHoldCaseText.setAction((Action)controlAction);
        this.mHoldCaseText.setColumns(2);
        this.mHoldCaseText.getDocument().addDocumentListener(this);
    }

    private void setupPanel(JPanel jPanel) {
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OPTION_MIN_LABEL");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel.setLabelFor((Component)this.mMinCaseText);
        insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, 0, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinCaseText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.setupHolOutPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    private JPanel setupHolOutPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_OPTION_HOLD_PANEL_TITLE")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        DialogUtil.addUsingGBL(jPanel, this.mHoldCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(n2, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHoldCaseText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = new Insets(n2, n2 + 10, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRandomCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }
}

