/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.conjoint.display_dlg;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.conjoint.display_dlg.DisplayDlg;
import com.spss.uitools.controls.ContextEnabledTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DisplayTitles
extends BaseSubDialog {
    static final String PROFILE_TITLE_KEY = "IDS_TITLE_AREA";
    static final String PROFILE_FOOTER_KEY = "IDS_FOOTER_AREA";
    private JLabel mTitleLabel;
    private JLabel mFooterLabel;
    private ContextEnabledTextArea mTitleArea;
    private ContextEnabledTextArea mFooterArea;
    private JScrollPane mTitleScrollPane;
    private JScrollPane mFooterScrollPane;

    public DisplayTitles(DisplayDlg displayDlg) {
        super(displayDlg, displayDlg.getResString("IDS_DISPLAY_DESIGN_TITLES_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_plan_ttl";
    }

    @Override
    public boolean continuePressed() {
        return this.mTitleArea.validateContents();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(PROFILE_TITLE_KEY, this.mTitleArea.getText());
        dialogDataModel.putString(PROFILE_FOOTER_KEY, this.mFooterArea.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = dialogDataModel.getString(PROFILE_TITLE_KEY);
        if (string == null) {
            this.mTitleArea.setText("");
        } else {
            this.mTitleArea.setText(string);
        }
        String string2 = dialogDataModel.getString(PROFILE_FOOTER_KEY);
        if (string2 == null) {
            this.mFooterArea.setText("");
        } else {
            this.mFooterArea.setText(string2);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mTitleLabel = DialogUtil.createLabel(this, "IDS_LABEL_TITLE");
        this.mFooterLabel = DialogUtil.createLabel(this, "IDS_LABEL_FOOTER");
        this.mTitleArea = new ContextEnabledTextArea(4, 40, ComponentState.getCurrentCharset());
        this.mTitleArea.addKeyListener((KeyListener)new keyTrap());
        this.mTitleArea.setDocument((Document)new DisplayTitlesFixedLengthDocument(this.mTitleArea, 255));
        this.mFooterArea = new ContextEnabledTextArea(4, 40, ComponentState.getCurrentCharset());
        this.mFooterArea.addKeyListener((KeyListener)new keyTrap());
        this.mFooterArea.setDocument((Document)new DisplayTitlesFixedLengthDocument(this.mFooterArea, 255));
        this.mFooterLabel.setLabelFor((Component)this.mFooterArea);
        this.mTitleLabel.setLabelFor((Component)this.mTitleArea);
        this.mTitleScrollPane = new JScrollPane((Component)this.mTitleArea, 22, 32);
        this.mTitleScrollPane.setEnabled(false);
        this.mFooterScrollPane = new JScrollPane((Component)this.mFooterArea, 22, 32);
        int n = 0;
        this.mTitleArea.setTabSize(n);
        this.mFooterArea.setTabSize(n);
        keyTrap keyTrap2 = new keyTrap();
        this.mTitleArea.addKeyListener((KeyListener)keyTrap2);
        this.mFooterArea.addKeyListener((KeyListener)keyTrap2);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(insets.top, 0, 0, insets.right);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTitleLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTitleScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2 = new Insets(insets.top + 10, 0, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mFooterLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFooterScrollPane, gridBagConstraints, 0, 3, 1, 1, n, null);
    }

    public class DisplayTitlesFixedLengthDocument
    extends PlainDocument {
        private int mMaxLength;
        private ContextEnabledTextArea mTextArea;

        public DisplayTitlesFixedLengthDocument(ContextEnabledTextArea contextEnabledTextArea, int n) {
            this.mMaxLength = n;
            this.mTextArea = contextEnabledTextArea;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = this.mTextArea.getLineOfOffset(this.mTextArea.getCaretPosition());
            int n3 = this.mTextArea.getLineStartOffset(n2);
            int n4 = this.mTextArea.getLineEndOffset(n2);
            String string2 = this.getText(n3, n4 - n3);
            if (string.length() > 1) {
                if (string.contains("\n")) {
                    String[] stringArray;
                    for (String string3 : stringArray = string.split("\n")) {
                        if (string3.length() + (n4 - n3) <= this.mMaxLength) continue;
                        return;
                    }
                } else if (string.length() < this.mMaxLength) {
                    if (string2.contains("\n")) {
                        int n5 = n4 - 1;
                        if (string.length() + n5 - n3 > this.mMaxLength) {
                            return;
                        }
                    } else if (string.length() + n4 - n3 > this.mMaxLength) {
                        return;
                    }
                } else if (string.length() + n4 - n3 > this.mMaxLength) {
                    return;
                }
            }
            if (string2.contains("\n")) {
                --n4;
            }
            if (string.equals("\n")) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (n4 - n3 < this.mMaxLength) {
                super.insertString(n, string, attributeSet);
            }
        }
    }

    class keyTrap
    extends KeyAdapter {
        keyTrap() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == DisplayTitles.this.mFooterArea && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 9) {
                DisplayTitles.this.mTitleArea.requestFocus();
            }
            if (keyEvent.getSource() == DisplayTitles.this.mFooterArea && !keyEvent.isShiftDown() && keyEvent.getKeyCode() == 9) {
                DisplayTitles.this.mCmdButtonPanel.getComponent(0).requestFocus();
            }
            if (keyEvent.getSource() == DisplayTitles.this.mTitleArea && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 9) {
                DisplayTitles.this.mCmdButtonPanel.getComponent(2).requestFocus();
            }
            if (keyEvent.getSource() == DisplayTitles.this.mTitleArea && !keyEvent.isShiftDown() && keyEvent.getKeyCode() == 9) {
                DisplayTitles.this.mFooterArea.requestFocus();
            }
            if (keyEvent.getKeyCode() == 9) {
                DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)DisplayTitles.this.mParentDlg.getFocusTraversalPolicy();
                Component component = (Component)keyEvent.getSource();
                if (component instanceof ContextEnabledTextArea) {
                    ((ContextEnabledTextArea)component).selectAll();
                }
                Component component2 = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)DisplayTitles.this), component) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)DisplayTitles.this), component);
                keyEvent.consume();
                if (component2 != null) {
                    component2.requestFocus();
                }
            }
        }
    }
}

