/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.conjoint.display_dlg;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.conjoint.display_dlg.DisplayTitles;
import com.spss.java_client.ui.dialogs.conjoint.res.ConjointResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DisplayDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private final String LISTING_CHECK_KEY = "IDS_LISTING_CHECK";
    private final String PROFILES_CHECK_KEY = "IDS_PROFILES_CHECK";
    private final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    private JScrollPane mListScrollPane;
    private SrcVariableList mSrcVarList;
    private ArrowButton mArrowButton;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetScrollPane;
    private JCheckBox mListingCheckBox;
    private JCheckBox mProfilesCheckBox;
    private JLabel mTargetListLabel;
    private JButton mTitlesButton;

    public DisplayDlg(JFrame jFrame) {
        super(jFrame, false, ConjointResBundle.getDefaultResourceBundleName(), ConjointResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DISPLAY_DESIGN_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("PLANCARDS"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FACTORS="));
        stringBuffer.append(this.mTargetVarList.getVariablesStringList());
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FORMAT "));
        stringBuffer.append(this.getCheckBoxString());
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString("IDS_TITLE_AREA");
        String string2 = dialogDataModel.getString("IDS_FOOTER_AREA");
        if (string == null || string2 == null || string.equals("") && string2.equals("")) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        } else {
            if (!string.equals("")) {
                this.getTitleAreaString(stringBuffer, string, string2);
            }
            if (!string2.equals("")) {
                this.getFooterAreaString(stringBuffer, string2);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_plan";
    }

    @Override
    public String getIActionKey() {
        return "data_ortho_design_display";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.getModel().removeAll();
        this.mListingCheckBox.setSelected(false);
        this.mProfilesCheckBox.setSelected(false);
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkStateOfCheckBox();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkStateOfCheckBox();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkStateOfCheckBox();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mTitlesButton = new JButton();
        this.mTitlesButton.setAction(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayDlg.this.runTitlesSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mTitlesButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mListScrollPane = new JScrollPane(this.mSrcVarList);
        this.mListScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetListLabel = DialogUtil.createLabel(this, "IDS_LABEL_FACTORS");
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 5 + 2));
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LISTING_CHECK");
        this.mListingCheckBox = new JCheckBox(toggleButtonAction);
        this.mListingCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_PROFILES_CHECK");
        this.mProfilesCheckBox = new JCheckBox(toggleButtonAction);
        this.mProfilesCheckBox.addItemListener(this);
    }

    private String getCheckBoxString() {
        String string = this.mListingCheckBox.isSelected() && this.mProfilesCheckBox.isSelected() ? "BOTH" : (this.mListingCheckBox.isSelected() ? "LIST" : "CARD");
        return string;
    }

    private void getTitleAreaString(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE "));
        string = string.replaceAll("\n", "\\\\n");
        string = CharacterUtil.smartQuote((String)string);
        stringBuffer.append(string);
        if (string2.equals("")) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
    }

    private void getFooterAreaString(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/FOOTER "));
        string = string.replaceAll("\n", "\\\\n");
        string = CharacterUtil.smartQuote((String)string);
        stringBuffer.append(string);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mListingCheckBox);
        vector.add(this.mTitlesButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.setShowVarLabels(false, true);
        this.mSrcVarList.setShowIcon(false);
        this.mTargetVarList.setShowVarLabels(false, true);
        this.mTargetVarList.setShowIcon(false);
    }

    private void setUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DISPLAY_DESIGN_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mListScrollPane, gridBagConstraints, 0, 1, 1, 6, n2, null);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n2, null);
        Insets insets2 = new Insets(0, 0, 0, n + 5);
        n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 3, 3, n2, insets2);
        JPanel jPanel2 = this.setUpFormatCheckPanel();
        DialogUtil.createButtonGroup(jPanel2);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(n, n + 5, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 3, n2, insets2);
    }

    private void checkStateOfCheckBox() {
        if ((this.mProfilesCheckBox.isSelected() | this.mListingCheckBox.isSelected()) & this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void runTitlesSubDialog() {
        this.runSubDialog(new DisplayTitles(this));
    }

    private JPanel setUpFormatCheckPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_BORDER"));
        jPanel.setBorder(titledBorder);
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mListingCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mProfilesCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }
}

