/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.common.ErrorCodeType;
import com.spss.java_client.ui.dialogs.complex_samples.common.Importer;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWAbstractWizardPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

class SWWelcomePage
extends SWAbstractWizardPage
implements ItemListener {
    static final String SAMPLING_WIZARD_WELCOME_PAGE_ID = "SAMPLING_WIZARD_WELCOME_PAGE_ID";
    private static final String SAMPLING_WIZARD_TITLE = "IDS_SW_SELECT_A_SAMPLE_WIZARD";
    private final String SAMPLING_WIZARD_HELP_ID = "idh_idd_samp_wiz_welcome";
    private final String WELCOME_PAGE_TITLE_LABEL = "IDS_SW_WELCOME_PAGE_TITLE_LABEL";
    private final String WELCOME_PAGE_FIRST_LABEL = "IDS_SW_WELCOME_PAGE_FIRST_LABEL";
    private final String WELCOME_PAGE_SECOND_LABEL = "IDS_SW_WELCOME_PAGE_SECOND_LABEL";
    private final String WELCOME_QUESTION_LABEL = "IDS_SW_WELCOME_QUESTION_LABEL";
    private final String DESIGN_SAMPLE = "IDS_SW_DESIGN_SAMPLE";
    private final String DESIGN_LABEL = "IDS_SW_DESIGN_LABEL";
    private final String DESIGN_FILE_LABEL = "IDS_SW_DESIGN_FILE_LABEL";
    private final String DESIGN_BROWSE = "IDS_SW_DESIGN_BROWSE";
    private final String EDIT_SAMPLE = "IDS_SW_EDIT_SAMPLE";
    private final String EDIT_LABEL = "IDS_SW_EDIT_LABEL";
    private final String EDIT_FILE_LABEL = "IDS_SW_EDIT_FILE_LABEL";
    private final String EDIT_BROWSE = "IDS_SW_EDIT_BROWSE";
    private final String DRAW_SAMPLE = "IDS_SW_DRAW_SAMPLE";
    private final String DRAW_LABEL = "IDS_SW_DRAW_LABEL";
    private final String DRAW_FILE_LABEL = "IDS_SW_DRAW_FILE_LABEL";
    private final String DRAW_BROWSE = "IDS_SW_DRAW_BROWSE";
    private final String WELCOME_IMAGE = "IDS_SW_WELCOME_IMAGE";
    private final String SAVE_FILE_CHOOSER_TITLE = "IDS_SW_SAVE_FILE_CHOOSER_TITLE";
    private final String OPEN_FILE_CHOOSER_TITLE = "IDS_SW_OPEN_FILE_CHOOSER_TITLE";
    private final String PLAN_FILE_EXTENSION = "IDS_SW_PLAN_FILE_EXTENSION";
    private final String PLAN_FILE_FILTER = "IDS_SW_PLAN_FILE_FILTER_DESC";
    private final String PLAN_FILE_NOT_VALID = "ERR_SW_PLAN_FILE_NOT_VALID";
    private final String SAMPLE_DESIGN_MISSING_IN_PLAN_FILE = "ERR_SW_SAMPLE_DESIGN_MISSING_IN_PLAN_FILE";
    private JRadioButton mDesignSampleRadio;
    private JTextArea mDesignSampleLabel;
    private JRadioButton mEditSampleDesignRadio;
    private JTextArea mEditSampleLabel;
    private JRadioButton mDrawSampleRadio;
    private JTextArea mDrawSampleLabel;
    private JLabel mQuestionLabel;
    private JLabel mDesignFileLabel;
    private FileTextField mDesignFileTextField;
    private JButton mDesignBrowseButton;
    private JLabel mEditFileLabel;
    private FileTextField mEditFileTextField;
    private JButton mEditBrowseButton;
    private JLabel mDrawFileLabel;
    private FileTextField mDrawFileTextField;
    private JButton mDrawBrowseButton;
    private Vector<String> mVarsNotInPlanFile = new Vector();
    private Vector<String> mVarsShouldBeNumericInPlanFile = new Vector();
    private boolean mDesignSample = false;
    private RemoteFileChooser mDesignFileChooser;
    private RemoteFileChooser mEditFileChooser;
    private RemoteFileChooser mDrawFileChooser;
    private String mCurrentDirPath;

    SWWelcomePage(BaseWizardDialog baseWizardDialog) {
        super(SAMPLING_WIZARD_WELCOME_PAGE_ID, baseWizardDialog.getResString(SAMPLING_WIZARD_TITLE), baseWizardDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemEvent.getSource().equals(this.mDesignSampleRadio)) {
            if (bl) {
                this.setEnabled(true, false, false);
            }
        } else if (itemEvent.getSource().equals(this.mEditSampleDesignRadio)) {
            if (bl) {
                this.setEnabled(false, true, false);
            }
        } else if (itemEvent.getSource().equals(this.mDrawSampleRadio) && bl) {
            this.setEnabled(false, false, true);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_samp_wiz_welcome";
    }

    public String fileName() {
        if (this.mDesignSampleRadio.isSelected()) {
            return this.mDesignFileTextField.getText();
        }
        if (this.mEditSampleDesignRadio.isSelected()) {
            return this.mEditFileTextField.getText();
        }
        return this.mDrawFileTextField.getText();
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToWelcomePanel();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getNextPage() {
        if (this.mDesignSampleRadio.isSelected()) {
            return "SW_STAGE1_DESIGN_VAR_PAGE_ID";
        }
        return "SW_PLAN_SUMMARY_PAGE_ID";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate() {
        if (this.mDesignSampleRadio.isSelected()) {
            boolean bl;
            if (this.mDesignFileTextField.getText().trim().length() == 0) {
                this.mDesignBrowseButton.doClick();
            }
            boolean bl2 = bl = PES_Repository.isPesUri((String)this.mDesignFileTextField.getText()) || FileValidator.validatePath((Component)((Object)this.mWizardDialog), this.mDesignFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
            if (this.mDesignFileTextField.getText().trim().length() == 0 || !bl) {
                this.mDesignFileTextField.requestFocusInWindow();
                return false;
            }
            this.mDesignFileTextField.setText(this.verifySelectedFile(this.mDesignFileTextField.getText(), ".csplan"));
            if (this.mDesignFileTextField.getText().length() == 0) {
                this.mDesignFileTextField.requestFocusInWindow();
                return false;
            }
            if (this.mDesignSample) return true;
            this.designSample();
            this.mDesignSample = true;
            this.mEditFileTextField.setText("");
            this.mDrawFileTextField.setText("");
            return true;
        } else if (this.mEditSampleDesignRadio.isSelected()) {
            this.mEditFileTextField.setText(this.verifySelectedFile(this.mEditFileTextField.getText(), ".csplan"));
            if (this.mEditFileTextField.getText().length() == 0) {
                this.mEditBrowseButton.doClick();
            }
            if (this.mEditFileTextField.getText().length() == 0) {
                this.mEditFileTextField.requestFocusInWindow();
                return false;
            }
            String string = FileValidator.addDirectoryPath(this.mEditFileTextField.getText().trim(), DataServerProxy.getDataProxy().isRemoteConnection());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DialogUtil.readTempDirLocationPrefs());
            stringBuffer.append(System.getProperties().getProperty("file.separator"));
            stringBuffer.append("spss_temp");
            String string2 = stringBuffer.toString();
            new File(string2).deleteOnExit();
            short s = FileValidator.evaluateOpenFile((Component)((Object)this.mWizardDialog), string, false, false);
            if (s == 2 || s == 3) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_READ_ONLY"), string), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            if (s == 5) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_NOT_FOUND"), string), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
            if (!utilityProxy.copyServerFile(string, string2, true)) {
                return false;
            }
            Specification specification = new Specification();
            Importer importer = new Importer(specification);
            ErrorCodeType errorCodeType = importer.getSamplePlan(string2);
            if (errorCodeType == ErrorCodeType.CSXML_PARSER_ERROR) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_SW_PLAN_FILE_NOT_VALID"), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            if (errorCodeType == ErrorCodeType.CSXML_SAMPLEDESIGN_MISSING) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_SW_SAMPLE_DESIGN_MISSING_IN_PLAN_FILE"), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            if (!this.verifyNumericPlanVars(specification)) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < this.mVarsShouldBeNumericInPlanFile.size(); ++i) {
                    stringBuffer2.append(this.mVarsShouldBeNumericInPlanFile.get(i));
                    if (i >= this.mVarsShouldBeNumericInPlanFile.size() - 1) continue;
                    stringBuffer2.append(", ");
                }
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_CS_PLAN_VARIABLES_REQUIRED_NUMERIC"), stringBuffer2.toString()), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            if (!this.checkPlanVarsValidity(specification)) return false;
            ((SelectASampleWizardDlg)this.mWizardDialog).setSpecification(specification);
            ((SelectASampleWizardDlg)this.mWizardDialog).setNumStages(specification.getStageListSize());
            if (errorCodeType != ErrorCodeType.CSXML_ERROR_NONE) return true;
            this.mDesignSample = false;
            this.mDesignFileTextField.setText("");
            this.mDrawFileTextField.setText("");
            this.editSample();
            return true;
        } else {
            boolean bl;
            if (!this.mDrawSampleRadio.isSelected()) return true;
            if (this.mDrawFileTextField.getText().length() == 0) {
                this.mDrawBrowseButton.doClick();
            }
            if (this.mDrawFileTextField.getText().length() == 0) {
                this.mDrawFileTextField.requestFocusInWindow();
                return false;
            }
            String string = this.mDrawFileTextField.getText().trim();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DialogUtil.readTempDirLocationPrefs());
            stringBuffer.append(System.getProperties().getProperty("file.separator"));
            stringBuffer.append("spss_temp");
            String string3 = stringBuffer.toString();
            new File(string3).deleteOnExit();
            boolean bl3 = false;
            RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
            boolean bl4 = bl = !remoteFileStatus.errorOccurred();
            if (bl) {
                boolean bl5 = bl3 = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
            }
            if (!bl3) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_NOT_FOUND"), this.mDrawFileTextField.getText()), VersionInfo.getAppVersionString());
                this.mDrawFileTextField.requestFocus();
                return false;
            }
            UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
            if (!utilityProxy.copyServerFile(string, string3, true)) {
                return false;
            }
            Specification specification = new Specification();
            Importer importer = new Importer(specification);
            ErrorCodeType errorCodeType = importer.getSamplePlan(string3);
            if (errorCodeType == ErrorCodeType.CSXML_PARSER_ERROR) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_SW_PLAN_FILE_NOT_VALID"), VersionInfo.getAppVersionString());
                this.mDrawFileTextField.requestFocus();
                return false;
            }
            if (errorCodeType == ErrorCodeType.CSXML_SAMPLEDESIGN_MISSING) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_SW_SAMPLE_DESIGN_MISSING_IN_PLAN_FILE"), VersionInfo.getAppVersionString());
                this.mDrawFileTextField.requestFocus();
                return false;
            }
            if (!this.verifyNumericPlanVars(specification)) {
                StringBuffer stringBuffer3 = new StringBuffer();
                for (int i = 0; i < this.mVarsShouldBeNumericInPlanFile.size(); ++i) {
                    stringBuffer3.append(this.mVarsShouldBeNumericInPlanFile.get(i));
                    if (i >= this.mVarsShouldBeNumericInPlanFile.size() - 1) continue;
                    stringBuffer3.append(", ");
                }
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_CS_PLAN_VARIABLES_REQUIRED_NUMERIC"), stringBuffer3.toString()), VersionInfo.getAppVersionString());
                this.mDrawFileTextField.requestFocus();
                return false;
            }
            if (!this.checkPlanVarsValidity(specification)) return false;
            ((SelectASampleWizardDlg)this.mWizardDialog).setSpecification(specification);
            ((SelectASampleWizardDlg)this.mWizardDialog).setNumStages(specification.getStageListSize());
            if (errorCodeType != ErrorCodeType.CSXML_ERROR_NONE) return true;
            this.mDesignSample = false;
            this.mDesignFileTextField.setText("");
            this.mEditFileTextField.setText("");
            this.drawSample();
            if (specification.getStageListSize() == 3L) {
                ((SelectASampleWizardDlg)this.mWizardDialog).setStage2Added(true);
                ((SelectASampleWizardDlg)this.mWizardDialog).setStage3Added(true);
                return true;
            } else {
                if (specification.getStageListSize() != 2L) return true;
                ((SelectASampleWizardDlg)this.mWizardDialog).setStage2Added(true);
            }
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.loadLabelPanel();
        this.setupImagePanel();
        ((SelectASampleWizardDlg)this.mWizardDialog).getIncompleteStageLabel().setVisible(false);
        ((SelectASampleWizardDlg)this.mWizardDialog).pushPageInStack(this);
        this.mWizardDialog.enableFinish(false);
    }

    boolean isDesignSampleSelected() {
        return this.mDesignSampleRadio.isSelected();
    }

    boolean isEditSampleSelected() {
        return this.mEditSampleDesignRadio.isSelected();
    }

    boolean isDrawSampleSelected() {
        return this.mDrawSampleRadio.isSelected();
    }

    String getDesignSampleFileName() {
        return this.mDesignFileTextField.getText();
    }

    String getEditSampleFileName() {
        return this.mEditFileTextField.getText();
    }

    String getDrawSampleFileName() {
        return this.mDrawFileTextField.getText();
    }

    private void designSample() {
        ((SelectASampleWizardDlg)this.mWizardDialog).cleanUp();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupDesignTree();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupDesignPages();
        this.packAllWizardDialogPages();
        ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, true);
    }

    private void editSample() {
        ((SelectASampleWizardDlg)this.mWizardDialog).cleanUp();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupEditTree();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupEditPages();
        this.packAllWizardDialogPages();
    }

    private void drawSample() {
        ((SelectASampleWizardDlg)this.mWizardDialog).cleanUp();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupDrawTree();
        ((SelectASampleWizardDlg)this.mWizardDialog).setupDrawPages();
        this.packAllWizardDialogPages();
    }

    private void loadLabelPanel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(this.mWizardDialog.getResString("IDS_SW_WELCOME_PAGE_TITLE_LABEL"));
        stringBuilder.append("\n\n");
        stringBuilder.append(this.mWizardDialog.getResString("IDS_SW_WELCOME_PAGE_FIRST_LABEL"));
        stringBuilder.append("\n");
        stringBuilder.append(this.mWizardDialog.getResString("IDS_SW_WELCOME_PAGE_SECOND_LABEL"));
        ((JTextArea)SelectASampleWizardDlg.sLabelPanel.getComponent(0)).setText(stringBuilder.toString());
    }

    private void setupImagePanel() {
        URL uRL = this.mWizardDialog.getResImageURL("IDS_SW_WELCOME_IMAGE");
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        if (SelectASampleWizardDlg.sImagePanel.getComponentCount() > 0) {
            SelectASampleWizardDlg.sImagePanel.remove(0);
        }
        DialogUtil.addUsingGBL(SelectASampleWizardDlg.sImagePanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        SelectASampleWizardDlg.sImagePanel.repaint();
    }

    private void setEnabled(boolean bl, boolean bl2, boolean bl3) {
        this.mDesignFileLabel.setEnabled(bl);
        this.mDesignFileTextField.setEnabled(bl);
        this.mDesignFileTextField.setOpaque(bl);
        this.mDesignBrowseButton.setEnabled(bl);
        this.mEditFileLabel.setEnabled(bl2);
        this.mEditFileTextField.setEnabled(bl2);
        this.mEditFileTextField.setOpaque(bl2);
        this.mEditBrowseButton.setEnabled(bl2);
        this.mDrawFileLabel.setEnabled(bl3);
        this.mDrawFileTextField.setEnabled(bl3);
        this.mDrawFileTextField.setOpaque(bl3);
        this.mDrawBrowseButton.setEnabled(bl3);
    }

    private boolean verifyNumericPlanVars(Specification specification) {
        this.mVarsShouldBeNumericInPlanFile.removeAllElements();
        boolean bl = true;
        if (!this.isNumericDataType(specification.getPreviousWeight())) {
            this.mVarsShouldBeNumericInPlanFile.add(specification.getPreviousWeight());
            bl = false;
        }
        if (!specification.isMOSFromData() && !this.isNumericDataType(specification.getMOS())) {
            this.mVarsShouldBeNumericInPlanFile.add(specification.getMOS());
            bl = false;
        }
        int n = 1;
        while ((long)n <= specification.getStageListSize()) {
            StageInformation stageInformation = specification.getStage(n);
            if (!this.isNumericDataType(stageInformation.getParameterVariable())) {
                this.mVarsShouldBeNumericInPlanFile.add(stageInformation.getParameterVariable());
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private boolean isNumericDataType(String string) {
        ISpssVariable iSpssVariable;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.findVarIndex(string);
        return n == -1 || (iSpssVariable = iSpssDataSrc.getVariable(n)).getType() == 0;
    }

    private boolean checkPlanVarsValidity(Specification specification) {
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((long)n <= specification.getStageListSize()) {
            StageInformation stageInformation = specification.getStage(n);
            int n2 = 0;
            while ((long)n2 < stageInformation.getStrataListSize()) {
                vector.add(stageInformation.getStrataVariable(n2));
                ++n2;
            }
            n2 = 0;
            while ((long)n2 < stageInformation.getClusterListSize()) {
                vector.add(stageInformation.getClusterVariable(n2));
                ++n2;
            }
            if (specification.getPreviousWeight().length() > 0) {
                vector.add(specification.getPreviousWeight());
            }
            if (specification.getMOS().length() > 0) {
                vector.add(specification.getMOS());
            }
            if (stageInformation.getParameterVariable().length() > 0) {
                vector.add(stageInformation.getParameterVariable());
            }
            n2 = 0;
            while ((long)n2 < stageInformation.getVariableCategoryList().getVariableListSize()) {
                vector.add(stageInformation.getVariableCategoryList().getVariable(n2));
                ++n2;
            }
            ++n;
        }
        if (!this.verfiyPlanVars(vector)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.mVarsNotInPlanFile.size(); ++i) {
                stringBuffer.append(this.mVarsNotInPlanFile.get(i));
                if (i >= this.mVarsNotInPlanFile.size() - 1) continue;
                stringBuffer.append(", ");
            }
            String string = String.format(this.mWizardDialog.getResString("ERR_CS_PLAN_VARIABLES_DO_NOT_MATCH"), stringBuffer.toString());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    private boolean verfiyPlanVars(Vector<String> vector) {
        this.mVarsNotInPlanFile.removeAllElements();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        boolean bl = true;
        for (String string : vector) {
            if (iSpssDataSrc.findVarIndex(string) != -1) continue;
            bl = false;
            if (this.mVarsNotInPlanFile.contains(string)) continue;
            this.mVarsNotInPlanFile.add(string);
        }
        return bl;
    }

    private void addComponentsToWelcomePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(15, 10, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mQuestionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDesignSampleRadio, gridBagConstraints, 0, 1, 4, 1, n, insets);
        insets.set(10, 25, 0, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDesignSampleLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDesignFileLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDesignFileTextField), gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mDesignBrowseButton, gridBagConstraints, 3, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mEditSampleDesignRadio, gridBagConstraints, 0, 3, 4, 1, n, insets);
        insets.set(10, 25, 0, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mEditSampleLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(25, DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mEditFileLabel, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mEditFileTextField), gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(25, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mEditBrowseButton, gridBagConstraints, 3, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDrawSampleRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(10, 25, 15, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDrawSampleLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getGroupBoxInnerMargin() * 2, 10, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDrawFileLabel, gridBagConstraints, 1, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDrawFileTextField), gridBagConstraints, 2, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getGroupBoxInnerMargin(), 10, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mDrawBrowseButton, gridBagConstraints, 3, 6, 1, 1, n, insets);
        DialogUtil.normalizeLabelWidths(jPanel);
        DialogUtil.createButtonGroup(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void initVars() {
        this.mQuestionLabel = new JLabel(this.mWizardDialog.getResString("IDS_SW_WELCOME_QUESTION_LABEL"));
        this.mDesignSampleRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_SW_DESIGN_SAMPLE"));
        this.mDesignSampleRadio.addItemListener(this);
        this.mDesignSampleLabel = new JTextArea(this.mWizardDialog.getResString("IDS_SW_DESIGN_LABEL"));
        this.mDesignSampleLabel.setLineWrap(true);
        this.mDesignSampleLabel.setWrapStyleWord(true);
        this.mDesignSampleLabel.setBorder(null);
        this.mDesignSampleLabel.setOpaque(false);
        this.mDesignSampleLabel.setFocusable(false);
        this.mDesignSampleLabel.setSize(new Dimension(100, 45));
        this.mDesignFileTextField = new FileTextField();
        this.mDesignFileTextField.setFocusable(true);
        this.mDesignFileTextField.setColumns(12);
        this.mDesignFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SW_DESIGN_FILE_LABEL");
        this.mDesignFileLabel.setLabelFor((Component)((Object)this.mDesignFileTextField));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SW_DESIGN_BROWSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (SWWelcomePage.this.mDesignFileChooser == null) {
                    SWWelcomePage.this.mDesignFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
                    SWWelcomePage.this.mDesignFileChooser.setDialogTitle(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_SAVE_FILE_CHOOSER_TITLE"));
                    SWWelcomePage.this.mDesignFileChooser.setAcceptAllFileFilterUsed(OSInfo.getOSType() == OSInfo.OSType.MAC);
                    SWWelcomePage.this.mDesignFileChooser.setFileFilter((FileFilter)new RefFileFilter(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_FILTER_DESC"), SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_EXTENSION")));
                }
                if (SWWelcomePage.this.mCurrentDirPath != null) {
                    SWWelcomePage.this.mDesignFileChooser.setCurrentDirectory((File)new RefFile(SWWelcomePage.this.mCurrentDirPath));
                }
                if ((n = SWWelcomePage.this.mDesignFileChooser.showSaveDialog((Component)((Object)SWWelcomePage.this.mWizardDialog))) == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)SWWelcomePage.this.mDesignFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = SWWelcomePage.this.mDesignFileChooser.getSelectedFilePath();
                    String string2 = SWWelcomePage.this.verifySelectedFile(string, ".csplan");
                    SWWelcomePage.this.mDesignFileChooser.setSelectedFile(new File(string2));
                    SWWelcomePage.this.mCurrentDirPath = SWWelcomePage.this.mDesignFileChooser.getSelectedFile().getParent();
                    SWWelcomePage.this.mDesignFileTextField.setText(string2);
                } else {
                    SWWelcomePage.this.mDesignFileTextField.requestFocusInWindow();
                }
            }
        };
        this.mDesignBrowseButton = new JButton(toggleButtonAction);
        this.mEditSampleDesignRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_SW_EDIT_SAMPLE"));
        this.mEditSampleDesignRadio.addItemListener(this);
        this.mEditSampleLabel = new JTextArea(this.mWizardDialog.getResString("IDS_SW_EDIT_LABEL"));
        this.mEditSampleLabel.setLineWrap(true);
        this.mEditSampleLabel.setWrapStyleWord(true);
        this.mEditSampleLabel.setBorder(null);
        this.mEditSampleLabel.setOpaque(false);
        this.mEditSampleLabel.setFocusable(false);
        this.mEditSampleLabel.setSize(new Dimension(100, 60));
        this.mEditFileTextField = new FileTextField();
        this.mEditFileTextField.setFocusable(true);
        this.mEditFileTextField.setColumns(12);
        this.mEditFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SW_EDIT_FILE_LABEL");
        this.mEditFileLabel.setLabelFor((Component)((Object)this.mEditFileTextField));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SW_EDIT_BROWSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (SWWelcomePage.this.mEditFileChooser == null) {
                    SWWelcomePage.this.mEditFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                    SWWelcomePage.this.mEditFileChooser.setDialogTitle(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_OPEN_FILE_CHOOSER_TITLE"));
                    RefFileFilter refFileFilter = new RefFileFilter(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_FILTER_DESC"), SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_EXTENSION"));
                    SWWelcomePage.this.mEditFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                    SWWelcomePage.this.mEditFileChooser.setAcceptAllFileFilterUsed(true);
                    SWWelcomePage.this.mEditFileChooser.setFileFilter((FileFilter)refFileFilter, true);
                }
                if (SWWelcomePage.this.mCurrentDirPath != null) {
                    SWWelcomePage.this.mEditFileChooser.setCurrentDirectory((File)new RefFile(SWWelcomePage.this.mCurrentDirPath));
                }
                if ((n = SWWelcomePage.this.mEditFileChooser.showOpenDialog((Component)((Object)SWWelcomePage.this.mWizardDialog))) == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)SWWelcomePage.this.mEditFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = SWWelcomePage.this.mEditFileChooser.getSelectedFilePath();
                    String string2 = SWWelcomePage.this.verifySelectedFile(string, null);
                    SWWelcomePage.this.mEditFileChooser.setSelectedFile(new File(string2));
                    SWWelcomePage.this.mCurrentDirPath = SWWelcomePage.this.mEditFileChooser.getSelectedFile().getParent();
                    SWWelcomePage.this.mEditFileTextField.setText(string2);
                } else {
                    SWWelcomePage.this.mEditFileTextField.requestFocusInWindow();
                }
            }
        };
        this.mEditBrowseButton = new JButton(toggleButtonAction);
        this.mDrawSampleRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_SW_DRAW_SAMPLE"));
        this.mDrawSampleRadio.addItemListener(this);
        this.mDrawSampleLabel = new JTextArea(this.mWizardDialog.getResString("IDS_SW_DRAW_LABEL"));
        this.mDrawSampleLabel.setLineWrap(true);
        this.mDrawSampleLabel.setWrapStyleWord(true);
        this.mDrawSampleLabel.setBorder(null);
        this.mDrawSampleLabel.setOpaque(false);
        this.mDrawSampleLabel.setFocusable(false);
        this.mDrawSampleLabel.setSize(new Dimension(100, 45));
        this.mDrawFileTextField = new FileTextField();
        this.mDrawFileTextField.setFocusable(true);
        this.mDrawFileTextField.setColumns(12);
        this.mDrawFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SW_DRAW_FILE_LABEL");
        this.mDrawFileLabel.setLabelFor((Component)((Object)this.mDrawFileTextField));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SW_DRAW_BROWSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (SWWelcomePage.this.mDrawFileChooser == null) {
                    SWWelcomePage.this.mDrawFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                    SWWelcomePage.this.mDrawFileChooser.setDialogTitle(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_OPEN_FILE_CHOOSER_TITLE"));
                    RefFileFilter refFileFilter = new RefFileFilter(SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_FILTER_DESC"), SWWelcomePage.this.mWizardDialog.getResString("IDS_SW_PLAN_FILE_EXTENSION"));
                    SWWelcomePage.this.mDrawFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                    SWWelcomePage.this.mDrawFileChooser.setAcceptAllFileFilterUsed(true);
                    SWWelcomePage.this.mDrawFileChooser.setFileFilter((FileFilter)refFileFilter, true);
                }
                if (SWWelcomePage.this.mCurrentDirPath != null) {
                    SWWelcomePage.this.mDrawFileChooser.setCurrentDirectory((File)new RefFile(SWWelcomePage.this.mCurrentDirPath));
                }
                if ((n = SWWelcomePage.this.mDrawFileChooser.showOpenDialog((Component)((Object)SWWelcomePage.this.mWizardDialog))) == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)SWWelcomePage.this.mDrawFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = SWWelcomePage.this.mDrawFileChooser.getSelectedFilePath();
                    String string2 = SWWelcomePage.this.verifySelectedFile(string, null);
                    SWWelcomePage.this.mDrawFileChooser.setSelectedFile(new File(string2));
                    SWWelcomePage.this.mCurrentDirPath = SWWelcomePage.this.mDrawFileChooser.getSelectedFile().getParent();
                    SWWelcomePage.this.mDrawFileTextField.setText(string2);
                } else {
                    SWWelcomePage.this.mDrawFileTextField.requestFocusInWindow();
                }
            }
        };
        this.mDrawBrowseButton = new JButton(toggleButtonAction);
        this.mDesignSampleRadio.setSelected(true);
    }

    private void setDefaults() {
        this.mDesignSampleRadio.setSelected(true);
        this.mEditFileLabel.setEnabled(false);
        this.mEditFileTextField.setEnabled(false);
        this.mEditFileTextField.setOpaque(false);
        this.mEditBrowseButton.setEnabled(false);
        this.mDrawFileLabel.setEnabled(false);
        this.mDrawFileTextField.setEnabled(false);
        this.mDrawFileTextField.setOpaque(false);
        this.mDrawBrowseButton.setEnabled(false);
    }
}

