/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage1MethodPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage1OutputVarPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage2MethodPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage2OutputVarPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage3MethodPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWStage3OutputVarPage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

class SWVariableNameConflictsAlertDialog
extends SpssAlertDialog {
    private static final String SAMPLE_WEIGHT_FINAL = "IDS_SW_SAMPLE_WEIGHT_FINAL";
    private static final String INCLUSION_PROB = "IDS_SW_INCLUSION_PROB";
    private static final String SAMPLE_WEIGHT_CUMULATIVE = "IDS_SW_SAMPLE_WEIGHT_CUMULATIVE";
    private static final String DUPLICATE_INDEX = "IDS_SW_DUPLICATE_INDEX";
    private static final String POPULATION_SIZES = "IDS_SW_POPULATION_SIZES";
    private static final String SAMPLE_SIZES = "IDS_SW_SAMPLE_SIZES";
    private static final String SAMPLING_PROPORTIONS = "IDS_SW_SAMPLING_PROPORTIONS";
    private static final String STAGEWISE_SAMPLING_WEIGHT = "IDS_SW_STAGEWISE_SAMPLING_WEIGHT";
    private static final String SIMPLE_RANDOM_SAMPLING = "IDS_SW_SIMPLE_RANDOM_SAMPLING";
    private static final String PPS = "IDS_SW_PPS";
    private JTable mVarNameConflictsTable;
    private BaseWizardDialog mParentDlg;
    private JScrollPane mTableScrollPane;
    private DefaultTableModel mTableModel;
    private boolean mRenamePressed;
    private boolean mDeletePressed;
    private boolean mCancelPressed;
    private JTextArea mRenDelCancelTextArea;

    SWVariableNameConflictsAlertDialog(BaseWizardDialog baseWizardDialog) {
        super(baseWizardDialog, baseWizardDialog.getResourceBundle(), baseWizardDialog.getResString("IDS_SW_VAR_NAME_CONFLICTS_TITLE_LABEL"), baseWizardDialog.getResString("IDS_SW_VAR_NAME_CONFLICTS_TITLE"), SpssAlertOptionPane.IconType.eWarning);
        this.mParentDlg = baseWizardDialog;
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void doHelp() {
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new RenameAction());
        JButton jButton2 = new JButton(new DeleteAction());
        JButton jButton3 = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton3);
                jPanel.add(jButton2);
                jPanel.add(jButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void initVars() {
        super.initVars();
        Object[][] objectArray = null;
        Object[] objectArray2 = this.getResStringArray("IDS_SW_VAR_NAME_CONFLICTS_COLUMN_NAMES");
        this.mTableModel = new DefaultTableModel(objectArray, objectArray2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mVarNameConflictsTable = new JTable(this.mTableModel);
        this.mVarNameConflictsTable.setBackground(Color.WHITE);
        this.mVarNameConflictsTable.setShowGrid(false);
        this.mVarNameConflictsTable.setAutoResizeMode(4);
        this.mVarNameConflictsTable.getTableHeader().setReorderingAllowed(false);
        this.mVarNameConflictsTable.setMinimumSize(new Dimension(420, 150));
        this.mTableScrollPane = new JScrollPane(this.mVarNameConflictsTable);
        this.mTableScrollPane.setPreferredSize(this.mVarNameConflictsTable.getMinimumSize());
        this.mTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.mTableScrollPane.setVerticalScrollBarPolicy(20);
        String string = this.getResString("IDS_SW_RENAME_DELETE_CANCEL_LABEL");
        this.mRenDelCancelTextArea = new JTextArea(string);
        FontMetrics fontMetrics = this.getFontMetrics(this.mRenDelCancelTextArea.getFont());
        String[] stringArray = string.split("\n");
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        int n3 = (int)Math.ceil((float)n / 434.0f);
        this.mRenDelCancelTextArea.setRows(n3 + stringArray.length - 1);
        int n4 = n >= 434 ? 40 : (int)Math.ceil(n / 11) + 1;
        this.mRenDelCancelTextArea.setColumns(n4);
        this.mRenDelCancelTextArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mRenDelCancelTextArea.setOpaque(false);
        this.mRenDelCancelTextArea.setFocusable(false);
        this.mRenDelCancelTextArea.setEditable(false);
        this.mRenDelCancelTextArea.setLineWrap(true);
        this.mRenDelCancelTextArea.setWrapStyleWord(true);
    }

    @Override
    protected void addComponents(boolean bl) {
        super.addComponents(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mViewPanel, this.mTableScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this.mViewPanel, this.mRenDelCancelTextArea, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.pack();
    }

    boolean isVarNameConflict() {
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        if (sWWelcomePage.isDesignSampleSelected()) {
            this.loadTableForDesign();
        } else if (sWWelcomePage.isEditSampleSelected()) {
            this.loadTableForEdit();
        } else {
            this.loadTableForDraw();
        }
        return this.mTableModel.getRowCount() > 0;
    }

    DefaultTableModel getTableModel() {
        return this.mTableModel;
    }

    boolean wasRenamePressed() {
        return this.mRenamePressed;
    }

    boolean wasDeletePressed() {
        return this.mDeletePressed;
    }

    boolean wasCancelPressed() {
        return this.mCancelPressed;
    }

    private void loadTableForDesign() {
        AbstractWizardPage abstractWizardPage;
        AbstractWizardPage abstractWizardPage2;
        SWStage1OutputVarPage sWStage1OutputVarPage;
        this.mTableModel.setRowCount(0);
        this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_FINAL_VAR_NAME"), this.getResString(SAMPLE_WEIGHT_FINAL));
        this.addRowToTable(this.getResString("IDS_SW_INCLUSION_PROBABILITY_VAR_NAME") + "1_", this.getResString(INCLUSION_PROB) + "1)");
        this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_CUMULATIVE_VAR_NAME") + "1_", this.getResString(SAMPLE_WEIGHT_CUMULATIVE) + "1)");
        SWStage1MethodPage sWStage1MethodPage = (SWStage1MethodPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE1_METHOD_PAGE_ID");
        if ((sWStage1MethodPage.getMethodTypeComboBox().getSelectedItem().equals(this.getResString(PPS)) || sWStage1MethodPage.getMethodTypeComboBox().getSelectedItem().equals(this.getResString(SIMPLE_RANDOM_SAMPLING))) && sWStage1MethodPage.getWORRadio().isEnabled() && !sWStage1MethodPage.getWORRadio().isSelected()) {
            this.addRowToTable(this.getResString("IDS_SW_INDEX_VAR_NAME") + "1_", this.getResString(DUPLICATE_INDEX) + "1)");
        }
        if ((sWStage1OutputVarPage = (SWStage1OutputVarPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE1_OUTPUT_VAR_PAGE_ID")).isPopSizeSelected()) {
            this.addRowToTable(this.getResString("IDS_SW_POPULATION_SIZE_VAR_NAME") + "1_", this.getResString(POPULATION_SIZES) + "1)");
        }
        if (sWStage1OutputVarPage.isSampleSizeSelected()) {
            this.addRowToTable(this.getResString("IDS_SW_SAMPLE_SIZE_VAR_NAME") + "1_", this.getResString(SAMPLE_SIZES) + "1)");
        }
        if (sWStage1OutputVarPage.isSampleProportionSelected()) {
            this.addRowToTable(this.getResString("IDS_SW_SAMPLING_RATE_VAR_NAME") + "1_", this.getResString(SAMPLING_PROPORTIONS) + "1)");
        }
        if (sWStage1OutputVarPage.isSampleWeightSelected()) {
            this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_VAR_NAME") + "1_", this.getResString(STAGEWISE_SAMPLING_WEIGHT) + "1)");
        }
        if (((SelectASampleWizardDlg)this.mParentDlg).isStage2Added()) {
            this.addRowToTable(this.getResString("IDS_SW_INCLUSION_PROBABILITY_VAR_NAME") + "2_", this.getResString(INCLUSION_PROB) + "2)");
            this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_CUMULATIVE_VAR_NAME") + "2_", this.getResString(SAMPLE_WEIGHT_CUMULATIVE) + "2)");
            abstractWizardPage2 = (SWStage2MethodPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE2_METHOD_PAGE_ID");
            if (((SWStage2MethodPage)abstractWizardPage2).getMethodTypeComboBox().getSelectedItem().equals(this.getResString(SIMPLE_RANDOM_SAMPLING)) && ((SWStage2MethodPage)abstractWizardPage2).getWORRadio().isEnabled() && !((SWStage2MethodPage)abstractWizardPage2).getWORRadio().isSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_INDEX_VAR_NAME") + "2_", this.getResString(DUPLICATE_INDEX) + "2)");
            }
            if (((SWStage2OutputVarPage)(abstractWizardPage = (SWStage2OutputVarPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE2_OUTPUT_VAR_PAGE_ID"))).isPopSizeSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_POPULATION_SIZE_VAR_NAME") + "2_", this.getResString(POPULATION_SIZES) + "2)");
            }
            if (((SWStage2OutputVarPage)abstractWizardPage).isSampleSizeSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLE_SIZE_VAR_NAME") + "2_", this.getResString(SAMPLE_SIZES) + "2)");
            }
            if (((SWStage2OutputVarPage)abstractWizardPage).isSampleProportionSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLING_RATE_VAR_NAME") + "2_", this.getResString(SAMPLING_PROPORTIONS) + "2)");
            }
            if (((SWStage2OutputVarPage)abstractWizardPage).isSampleWeightSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_VAR_NAME") + "2_", this.getResString(STAGEWISE_SAMPLING_WEIGHT) + "2)");
            }
        }
        if (((SelectASampleWizardDlg)this.mParentDlg).isStage3Added()) {
            this.addRowToTable(this.getResString("IDS_SW_INCLUSION_PROBABILITY_VAR_NAME") + "3_", this.getResString(INCLUSION_PROB) + "3)");
            this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_CUMULATIVE_VAR_NAME") + "3_", this.getResString(SAMPLE_WEIGHT_CUMULATIVE) + "3)");
            abstractWizardPage2 = (SWStage3MethodPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE3_METHOD_PAGE_ID");
            if (((SWStage3MethodPage)abstractWizardPage2).getMethodTypeComboBox().getSelectedItem().equals(this.getResString(SIMPLE_RANDOM_SAMPLING)) && ((SWStage3MethodPage)abstractWizardPage2).getWORRadio().isEnabled() && !((SWStage3MethodPage)abstractWizardPage2).getWORRadio().isSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_INDEX_VAR_NAME") + "3_", this.getResString(DUPLICATE_INDEX) + "3)");
            }
            if (((SWStage3OutputVarPage)(abstractWizardPage = (SWStage3OutputVarPage)((SelectASampleWizardDlg)this.mParentDlg).getWizardModel().getPage("SW_STAGE3_OUTPUT_VAR_PAGE_ID"))).isPopSizeSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_POPULATION_SIZE_VAR_NAME") + "3_", this.getResString(POPULATION_SIZES) + "3)");
            }
            if (((SWStage3OutputVarPage)abstractWizardPage).isSampleSizeSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLE_SIZE_VAR_NAME") + "3_", this.getResString(SAMPLE_SIZES) + "3)");
            }
            if (((SWStage3OutputVarPage)abstractWizardPage).isSampleProportionSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLING_RATE_VAR_NAME") + "3_", this.getResString(SAMPLING_PROPORTIONS) + "3)");
            }
            if (((SWStage3OutputVarPage)abstractWizardPage).isSampleWeightSelected()) {
                this.addRowToTable(this.getResString("IDS_SW_SAMPLE_WEIGHT_VAR_NAME") + "3_", this.getResString(STAGEWISE_SAMPLING_WEIGHT) + "2)");
            }
        }
    }

    private void loadTableForEdit() {
        this.mTableModel.setRowCount(0);
        Specification specification = ((SelectASampleWizardDlg)this.mParentDlg).getSpecification();
        if (specification.getWeight().length() > 0) {
            this.addRowToTable(specification.getWeight(), this.mParentDlg.getResString(SAMPLE_WEIGHT_FINAL));
        }
        int n = 1;
        while ((long)n <= ((SelectASampleWizardDlg)this.mParentDlg).getNumStages()) {
            StageInformation stageInformation = specification.getStage(n);
            if (stageInformation.getInclusionProbability().length() > 0) {
                this.addRowToTable(stageInformation.getInclusionProbability(), this.mParentDlg.getResString(INCLUSION_PROB) + n + ")");
            }
            if (stageInformation.getCumulativeWeight().length() > 0) {
                this.addRowToTable(stageInformation.getCumulativeWeight(), this.mParentDlg.getResString(SAMPLE_WEIGHT_CUMULATIVE) + n + ")");
            }
            if (stageInformation.getIndex().length() > 0) {
                this.addRowToTable(stageInformation.getIndex(), this.mParentDlg.getResString(DUPLICATE_INDEX) + n + ")");
            }
            if (stageInformation.getPopulationSize().length() > 0) {
                this.addRowToTable(stageInformation.getPopulationSize(), this.mParentDlg.getResString(POPULATION_SIZES) + n + ")");
            }
            if (stageInformation.getSampleSize().length() > 0) {
                this.addRowToTable(stageInformation.getSampleSize(), this.mParentDlg.getResString(SAMPLE_SIZES) + n + ")");
            }
            if (stageInformation.getRate().length() > 0) {
                this.addRowToTable(stageInformation.getRate(), this.mParentDlg.getResString(SAMPLING_PROPORTIONS) + n + ")");
            }
            if (stageInformation.getWeight().length() > 0) {
                this.addRowToTable(stageInformation.getWeight(), this.mParentDlg.getResString(STAGEWISE_SAMPLING_WEIGHT) + n + ")");
            }
            ++n;
        }
    }

    private void loadTableForDraw() {
        this.mTableModel.setRowCount(0);
        Specification specification = ((SelectASampleWizardDlg)this.mParentDlg).getSpecification();
        if (specification.getWeight().length() > 0) {
            this.addRowToTable(specification.getWeight(), this.mParentDlg.getResString(SAMPLE_WEIGHT_FINAL));
        }
    }

    private void addRowToTable(String string, String string2) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Vector<String> vector = new Vector<String>();
        if (iSpssDataSrc.findVarIndex(string) != -1) {
            vector.add(string);
            vector.add(string2);
            this.mTableModel.addRow(vector);
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", SWVariableNameConflictsAlertDialog.this.getResString("IDS_SW_CANCEL_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SWVariableNameConflictsAlertDialog.this.mCancelPressed = true;
            SWVariableNameConflictsAlertDialog.this.dispose();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", SWVariableNameConflictsAlertDialog.this.getResString("IDS_SW_DELETE_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SWVariableNameConflictsAlertDialog.this.mDeletePressed = true;
            SWVariableNameConflictsAlertDialog.this.dispose();
        }
    }

    private class RenameAction
    extends AbstractAction {
        RenameAction() {
            this.putValue("Name", SWVariableNameConflictsAlertDialog.this.getResString("IDS_SW_RENAME_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SWVariableNameConflictsAlertDialog.this.mRenamePressed = true;
            SWVariableNameConflictsAlertDialog.this.dispose();
        }
    }
}

