/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWCustomTree;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWMenuTreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;

class SWStage3OutputVarPage
extends AbstractWizardPage
implements ItemListener {
    static final String SW_STAGE3_OUTPUT_VAR_PAGE_ID = "SW_STAGE3_OUTPUT_VAR_PAGE_ID";
    private static final String SAMPLING_WIZARD_TITLE = "IDS_SW_SELECT_A_SAMPLE_WIZARD";
    private static final String SW_STAGE1_OUTPUT_VAR_PAGE_HELP_ID = "idh_idd_samp_wiz_output_vars";
    private static final String STAGE3_OUTPUT_VAR_PAGE_TITLE_LABEL = "IDS_SW_STAGE3_OUTPUT_VAR_PAGE_TITLE_LABEL";
    private static final String OUTPUT_VAR_PAGE_FIRST_LABEL = "IDS_SW_OUTPUT_VAR_PAGE_FIRST_LABEL_NOT_LOCKED";
    private static final String OUTPUT_VAR_QUESTION_LABEL = "IDS_SW_OUTPUT_VAR_QUESTION_LABEL";
    private static final String POPULATION_SIZE = "IDS_SW_POPULATION_SIZE";
    private static final String SAMPLE_SIZE = "IDS_SW_SAMPLE_SIZE";
    private static final String SAMPLE_PROPORTION = "IDS_SW_SAMPLE_PROPORTION";
    private static final String SAMPLE_WEIGHT = "IDS_SW_SAMPLE_WEIGHT";
    private static final String INCLUSION_LABEL = "IDS_SW_INCLUSION_LABEL";
    private static final String DUPLICATION_LABEL = "IDS_SW_DUPLICATION_LABEL";
    private static final String IMAGE_URL = "IDS_INFO_DOT_IMAGE";
    private JLabel mQuestionLabel;
    private JCheckBox mPopulationSizeCheckBox;
    private JCheckBox mSampleSizeCheckBox;
    private JCheckBox mSampleProportionCheckBox;
    private JCheckBox mSampleWeightCheckBox;
    private JTextArea mInclusionLabel;
    private JTextArea mDuplicationLabel;
    private JLabel mImageLabel;
    private SWCustomTree mMenuTree;
    private Specification mSpecification;
    private boolean mIsFirstVisit = false;

    SWStage3OutputVarPage(BaseWizardDialog baseWizardDialog, SWCustomTree sWCustomTree) {
        super(SW_STAGE3_OUTPUT_VAR_PAGE_ID, baseWizardDialog.getResString(SAMPLING_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = sWCustomTree;
        this.mIsFirstVisit = true;
    }

    @Override
    public String getDialogHelpID() {
        return SW_STAGE1_OUTPUT_VAR_PAGE_HELP_ID;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ((SelectASampleWizardDlg)this.mWizardDialog).markStateHasChanged(3);
    }

    @Override
    public void init() {
        this.initVars();
        this.addListeners();
        this.addComponentsToOutputVarsPanel();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getNextPage() {
        return "SW_STAGE3_SUMMARY_PAGE_ID";
    }

    @Override
    protected void aboutToShowPanel() {
        this.loadLabelPanel();
        this.setTreeNodeSelected();
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        if (sWWelcomePage.isEditSampleSelected()) {
            this.loadStateFromPlanFile();
        }
        ((SelectASampleWizardDlg)this.mWizardDialog).pushPageInStack(this);
    }

    void loadStateFromPlanFile() {
        if (this.mIsFirstVisit) {
            Object object;
            if (((SelectASampleWizardDlg)this.mWizardDialog).getNumStages() == 3L && !((SelectASampleWizardDlg)this.mWizardDialog).isStage3RemovedViaEdit()) {
                this.mSpecification = ((SelectASampleWizardDlg)this.mWizardDialog).getSpecification();
                object = this.mSpecification.getStage(3L);
                this.mPopulationSizeCheckBox.setSelected(((StageInformation)object).getPopulationSize().length() > 0);
                this.mSampleSizeCheckBox.setSelected(((StageInformation)object).getSampleSize().length() > 0);
                this.mSampleProportionCheckBox.setSelected(((StageInformation)object).getRate().length() > 0);
                this.mSampleWeightCheckBox.setSelected(((StageInformation)object).getWeight().length() > 0);
            }
            if (!((SWWelcomePage)(object = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID"))).isEditSampleSelected()) {
                ((SelectASampleWizardDlg)this.mWizardDialog).setStateChanged(false);
            }
            this.mIsFirstVisit = false;
        }
    }

    boolean isPopSizeSelected() {
        return this.mPopulationSizeCheckBox.isSelected();
    }

    boolean isSampleProportionSelected() {
        return this.mSampleProportionCheckBox.isSelected();
    }

    boolean isSampleSizeSelected() {
        return this.mSampleSizeCheckBox.isSelected();
    }

    boolean isSampleWeightSelected() {
        return this.mSampleWeightCheckBox.isSelected();
    }

    private void loadLabelPanel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ");
        stringBuilder.append(this.mWizardDialog.getResString(STAGE3_OUTPUT_VAR_PAGE_TITLE_LABEL));
        stringBuilder.append("\n\n");
        stringBuilder.append(this.mWizardDialog.getResString(OUTPUT_VAR_PAGE_FIRST_LABEL));
        stringBuilder.append("\n ");
        ((JTextArea)SelectASampleWizardDlg.sLabelPanel.getComponent(0)).setText(stringBuilder.toString());
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        SWMenuTreeNode sWMenuTreeNode = ((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        sWMenuTreeNode.setIsVisited(true);
        TreePath treePath = new TreePath(sWMenuTreeNode.getPath());
        this.mMenuTree.setSelectionPath(treePath);
        this.mMenuTree.scrollPathToVisible(treePath);
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    private void addComponentsToOutputVarsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(30, 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mQuestionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPopulationSizeCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(20, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSampleProportionCheckBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSampleSizeCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(20, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSampleWeightCheckBox, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel2 = this.setupInclusionDupPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
    }

    private JPanel setupInclusionDupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(30, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(30, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mInclusionLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDuplicationLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mQuestionLabel = new JLabel(this.mWizardDialog.getResString(OUTPUT_VAR_QUESTION_LABEL));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, POPULATION_SIZE);
        this.mPopulationSizeCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAMPLE_SIZE);
        this.mSampleSizeCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAMPLE_PROPORTION);
        this.mSampleProportionCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAMPLE_WEIGHT);
        this.mSampleWeightCheckBox = new JCheckBox(toggleButtonAction);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, IMAGE_URL));
        this.mImageLabel = new JLabel(new ImageIcon(uRL));
        this.mInclusionLabel = new JTextArea(this.mWizardDialog.getResString(INCLUSION_LABEL));
        this.mInclusionLabel.setLineWrap(true);
        this.mInclusionLabel.setWrapStyleWord(true);
        this.mInclusionLabel.setBorder(null);
        this.mInclusionLabel.setOpaque(false);
        this.mInclusionLabel.setFocusable(false);
        this.mDuplicationLabel = new JTextArea(this.mWizardDialog.getResString(DUPLICATION_LABEL));
        this.mDuplicationLabel.setLineWrap(true);
        this.mDuplicationLabel.setWrapStyleWord(true);
        this.mDuplicationLabel.setBorder(null);
        this.mDuplicationLabel.setOpaque(false);
        this.mDuplicationLabel.setFocusable(false);
    }

    private void addListeners() {
        this.mPopulationSizeCheckBox.addItemListener(this);
        this.mSampleProportionCheckBox.addItemListener(this);
        this.mSampleSizeCheckBox.addItemListener(this);
        this.mSampleWeightCheckBox.addItemListener(this);
    }
}

