/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWCustomTree;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWCustomTreeCellRenderer;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWMenuTreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class SWSelectionOptionsPage
extends AbstractWizardPage
implements ItemListener,
DocumentListener {
    static final String SW_SELECTION_OPTIONS_PAGE_ID = "SW_SELECTION_OPTIONS_PAGE_ID";
    private static final String SAMPLING_WIZARD_TITLE = "IDS_SW_SELECT_A_SAMPLE_WIZARD";
    private static final String SW_SELECTION_OPTIONS_PAGE_HELP_ID = "idh_idd_samp_wiz_draw_options";
    private static final String SELECTION_OPTIONS_PAGE_TITLE_LABEL = "IDS_SW_SELECTION_OPTIONS_PAGE_TITLE_LABEL";
    private static final String SELECTION_OPTIONS_PAGE_FIRST_LABEL = "IDS_SW_SELECTION_OPTIONS_PAGE_FIRST_LABEL";
    private static final String SELECTION_OPTIONS_PAGE_FIRST_LABEL_DRAW_SAMPLE = "IDS_SW_SELECTION_OPTIONS_PAGE_FIRST_LABEL_DRAW_SAMPLE";
    private static final String DRAW_SAMPLE_QUESTION_LABEL = "IDS_SW_DRAW_SAMPLE_QUESTION_LABEL";
    private static final String WHICH_STAGES_SAMPLE_QUESTION_LABEL = "IDS_SW_WHICH_STAGES_SAMPLE_QUESTION_LABEL";
    private static final String YES = "IDS_SW_YES";
    private static final String NO = "IDS_SW_NO";
    private static final String STAGES_LABEL = "IDS_SW_STAGES_LABEL";
    private static final String SEED_VALUE_QUESTION_LABEL = "IDS_SW_SEED_VALUE_QUESTION_LABEL";
    private static final String RANDOMLY_CHOSEN_NUM = "IDS_SW_RANDOMLY_CHOSEN_NUM";
    private static final String CUSTOM_VALUE = "IDS_SW_CUSTOM_VALUE";
    private static final String CUSTOM_SEED_VALUE_LABEL = "IDS_SW_CUSTOM_SEED_VALUE_LABEL";
    public static final String ONE_STAGE = " (1)";
    public static final String TWO_STAGE = " (1,2)";
    public static final String THREE_STAGE = " (1,2,3)";
    private static final String OUTPUT_FILES_NODE = "IDS_SW_OUTPUT_FILES_NODE";
    private static final String SEED_VALUE_CANNOT_BE_ZERO = "ERR_SW_SEED_VALUE_CANNOT_BE_ZERO";
    private JLabel mDrawSampleQuestionLabel;
    private JRadioButton mYesRadio;
    private JRadioButton mNoRadio;
    private JLabel mStagesLabel;
    private JComboBox mStagesComboBox;
    private DefaultComboBoxModel mStagesComboModel;
    private JLabel mSeedValueQuestionLabel;
    private JRadioButton mRandomlyChosenRadio;
    private JRadioButton mCustomValueRadio;
    private IntTextField mCustomValueTextField;
    private JTextArea mCustomSeedValueLabel;
    private JCheckBox mIncludeCheckBox;
    private JCheckBox mSortCheckBox;
    private Specification mSpecification;
    private SWCustomTree mMenuTree;
    private boolean mIsFirstVisit = false;
    private boolean mLoadComboFirst = false;

    SWSelectionOptionsPage(BaseWizardDialog baseWizardDialog, SWCustomTree sWCustomTree) {
        super(SW_SELECTION_OPTIONS_PAGE_ID, baseWizardDialog.getResString(SAMPLING_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = sWCustomTree;
        this.mIsFirstVisit = true;
        this.mLoadComboFirst = true;
    }

    @Override
    public String getDialogHelpID() {
        return SW_SELECTION_OPTIONS_PAGE_HELP_ID;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mWizardDialog.enableNext(this.mCustomValueTextField.getText().length() > 0);
        ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, this.mCustomValueTextField.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mWizardDialog.enableNext(this.mCustomValueTextField.getText().length() > 0);
        ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, this.mCustomValueTextField.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Vector<SWMenuTreeNode> vector;
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemEvent.getSource().equals(this.mYesRadio) && bl) {
            this.setEnabled(this.mYesRadio.isSelected());
            this.addOutputFilesNode();
            if (this.mMenuTree != null) {
                vector = ((SWCustomTreeCellRenderer)this.mMenuTree.getCellRenderer()).getNodesToDisableVector();
                vector.removeAllElements();
                vector.add(((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap("SW_COMPLETION_PAGE_ID"));
                ((SWCustomTreeCellRenderer)this.mMenuTree.getCellRenderer()).setNodesToDisableVector(vector);
            }
            if (this.mRandomlyChosenRadio.isSelected() || this.mCustomValueRadio.isSelected() && this.mCustomValueTextField.getText().length() > 0) {
                ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, true);
            } else {
                ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, false);
            }
        }
        if (itemEvent.getSource().equals(this.mNoRadio) && bl) {
            this.setEnabled(this.mYesRadio.isSelected());
            this.removeOutputFilesNode();
            if (this.mMenuTree != null && (vector = ((SWCustomTreeCellRenderer)this.mMenuTree.getCellRenderer()).getNodesToDisableVector()).remove(((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap("SW_COMPLETION_PAGE_ID"))) {
                ((SWCustomTreeCellRenderer)this.mMenuTree.getCellRenderer()).setNodesToDisableVector(vector);
            }
            this.mWizardDialog.enableNext(true);
            this.mWizardDialog.enableFinish(true);
            ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, true);
        }
        if (itemEvent.getSource().equals(this.mRandomlyChosenRadio) && bl) {
            this.mCustomValueTextField.setEnabled(false);
            this.mCustomValueTextField.setOpaque(false);
            this.mWizardDialog.enableNext(true);
            this.mWizardDialog.enableFinish(true);
            ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, true);
        }
        if (itemEvent.getSource().equals(this.mCustomValueRadio) && bl) {
            this.mCustomValueTextField.setEnabled(true);
            this.mCustomValueTextField.setOpaque(true);
            this.mWizardDialog.enableNext(this.mCustomValueTextField.getText().length() > 0);
            this.mWizardDialog.enableFinish(this.mCustomValueTextField.getText().length() > 0);
            ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(4, this.mCustomValueTextField.getText().length() > 0);
        }
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToSelectionOptionsPanel();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getNextPage() {
        if (this.mYesRadio.isSelected()) {
            return "SW_OUTPUT_FILES_PAGE_ID";
        }
        return "SW_COMPLETION_PAGE_ID";
    }

    @Override
    public boolean validate() {
        if (this.mCustomValueRadio.isEnabled() && this.mCustomValueRadio.isSelected() && this.mCustomValueTextField.getText().length() > 0 && this.isTextZero(this.mCustomValueTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString(SEED_VALUE_CANNOT_BE_ZERO), VersionInfo.getAppVersionString());
            this.mCustomValueTextField.selectAll();
            this.mCustomValueTextField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.loadLabelPanel();
        this.setTreeNodeSelected();
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        if (sWWelcomePage.isDrawSampleSelected()) {
            this.loadStateFromPlanFile();
            this.mDrawSampleQuestionLabel.setText(this.mWizardDialog.getResString(WHICH_STAGES_SAMPLE_QUESTION_LABEL));
            this.mYesRadio.setVisible(false);
            this.mNoRadio.setVisible(false);
            this.mWizardDialog.enableFinish(true);
        } else if (sWWelcomePage.isDesignSampleSelected()) {
            this.loadComboBoxValues();
        } else if (sWWelcomePage.isEditSampleSelected()) {
            this.loadStateFromPlanFile();
            if (this.getStageCount() == 1) {
                if (((SelectASampleWizardDlg)this.mWizardDialog).isStage1Sampled()) {
                    this.mYesRadio.setEnabled(false);
                    this.mNoRadio.setSelected(true);
                } else {
                    this.mYesRadio.setEnabled(true);
                }
            }
        }
        ((SelectASampleWizardDlg)this.mWizardDialog).pushPageInStack(this);
    }

    JComboBox getSampledStagesComboBox() {
        return this.mStagesComboBox;
    }

    boolean isYesRadioSelected() {
        return this.mYesRadio.isSelected();
    }

    boolean isRandomRadioSelected() {
        return this.mRandomlyChosenRadio.isSelected();
    }

    String getCustomSeedValue() {
        return this.mCustomValueTextField.getText();
    }

    boolean isIncludeCheckBoxSelected() {
        return this.mIncludeCheckBox.isSelected();
    }

    boolean isSortCheckBoxSelected() {
        return this.mSortCheckBox.isSelected();
    }

    void setFirstVisitTrue() {
        this.mIsFirstVisit = true;
    }

    private void loadStateFromPlanFile() {
        this.mSpecification = ((SelectASampleWizardDlg)this.mWizardDialog).getSpecification();
        String[] stringArray = null;
        int n = this.getStageCount();
        if (n == 3) {
            if (((SelectASampleWizardDlg)this.mWizardDialog).isStage1Sampled() && ((SelectASampleWizardDlg)this.mWizardDialog).isStage2Sampled()) {
                if (this.mIsFirstVisit) {
                    stringArray = new String[]{"3"};
                }
            } else if (((SelectASampleWizardDlg)this.mWizardDialog).isStage1Sampled()) {
                if (this.mIsFirstVisit) {
                    stringArray = new String[]{"2,3", "2"};
                }
            } else if (this.mIsFirstVisit) {
                stringArray = new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + THREE_STAGE, "1,2", "1"};
            }
        } else if (n == 2) {
            if (((SelectASampleWizardDlg)this.mWizardDialog).isStage1Sampled()) {
                if (this.mIsFirstVisit) {
                    stringArray = new String[]{"2"};
                }
            } else if (this.mIsFirstVisit) {
                stringArray = new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + TWO_STAGE, "1"};
            }
        } else if (this.mIsFirstVisit) {
            stringArray = new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + ONE_STAGE};
        }
        if (this.mIsFirstVisit) {
            this.mStagesComboModel = new DefaultComboBoxModel<String>(stringArray);
            this.mStagesComboBox.setModel(this.mStagesComboModel);
            this.mIsFirstVisit = false;
        }
    }

    private int getStageCount() {
        int n = 1;
        if (((SelectASampleWizardDlg)this.mWizardDialog).isStage3Added()) {
            n = 3;
        } else if (((SelectASampleWizardDlg)this.mWizardDialog).isStage2Added()) {
            n = 2;
        }
        return n;
    }

    private void setEnabled(boolean bl) {
        this.mStagesComboBox.setEnabled(bl);
        this.mSeedValueQuestionLabel.setEnabled(bl);
        this.mRandomlyChosenRadio.setEnabled(bl);
        this.mCustomValueRadio.setEnabled(bl);
        if (bl) {
            this.mCustomValueTextField.setEnabled(this.mCustomValueRadio.isSelected());
            this.mCustomValueTextField.setOpaque(this.mCustomValueRadio.isSelected());
            DialogUtil.enableHTMLComponent(this.mCustomSeedValueLabel, bl);
            DialogUtil.enableHTMLComponent(this.mIncludeCheckBox, bl);
            DialogUtil.enableHTMLComponent(this.mSortCheckBox, bl);
        } else {
            this.mCustomValueTextField.setEnabled(false);
            this.mCustomValueTextField.setOpaque(false);
            DialogUtil.enableHTMLComponent(this.mCustomSeedValueLabel, bl);
            DialogUtil.enableHTMLComponent(this.mIncludeCheckBox, bl);
            DialogUtil.enableHTMLComponent(this.mSortCheckBox, bl);
        }
    }

    private void addOutputFilesNode() {
        if (this.mMenuTree != null) {
            SWMenuTreeNode sWMenuTreeNode = ((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
            SWMenuTreeNode sWMenuTreeNode2 = (SWMenuTreeNode)sWMenuTreeNode.getParent();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mMenuTree.getModel();
            SWMenuTreeNode sWMenuTreeNode3 = new SWMenuTreeNode(this.mWizardDialog.getResString(OUTPUT_FILES_NODE), "SW_OUTPUT_FILES_PAGE_ID", 4);
            ((SelectASampleWizardDlg)this.mWizardDialog).putInPageNodeMap("SW_OUTPUT_FILES_PAGE_ID", sWMenuTreeNode3);
            defaultTreeModel.insertNodeInto(sWMenuTreeNode3, sWMenuTreeNode2, 1);
        }
    }

    private void removeOutputFilesNode() {
        SWMenuTreeNode sWMenuTreeNode = ((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        SWMenuTreeNode sWMenuTreeNode2 = (SWMenuTreeNode)sWMenuTreeNode.getParent();
        SWMenuTreeNode sWMenuTreeNode3 = (SWMenuTreeNode)sWMenuTreeNode2.getChildAt(1);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mMenuTree.getModel();
        defaultTreeModel.removeNodeFromParent(sWMenuTreeNode3);
    }

    private boolean isTextZero(String string) {
        Integer n = new Integer(string);
        return 0 == n;
    }

    private void loadLabelPanel() {
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mWizardDialog.getResString(SELECTION_OPTIONS_PAGE_TITLE_LABEL));
        stringBuilder.append("\n\n");
        if (sWWelcomePage.isDrawSampleSelected()) {
            stringBuilder.append(this.mWizardDialog.getResString(SELECTION_OPTIONS_PAGE_FIRST_LABEL_DRAW_SAMPLE));
            stringBuilder.append("\n ");
        } else {
            stringBuilder.append(this.mWizardDialog.getResString(SELECTION_OPTIONS_PAGE_FIRST_LABEL));
            stringBuilder.append("\n ");
        }
        ((JTextArea)SelectASampleWizardDlg.sLabelPanel.getComponent(0)).setText(stringBuilder.toString());
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        SWMenuTreeNode sWMenuTreeNode = ((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        sWMenuTreeNode.setIsVisited(true);
        TreePath treePath = new TreePath(sWMenuTreeNode.getPath());
        this.mMenuTree.setSelectionPath(treePath);
        this.mMenuTree.scrollPathToVisible(treePath);
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    private void loadComboBoxValues() {
        String string;
        String[] stringArray;
        boolean bl = ((SelectASampleWizardDlg)this.mWizardDialog).isStage2Added();
        boolean bl2 = ((SelectASampleWizardDlg)this.mWizardDialog).isStage3Added();
        if (this.mLoadComboFirst) {
            stringArray = bl2 ? new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + THREE_STAGE, "1,2", "1"} : (bl ? new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + TWO_STAGE, "1"} : new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + ONE_STAGE});
            this.mLoadComboFirst = false;
            string = stringArray[0];
        } else {
            string = (String)this.mStagesComboBox.getSelectedItem();
            stringArray = bl2 ? new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + THREE_STAGE, "1,2", "1"} : (bl ? new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + TWO_STAGE, "1"} : new String[]{this.mWizardDialog.getResString("IDS_SW_ALL") + ONE_STAGE});
        }
        this.mStagesComboModel = new DefaultComboBoxModel<String>(stringArray);
        this.mStagesComboBox.setModel(this.mStagesComboModel);
        this.mStagesComboBox.setSelectedItem(string);
    }

    private void addComponentsToSelectionOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(20, 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDrawSampleQuestionLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mYesRadio, this.mNoRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        DialogUtil.createButtonGroup(jPanel2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, 50, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel3 = this.setupStagesPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, 25, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSeedValueQuestionLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel4 = this.setupCustomValuePanel();
        DialogUtil.createButtonGroup(jPanel4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 50, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1, n, insets);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        DialogUtil.applyTopBorder(jPanel5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 3, 35, 0, 30);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 5, 2, 1, n, insets);
        JPanel jPanel6 = this.setupCheckBoxPanel();
        DialogUtil.createButtonGroup(jPanel6);
        DialogUtil.normalizeLabelWidths(jPanel6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 50, DialogUtil.getGroupBoxInnerMargin() * 3, 30);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 6, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private JPanel setupStagesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(5, DialogUtil.getGroupBoxInnerMargin() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStagesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(5, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStagesComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCustomValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRandomlyChosenRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCustomValueRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(5, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCustomValueTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCustomSeedValueLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mSortCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mDrawSampleQuestionLabel = new JLabel(this.mWizardDialog.getResString(DRAW_SAMPLE_QUESTION_LABEL));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, YES);
        this.mYesRadio = new JRadioButton(toggleButtonAction);
        this.mYesRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, NO);
        this.mNoRadio = new JRadioButton(toggleButtonAction);
        this.mNoRadio.addItemListener(this);
        this.mStagesComboBox = new JComboBox();
        this.mStagesLabel = DialogUtil.createLabel(this.mWizardDialog, STAGES_LABEL);
        this.mStagesLabel.setLabelFor(this.mStagesComboBox);
        this.mSeedValueQuestionLabel = new JLabel(this.mWizardDialog.getResString(SEED_VALUE_QUESTION_LABEL));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, RANDOMLY_CHOSEN_NUM);
        this.mRandomlyChosenRadio = new JRadioButton(toggleButtonAction);
        this.mRandomlyChosenRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, CUSTOM_VALUE);
        this.mCustomValueRadio = new JRadioButton(toggleButtonAction);
        this.mCustomValueRadio.addItemListener(this);
        this.mCustomValueTextField = new IntTextField(true);
        this.mCustomValueTextField.getDocument().addDocumentListener(this);
        this.mCustomSeedValueLabel = new JTextArea(this.mWizardDialog.getResString(CUSTOM_SEED_VALUE_LABEL));
        this.mCustomSeedValueLabel.setLineWrap(true);
        this.mCustomSeedValueLabel.setWrapStyleWord(true);
        this.mCustomSeedValueLabel.setBorder(null);
        this.mCustomSeedValueLabel.setOpaque(false);
        this.mCustomSeedValueLabel.setFocusable(false);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SW_INCLUDE");
        this.mIncludeCheckBox = new SpssMultiLineCheckBox(toggleButtonAction, 400);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SW_WORKING");
        this.mSortCheckBox = new SpssMultiLineCheckBox(toggleButtonAction, 400);
    }

    private void setDefaults() {
        this.mYesRadio.setSelected(true);
        this.mRandomlyChosenRadio.setSelected(true);
        this.mCustomValueTextField.setEnabled(false);
        this.mCustomValueTextField.setOpaque(false);
    }
}

