/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWMenuTreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SWCustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String STAGE_ONE_NODE = "IDS_SW_STAGE_ONE_NODE";
    private static final String STAGE_TWO_NODE = "IDS_SW_STAGE_TWO_NODE";
    private static final String STAGE_THREE_NODE = "IDS_SW_STAGE_THREE_NODE";
    private static final String ADD_STAGE_TWO_NODE = "IDS_SW_ADD_STAGE_TWO_NODE";
    private static final String ADD_STAGE_THREE_NODE = "IDS_SW_ADD_STAGE_THREE_NODE";
    private static final String DRAW_SAMPLE_NODE = "IDS_SW_DRAW_SAMPLE_NODE";
    private Icon mSelectedNodeIcon;
    private Icon mVisitedNodeIcon;
    private Icon mEmptyIcon;
    private Icon mIncompleteStageIcon;
    private Icon mLockedIcon;
    private Color mBgSelectionColor;
    private Color mBorderSelectionColor;
    private SelectASampleWizardDlg mSampleWizardDlg;
    private Vector<SWMenuTreeNode> mNodesToDisable = new Vector();

    public SWCustomTreeCellRenderer(SelectASampleWizardDlg selectASampleWizardDlg, Icon icon, Icon icon2, Icon icon3, Icon icon4, Icon icon5) {
        this.mSampleWizardDlg = selectASampleWizardDlg;
        this.mSelectedNodeIcon = icon2;
        this.mVisitedNodeIcon = icon;
        this.mEmptyIcon = icon3;
        this.mIncompleteStageIcon = icon4;
        this.mLockedIcon = icon5;
        this.mBgSelectionColor = this.getBackgroundSelectionColor();
        this.mBorderSelectionColor = this.getBorderSelectionColor();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            SWMenuTreeNode sWMenuTreeNode = (SWMenuTreeNode)object;
            String string = sWMenuTreeNode.getMenuName();
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTreeCellRendererComponent(jTree, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, bl3, n, bl4);
            } else {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            if (this.mNodesToDisable.contains(sWMenuTreeNode)) {
                this.setEnabled(false);
                if (sWMenuTreeNode.isStageComplete()) {
                    this.setDisabledIcon(this.mEmptyIcon);
                } else {
                    this.setDisabledIcon(this.mIncompleteStageIcon);
                }
                if (bl) {
                    this.setBackgroundSelectionColor(Color.WHITE);
                    this.setBorderSelectionColor(Color.WHITE);
                }
            } else {
                this.setBackgroundSelectionColor(this.mBgSelectionColor);
                this.setBorderSelectionColor(this.mBorderSelectionColor);
                this.setNodeIcon(sWMenuTreeNode, string);
            }
        }
        return this;
    }

    Vector<SWMenuTreeNode> getNodesToDisableVector() {
        return this.mNodesToDisable;
    }

    void setNodesToDisableVector(Vector<SWMenuTreeNode> vector) {
        this.mNodesToDisable = vector;
    }

    private void setNodeIcon(SWMenuTreeNode sWMenuTreeNode, String string) {
        if (string.contains(this.mSampleWizardDlg.getResString(STAGE_ONE_NODE)) || string.contains(this.mSampleWizardDlg.getResString(STAGE_TWO_NODE)) || string.contains(this.mSampleWizardDlg.getResString(STAGE_THREE_NODE)) || string.equals(this.mSampleWizardDlg.getResString(ADD_STAGE_TWO_NODE)) || string.equals(this.mSampleWizardDlg.getResString(ADD_STAGE_THREE_NODE))) {
            if (sWMenuTreeNode.isStageLocked()) {
                this.setIcon(this.mLockedIcon);
            } else if (sWMenuTreeNode.isStageComplete()) {
                this.setIcon(this.mEmptyIcon);
            } else {
                this.setIcon(this.mIncompleteStageIcon);
            }
        } else if (string.equals(this.mSampleWizardDlg.getResString(DRAW_SAMPLE_NODE))) {
            if (sWMenuTreeNode.isStageComplete()) {
                this.setIcon(this.mEmptyIcon);
            } else {
                this.setIcon(this.mIncompleteStageIcon);
            }
        } else if (this.selected) {
            this.setIcon(this.mSelectedNodeIcon);
        } else if (sWMenuTreeNode.isVisited()) {
            if (sWMenuTreeNode.isStageComplete()) {
                this.setIcon(this.mVisitedNodeIcon);
            } else {
                this.setIcon(this.mIncompleteStageIcon);
            }
        } else if (sWMenuTreeNode.isStageComplete()) {
            this.setIcon(this.mEmptyIcon);
        } else {
            this.setIcon(this.mIncompleteStageIcon);
        }
    }
}

