/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.select_sample;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWCustomTree;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWMenuTreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SWWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.select_sample.SelectASampleWizardDlg;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

class SWCompletionPage
extends AbstractWizardPage
implements ItemListener,
DocumentListener {
    static final String SW_COMPLETION_PAGE_ID = "SW_COMPLETION_PAGE_ID";
    private static final String SAMPLING_WIZARD_TITLE = "IDS_SW_SELECT_A_SAMPLE_WIZARD";
    private static final String SW_COMPLETION_PAGE_HELP_ID = "idh_idd_samp_wiz_finish";
    private static final String COMPLETION_PAGE_TITLE_LABEL = "IDS_SW_COMPLETION_PAGE_TITLE_LABEL";
    private static final String COMPLETION_PAGE_FIRST_LABEL_DESIGN_SELECTED = "IDS_SW_COMPLETION_PAGE_FIRST_LABEL_DESIGN_SELECTED";
    private static final String COMPLETION_PAGE_FIRST_LABEL_EDIT_SELECTED = "IDS_SW_COMPLETION_PAGE_FIRST_LABEL_EDIT_SELECTED";
    private static final String COMPLETION_PAGE_FIRST_LABEL_DRAW_SELECTED = "IDS_SW_COMPLETION_PAGE_FIRST_LABEL_DRAW_SELECTED";
    private static final String COMPLETION_PAGE_SECOND_LABEL = "IDS_SW_COMPLETION_PAGE_SECOND_LABEL";
    private static final String COMPLETION_QUESTION_LABEL = "IDS_SW_COMPLETION_QUESTION_LABEL";
    private static final String SAVE_DESIGN = "IDS_SW_SAVE_DESIGN";
    private static final String PASTE_SYNTAX = "IDS_SW_PASTE_SYNTAX";
    private static final String DRAW_SAMPLE = "IDS_SW_DRAW_SAMPLE";
    private static final String STATE_CHANGE_LABEL = "IDS_SW_STATE_CHANGE_LABEL";
    private static final String NEW_PLAN_FILE = "IDS_SW_NEW_PLAN_FILE";
    private static final String EXISTING_PLAN_FILE = "IDS_SW_EXISTING_PLAN_FILE";
    private static final String FILE_LABEL = "IDS_SW_FILE_LABEL";
    private static final String NEW_FILE_BROWSE = "IDS_SW_NEW_FILE_BROWSE";
    private static final String FINISH_LABEL = "IDS_SW_FINISH_LABEL";
    private static final String FINISH_LABEL_MAC = "IDS_SW_FINISH_LABEL_MAC";
    private static final String SAVE_FILE_CHOOSER_TITLE = "IDS_SW_SAVE_FILE_CHOOSER_TITLE";
    private static final String PLAN_FILE_EXTENSION = "IDS_SW_PLAN_FILE_EXTENSION";
    private static final String PLAN_FILE_FILTER = "IDS_SW_PLAN_FILE_FILTER_DESC";
    private JLabel mQuestionLabel;
    private JRadioButton mSaveDesignRadio;
    private JRadioButton mPasteSyntaxRadio;
    private JLabel mFinishLabel;
    private JTextArea mStateChangeLabel;
    private JRadioButton mNewPlanFileRadio;
    private JRadioButton mExistingPlanFileRadio;
    private JLabel mNewPlanFileLabel;
    private FileTextField mNewPlanFileTextField;
    private JButton mNewPlanFileBrowseButton;
    private FileTextField mExistingFileNameTextField;
    private JPanel mStateChangePanel;
    private SWCustomTree mMenuTree;

    SWCompletionPage(BaseWizardDialog baseWizardDialog, SWCustomTree sWCustomTree) {
        super(SW_COMPLETION_PAGE_ID, baseWizardDialog.getResString(SAMPLING_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = sWCustomTree;
    }

    @Override
    public String getDialogHelpID() {
        return SW_COMPLETION_PAGE_HELP_ID;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, this.mNewPlanFileTextField.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, this.mNewPlanFileTextField.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mNewPlanFileRadio)) {
            if (this.mNewPlanFileRadio.isSelected()) {
                this.mNewPlanFileLabel.setEnabled(true);
                this.mNewPlanFileTextField.setEnabled(true);
                this.mNewPlanFileTextField.setOpaque(true);
                this.mNewPlanFileBrowseButton.setEnabled(true);
                ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, this.mNewPlanFileTextField.getText().length() > 0);
            }
        } else if (itemEvent.getSource().equals(this.mExistingPlanFileRadio) && this.mExistingPlanFileRadio.isSelected()) {
            this.mNewPlanFileLabel.setEnabled(false);
            this.mNewPlanFileTextField.setEnabled(false);
            this.mNewPlanFileTextField.setOpaque(false);
            this.mNewPlanFileBrowseButton.setEnabled(false);
            ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, true);
        }
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToCompletionPanel();
        this.mStateChangePanel.setVisible(false);
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean validate() {
        if (this.mNewPlanFileRadio.isSelected() && !FileValidator.validatePath((Component)((Object)this.mWizardDialog), this.mNewPlanFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
            this.mNewPlanFileTextField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.loadLabelPanel();
        this.setTreeNodeSelected();
        this.updateSaveRadio();
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        if (sWWelcomePage.isDesignSampleSelected()) {
            this.mStateChangePanel.setVisible(false);
        } else if (sWWelcomePage.isEditSampleSelected() && ((SelectASampleWizardDlg)this.mWizardDialog).hasStateChanged()) {
            this.mStateChangePanel.setVisible(true);
            if (this.mNewPlanFileRadio.isSelected()) {
                ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, this.mNewPlanFileTextField.getText().length() > 0);
            } else {
                ((SelectASampleWizardDlg)this.mWizardDialog).markStageComplete(5, true);
            }
        } else {
            this.mStateChangePanel.setVisible(false);
        }
        this.mExistingFileNameTextField.setText("(" + sWWelcomePage.getEditSampleFileName() + ")");
        ((SelectASampleWizardDlg)this.mWizardDialog).pushPageInStack(this);
    }

    boolean isPasteRadioSelected() {
        return this.mPasteSyntaxRadio.isSelected();
    }

    boolean isNewPlanFileRadioSelected() {
        return this.mNewPlanFileRadio.isSelected();
    }

    String getNewPlanFileName() {
        return this.mNewPlanFileTextField.getText();
    }

    private void loadLabelPanel() {
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mWizardDialog.getResString(COMPLETION_PAGE_TITLE_LABEL));
        stringBuilder.append("\n\n");
        if (sWWelcomePage.isDesignSampleSelected()) {
            stringBuilder.append(this.mWizardDialog.getResString(COMPLETION_PAGE_FIRST_LABEL_DESIGN_SELECTED));
            stringBuilder.append("\n");
        } else if (sWWelcomePage.isEditSampleSelected()) {
            stringBuilder.append(this.mWizardDialog.getResString(COMPLETION_PAGE_FIRST_LABEL_EDIT_SELECTED));
            stringBuilder.append("\n");
        } else {
            stringBuilder.append(this.mWizardDialog.getResString(COMPLETION_PAGE_FIRST_LABEL_DRAW_SELECTED));
            stringBuilder.append("\n");
        }
        stringBuilder.append(this.mWizardDialog.getResString(COMPLETION_PAGE_SECOND_LABEL));
        ((JTextArea)SelectASampleWizardDlg.sLabelPanel.getComponent(0)).setText(stringBuilder.toString());
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        SWMenuTreeNode sWMenuTreeNode = ((SelectASampleWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        sWMenuTreeNode.setIsVisited(true);
        TreePath treePath = new TreePath(sWMenuTreeNode.getPath());
        this.mMenuTree.setSelectionPath(treePath);
        this.mMenuTree.scrollPathToVisible(treePath);
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    private void updateSaveRadio() {
        SWWelcomePage sWWelcomePage = (SWWelcomePage)((SelectASampleWizardDlg)this.mWizardDialog).getWizardModel().getPage("SAMPLING_WIZARD_WELCOME_PAGE_ID");
        if (sWWelcomePage.isDrawSampleSelected()) {
            this.mSaveDesignRadio.setText(this.mWizardDialog.getResString(DRAW_SAMPLE));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mSaveDesignRadio.setMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_SW_SAVE_DESIGN_FOR_DRAW_SAMPLE_KEY"));
            }
        }
    }

    private void addComponentsToCompletionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(30, 60, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mQuestionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mSaveDesignRadio, this.mPasteSyntaxRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        DialogUtil.createButtonGroup(jPanel2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(10, 55, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mStateChangePanel = this.setupStateChangePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(30, 60, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStateChangePanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        n = 20;
        insets.set(DialogUtil.getComponentGroupGap(), 60, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFinishLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private JPanel setupStateChangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mStateChangeLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNewPlanFileRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel2 = this.setupNewFilePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 40, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mExistingPlanFileRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap() + 5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mExistingFileNameTextField), gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupNewFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNewPlanFileLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewPlanFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNewPlanFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mQuestionLabel = new JLabel(this.mWizardDialog.getResString(COMPLETION_QUESTION_LABEL));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAVE_DESIGN);
        this.mSaveDesignRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, PASTE_SYNTAX);
        this.mPasteSyntaxRadio = new JRadioButton(toggleButtonAction);
        this.mStateChangeLabel = new JTextArea(this.mWizardDialog.getResString(STATE_CHANGE_LABEL));
        this.mStateChangeLabel.setLineWrap(true);
        this.mStateChangeLabel.setWrapStyleWord(true);
        this.mStateChangeLabel.setBorder(null);
        this.mStateChangeLabel.setOpaque(false);
        this.mStateChangeLabel.setFocusable(false);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, NEW_PLAN_FILE);
        this.mNewPlanFileRadio = new JRadioButton(toggleButtonAction);
        this.mNewPlanFileRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, EXISTING_PLAN_FILE);
        this.mExistingPlanFileRadio = new JRadioButton(toggleButtonAction);
        this.mExistingPlanFileRadio.addItemListener(this);
        this.mNewPlanFileLabel = DialogUtil.createLabel(this.mWizardDialog, FILE_LABEL);
        this.mNewPlanFileTextField = new FileTextField();
        this.mNewPlanFileTextField.setColumns(12);
        this.mNewPlanFileTextField.setFocusable(true);
        this.mNewPlanFileTextField.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, NEW_FILE_BROWSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                remoteFileChooser.setDialogTitle(SWCompletionPage.this.mWizardDialog.getResString(SWCompletionPage.SAVE_FILE_CHOOSER_TITLE));
                RefFileFilter refFileFilter = new RefFileFilter(SWCompletionPage.this.mWizardDialog.getResString(SWCompletionPage.PLAN_FILE_FILTER), SWCompletionPage.this.mWizardDialog.getResString(SWCompletionPage.PLAN_FILE_EXTENSION));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)SWCompletionPage.this.mWizardDialog));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(SWCompletionPage.this.mWizardDialog.getResString(SWCompletionPage.PLAN_FILE_EXTENSION))) {
                        string = string + SWCompletionPage.this.mWizardDialog.getResString(SWCompletionPage.PLAN_FILE_EXTENSION);
                    }
                    SWCompletionPage.this.mNewPlanFileTextField.setText(string);
                }
            }
        };
        this.mNewPlanFileBrowseButton = new JButton(toggleButtonAction);
        this.mExistingFileNameTextField = new FileTextField();
        String string = FINISH_LABEL;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = FINISH_LABEL_MAC;
        }
        this.mFinishLabel = new JLabel(this.mWizardDialog.getResString(string));
    }

    private void setDefaults() {
        this.mSaveDesignRadio.setSelected(true);
        this.mNewPlanFileRadio.setSelected(true);
        this.mExistingFileNameTextField.setBorder(null);
        this.mExistingFileNameTextField.setOpaque(false);
        this.mExistingFileNameTextField.setEditable(false);
    }
}

