/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ratios;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CompSamplesRatiosStat
extends BaseSubDialog
implements ItemListener,
FocusListener,
DocumentListener {
    static final String STANDARD_ERROR_CHECK = "IDS_CS_RATIOS_STAT_STD_ERROR_CHECK";
    static final String CONFIDENCE_INTERVAL_CHECK = "IDS_CS_RATIOS_STAT_CONF_INT_CHECK";
    static final String COEFFICIENT_OF_VAR_CHECK = "IDS_CS_RATIOS_STAT_COEFF_OF_VAR_CHECK";
    static final String UNWEIGHTED_COUNT_CHECK = "IDS_CS_RATIOS_STAT_UNWT_COUNT_CHECK";
    static final String POPULATION_SIZE_CHECK = "IDS_CS_RATIOS_STAT_POPLN_SIZE_CHECK";
    static final String DESIGN_EFFECT_CHECK = "IDS_CS_RATIOS_STAT_DESIGN_EFFECT_CHECK";
    static final String SQUARE_ROOT_OF_DESIGN_EFFECT_CHECK = "IDS_CS_RATIOS_STAT_SQRT_DESIGN_EFFECT_CHECK";
    static final String TTEST_CHECK = "IDS_CS_RATIOS_STAT_TTEST_CHECK";
    static final String LEVEL_PER_TEXT = "IDS_LEVEL_PER_TEXT";
    static final String TEST_VALUE_TEXT = "IDS_TEST_VALUE_TEXT";
    private static final String DEFAULT_LEVEL_VALUE = "95";
    private JCheckBox mStdErrorCheck;
    private JCheckBox mConfIntervalCheck;
    private JCheckBox mCoeffOfVarCheck;
    private JCheckBox mUnweightedCountCheck;
    private JCheckBox mPoplnSizeCheck;
    private JCheckBox mDesignEffCheck;
    private JCheckBox mSqRtDesignEffCheck;
    private JCheckBox mTtestCheck;
    private JLabel mLevelPerLabel;
    private JLabel mTestValLabel;
    private JTextField mLevelPerText;
    private JTextField mTestValText;
    private JPanel mStatPanel;

    public CompSamplesRatiosStat(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CS_RATIOS_STAT_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_ratio_stat";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mConfIntervalCheck) {
            if (this.mConfIntervalCheck.isSelected()) {
                this.enableConfInterval(true);
            } else {
                this.enableConfInterval(false);
            }
        } else if (object == this.mTtestCheck) {
            if (this.mTtestCheck.isSelected()) {
                this.enableTestVal(true);
            } else {
                this.enableTestVal(false);
            }
        }
        this.setContinueEnabled();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public boolean continuePressed() {
        if (!this.recursiveCheckBoxSelection(this.mStatPanel)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_RATIOS_STAT_CHECKBOX_SELECTION_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, STANDARD_ERROR_CHECK);
        this.mStdErrorCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CONFIDENCE_INTERVAL_CHECK);
        this.mConfIntervalCheck = new JCheckBox(toggleButtonAction);
        this.mConfIntervalCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, COEFFICIENT_OF_VAR_CHECK);
        this.mCoeffOfVarCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, UNWEIGHTED_COUNT_CHECK);
        this.mUnweightedCountCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, POPULATION_SIZE_CHECK);
        this.mPoplnSizeCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, DESIGN_EFFECT_CHECK);
        this.mDesignEffCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, SQUARE_ROOT_OF_DESIGN_EFFECT_CHECK);
        this.mSqRtDesignEffCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, TTEST_CHECK);
        this.mTtestCheck = new JCheckBox(toggleButtonAction);
        this.mTtestCheck.addItemListener(this);
        this.mLevelPerLabel = DialogUtil.createLabel(this, "IDS_CS_RATIOS_STAT_LEVEL_LABEL");
        this.mLevelPerText = new FloatTextField(0.0, 100.0, -1, true);
        ((FloatTextField)this.mLevelPerText).setIncludeMaxRange(false);
        ((FloatTextField)this.mLevelPerText).setIncludeMinRange(false);
        this.mLevelPerText.setAction(new TextFieldAction(this, LEVEL_PER_TEXT));
        this.mLevelPerLabel.setLabelFor(this.mLevelPerText);
        this.mLevelPerText.addFocusListener(this);
        this.mLevelPerText.getDocument().addDocumentListener(this);
        this.mTestValLabel = DialogUtil.createLabel(this, "IDS_CS_RATIOS_STAT_TEST_VAL_LABEL");
        this.mTestValText = new FloatTextField(false);
        this.mTestValText.setAction(new TextFieldAction(this, TEST_VALUE_TEXT));
        this.mTestValLabel.setLabelFor(this.mTestValText);
        this.mTestValText.addFocusListener(this);
        this.mTestValText.getDocument().addDocumentListener(this);
    }

    private boolean recursiveCheckBoxSelection(Container container) {
        boolean bl = false;
        for (Component component : container.getComponents()) {
            if (component instanceof JCheckBox && ((JCheckBox)component).isSelected()) {
                bl = true;
            }
            if (!(component instanceof Container)) continue;
            this.recursiveCheckBoxSelection((Container)component);
        }
        return bl;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        this.mStatPanel = this.setupStatisticsPanel();
        DialogUtil.addUsingGBL(jPanel, this.mStatPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.createButtonGroup(this.mStatPanel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTtestPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupTtestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTtestCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.left, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupLabelTextPanel(this.mTestValLabel, this.mTestValText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CS_RATIOS_STAT_STATISTICS_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mStdErrorCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConfIntervalCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left * 8, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupLabelTextPanel(this.mLevelPerLabel, this.mLevelPerText), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCoeffOfVarCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mUnweightedCountCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPoplnSizeCheck, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDesignEffCheck, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSqRtDesignEffCheck, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLabelTextPanel(JLabel jLabel, JTextField jTextField) {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void enableConfInterval(boolean bl) {
        this.mLevelPerLabel.setEnabled(bl);
        this.mLevelPerText.setEnabled(bl);
        if (this.mLevelPerText.getText().length() < 1) {
            this.mLevelPerText.setText(DEFAULT_LEVEL_VALUE);
        }
        this.mLevelPerText.setOpaque(bl);
    }

    private void enableTestVal(boolean bl) {
        this.mTestValLabel.setEnabled(bl);
        this.mTestValText.setEnabled(bl);
        this.mTestValText.setOpaque(bl);
    }

    private void setContinueEnabled() {
        if (this.getLevelTextStatus() && this.getTestValueTextStatus()) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    private boolean getLevelTextStatus() {
        boolean bl = false;
        bl = this.mConfIntervalCheck.isSelected() ? this.mLevelPerText.getText().length() > 0 : true;
        return bl;
    }

    private boolean getTestValueTextStatus() {
        boolean bl = false;
        bl = this.mTtestCheck.isSelected() ? this.mTestValText.getText().length() > 0 : true;
        return bl;
    }

    private void setDefaults() {
        this.enableConfInterval(false);
        this.enableTestVal(false);
        this.mStdErrorCheck.setSelected(true);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mStdErrorCheck);
        vector.add(this.mConfIntervalCheck);
        vector.add(this.mLevelPerText);
        vector.add(this.mCoeffOfVarCheck);
        vector.add(this.mUnweightedCountCheck);
        vector.add(this.mPoplnSizeCheck);
        vector.add(this.mDesignEffCheck);
        vector.add(this.mSqRtDesignEffCheck);
        vector.add(this.mTtestCheck);
        vector.add(this.mTestValText);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

