/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ratios;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOptions;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.ratios.CompSamplesRatiosMissingValues;
import com.spss.java_client.ui.dialogs.complex_samples.ratios.CompSamplesRatiosStat;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CompSamplesRatiosDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String NUM_VAR_LIST = "IDS_NUM_VAR_LIST";
    private static final String DEN_VAR_LIST = "IDS_DEN_VAR_LIST";
    private static final String SUBPOP_VAR_LIST = "IDS_SUBPOP_VAR_LIST";
    private static final String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    private static final String MISSING_VAL_BUTTON = "IDS_COMMON_MISS_VALUE_BUTTON";
    private static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private ArrowButton mNumVarListArrow;
    private ArrowButton mDenVarListArrow;
    private ArrowButton mSubPopVarListArrow;
    private JButton mOptionsButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mNumVarList;
    private TargetVariableList mDenomVarList;
    private TargetVariableList mSubpopVarList;
    private JScrollPane mSrcVarListScroll;
    private JScrollPane mNumVarListScroll;
    private JScrollPane mDenomVarListScroll;
    private JScrollPane mSubpopVarListScroll;

    public CompSamplesRatiosDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CS_RATIOS_TITLE"));
    }

    @Override
    public final String getIActionKey() {
        return "analyze_complex_samples_ratios_main";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_ratio_main";
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        Serializable serializable;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* ").append(this.getResString("IDS_COMPLEX_SAMPLES_RATIO_SYNTAX_TITLE")).append(".\n");
        stringBuffer.append(SyntaxUtil.getCommand("CSDESCRIPTIVES"));
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLAN FILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        stringBuffer.append("\n");
        String string = ComplexSamplesPlan.getJointProbalityValue();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/RATIO NUMERATOR=")).append(this.mNumVarList.getVariablesStringList());
        stringBuffer.append(" DENOMINATOR=").append(this.mDenomVarList.getVariablesStringList());
        Boolean bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_TTEST_CHECK");
        if (bl2 != null && bl2.booleanValue()) {
            serializable = new MathContext(15);
            BigDecimal bigDecimal = new BigDecimal(dialogDataModel.getString("IDS_TEST_VALUE_TEXT"), (MathContext)serializable);
            stringBuffer.append(" TTEST=").append(bigDecimal);
        }
        stringBuffer.append("\n");
        serializable = new StringBuilder();
        bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_STD_ERROR_CHECK");
        if (bl2 == null || bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" SE");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_COEFF_OF_VAR_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" CV");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_UNWT_COUNT_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" COUNT");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_POPLN_SIZE_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" POPSIZE");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_DESIGN_EFFECT_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" DEFF");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_SQRT_DESIGN_EFFECT_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" DEFFSQRT");
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CS_RATIOS_STAT_CONF_INT_CHECK")) != null && bl2.booleanValue()) {
            ((StringBuilder)serializable).append(" CIN").append("(");
            ((StringBuilder)serializable).append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString(dialogDataModel.getString("IDS_LEVEL_PER_TEXT")));
            ((StringBuilder)serializable).append(")");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
        stringBuffer.append(((StringBuilder)serializable).toString());
        stringBuffer.append("\n");
        if (this.mOptionsButton.isEnabled()) {
            stringBuffer.append("").append(SyntaxUtil.getSubCommand("/SUBPOP TABLE=")).append(this.getPopulationListElement());
            stringBuffer.append(" DISPLAY=");
            bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_RADIO_SAME_TABLE");
            if (bl == null || bl.booleanValue()) {
                stringBuffer.append("LAYERED");
            } else {
                stringBuffer.append("SEPARATE");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        bl = dialogDataModel.getBoolean("IDS_CS_RATIOS_MV_USE_ALL_AVAIL_DATA_RADIO");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("ANALYSIS ");
        } else {
            stringBuffer.append("LISTWISE ");
        }
        bl = dialogDataModel.getBoolean("IDS_CS_RATIOS_MV_USER_MISSING_INVALID_RADIO");
        stringBuffer.append("CLASSMISSING=");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("EXCLUDE");
        } else {
            stringBuffer.append("INCLUDE");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mSubpopVarList.getModel()) {
            this.mOptionsButton.setEnabled(true);
        }
        if (this.mNumVarList.getModel().getSize() > 0 && this.mDenomVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mSubpopVarList.getModel() && this.mSubpopVarList.getModel().getSize() == 0) {
            this.mOptionsButton.setEnabled(false);
        }
        if (this.mNumVarList.getModel().getSize() <= 0 || this.mDenomVarList.getModel().getSize() <= 0) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mNumVarList);
        vector.add(this.mDenomVarList);
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("ERR_CS_RATIOS_NUM_LIST_WARNING"));
        vector2.add(this.getResString("ERR_CS_RATIOS_DENOM_LIST_WARNING"));
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(vector, vector2);
        this.setDefaults();
        this.pack();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_RATIO_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_RATIO_PLAN_FILE_NAME"))) {
            super.loadDialogState();
        } else {
            this.setVisible(true);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("IDS_CS_RATIO_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(STATISTICS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompSamplesRatiosDlg.this.runStatisticsSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(MISSING_VAL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompSamplesRatiosDlg.this.runMissingValSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompSamplesRatiosDlg.this.runOptionsSubDlg();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarListScroll = new JScrollPane(this.mSrcVarList);
        this.mSrcVarListScroll.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mNumVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mNumVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mNumVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mNumVarList.getFixedCellHeight() * 4 + 2));
        this.mNumVarListScroll = new JScrollPane(this.mNumVarList);
        this.mNumVarListScroll.setPreferredSize(this.mNumVarList.getMinimumSize());
        this.mNumVarList.setIdentifier(NUM_VAR_LIST);
        this.mNumVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mNumVarList.getModel().addListDataListener(this);
        this.mDenomVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDenomVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDenomVarListScroll = new JScrollPane(this.mDenomVarList);
        this.mDenomVarListScroll.setHorizontalScrollBarPolicy(31);
        this.mDenomVarListScroll.setVerticalScrollBarPolicy(21);
        this.mDenomVarListScroll.setPreferredSize(this.mDenomVarList.getMinimumSize());
        this.mDenomVarList.setIdentifier(DEN_VAR_LIST);
        this.mDenomVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDenomVarList.getModel().addListDataListener(this);
        this.mSubpopVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mSubpopVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSubpopVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSubpopVarList.getFixedCellHeight() * 3 + 2));
        this.mSubpopVarList.setMaxLimitOfList(17);
        this.mSubpopVarListScroll = new JScrollPane(this.mSubpopVarList);
        this.mSubpopVarListScroll.setPreferredSize(this.mSubpopVarList.getMinimumSize());
        this.mSubpopVarList.setIdentifier(SUBPOP_VAR_LIST);
        this.mSubpopVarList.getModel().addListDataListener(this);
        this.mNumVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mNumVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mNumVarListArrow.registerVariableList(this.mNumVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNumVarListArrow.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_CS_RATIOS_NUM_LIST_WARNING")));
        this.mDenVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDenVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDenVarListArrow.registerVariableList(this.mDenomVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDenVarListArrow.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_CS_RATIOS_DENOM_LIST_WARNING")));
        this.mSubPopVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubPopVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubPopVarListArrow.registerVariableList(this.mSubpopVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mNumVarList.removeAll();
        this.mDenomVarList.removeAll();
        this.mSubpopVarList.removeAll();
        this.enableOkPaste(false);
        this.mOptionsButton.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void addComponents(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CS_RATIOS_VAR_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CS_RATIOS_NUM_LABEL");
        jLabel2.setLabelFor(this.mNumVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_CS_RATIOS_DEN_LABEL");
        jLabel3.setLabelFor(this.mDenomVarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_CS_RATIOS_SUBPOP_LABEL");
        jLabel4.setLabelFor(this.mSubpopVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcVarListScroll, gridBagConstraints, 0, 1, 1, 8, n, null);
        n = 10;
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNumVarListArrow, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mNumVarListScroll, gridBagConstraints, 2, 2, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDenVarListArrow, gridBagConstraints, 1, 3, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mDenomVarListScroll, gridBagConstraints, 2, 4, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBounds(0, 0, 100, 100);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        Insets insets4 = new Insets(DialogUtil.getComponentGroupGap() * 2, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 2, 5, 1, 1, n, insets4);
        gridBagConstraints.fill = 0;
        n = 10;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSubPopVarListArrow, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSubpopVarListScroll, gridBagConstraints, 2, 7, 1, 1, n, null);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_CS_RATIOS_EACH_COMB_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 8, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mNumVarListArrow);
        vector.add(this.mDenVarListArrow);
        vector.add(this.mSubPopVarListArrow);
        vector.add(this.mNumVarList);
        vector.add(this.mDenomVarList);
        vector.add(this.mSubpopVarList);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void runStatisticsSubDlg() {
        this.runSubDialog(new CompSamplesRatiosStat(this));
    }

    private void runMissingValSubDlg() {
        this.runSubDialog(new CompSamplesRatiosMissingValues(this));
    }

    private void runOptionsSubDlg() {
        this.runSubDialog(new ComplexSamplesOptions(this, this.getResString("IDS_CS_RATIOS_OPTIONS_TITLE")));
    }

    private String getPopulationListElement() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mSubpopVarList.getModel().getSize(); ++i) {
            stringBuffer.append(this.mSubpopVarList.getModel().getElementAt(i).getName());
            if (i >= this.mSubpopVarList.getModel().getSize() - 1) continue;
            stringBuffer.append(" ").append("BY").append(" ");
        }
        return stringBuffer.toString();
    }
}

