/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.complex_samples.common.ErrorCodeType;
import com.spss.java_client.ui.dialogs.complex_samples.common.Importer;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

class PFAWelcomePage
extends AbstractWizardPage
implements ActionListener,
ItemListener {
    private static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    static final String WELCOME_PAGE_TITLE_LABEL = "IDS_PFA_WELCOME_PAGE_TITLE";
    static final String WELCOME_PAGE_FIRST_LABEL = "IDS_PFA_WELCOME_PAGE_FIRST_LABEL";
    static final String WELCOME_PAGE_SECOND_LABEL = "IDS_PFA_WELCOME_PAGE_SECOND_LABEL";
    public static final String WELCOME_PAGE_ID = "WELCOME_PAGE_ID";
    public static final String WELCOME_PAGE_TITLE = "IDS_PFA_WELCOME_PAGE_TITLE";
    private static final String WELCOME_QUESTION_LABEL = "IDS_PFA_WELCOME_QUESTION_LABEL";
    private static final String CREATE_PLAN_FILE = "IDS_PFA_CREATE_PLAN_FILE";
    private static final String CREATE_LABEL = "IDS_PFA_CREATE_LABEL";
    private static final String CREATE_FILE_LABEL = "IDS_PFA_CREATE_FILE_LABEL";
    private static final String CREATE_BROWSE = "IDS_PFA_CREATE_BROWSE";
    private static final String EDIT_PLAN_FILE = "IDS_PFA_EDIT_PLAN_FILE";
    private static final String EDIT_LABEL = "IDS_PFA_EDIT_LABEL";
    private static final String EDIT_FILE_LABEL = "IDS_PFA_EDIT_FILE_LABEL";
    private static final String EDIT_BROWSE = "IDS_PFA_EDIT_BROWSE";
    private static final String INFO_LABEL = "IDS_PFA_INFO_LABEL";
    private static final String WELCOME_PAGE_HELP_ID = "idh_idd_anal_wiz_welcome";
    private static Vector<String> mPlanElements;
    private JRadioButton mCreatePlanRadio;
    private JTextArea mCreatePlanLabel;
    private JRadioButton mEditPlanFileRadio;
    private JTextArea mEditPlanFileLabel;
    private SpssButtonGroup mButtongrp;
    private JLabel mQuestionLabel;
    private JLabel mCreatePlanFileLabel;
    private FileTextField mCreatePlanFileTextField;
    private JButton mCreatePlanBrowseButton;
    private JLabel mEditFileLabel;
    private FileTextField mEditFileTextField;
    private JButton mEditBrowseButton;
    private boolean mCreatePlanVisited = false;
    private Vector<String> mVarsShouldBeNumericInPlanFile = new Vector();

    PFAWelcomePage(BaseWizardDialog baseWizardDialog) {
        super(WELCOME_PAGE_ID, baseWizardDialog.getResString(PREPARE_FOR_ANALYSIS_WIZARD_TITLE), baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return WELCOME_PAGE_HELP_ID;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean validate() {
        if (this.mCreatePlanRadio.isSelected()) {
            if (this.mCreatePlanFileTextField.getText().trim().length() == 0) {
                this.mCreatePlanBrowseButton.doClick();
            }
            if (this.mCreatePlanFileTextField.getText().trim().length() == 0) {
                this.mCreatePlanFileTextField.requestFocusInWindow();
                return false;
            }
            if (!FileValidator.validatePath((Component)((Object)this.mWizardDialog), this.mCreatePlanFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
                this.mCreatePlanFileTextField.requestFocusInWindow();
                return false;
            }
            if (this.mCreatePlanVisited) return true;
            this.createPlanFile();
            this.mCreatePlanVisited = true;
            return true;
        }
        if (!this.mEditPlanFileRadio.isSelected()) return true;
        String string = this.mEditFileTextField.getText().trim();
        if (this.mEditFileTextField.getText().trim().length() == 0) {
            this.openRemoteFile();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_NOT_VALID"), VersionInfo.getAppVersionString());
            this.mEditFileTextField.requestFocus();
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DialogUtil.readTempDirLocationPrefs());
        stringBuffer.append(System.getProperties().getProperty("file.separator"));
        stringBuffer.append("spss_temp");
        String string2 = stringBuffer.toString();
        new File(string2).deleteOnExit();
        short s = FileValidator.evaluateOpenFile((Component)((Object)this.mWizardDialog), string, false, false);
        if (s == 2 || s == 3) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_READ_ONLY"), this.mEditFileTextField.getText()), VersionInfo.getAppVersionString());
            this.mEditFileTextField.requestFocus();
            return false;
        }
        if (s == 5) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_NOT_FOUND"), this.mEditFileTextField.getText()), VersionInfo.getAppVersionString());
            this.mEditFileTextField.requestFocus();
            return false;
        }
        UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
        if (!utilityProxy.copyServerFile(string, string2, true)) {
            return false;
        }
        this.mCreatePlanVisited = false;
        Specification specification = new Specification();
        Importer importer = new Importer(specification);
        ErrorCodeType errorCodeType = importer.getAnalysisPlan(string2);
        if (errorCodeType != ErrorCodeType.CSXML_ERROR_NONE) {
            if (errorCodeType == ErrorCodeType.CSXML_PARSER_ERROR) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_PLAN_FILE_NOT_VALID"), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            if (!this.verifyNumericPlanVars(specification)) {
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = 0;
                while (true) {
                    if (n >= this.mVarsShouldBeNumericInPlanFile.size()) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_CS_PLAN_VARIABLES_REQUIRED_NUMERIC"), stringBuffer2.toString()), VersionInfo.getAppVersionString());
                        this.mEditFileTextField.requestFocus();
                        return false;
                    }
                    stringBuffer2.append(this.mVarsShouldBeNumericInPlanFile.get(n));
                    if (n < this.mVarsShouldBeNumericInPlanFile.size() - 1) {
                        stringBuffer2.append(", ");
                    }
                    ++n;
                }
            }
        } else {
            StageInformation stageInformation;
            if (!specification.isAnalysisMode()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_PLAN_DOES_NOT_CONTAIN_ANALYSIS_PLAN"), VersionInfo.getAppVersionString());
                this.mEditFileTextField.requestFocus();
                return false;
            }
            mPlanElements.clear();
            long l = specification.getStageListSize();
            for (long i = 1L; i <= l; ++i) {
                long l2;
                stageInformation = specification.getStage(i);
                long l3 = stageInformation.getStrataListSize();
                for (l2 = 0L; l2 < l3; ++l2) {
                    mPlanElements.addElement(stageInformation.getStrataVariable(l2));
                }
                l2 = stageInformation.getClusterListSize();
                for (long j = 0L; j < l2; ++j) {
                    mPlanElements.addElement(stageInformation.getClusterVariable(j));
                }
                if (!stageInformation.getParameterGiven().equals((Object)StageInformation.ParameterGivenType.BY_VARNAME)) continue;
                mPlanElements.addElement(stageInformation.getParameterVariable());
            }
            mPlanElements.addElement(specification.getWeight());
            int n = mPlanElements.size();
            StringBuffer stringBuffer3 = new StringBuffer();
            stageInformation = ((DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC)).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource((LocallyUniqueId)stageInformation);
            int n2 = 0;
            int n3 = iSpssDataSrc.columnCount();
            int n4 = 0;
            while (true) {
                boolean bl;
                String string3;
                if (n4 < n) {
                    string3 = mPlanElements.elementAt(n4);
                    bl = false;
                } else {
                    if (n2 == n) break;
                    String string4 = stringBuffer3.toString();
                    string4 = string4.substring(0, string4.length() - 2);
                    stringBuffer3.delete(0, stringBuffer3.length());
                    string3 = String.format(this.mWizardDialog.getResString("ERR_PFA_PLAN_VARIABLES_DO_NOT_MATCH"), string4);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string3, VersionInfo.getAppVersionString());
                    this.mEditFileTextField.requestFocus();
                    return false;
                }
                for (int i = 0; i < n3; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    if (!iSpssVariable.getName().equalsIgnoreCase(string3)) continue;
                    ++n2;
                    bl = true;
                    break;
                }
                if (!bl) {
                    stringBuffer3.append(string3).append(", ");
                }
                ++n4;
            }
        }
        ((PFAWizardDlg)this.mWizardDialog).setSpecification(specification);
        ((PFAWizardDlg)this.mWizardDialog).setNumStages((int)specification.getStageListSize());
        this.editPlanFile();
        return true;
    }

    @Override
    public String getNextPage() {
        if (this.mCreatePlanRadio.isSelected()) {
            return "STAGE1_DESIGN_PAGE_ID";
        }
        return "PLAN_SUMMARY_PAGE_ID";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mCreatePlanBrowseButton)) {
            this.mCreatePlanFileTextField.setText(this.saveRemoteFile());
        }
        if (actionEvent.getSource().equals(this.mEditBrowseButton)) {
            this.openRemoteFile();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mCreatePlanRadio)) {
            this.mCreatePlanFileLabel.setEnabled(true);
            this.mCreatePlanBrowseButton.setEnabled(true);
            this.mCreatePlanFileTextField.setEnabled(true);
            this.mCreatePlanFileTextField.setOpaque(true);
            this.mEditFileLabel.setEnabled(false);
            this.mEditBrowseButton.setEnabled(false);
            this.mEditFileTextField.setEnabled(false);
            this.mEditFileTextField.setOpaque(false);
        } else if (itemEvent.getSource().equals(this.mEditPlanFileRadio)) {
            this.mCreatePlanFileLabel.setEnabled(false);
            this.mCreatePlanBrowseButton.setEnabled(false);
            this.mCreatePlanFileTextField.setEnabled(false);
            this.mCreatePlanFileTextField.setOpaque(false);
            this.mEditFileLabel.setEnabled(true);
            this.mEditBrowseButton.setEnabled(true);
            this.mEditFileTextField.setEnabled(true);
            this.mEditFileTextField.setOpaque(true);
        }
    }

    public String fileName() {
        if (this.mCreatePlanRadio.isSelected()) {
            return this.mCreatePlanFileTextField.getText();
        }
        return this.mEditFileTextField.getText();
    }

    public boolean isEditPlanFileRadioSelected() {
        return this.mEditPlanFileRadio.isSelected();
    }

    @Override
    public void init() {
        this.initVars();
        this.addComponentsToWelcomePanel();
    }

    @Override
    protected void aboutToShowPanel() {
        this.mWizardDialog.enableFinish(false);
        this.setupLabelPanel();
        this.setupImagePanel();
        ((PFAWizardDlg)this.mWizardDialog).getInCompleteStageLabel().setVisible(false);
        ((PFAWizardDlg)this.mWizardDialog).pushPageInStack(this);
        this.mWizardDialog.setFocusTraversalPolicy(this.getTabTraversalPolicy());
    }

    protected String saveRemoteFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setAcceptAllFileFilterUsed(OSInfo.getOSType() == OSInfo.OSType.MAC);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_FILTER"), this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_EXT")));
        remoteFileChooser.setDialogTitle(this.mWizardDialog.getResString("IDS_PFA_SAVE_DATA_AS"));
        remoteFileChooser.setApproveButtonText(this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_SAVE"));
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mWizardDialog));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.endsWith("csaplan")) {
                string = string + ".csaplan";
            }
            return string;
        }
        return "";
    }

    protected boolean openRemoteFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        RefFileFilter refFileFilter = new RefFileFilter(this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_FILTER"), this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_EXT"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(true);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setDialogTitle(this.mWizardDialog.getResString("IDS_PFA_OPEN_FILE"));
        remoteFileChooser.setApproveButtonText(this.mWizardDialog.getResString("IDS_PFA_SPSS_DATAFILE_OPEN"));
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mWizardDialog));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            String string = remoteFileChooser.getSelectedFilePath();
            this.mEditFileTextField.setText(string);
            return true;
        }
        return false;
    }

    private boolean verifyNumericPlanVars(Specification specification) {
        this.mVarsShouldBeNumericInPlanFile.removeAllElements();
        boolean bl = true;
        if (!this.isNumericDataType(specification.getPreviousWeight())) {
            this.mVarsShouldBeNumericInPlanFile.add(specification.getPreviousWeight());
            bl = false;
        }
        if (!specification.isMOSFromData() && !this.isNumericDataType(specification.getMOS())) {
            this.mVarsShouldBeNumericInPlanFile.add(specification.getMOS());
            bl = false;
        }
        int n = 1;
        while ((long)n <= specification.getStageListSize()) {
            StageInformation stageInformation = specification.getStage(n);
            if (!this.isNumericDataType(stageInformation.getParameterVariable())) {
                this.mVarsShouldBeNumericInPlanFile.add(stageInformation.getParameterVariable());
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private boolean isNumericDataType(String string) {
        ISpssVariable iSpssVariable;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.findVarIndex(string);
        return n == -1 || (iSpssVariable = iSpssDataSrc.getVariable(n)).getType() == 0;
    }

    private void editPlanFile() {
        ((PFAWizardDlg)this.mWizardDialog).cleanUpFlags();
        ((PFAWizardDlg)this.mWizardDialog).setupEditPlanFileTree();
        ((PFAWizardDlg)this.mWizardDialog).setupEditPlanFilePages();
        this.packAllWizardDialogPages();
    }

    private void createPlanFile() {
        ((PFAWizardDlg)this.mWizardDialog).cleanUpFlags();
        ((PFAWizardDlg)this.mWizardDialog).setupCreatePlanFileTree();
        ((PFAWizardDlg)this.mWizardDialog).setupCreatePlanFilePages();
        this.packAllWizardDialogPages();
    }

    private void initVars() {
        this.mButtongrp = new SpssButtonGroup();
        this.mQuestionLabel = new JLabel(this.mWizardDialog.getResString(WELCOME_QUESTION_LABEL));
        this.mCreatePlanRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, CREATE_PLAN_FILE));
        this.mButtongrp.add(this.mCreatePlanRadio);
        this.mCreatePlanLabel = new JTextArea(this.mWizardDialog.getResString(CREATE_LABEL));
        this.mCreatePlanLabel.setLineWrap(true);
        this.mCreatePlanLabel.setWrapStyleWord(true);
        this.mCreatePlanLabel.setBorder(null);
        this.mCreatePlanLabel.setOpaque(false);
        this.mCreatePlanLabel.setFocusable(false);
        this.mCreatePlanLabel.setPreferredSize(new Dimension(100, 50));
        this.mCreatePlanFileTextField = new FileTextField();
        this.mCreatePlanFileTextField.setColumns(12);
        this.mCreatePlanFileTextField.setFocusable(true);
        this.mCreatePlanFileLabel = DialogUtil.createLabel(this.mWizardDialog, CREATE_FILE_LABEL);
        this.mCreatePlanFileLabel.setLabelFor((Component)((Object)this.mCreatePlanFileTextField));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, CREATE_BROWSE);
        this.mCreatePlanBrowseButton = new JButton(toggleButtonAction);
        this.mCreatePlanRadio.addItemListener(this);
        this.mEditPlanFileRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, EDIT_PLAN_FILE));
        this.mButtongrp.add(this.mEditPlanFileRadio);
        this.mEditPlanFileLabel = new JTextArea(this.mWizardDialog.getResString(EDIT_LABEL));
        this.mEditPlanFileLabel.setLineWrap(true);
        this.mEditPlanFileLabel.setWrapStyleWord(true);
        this.mEditPlanFileLabel.setBorder(null);
        this.mEditPlanFileLabel.setOpaque(false);
        this.mEditPlanFileLabel.setFocusable(false);
        this.mEditPlanFileLabel.setPreferredSize(new Dimension(100, 50));
        this.mEditFileTextField = new FileTextField();
        this.mEditFileTextField.setColumns(12);
        this.mEditFileLabel = DialogUtil.createLabel(this.mWizardDialog, EDIT_FILE_LABEL);
        this.mEditFileLabel.setLabelFor((Component)((Object)this.mEditFileTextField));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, EDIT_BROWSE);
        this.mEditBrowseButton = new JButton(toggleButtonAction);
        this.mCreatePlanRadio.setSelected(true);
        this.mCreatePlanBrowseButton.addActionListener(this);
        this.mEditBrowseButton.addActionListener(this);
        this.mEditPlanFileRadio.addItemListener(this);
        this.mEditFileLabel.setEnabled(false);
        this.mEditBrowseButton.setEnabled(false);
        this.mEditFileTextField.setEnabled(false);
        this.mEditFileTextField.setOpaque(false);
        this.mCreatePlanFileTextField.setMinimumSize(new Dimension(252, 22));
        this.mEditFileTextField.setMinimumSize(new Dimension(252, 22));
        mPlanElements = new Vector();
    }

    private void addComponentsToWelcomePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(15, 10, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mQuestionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreatePlanRadio, gridBagConstraints, 0, 1, 4, 1, n, insets);
        insets.set(10, 25, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCreatePlanLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreatePlanFileLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCreatePlanFileTextField), gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mCreatePlanBrowseButton, gridBagConstraints, 3, 2, 1, 1, n, insets);
        insets.set(10, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mEditPlanFileRadio, gridBagConstraints, 0, 3, 4, 1, n, insets);
        insets.set(10, 25, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mEditPlanFileLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(25, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mEditFileLabel, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mEditFileTextField), gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(25, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mEditBrowseButton, gridBagConstraints, 3, 4, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString(INFO_LABEL));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        insets.set(DialogUtil.getComponentGroupGap() * 2, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap() * 2, 5 * DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 5, 4, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void setupImagePanel() {
        PFAWizardDlg.sImagePanel.remove(0);
        URL uRL = this.mWizardDialog.getResImageURL("IDS_PREPARE_FOR_ANALYSIS_IMAGE");
        JLabel jLabel = new JLabel(" ");
        jLabel.setIcon(new ImageIcon(uRL));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(PFAWizardDlg.sImagePanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        PFAWizardDlg.sImagePanel.repaint();
    }

    private void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.mWizardDialog.getResString("IDS_PFA_WELCOME_PAGE_TITLE"));
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString(WELCOME_PAGE_FIRST_LABEL));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(this.mWizardDialog.getResString(WELCOME_PAGE_SECOND_LABEL));
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    private FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtongrp);
        vector.add(this.mCreatePlanFileTextField);
        vector.add(this.mCreatePlanBrowseButton);
        vector.add(this.mEditFileTextField);
        vector.add(this.mEditBrowseButton);
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }
}

