/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PFATreeCellRenderer
extends DefaultTreeCellRenderer {
    static final String STAGE_ONE = "IDS_PFA_STAGE1";
    static final String STAGE_TWO = "IDS_PFA_STAGE2";
    static final String STAGE_THREE = "IDS_PFA_STAGE3";
    static final String ADD_STAGE_TWO = "IDS_PFA_ADD_STAGE2";
    static final String ADD_STAGE_THREE = "IDS_PFA_ADD_STAGE3";
    static final String COMPLETION = "IDS_PFA_COMPLETION";
    private PFAWizardDlg mWizardDlg;
    private Vector<PFATreeNode> mNodesToDisable = new Vector();
    private Icon mSelectedIcon;
    private Icon mVisitedIcon;
    private Icon mEmptyIcon;
    private Icon mIncompleteStageIcon;
    private Color mBgSelectionColor;
    private Color mBorderSelectionColor;

    public PFATreeCellRenderer(PFAWizardDlg pFAWizardDlg, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
        this.mWizardDlg = pFAWizardDlg;
        this.mSelectedIcon = icon;
        this.mVisitedIcon = icon2;
        this.mEmptyIcon = icon3;
        this.mIncompleteStageIcon = icon4;
        this.mBgSelectionColor = this.getBackgroundSelectionColor();
        this.mBorderSelectionColor = this.getBorderSelectionColor();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        PFATreeNode pFATreeNode = (PFATreeNode)object;
        String string = pFATreeNode.getMenuName();
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (this.mNodesToDisable.contains(pFATreeNode)) {
            this.setEnabled(false);
            if (string.contains(this.mWizardDlg.getResString(STAGE_ONE)) || string.equals(this.mWizardDlg.getResString(ADD_STAGE_TWO)) || string.contains(this.mWizardDlg.getResString(STAGE_TWO)) || string.equals(this.mWizardDlg.getResString(ADD_STAGE_THREE)) || string.contains(this.mWizardDlg.getResString(STAGE_THREE)) || string.equals(this.mWizardDlg.getResString(COMPLETION))) {
                if (pFATreeNode.isStageComplete()) {
                    if (string.equals(this.mWizardDlg.getResString(COMPLETION))) {
                        if (pFATreeNode.isVisited()) {
                            this.setDisabledIcon(this.mVisitedIcon);
                        } else {
                            this.setDisabledIcon(this.mEmptyIcon);
                        }
                    } else if (pFATreeNode.isVisited()) {
                        this.setDisabledIcon(this.mVisitedIcon);
                    } else {
                        this.setDisabledIcon(this.mEmptyIcon);
                    }
                } else {
                    this.setDisabledIcon(this.mIncompleteStageIcon);
                }
            } else if (pFATreeNode.isVisited()) {
                this.setDisabledIcon(this.mVisitedIcon);
            } else {
                this.setDisabledIcon(this.mEmptyIcon);
            }
            if (bl) {
                this.setBackgroundSelectionColor(Color.WHITE);
                this.setBorderSelectionColor(Color.WHITE);
            }
        } else {
            this.setBackgroundSelectionColor(this.mBgSelectionColor);
            this.setBorderSelectionColor(this.mBorderSelectionColor);
            this.setNodeIcon(pFATreeNode, string);
        }
        return this;
    }

    Vector<PFATreeNode> getNodesToDisable() {
        return this.mNodesToDisable;
    }

    void setNodesToDisable(Vector<PFATreeNode> vector) {
        this.mNodesToDisable = vector;
    }

    private void setNodeIcon(PFATreeNode pFATreeNode, String string) {
        if (string.contains(this.mWizardDlg.getResString(STAGE_ONE)) || string.equals(this.mWizardDlg.getResString(ADD_STAGE_TWO)) || string.contains(this.mWizardDlg.getResString(STAGE_TWO)) || string.equals(this.mWizardDlg.getResString(ADD_STAGE_THREE)) || string.contains(this.mWizardDlg.getResString(STAGE_THREE))) {
            if (pFATreeNode.isStageComplete()) {
                this.setIcon(this.mEmptyIcon);
            } else {
                this.setIcon(this.mIncompleteStageIcon);
            }
        } else if (this.selected) {
            this.setIcon(this.mSelectedIcon);
        } else if (string.equals(this.mWizardDlg.getResString(COMPLETION))) {
            if (pFATreeNode.isStageComplete()) {
                if (pFATreeNode.isVisited()) {
                    this.setIcon(this.mVisitedIcon);
                } else {
                    this.setIcon(this.mEmptyIcon);
                }
            } else {
                this.setIcon(this.mIncompleteStageIcon);
            }
        } else if (pFATreeNode.isVisited()) {
            this.setIcon(this.mVisitedIcon);
        } else {
            this.setIcon(this.mEmptyIcon);
        }
    }
}

