/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.complex_samples.DefineTableModel;
import com.spss.java_client.ui.dialogs.complex_samples.SummaryTableCellRenderer;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3DefineSubDialog;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3EstimationPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3SizePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATree;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;

class PFAStage3SummaryPage
extends AbstractWizardPage {
    private static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    static final String STAGE3_SUMMARY_PAGE_ID = "STAGE3_SUMMARY_PAGE_ID";
    private static final String SUMMARY_LABEL = "IDS_PFA_SUMMARY_COLON";
    private static final String FILE_LABEL = "IDS_PFA_FILE_COLON";
    private SummaryTableCellRenderer mSummaryTableCellRenderer;
    private int mDefaultRowHeight;
    private JLabel mSummaryLabel;
    private PlainTable mSummaryTable;
    private JScrollPane mTableScroll;
    private DefaultTableModel mTableModel;
    private JLabel mFileLabel;
    private FileTextField mFileTextField;
    private PFATree mMenuTree;
    private boolean mFirstVisit;
    private int mNumStages;

    PFAStage3SummaryPage(BaseWizardDialog baseWizardDialog, PFATree pFATree) {
        super(STAGE3_SUMMARY_PAGE_ID, baseWizardDialog.getResString(PREPARE_FOR_ANALYSIS_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = pFATree;
        this.mFirstVisit = true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_anal_wiz_stage_summary";
    }

    @Override
    public void init() {
        this.initVars();
        this.addComponentsToSummaryPanel();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public String getNextPage() {
        return "COMPLETION_PAGE_ID";
    }

    public String getGeneratedSyntax() {
        String string;
        String string2;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN "));
        PFAStage3DesignPage pFAStage3DesignPage = (PFAStage3DesignPage)this.mWizardDialog.getWizardModel().getPage("STAGE3_DESIGN_PAGE_ID");
        PFAStage3EstimationPage pFAStage3EstimationPage = (PFAStage3EstimationPage)this.mWizardDialog.getWizardModel().getPage("STAGE3_ESTIMATION_PAGE_ID");
        PFAStage3SizePage pFAStage3SizePage = (PFAStage3SizePage)this.mWizardDialog.getWizardModel().getPage("STAGE3_SIZE_PAGE_ID");
        String string5 = pFAStage3DesignPage.getStageLabel();
        if (!string5.equals("")) {
            stringBuffer.append("STAGELABEL=");
            stringBuffer.append(CharacterUtil.smartQuote((String)string5) + " ");
        }
        if ((string4 = (string3 = pFAStage3DesignPage.getStrataVarList().toString().replace(",", "")).substring(1, string3.length() - 1)).length() > 0) {
            stringBuffer.append("STRATA=" + string4 + " ");
        }
        if ((string2 = (string = pFAStage3DesignPage.getClusterVarList().toString().replace(",", "")).substring(1, string.length() - 1)).length() > 0) {
            stringBuffer.append("CLUSTER=" + string2 + " ");
        }
        String string6 = "";
        switch (pFAStage3EstimationPage.getSelectedRadio()) {
            case 1: {
                string6 = "WR";
                break;
            }
            case 2: {
                string6 = "EQUAL_WOR";
                break;
            }
            case 3: {
                string6 = "UNEQUAL_WOR";
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ESTIMATOR TYPE=") + string6);
        if (pFAStage3EstimationPage.getSelectedRadio() == 2) {
            switch (pFAStage3SizePage.selectedRadio()) {
                case 1: {
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() == 1) {
                        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/INCLPROB VALUE=") + ((PFAWizardDlg)this.mWizardDialog).getStage3Size());
                        break;
                    }
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() != 0) break;
                    stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/POPSIZE VALUE=") + ((PFAWizardDlg)this.mWizardDialog).getStage3Size());
                    break;
                }
                case 2: {
                    String string7 = this.getDefineSyntax();
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() == 1) {
                        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/INCLPROB MATRIX=") + string7);
                        break;
                    }
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() != 0) break;
                    stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/POPSIZE MATRIX=") + string7);
                    break;
                }
                case 3: {
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() == 1) {
                        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/INCLPROB VARIABLE=") + pFAStage3SizePage.readValueFromVariable());
                        break;
                    }
                    if (pFAStage3SizePage.getUnitsComboBoxSelectedIndex() != 0) break;
                    stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/POPSIZE VARIABLE=") + pFAStage3SizePage.readValueFromVariable());
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected void aboutToShowPanel() {
        this.setTreeNodeSelected();
        this.setupLabelPanel();
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        this.mFileTextField.setText(pFAWelcomePage.fileName());
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            if (((PFAWizardDlg)this.mWizardDialog).isPlanFileModified() || ((PFAWizardDlg)this.mWizardDialog).getNumStages() > (int)((PFAWizardDlg)this.mWizardDialog).getSpecification().getStageListSize()) {
                this.loadSummaryTable();
            } else {
                this.loadSummaryTableFromPlanFile();
            }
        } else {
            this.loadSummaryTable();
        }
        ((PFAWizardDlg)this.mWizardDialog).pushPageInStack(this);
        this.mWizardDialog.setFocusTraversalPolicy(this.getTabTraversalPolicy());
        if (this.mSummaryTable.getModel().getRowCount() > 0) {
            this.mSummaryTable.changeSelection(0, 0, false, false);
        }
    }

    void loadSummaryTableFromPlanFile() {
        this.mNumStages = ((PFAWizardDlg)this.mWizardDialog).getNumStages();
        switch (this.mNumStages) {
            case 1: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                break;
            }
            case 2: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage2SummaryFromPlan(this.mTableModel);
                break;
            }
            case 3: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage2SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage3SummaryFromPlan(this.mTableModel);
            }
        }
        this.setRendererToSummaryTable();
    }

    private void loadSummaryTable() {
        ((PFAWizardDlg)this.mWizardDialog).addStage1Row(this.mTableModel);
        ((PFAWizardDlg)this.mWizardDialog).addStage2Row(this.mTableModel);
        ((PFAWizardDlg)this.mWizardDialog).addStage3Row(this.mTableModel);
        this.setRendererToSummaryTable();
    }

    private String getDefineSyntax() {
        PFAStage3SizePage pFAStage3SizePage = (PFAStage3SizePage)this.mWizardDialog.getWizardModel().getPage("STAGE3_SIZE_PAGE_ID");
        PFAStage3DefineSubDialog pFAStage3DefineSubDialog = new PFAStage3DefineSubDialog(this.mWizardDialog);
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        Map<String, Vector<Object>> map = pFAStage3SizePage.getTableRowData();
        Vector<String> vector = pFAStage3SizePage.getTableColumnData();
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            map = pFAStage3SizePage.getEditColumnDataMap();
            vector = pFAStage3SizePage.getEditColumnVector();
        } else {
            map = pFAStage3SizePage.getTableRowData();
            vector = pFAStage3SizePage.getTableColumnData();
        }
        return DefineTableModel.getDefineSyntax(pFAStage3DefineSubDialog.getDefineTableModel(), map, vector);
    }

    private void setRendererToSummaryTable() {
        if (this.mFirstVisit) {
            this.mDefaultRowHeight = this.mSummaryTable.getRowHeight(0);
            this.mFirstVisit = false;
        }
        this.mSummaryTableCellRenderer = new SummaryTableCellRenderer(this.mSummaryTable, this.mDefaultRowHeight);
        this.mSummaryTableCellRenderer.clearRowHeightHashMap();
        this.mSummaryTable.setDefaultRenderer(Object.class, this.mSummaryTableCellRenderer);
    }

    private void initVars() {
        this.mSummaryLabel = DialogUtil.createLabel(this.mWizardDialog, SUMMARY_LABEL);
        this.mTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN1") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN2") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN3") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN4") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN5") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN6") + "</HTML>");
        this.mTableModel.addColumn("<HTML>" + this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN7") + "</HTML>");
        this.mSummaryTable = new PlainTable(this.mTableModel);
        this.mSummaryTable.setAutoResizeMode(0);
        this.mSummaryTable.setMinimumSize(new Dimension(300, 130));
        TableColumnModel tableColumnModel = this.mSummaryTable.getColumnModel();
        for (int i = 0; i < this.mSummaryTable.getColumnCount(); ++i) {
            if (i == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(50);
                continue;
            }
            if (i == this.mSummaryTable.getColumnCount() - 1) {
                tableColumnModel.getColumn(i).setPreferredWidth(78);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(73);
        }
        this.mTableScroll = new JScrollPane(this.mSummaryTable);
        this.mTableScroll.setPreferredSize(this.mSummaryTable.getMinimumSize());
        this.mFileLabel = new JLabel(this.mWizardDialog.getResString(FILE_LABEL));
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTextField.setBackground(this.mWizardDialog.getBackground());
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
    }

    private FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummaryTable);
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        PFATreeNode pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        pFATreeNode.setIsVisited(true);
        this.mMenuTree.setSelectionPath(this.mMenuTree.getNextMatch(pFATreeNode.getMenuName(), 12, Position.Bias.Forward));
        this.mMenuTree.requestFocus();
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    private void addComponentsToSummaryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSummaryLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 2, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel2 = this.setupFilePanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.mWizardDialog.getResString("IDS_PFA_SUMMARY_STAGE3_PAGE_TITLE_LABEL"));
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString("IDS_PFA_SUMMARY_IF_WR_METHOD_FIRST_LABEL"));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(" ");
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    private JPanel setupFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }
}

