/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.SummaryTableCellRenderer;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage1DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage1EstimationPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage1SizePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage1SummaryPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage2DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage2EstimationPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage2SizePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage2SummaryPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3EstimationPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3SizePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3SummaryPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATree;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

class PFAPlanSummaryPage
extends AbstractWizardPage
implements ItemListener {
    private static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    static final String STAGE_ONE = "IDS_PFA_STAGE1";
    static final String STAGE_TWO = "IDS_PFA_STAGE2";
    static final String STAGE_THREE = "IDS_PFA_STAGE3";
    static final String ADD_STAGE_TWO = "IDS_PFA_ADD_STAGE2";
    static final String ADD_STAGE_THREE = "IDS_PFA_ADD_STAGE3";
    static final String DESIGN_VARIABLES = "IDS_PFA_DESIGN_VARS";
    static final String ESTIMATION_METHOD = "IDS_PFA_EST_METHOD";
    static final String SIZE = "IDS_PFA_SIZE";
    static final String SUMMARY = "IDS_PFA_SUMMARY";
    static final String COMPLETION = "IDS_PFA_COMPLETION";
    private static final String NOT_APPLICABLE = "IDS_PFA_NOT_APPLICABLE";
    static final String REMOVE_STAGE = "IDS_PFA_REMOVE_STAGES";
    static final String STAGES_LABEL = "IDS_PFA_STAGES_COLON";
    static final String SUMMARY_PAGE_TITLE_LABEL = "IDS_PFA_PLAN_SUMMARY_TITLE";
    static final String SUMMARY_PAGE_FIRST_LABEL = "IDS_PFA_PLAN_SUMMARY_FIRST_LABEL";
    static final String PLAN_SUMMARY_PAGE_ID = "PLAN_SUMMARY_PAGE_ID";
    private static final String SUMMARY_LABEL = "IDS_PFA_SUMMARY_LABEL";
    private static final String FILE_LABEL = "IDS_PFA_FILE_COLON";
    private static final String DELETE_SELECTED_STAGES = "ERR_PFA_SURE_TO_DELETE_THE_STAGE";
    private static final String PLAN_SUMMARY_PAGE_HELP_ID = "idh_idd_anal_wiz_plan_summary";
    private SummaryTableCellRenderer mSummaryTableCellRenderer;
    private int mDefaultRowHeight;
    private JLabel mSummaryLabel;
    private JTable mSummaryTable;
    private JScrollPane mTableScroll;
    private DefaultTableModel mTableModel;
    private JLabel mFileLabel;
    private FileTextField mFileTextField;
    private JCheckBox mRemoveStagesCheckBox;
    private JLabel mStagesLabel;
    private JComboBox mStagesComboBox;
    private PFATree mMenuTree;
    private Specification mSpecification;
    private Vector<String> mSrcVector;
    private boolean mFirstVisit;
    private int mNumStages;

    PFAPlanSummaryPage(BaseWizardDialog baseWizardDialog, PFATree pFATree) {
        super(PLAN_SUMMARY_PAGE_ID, baseWizardDialog.getResString(PREPARE_FOR_ANALYSIS_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = pFATree;
        this.mFirstVisit = true;
    }

    @Override
    public String getDialogHelpID() {
        return PLAN_SUMMARY_PAGE_HELP_ID;
    }

    @Override
    public void init() {
        this.initVars();
        this.addComponentsToSummaryPanel();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getNextPage() {
        return "STAGE1_DESIGN_PAGE_ID";
    }

    @Override
    public boolean validate() {
        if (this.mRemoveStagesCheckBox.isSelected()) {
            if (1 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString(DELETE_SELECTED_STAGES), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                this.mStagesComboBox.requestFocus();
                return false;
            }
            if (this.mStagesComboBox.getSelectedItem().equals("2")) {
                ((PFAWizardDlg)this.mWizardDialog).removeStage2TreeNodes();
                ((PFAWizardDlg)this.mWizardDialog).restoreStage2Variables();
                ((PFAWizardDlg)this.mWizardDialog).setStage2Added(false);
                this.mRemoveStagesCheckBox.setSelected(false);
                if (((PFAWizardDlg)this.mWizardDialog).getNumStages() > 1) {
                    ((PFAWizardDlg)this.mWizardDialog).decrementNumStages();
                }
                ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(2, true);
            } else if (this.mStagesComboBox.getSelectedItem().equals("3")) {
                ((PFAWizardDlg)this.mWizardDialog).removeStage3TreeNodes();
                ((PFAWizardDlg)this.mWizardDialog).restoreStage3Variables();
                ((PFAWizardDlg)this.mWizardDialog).setStage3Added(false);
                this.mRemoveStagesCheckBox.setSelected(false);
                if (((PFAWizardDlg)this.mWizardDialog).getNumStages() > 1) {
                    ((PFAWizardDlg)this.mWizardDialog).decrementNumStages();
                }
                ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(3, true);
            } else if (this.mStagesComboBox.getSelectedItem().equals("2,3")) {
                ((PFAWizardDlg)this.mWizardDialog).removeStage3TreeNodes();
                ((PFAWizardDlg)this.mWizardDialog).restoreStage3Variables();
                ((PFAWizardDlg)this.mWizardDialog).setStage3Added(false);
                this.mRemoveStagesCheckBox.setSelected(false);
                if (((PFAWizardDlg)this.mWizardDialog).getNumStages() > 1) {
                    ((PFAWizardDlg)this.mWizardDialog).decrementNumStages();
                }
                ((PFAWizardDlg)this.mWizardDialog).removeStage2TreeNodes();
                ((PFAWizardDlg)this.mWizardDialog).restoreStage2Variables();
                ((PFAWizardDlg)this.mWizardDialog).setStage2Added(false);
                if (((PFAWizardDlg)this.mWizardDialog).getNumStages() > 1) {
                    ((PFAWizardDlg)this.mWizardDialog).decrementNumStages();
                }
                ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(3, true);
                ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(2, true);
            }
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mStagesLabel.setEnabled(this.mRemoveStagesCheckBox.isSelected());
        this.mStagesComboBox.setEnabled(this.mRemoveStagesCheckBox.isSelected());
    }

    public void addTreeNodes(int n) {
        switch (n) {
            case 1: {
                PFATreeNode pFATreeNode = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getRoot();
                PFATreeNode pFATreeNode2 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(pFATreeNode, 0);
                pFATreeNode2 = new PFATreeNode(this.mWizardDialog.getResString(STAGE_ONE), this.mWizardDialog.getResString(STAGE_ONE), -1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode2, pFATreeNode, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap(this.mWizardDialog.getResString(STAGE_ONE), pFATreeNode2);
                pFATreeNode2.setIsVisited(true);
                PFATreeNode pFATreeNode3 = new PFATreeNode(this.mWizardDialog.getResString(DESIGN_VARIABLES), "STAGE1_DESIGN_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode3, pFATreeNode2, 0);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_DESIGN_PAGE_ID", pFATreeNode3);
                pFATreeNode3 = new PFATreeNode(this.mWizardDialog.getResString(ESTIMATION_METHOD), "STAGE1_ESTIMATION_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode3, pFATreeNode2, 1);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_ESTIMATION_PAGE_ID", pFATreeNode3);
                pFATreeNode3 = new PFATreeNode(this.mWizardDialog.getResString(SUMMARY), "STAGE1_SUMMARY_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode3, pFATreeNode2, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_SUMMARY_PAGE_ID", pFATreeNode3);
                pFATreeNode2 = new PFATreeNode(this.mWizardDialog.getResString(ADD_STAGE_TWO), this.mWizardDialog.getResString(STAGE_TWO), -1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode2, (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 3);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap(this.mWizardDialog.getResString(STAGE_TWO), pFATreeNode2);
                this.mMenuTree.expandRow(2);
                break;
            }
            case 2: {
                PFATreeNode pFATreeNode = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 3);
                pFATreeNode.setUserObject(this.mWizardDialog.getResString(STAGE_TWO));
                PFATreeNode pFATreeNode4 = new PFATreeNode(this.mWizardDialog.getResString(DESIGN_VARIABLES), "STAGE2_DESIGN_PAGE_ID", 2);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode4, pFATreeNode, 0);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE2_DESIGN_PAGE_ID", pFATreeNode4);
                pFATreeNode4 = new PFATreeNode(this.mWizardDialog.getResString(ESTIMATION_METHOD), "STAGE2_ESTIMATION_PAGE_ID", 2);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode4, pFATreeNode, 1);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE2_ESTIMATION_PAGE_ID", pFATreeNode4);
                pFATreeNode4 = new PFATreeNode(this.mWizardDialog.getResString(SUMMARY), "STAGE2_SUMMARY_PAGE_ID", 2);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode4, pFATreeNode, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE2_SUMMARY_PAGE_ID", pFATreeNode4);
                pFATreeNode4 = new PFATreeNode(this.mWizardDialog.getResString(ADD_STAGE_THREE), this.mWizardDialog.getResString(STAGE_THREE), -1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode4, (MutableTreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 4);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap(this.mWizardDialog.getResString(STAGE_THREE), pFATreeNode4);
                if (!this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                    this.mMenuTree.expandRow(7);
                    break;
                }
                this.mMenuTree.expandRow(6);
                break;
            }
            case 3: {
                PFATreeNode pFATreeNode = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 4);
                pFATreeNode.setUserObject(this.mWizardDialog.getResString(STAGE_THREE));
                PFATreeNode pFATreeNode5 = new PFATreeNode(this.mWizardDialog.getResString(DESIGN_VARIABLES), "STAGE3_DESIGN_PAGE_ID", 3);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode5, pFATreeNode, 0);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE3_DESIGN_PAGE_ID", pFATreeNode5);
                pFATreeNode5 = new PFATreeNode(this.mWizardDialog.getResString(ESTIMATION_METHOD), "STAGE3_ESTIMATION_PAGE_ID", 3);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode5, pFATreeNode, 1);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE3_ESTIMATION_PAGE_ID", pFATreeNode5);
                pFATreeNode5 = new PFATreeNode(this.mWizardDialog.getResString(SUMMARY), "STAGE3_SUMMARY_PAGE_ID", 3);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode5, pFATreeNode, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE3_SUMMARY_PAGE_ID", pFATreeNode5);
                if (this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE)) && this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                    this.mMenuTree.expandRow(10);
                    break;
                }
                if (this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE)) && !this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE)) || !this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE)) && this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                    this.mMenuTree.expandRow(11);
                    break;
                }
                if (this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE)) || this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) break;
                this.mMenuTree.expandRow(12);
            }
        }
    }

    public void setFlagsForExistingStages() {
        if (this.mSpecification != null) {
            int n;
            StageInformation stageInformation;
            ((PFAWizardDlg)this.mWizardDialog).setStage2Added(this.mSpecification.getStageListSize() > 1L);
            ((PFAWizardDlg)this.mWizardDialog).setStage3Added(this.mSpecification.getStageListSize() > 2L);
            if (((PFAWizardDlg)this.mWizardDialog).getNumStages() == 2 && (stageInformation = this.mSpecification.getStage(2L)) != null && (n = stageInformation.getKey().getValue()) == StageInformation.KeyType.EQUAL_WOR.getValue()) {
                ((PFAWizardDlg)this.mWizardDialog).setSizeAndOrStage3Added(true);
            }
            if (((PFAWizardDlg)this.mWizardDialog).getNumStages() == 3 && (stageInformation = this.mSpecification.getStage(3L)) != null && (n = stageInformation.getKey().getValue()) == StageInformation.KeyType.EQUAL_WOR.getValue()) {
                ((PFAWizardDlg)this.mWizardDialog).setSizeOfStage3Added(true);
                ((PFAWizardDlg)this.mWizardDialog).setSizeAndOrStage3Added(true);
            }
        }
    }

    public Vector<String> getSrcListVariables() {
        return this.mSrcVector;
    }

    @Override
    protected void aboutToShowPanel() {
        this.setupTreePanel();
        this.setTreeNodeSelected();
        this.setupLabelPanel();
        if (((PFAWizardDlg)this.mWizardDialog).isPlanFileModified() || ((PFAWizardDlg)this.mWizardDialog).getNumStages() > (int)((PFAWizardDlg)this.mWizardDialog).getSpecification().getStageListSize()) {
            this.loadSummaryTable();
        } else {
            this.loadSummaryTablefromPlanFile();
        }
        if (this.mFirstVisit) {
            PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
            this.mFileTextField.setText(pFAWelcomePage.fileName());
            this.setupTree();
            this.storeItemsNotToBeAddedInSrcList();
            this.mDefaultRowHeight = this.mSummaryTable.getRowHeight(0);
            this.setFlagsForExistingStages();
            this.loadPagesFromPlanFile();
            this.setStageLabelsToTreeNodes();
            this.mFirstVisit = false;
        }
        this.loadComboBox();
        this.setRendererToSummaryTable();
        ((PFAWizardDlg)this.mWizardDialog).pushPageInStack(this);
        this.mWizardDialog.setFocusTraversalPolicy(this.getTabTraversalPolicy());
        if (this.mSummaryTable.getModel().getRowCount() > 0) {
            this.mSummaryTable.changeSelection(0, 0, false, false);
        }
    }

    void loadComboBox() {
        this.disableRemoveStages();
        this.mStagesComboBox.removeAllItems();
        int n = ((PFAWizardDlg)this.mWizardDialog).getNumStages();
        switch (n) {
            case 2: {
                this.mStagesComboBox.addItem("2");
                break;
            }
            case 3: {
                this.mStagesComboBox.addItem("3");
                this.mStagesComboBox.addItem("2,3");
                break;
            }
            default: {
                this.mStagesComboBox.setEnabled(false);
                this.mStagesLabel.setEnabled(false);
            }
        }
    }

    private void disableRemoveStages() {
        if (!((PFAWizardDlg)this.mWizardDialog).isStage2Added() && !((PFAWizardDlg)this.mWizardDialog).isStage3Added()) {
            this.mRemoveStagesCheckBox.setEnabled(false);
        } else {
            this.mRemoveStagesCheckBox.setEnabled(true);
        }
    }

    private void setRendererToSummaryTable() {
        this.mSummaryTableCellRenderer = new SummaryTableCellRenderer(this.mSummaryTable, this.mDefaultRowHeight);
        this.mSummaryTableCellRenderer.clearRowHeightHashMap();
        this.mSummaryTable.setDefaultRenderer(Object.class, this.mSummaryTableCellRenderer);
    }

    private void loadPagesFromPlanFile() {
        PFAStage1DesignPage pFAStage1DesignPage = (PFAStage1DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_DESIGN_PAGE_ID");
        pFAStage1DesignPage.loadPageFromPlanFile();
        PFAStage1EstimationPage pFAStage1EstimationPage = (PFAStage1EstimationPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_ESTIMATION_PAGE_ID");
        pFAStage1EstimationPage.loadPageFromPlanFile();
        PFAStage1SizePage pFAStage1SizePage = (PFAStage1SizePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_SIZE_PAGE_ID");
        pFAStage1SizePage.loadPageFromPlanFile();
        PFAStage1SummaryPage pFAStage1SummaryPage = (PFAStage1SummaryPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_SUMMARY_PAGE_ID");
        pFAStage1SummaryPage.setAddStageRadioSelected();
        if (((PFAWizardDlg)this.mWizardDialog).getNumStages() == 2) {
            PFAStage2DesignPage pFAStage2DesignPage = (PFAStage2DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_DESIGN_PAGE_ID");
            pFAStage2DesignPage.loadPageFromPlanFile();
            PFAStage2EstimationPage pFAStage2EstimationPage = (PFAStage2EstimationPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_ESTIMATION_PAGE_ID");
            pFAStage2EstimationPage.loadPageFromPlanFile();
            PFAStage2SizePage pFAStage2SizePage = (PFAStage2SizePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_SIZE_PAGE_ID");
            pFAStage2SizePage.loadPageFromPlanFile();
            PFAStage2SummaryPage pFAStage2SummaryPage = (PFAStage2SummaryPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_SUMMARY_PAGE_ID");
            pFAStage2SummaryPage.setAddStageRadioSelected();
        } else if (((PFAWizardDlg)this.mWizardDialog).getNumStages() == 3) {
            PFAStage2DesignPage pFAStage2DesignPage = (PFAStage2DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_DESIGN_PAGE_ID");
            pFAStage2DesignPage.loadPageFromPlanFile();
            PFAStage2EstimationPage pFAStage2EstimationPage = (PFAStage2EstimationPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_ESTIMATION_PAGE_ID");
            pFAStage2EstimationPage.loadPageFromPlanFile();
            PFAStage2SizePage pFAStage2SizePage = (PFAStage2SizePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_SIZE_PAGE_ID");
            pFAStage2SizePage.loadPageFromPlanFile();
            PFAStage2SummaryPage pFAStage2SummaryPage = (PFAStage2SummaryPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_SUMMARY_PAGE_ID");
            pFAStage2SummaryPage.setAddStageRadioSelected();
            PFAStage3DesignPage pFAStage3DesignPage = (PFAStage3DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE3_DESIGN_PAGE_ID");
            pFAStage3DesignPage.loadPageFromPlanFile();
            PFAStage3EstimationPage pFAStage3EstimationPage = (PFAStage3EstimationPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE3_ESTIMATION_PAGE_ID");
            pFAStage3EstimationPage.loadPageFromPlanFile();
            PFAStage3SizePage pFAStage3SizePage = (PFAStage3SizePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE3_SIZE_PAGE_ID");
            pFAStage3SizePage.loadPageFromPlanFile();
            PFAStage3SummaryPage pFAStage3SummaryPage = (PFAStage3SummaryPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE3_SUMMARY_PAGE_ID");
            pFAStage3SummaryPage.loadSummaryTableFromPlanFile();
        }
        ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(false);
        ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(true);
    }

    private void setStageLabelsToTreeNodes() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mMenuTree.getModel();
        for (int i = 1; i <= ((PFAWizardDlg)this.mWizardDialog).getNumStages(); ++i) {
            PFATreeNode pFATreeNode = (PFATreeNode)((PFATreeNode)defaultTreeModel.getRoot()).getChildAt(i + 1);
            StageInformation stageInformation = this.mSpecification.getStage(i);
            String string = stageInformation.getLabel();
            if (string != null && string != "") {
                pFATreeNode.setUserObject("Stage " + i + ": " + string);
                continue;
            }
            pFATreeNode.setUserObject("Stage " + i);
        }
        this.mMenuTree.updateUI();
    }

    private void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.mWizardDialog.getResString(SUMMARY_PAGE_TITLE_LABEL));
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString(SUMMARY_PAGE_FIRST_LABEL));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(" ");
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    private void setupTreePanel() {
        PFAWizardDlg.sImagePanel.remove(0);
        JScrollPane jScrollPane = new JScrollPane(this.mMenuTree);
        jScrollPane.setPreferredSize(new Dimension(180, this.mMenuTree.getMinimumSize().height));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(PFAWizardDlg.sImagePanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setupTree() {
        PFATreeNode pFATreeNode = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getRoot();
        if (this.mTableModel.getRowCount() == 1) {
            PFATreeNode pFATreeNode2;
            PFATreeNode pFATreeNode3;
            this.addTreeNodes(1);
            if (!this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode3 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 2);
                pFATreeNode2 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE1_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode2, pFATreeNode3, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_SIZE_PAGE_ID", pFATreeNode2);
            }
            pFATreeNode3 = new PFATreeNode(this.mWizardDialog.getResString(COMPLETION), "COMPLETION_PAGE_ID", -1);
            ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("COMPLETION_PAGE_ID", pFATreeNode3);
            if (this.mSpecification.getStage(1L).getKey().equals((Object)StageInformation.KeyType.WR)) {
                pFATreeNode2 = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.mWizardDialog.getResString(STAGE_TWO));
                ((DefaultTreeModel)this.mMenuTree.getModel()).removeNodeFromParent(pFATreeNode2);
                ((PFAWizardDlg)this.mWizardDialog).removeFromPageNodeMap(this.mWizardDialog.getResString(STAGE_TWO));
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode3, pFATreeNode, 3);
            } else {
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode3, pFATreeNode, 4);
            }
        } else if (this.mTableModel.getRowCount() == 2) {
            PFATreeNode pFATreeNode4;
            PFATreeNode pFATreeNode5;
            this.addTreeNodes(1);
            if (!this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode5 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 2);
                pFATreeNode4 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE1_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode4, pFATreeNode5, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_SIZE_PAGE_ID", pFATreeNode4);
            }
            this.addTreeNodes(2);
            pFATreeNode5 = new PFATreeNode(this.mWizardDialog.getResString(COMPLETION), "COMPLETION_PAGE_ID", -1);
            ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("COMPLETION_PAGE_ID", pFATreeNode5);
            if (!this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode4 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 3);
                PFATreeNode pFATreeNode6 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE2_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode6, pFATreeNode4, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE2_SIZE_PAGE_ID", pFATreeNode6);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode5, pFATreeNode, 5);
            } else {
                pFATreeNode4 = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.mWizardDialog.getResString(STAGE_THREE));
                ((DefaultTreeModel)this.mMenuTree.getModel()).removeNodeFromParent(pFATreeNode4);
                ((PFAWizardDlg)this.mWizardDialog).removeFromPageNodeMap(this.mWizardDialog.getResString(STAGE_THREE));
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode5, pFATreeNode, 4);
            }
        } else if (this.mTableModel.getRowCount() == 3) {
            PFATreeNode pFATreeNode7;
            PFATreeNode pFATreeNode8;
            this.addTreeNodes(1);
            if (!this.mTableModel.getValueAt(0, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode8 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 2);
                pFATreeNode7 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE1_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode7, pFATreeNode8, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE1_SIZE_PAGE_ID", pFATreeNode7);
            }
            this.addTreeNodes(2);
            if (!this.mTableModel.getValueAt(1, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode8 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 3);
                pFATreeNode7 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE2_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode7, pFATreeNode8, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE2_SIZE_PAGE_ID", pFATreeNode7);
            }
            this.addTreeNodes(3);
            if (!this.mTableModel.getValueAt(2, 5).toString().equals(this.mWizardDialog.getResString(NOT_APPLICABLE))) {
                pFATreeNode8 = (PFATreeNode)((DefaultTreeModel)this.mMenuTree.getModel()).getChild(((DefaultTreeModel)this.mMenuTree.getModel()).getRoot(), 4);
                pFATreeNode7 = new PFATreeNode(this.mWizardDialog.getResString(SIZE), "STAGE3_SIZE_PAGE_ID", 1);
                ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode7, pFATreeNode8, 2);
                ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("STAGE3_SIZE_PAGE_ID", pFATreeNode7);
            }
            pFATreeNode8 = new PFATreeNode(this.mWizardDialog.getResString(COMPLETION), "COMPLETION_PAGE_ID", -1);
            ((DefaultTreeModel)this.mMenuTree.getModel()).insertNodeInto(pFATreeNode8, pFATreeNode, 5);
            ((PFAWizardDlg)this.mWizardDialog).putInPageNodeMap("COMPLETION_PAGE_ID", pFATreeNode8);
        }
    }

    private void initVars() {
        this.mSummaryLabel = DialogUtil.createLabel(this.mWizardDialog, SUMMARY_LABEL);
        this.mTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN1"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN2"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN3"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN4"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN5"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN6"));
        this.mTableModel.addColumn(this.mWizardDialog.getResString("IDS_PFA_TABLE_COLUMN7"));
        this.mSummaryTable = new JTable(this.mTableModel);
        this.mSummaryTable.setAutoResizeMode(0);
        this.mSummaryTable.setMinimumSize(new Dimension(300, 130));
        TableColumnModel tableColumnModel = this.mSummaryTable.getColumnModel();
        for (int i = 0; i < this.mSummaryTable.getColumnCount(); ++i) {
            if (i == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(50);
                continue;
            }
            if (i == this.mSummaryTable.getColumnCount() - 1) {
                tableColumnModel.getColumn(i).setPreferredWidth(78);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(73);
        }
        this.mTableScroll = new JScrollPane(this.mSummaryTable);
        this.mTableScroll.setPreferredSize(this.mSummaryTable.getMinimumSize());
        this.mFileLabel = new JLabel(this.mWizardDialog.getResString(FILE_LABEL));
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTextField.setBackground(this.mWizardDialog.getBackground());
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mRemoveStagesCheckBox = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, REMOVE_STAGE));
        this.mStagesLabel = DialogUtil.createLabel(this.mWizardDialog, STAGES_LABEL);
        this.mStagesLabel.setEnabled(false);
        this.mStagesComboBox = new JComboBox();
        this.mStagesComboBox.setEnabled(false);
        this.mRemoveStagesCheckBox.addItemListener(this);
        this.mSrcVector = new Vector();
    }

    private FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummaryTable);
        vector.add(this.mRemoveStagesCheckBox);
        vector.add(this.mStagesComboBox);
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }

    private void addComponentsToSummaryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JPanel jPanel2 = this.setUpStagesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = new JLabel();
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSummaryLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 2, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel3 = this.setupFilePanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(70, 160, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 6, 2, 1, n, null);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private JPanel setUpStagesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveStagesCheckBox, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(DialogUtil.getComponentGroupGap(), 40, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mStagesLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mStagesComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        PFATreeNode pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        this.mMenuTree.setSelectionPath(this.mMenuTree.getNextMatch(pFATreeNode.getMenuName(), 0, Position.Bias.Forward));
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
        pFATreeNode.setIsVisited(true);
    }

    private void loadSummaryTable() {
        ((PFAWizardDlg)this.mWizardDialog).addStage1Row(this.mTableModel);
        if (((PFAWizardDlg)this.mWizardDialog).isStage2Added()) {
            ((PFAWizardDlg)this.mWizardDialog).addStage2Row(this.mTableModel);
        }
        if (((PFAWizardDlg)this.mWizardDialog).isStage3Added()) {
            ((PFAWizardDlg)this.mWizardDialog).addStage3Row(this.mTableModel);
        }
        this.setRendererToSummaryTable();
    }

    private void loadSummaryTablefromPlanFile() {
        this.mSpecification = ((PFAWizardDlg)this.mWizardDialog).getSpecification();
        this.mNumStages = ((PFAWizardDlg)this.mWizardDialog).getNumStages();
        switch (this.mNumStages) {
            case 1: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                break;
            }
            case 2: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage2SummaryFromPlan(this.mTableModel);
                break;
            }
            case 3: {
                ((PFAWizardDlg)this.mWizardDialog).loadStage1SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage2SummaryFromPlan(this.mTableModel);
                ((PFAWizardDlg)this.mWizardDialog).loadStage3SummaryFromPlan(this.mTableModel);
            }
        }
        this.setRendererToSummaryTable();
    }

    private void storeItemsNotToBeAddedInSrcList() {
        this.mSpecification = ((PFAWizardDlg)this.mWizardDialog).getSpecification();
        for (int i = 1; i <= ((PFAWizardDlg)this.mWizardDialog).getNumStages(); ++i) {
            StageInformation stageInformation = this.mSpecification.getStage(i);
            int n = 0;
            while ((long)n < stageInformation.getStrataListSize()) {
                this.mSrcVector.add(stageInformation.getStrataVariable(n));
                ++n;
            }
            n = 0;
            while ((long)n < stageInformation.getClusterListSize()) {
                this.mSrcVector.add(stageInformation.getClusterVariable(n));
                ++n;
            }
            if (i == 1) {
                this.mSrcVector.add(this.mSpecification.getWeight());
            }
            if (!stageInformation.getParameterGiven().equals((Object)StageInformation.ParameterGivenType.BY_VARNAME)) continue;
            this.mSrcVector.add(stageInformation.getParameterVariable());
        }
    }
}

