/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATree;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Position;

class PFACompletionPage
extends AbstractWizardPage
implements ItemListener,
ActionListener,
DocumentListener {
    static final String COMPLETION_PAGE_TITLE_LABEL = "IDS_PFA_COMPLETION_PAGE_TITLE_LABEL";
    static final String COMPLETION_PAGE_FIRST_LABEL = "IDS_PFA_COMPLETION_PAGE_FIRST_LABEL";
    static final String COMPLETION_PAGE_SECOND_LABEL = "IDS_PFA_COMPLETION_PAGE_SECOND_LABEL";
    private static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    static final String COMPLETION_PAGE_ID = "COMPLETION_PAGE_ID";
    private static final String COMPLETION_QUESTION_LABEL = "IDS_PFA_COMPLETION_QUESTION_LABEL";
    private static final String SAVE_DESIGN = "IDS_PFA_SAVE_DESIGN";
    private static final String PASTE_SYNTAX = "IDS_PFA_PASTE_SYNTAX";
    private static final String FINISH_LABEL = "IDS_PFA_FINISH_LABEL";
    private static final String FINISH_LABEL_MAC = "IDS_PFA_FINISH_LABEL_MAC";
    private static final String NEW_PLAN_FILE = "IDS_PFA_EDIT_NEW_PLAN_FILE";
    private static final String EXISTING_PLAN_FILE = "IDS_PFA_EDIT_EXISTING_PLAN";
    private static final String EDIT_FILE_LABEL = "IDS_PFA_FILE_COLON";
    private static final String EDIT_BROWSE = "IDS_PFA_EDIT_BROWSE";
    private static final String PFA_COMPLETION_PAGE_HELP_ID = "idh_idd_anal_wiz_finish";
    private JLabel mQuestionLabel;
    private JRadioButton mSaveSpecificationRadio;
    private JRadioButton mPasteSyntaxRadio;
    private SpssButtonGroup mRadioButtonGroup;
    private SpssButtonGroup mPlanFileRadioButtonGroup;
    private JLabel mFinishLabel;
    private JRadioButton mNewPlanRadio;
    private JRadioButton mExistingPlanRadio;
    private JButton mNewPlanFileBrowseButton;
    private StringTextField mNewFileTextField;
    private FileTextField mExistingFileLabel;
    private JTextArea avoid1Label;
    private JLabel fileLabel;
    private PFATree mMenuTree;

    PFACompletionPage(BaseWizardDialog baseWizardDialog, PFATree pFATree) {
        super(COMPLETION_PAGE_ID, baseWizardDialog.getResString(PREPARE_FOR_ANALYSIS_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = pFATree;
    }

    @Override
    public String getDialogHelpID() {
        return PFA_COMPLETION_PAGE_HELP_ID;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mNewPlanRadio) && this.mNewPlanRadio.isSelected()) {
            this.mNewPlanFileBrowseButton.setEnabled(true);
            this.mNewFileTextField.setEnabled(true);
            this.mNewFileTextField.setOpaque(true);
            this.fileLabel.setEnabled(true);
            ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(this.mNewFileTextField.getText().length() > 0);
            this.mWizardDialog.enableFinish(this.mNewFileTextField.getText().length() > 0);
        } else if (itemEvent.getSource().equals(this.mExistingPlanRadio) && this.mExistingPlanRadio.isSelected()) {
            this.mNewPlanFileBrowseButton.setEnabled(false);
            this.mNewFileTextField.setEnabled(false);
            this.mNewFileTextField.setOpaque(false);
            this.fileLabel.setEnabled(false);
            ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(true);
            this.mWizardDialog.enableFinish(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        String string = pFAWelcomePage.saveRemoteFile();
        if (!string.equals("")) {
            this.mNewFileTextField.setText(string);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(this.mNewFileTextField.getText().length() > 0);
        this.mWizardDialog.enableFinish(this.mNewFileTextField.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(this.mNewFileTextField.getText().length() > 0);
        this.mWizardDialog.enableFinish(this.mNewFileTextField.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mWizardDialog.enableFinish(this.mNewFileTextField.getText().length() > 0);
    }

    public boolean isNewPlanFileRadioSelected() {
        return this.mNewPlanRadio.isSelected();
    }

    public boolean isExistingPlanFileRadioSelected() {
        return this.mExistingPlanRadio.isSelected();
    }

    String getNewPlanFileName() {
        return this.mNewFileTextField.getText();
    }

    @Override
    public void init() {
        this.initVars();
        this.addComponentsToCompletionPanel();
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public boolean validate() {
        if (this.mNewPlanRadio.isSelected() && !FileValidator.validatePath((Component)((Object)this.mWizardDialog), this.mNewFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
            this.mNewFileTextField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getNextPage() {
        return "";
    }

    @Override
    protected void aboutToShowPanel() {
        this.setupLabelPanel();
        this.setTreeNodeSelected();
        this.setupSaveToFilePanel();
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            if (this.mNewPlanRadio.isSelected() && ((PFAWizardDlg)this.mWizardDialog).isPlanFileModified()) {
                ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(this.mNewFileTextField.getText().length() > 0);
            } else {
                ((PFAWizardDlg)this.mWizardDialog).markCompletionNodeComplete(true);
            }
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.getTabTraversalPolicy());
    }

    int getSelectedRadio() {
        if (this.mSaveSpecificationRadio.isSelected()) {
            return 1;
        }
        return 2;
    }

    private void setupSaveToFilePanel() {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        this.mExistingFileLabel.setText("(" + pFAWelcomePage.fileName() + ")");
        if (pFAWelcomePage.isEditPlanFileRadioSelected() && ((PFAWizardDlg)this.mWizardDialog).isPlanFileModified()) {
            this.mNewPlanFileBrowseButton.setVisible(true);
            this.mNewPlanRadio.setVisible(true);
            this.mExistingPlanRadio.setVisible(true);
            this.mNewFileTextField.setVisible(true);
            this.mExistingFileLabel.setVisible(true);
            this.avoid1Label.setVisible(true);
            this.fileLabel.setVisible(true);
        } else {
            this.mNewPlanFileBrowseButton.setVisible(false);
            this.mNewPlanRadio.setVisible(false);
            this.mExistingPlanRadio.setVisible(false);
            this.mNewFileTextField.setVisible(false);
            this.mExistingFileLabel.setVisible(false);
            this.avoid1Label.setVisible(false);
            this.fileLabel.setVisible(false);
            this.mWizardDialog.enableFinish(true);
        }
    }

    private void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        PFATreeNode pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        pFATreeNode.setIsVisited(true);
        this.mMenuTree.setSelectionPath(this.mMenuTree.getNextMatch(pFATreeNode.getMenuName(), 0, Position.Bias.Forward));
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    private void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.mWizardDialog.getResString(COMPLETION_PAGE_TITLE_LABEL));
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString(COMPLETION_PAGE_FIRST_LABEL));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(this.mWizardDialog.getResString(COMPLETION_PAGE_SECOND_LABEL));
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    private void addComponentsToCompletionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.avoid1Label = new JTextArea(this.mWizardDialog.getResString("IDS_PFA_EDIT_AVOID_FIRST_LABEL"));
        this.avoid1Label.setLineWrap(true);
        this.avoid1Label.setWrapStyleWord(true);
        this.avoid1Label.setBorder(null);
        this.avoid1Label.setOpaque(false);
        this.avoid1Label.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(30, 60, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mQuestionLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mSaveSpecificationRadio, this.mPasteSyntaxRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(10, 55, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        insets.set(28, 58, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.avoid1Label, gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets.set(15, 55, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(15, 55, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNewPlanRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        insets.set(8, 80, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setUpFilePanel(), gridBagConstraints, 0, 5, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(8, 55, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExistingPlanRadio, gridBagConstraints, 0, 6, 1, 1, n, insets);
        insets.set(13, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mExistingFileLabel), gridBagConstraints, 1, 6, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, 60, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mFinishLabel, gridBagConstraints, 0, 7, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private JPanel setUpFilePanel() {
        this.fileLabel = DialogUtil.createLabel(this.mWizardDialog, EDIT_FILE_LABEL);
        this.fileLabel.setLabelFor((Component)((Object)this.mNewFileTextField));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.fileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNewPlanFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mQuestionLabel = new JLabel(this.mWizardDialog.getResString(COMPLETION_QUESTION_LABEL));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAVE_DESIGN);
        this.mSaveSpecificationRadio = new JRadioButton(toggleButtonAction);
        this.mSaveSpecificationRadio.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, PASTE_SYNTAX);
        this.mPasteSyntaxRadio = new JRadioButton(toggleButtonAction);
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mSaveSpecificationRadio);
        this.mRadioButtonGroup.add(this.mPasteSyntaxRadio);
        this.mNewPlanRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, NEW_PLAN_FILE));
        this.mNewPlanRadio.setSelected(true);
        this.mNewPlanRadio.addItemListener(this);
        this.mExistingPlanRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, EXISTING_PLAN_FILE));
        this.mExistingPlanRadio.addItemListener(this);
        this.mPlanFileRadioButtonGroup = new SpssButtonGroup();
        this.mPlanFileRadioButtonGroup.add(this.mNewPlanRadio);
        this.mPlanFileRadioButtonGroup.add(this.mExistingPlanRadio);
        String string = FINISH_LABEL;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = FINISH_LABEL_MAC;
        }
        this.mFinishLabel = new JLabel(this.mWizardDialog.getResString(string));
        this.mExistingFileLabel = new FileTextField();
        this.mExistingFileLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mExistingFileLabel.setOpaque(false);
        this.mExistingFileLabel.setEditable(false);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, EDIT_BROWSE);
        this.mNewPlanFileBrowseButton = new JButton(toggleButtonAction);
        this.mNewPlanFileBrowseButton.addActionListener(this);
        this.mNewFileTextField = new StringTextField(20);
        this.mNewFileTextField.getDocument().addDocumentListener(this);
    }

    private FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mPlanFileRadioButtonGroup);
        vector.add(this.mNewFileTextField);
        vector.add(this.mNewPlanFileBrowseButton);
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }
}

