/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.common.Specification;
import com.spss.java_client.ui.dialogs.complex_samples.common.StageInformation;
import com.spss.java_client.ui.dialogs.complex_samples.common.VariableCategoryList;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage1DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage2DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAStage3DesignPage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATree;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.text.Position;

public abstract class BasePFAStageSizePage
extends AbstractWizardPage
implements ItemListener,
ListDataListener,
DocumentListener {
    protected static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    protected static final String VARIABLES_LABEL = "IDS_PFA_VARIABLES_LABEL";
    protected static final String UNITS_LABEL_COLON = "IDS_PFA_UNITS_COLON";
    protected static final String UNITS_COMBO_VALUES = "IDS_PFA_UNITS_COMBO_VALUES";
    protected static final String UNIT_COMBO_ACTION = "UNIT_COMBO_ACTION";
    protected static final String VALUE_RADIO_KEY = "IDS_PFA_VALUE_COLON";
    protected static final String UNEQUAL_VALUE_RADIO_KEY = "IDS_PFA_UNEQUAL_VALUES_COLON";
    protected static final String DEFINE_BUTTON_LABEL = "IDS_PFA_DEFINE_3_DOTS";
    protected static final String READ_VALUES_FROM_VAR_RADIO_KEY = "IDS_PFA_READ_VALUES_FROM_VAR_COLON";
    protected ArrowButton mTargetReadValueArrowButton;
    protected SpssButtonGroup mButtonGroup;
    protected JButton mDefineButton;
    protected TargetVariableList mTargetReadValueList;
    protected JLabel mVariablesLabel;
    protected boolean mContinuePressedOnDefine = false;
    protected boolean mIsUnitValueChanged = false;
    protected Map<String, Vector<Object>> mTableRowData;
    protected Vector<String> mTableColData;
    protected Vector<String> mExcludeListData;
    protected Map<String, Vector<Object>> mDefaultCellValMap;
    protected Map<String, Vector<Object>> mDefaultCellValMapAfterContinue;
    protected Map<String, Vector<Object>> mCellMap;
    protected int mRowSize;
    protected int mMaxSize;
    protected StringTextField mValueTextField;
    protected JComboBox mUnitsComboBox;
    protected Vector<String> mColumnVector;
    protected Vector<String> mExcludeListVect;
    protected Map<String, Vector<Object>> mEditMatrixMap;
    protected SrcVariableList mSrcVariableList;
    protected JRadioButton mValueRadio;
    protected JRadioButton mUnequalValuesRadio;
    protected JRadioButton mReadValuesFromVarRadio;
    protected PFATree mMenuTree;
    protected boolean mFirstVisit;
    protected JLabel mSizeValueLabel;
    protected JScrollPane mSrcScrollPane;
    protected JLabel mUnitslabel;
    protected JScrollPane mTargetReadValueScrollPane;
    protected FixedLengthNumericDocument mValueIntegerDocument;
    protected FixedLengthNumericDocument mValueFloatDocument;
    private int mStageNum = 0;

    public BasePFAStageSizePage(String string, String string2, BaseWizardDialog baseWizardDialog, boolean bl, PFATree pFATree, int n) {
        super(string, string2, baseWizardDialog, bl);
        this.mMenuTree = pFATree;
        this.mFirstVisit = true;
        this.mStageNum = n;
        assert (this.mStageNum == 1 || this.mStageNum == 2 || this.mStageNum == 3);
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validate() {
        this.mSrcVariableList.clearSelection();
        if (this.mValueRadio.isSelected() && this.mValueTextField.getText().length() > 0) {
            if (this.mUnitsComboBox.getSelectedIndex() == 1) {
                Float f = Float.valueOf(0.0f);
                try {
                    f = Float.valueOf(Float.parseFloat(this.mValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                if (f.floatValue() == 0.0f) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_VALUE_MUST_BE_GREATER_THAN_ZERO"), VersionInfo.getAppVersionString());
                    this.mValueTextField.selectAll();
                    this.mValueTextField.requestFocus();
                    return false;
                }
                if (f.floatValue() < 0.0f || f.floatValue() > 1.0f) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_ERR_INCLUSION_PROBABILITIES_LIMIT"), VersionInfo.getAppVersionString());
                    this.mValueTextField.requestFocus();
                    this.mValueTextField.selectAll();
                    return false;
                }
            } else if (this.mUnitsComboBox.getSelectedIndex() == 0) {
                try {
                    if (Integer.parseInt(this.mValueTextField.getText()) == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_PFA_VALUE_MUST_BE_GREATER_THAN_ZERO"), VersionInfo.getAppVersionString());
                        this.mValueTextField.selectAll();
                        this.mValueTextField.requestFocus();
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string = MessageFormat.format(this.mWizardDialog.getResString("ERR_PFA_INT_MUST_NOT_EXCEED_WARNING"), Integer.MAX_VALUE);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
                    this.mValueTextField.selectAll();
                    this.mValueTextField.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.setTreeNodeSelected();
        this.setupLabelPanel();
        if (this.mStageNum == 1) {
            this.aboutToShowPanelForStage1();
        } else if (this.mStageNum == 2) {
            this.aboutToShowPanelForStage2();
        } else if (this.mStageNum == 3) {
            this.aboutToShowPanelForStage3();
        }
        this.mValueTextField.getDocument().addDocumentListener(this);
        if (this.mValueRadio.isSelected() && this.mValueTextField.getText().length() == 0 || this.mReadValuesFromVarRadio.isSelected() && this.mTargetReadValueList.getModel().getSize() == 0) {
            this.mWizardDialog.enableNext(false);
        } else if (this.mValueRadio.isSelected() && this.mValueTextField.getText().length() >= 1 || this.mReadValuesFromVarRadio.isSelected() && this.mTargetReadValueList.getModel().getSize() == 1) {
            this.mWizardDialog.enableNext(true);
        }
        ((PFAWizardDlg)this.mWizardDialog).pushPageInStack(this);
        if (this.mWizardDialog.getGlassPane() instanceof DragPane) {
            DragPane dragPane = (DragPane)this.mWizardDialog.getGlassPane();
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVariableList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetReadValueList));
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.getTabTraversalPolicy());
        this.mSrcVariableList.requestFocus();
    }

    public String getUnitsValue() {
        int n = this.mUnitsComboBox.getSelectedIndex();
        if (n == 1) {
            return this.mWizardDialog.getResString("IDS_PFA_PROPORTION");
        }
        return this.mWizardDialog.getResString("IDS_PFA_COUNT");
    }

    public String getSizeValue() {
        if (this.mValueRadio.isSelected()) {
            return this.mValueTextField.getText();
        }
        return this.mWizardDialog.getResString("IDS_PFA_NOT_APPLICABLE");
    }

    public void continueIsPressedOnDefine() {
        this.mWizardDialog.enableNext(this.isContinuePressedOnDefine());
        if (this.isContinuePressedOnDefine()) {
            ((PFAWizardDlg)this.mWizardDialog).markStageComplete(this.mStageNum, true);
            if (this.mStageNum == 1) {
                ((PFAWizardDlg)this.mWizardDialog).enableStage1OnwardsNodes();
            } else if (this.mStageNum == 2) {
                ((PFAWizardDlg)this.mWizardDialog).enableStage2OnwardsNodes();
            } else if (this.mStageNum == 3) {
                ((PFAWizardDlg)this.mWizardDialog).getNodesToDisable().clear();
            }
            this.setTreeNodeSelected();
        } else {
            ((PFAWizardDlg)this.mWizardDialog).markStageComplete(this.mStageNum, false);
            if (this.mStageNum == 1) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage1OnwardsTreeNodes();
            } else if (this.mStageNum == 2) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage2OnwardsNodes();
            } else if (this.mStageNum == 3) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage3SizeOnwardsTreeNodes();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(this.mStageNum, true);
        }
        if (this.mValueRadio.isSelected() && this.mValueTextField.getText().length() > 0) {
            this.mWizardDialog.enableNext(true);
            ((PFAWizardDlg)this.mWizardDialog).markStageComplete(this.mStageNum, true);
            if (this.mStageNum == 1) {
                ((PFAWizardDlg)this.mWizardDialog).enableStage1OnwardsNodes();
            } else if (this.mStageNum == 2) {
                ((PFAWizardDlg)this.mWizardDialog).enableStage2OnwardsNodes();
            } else if (this.mStageNum == 3) {
                ((PFAWizardDlg)this.mWizardDialog).getNodesToDisable().clear();
            }
            this.setTreeNodeSelected();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(this.mStageNum, true);
        }
        if (this.mValueRadio.isSelected() && this.mValueTextField.getText().length() == 0) {
            this.mWizardDialog.enableNext(false);
            ((PFAWizardDlg)this.mWizardDialog).markStageComplete(this.mStageNum, false);
            if (this.mStageNum == 1) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage1OnwardsTreeNodes();
            } else if (this.mStageNum == 2) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage2OnwardsNodes();
            } else if (this.mStageNum == 3) {
                ((PFAWizardDlg)this.mWizardDialog).disableStage3SizeOnwardsTreeNodes();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(this.mStageNum, true);
        }
    }

    public void setSelectedRadio(int n) {
        switch (n) {
            case 1: {
                this.mValueRadio.setSelected(true);
                break;
            }
            case 2: {
                this.mUnequalValuesRadio.setSelected(true);
                break;
            }
            case 3: {
                this.mReadValuesFromVarRadio.setSelected(true);
            }
        }
    }

    public int selectedRadio() {
        if (this.mValueRadio.isSelected()) {
            return 1;
        }
        if (this.mUnequalValuesRadio.isSelected()) {
            return 2;
        }
        return 3;
    }

    public int getUnitsComboBoxSelectedIndex() {
        return this.mUnitsComboBox.getSelectedIndex();
    }

    public String readValueFromVariable() {
        if (this.mTargetReadValueList.getModel().getSize() > 0) {
            return this.mTargetReadValueList.getModel().getElementAt(0).getName();
        }
        return "";
    }

    public VarListModel getReadValueModel() {
        return this.mTargetReadValueList.getModel();
    }

    public Map<String, Vector<Object>> getTableRowData() {
        return this.mTableRowData;
    }

    public void setTableRowData(Map<String, Vector<Object>> map) {
        this.mTableRowData = map;
    }

    public Vector<String> getTableColumnData() {
        return this.mTableColData;
    }

    public void setTableColumnData(Vector<String> vector) {
        this.mTableColData = vector;
    }

    public Vector<String> getExcludeListData() {
        return this.mExcludeListData;
    }

    public void setExcludeListData(Vector<String> vector) {
        this.mExcludeListData = vector;
    }

    public Map<String, Vector<Object>> getDefaultCellValueMap() {
        return this.mDefaultCellValMap;
    }

    public void setDefaultCellValueMap(Map<String, Vector<Object>> map) {
        this.mDefaultCellValMap = map;
    }

    public Map<String, Vector<Object>> getDefaultCellValueMapAfterContinue() {
        return this.mDefaultCellValMapAfterContinue;
    }

    public void setDefaultCellValueMapAfterContinue(Map<String, Vector<Object>> map) {
        this.mDefaultCellValMapAfterContinue = map;
    }

    public Map<String, Vector<Object>> getCellValueMap() {
        return this.mCellMap;
    }

    public void setCellValueMap(Map<String, Vector<Object>> map) {
        this.mCellMap = map;
    }

    public int getRowSize() {
        return this.mRowSize;
    }

    public void setRowSize(int n) {
        this.mRowSize = n;
    }

    public Vector<String> getEditColumnVector() {
        return this.mColumnVector;
    }

    public Map<String, Vector<Object>> getEditColumnDataMap() {
        return this.mEditMatrixMap;
    }

    public Vector<String> getEditExcludeListValues() {
        return this.mExcludeListVect;
    }

    public void setEditColumnVector(Vector<String> vector) {
        this.mColumnVector = vector;
    }

    public void setEditColumnDataMap(Map<String, Vector<Object>> map) {
        this.mEditMatrixMap = map;
    }

    protected void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        PFATreeNode pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        pFATreeNode.setIsVisited(true);
        int n = 0;
        if (this.mStageNum == 2) {
            n = 6;
        } else if (this.mStageNum == 3) {
            n = 11;
        }
        this.mMenuTree.setSelectionPath(this.mMenuTree.getNextMatch(pFATreeNode.getMenuName(), n, Position.Bias.Forward));
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
    }

    public void setContinuePressedOnDefine(boolean bl) {
        this.mContinuePressedOnDefine = bl;
    }

    public boolean isContinuePressedOnDefine() {
        return this.mContinuePressedOnDefine;
    }

    public boolean isUnitValueChanged() {
        return this.mIsUnitValueChanged;
    }

    public void setUnitValue(boolean bl) {
        this.mIsUnitValueChanged = bl;
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public void setMaxSize(int n) {
        this.mMaxSize = n;
    }

    private FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mTargetReadValueArrowButton);
        vector.add(this.mUnitsComboBox);
        vector.add(this.mButtonGroup);
        vector.add(this.mValueTextField);
        vector.add(this.mDefineButton);
        vector.add(this.mTargetReadValueList);
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }

    protected void setEnabled(boolean bl, boolean bl2, boolean bl3) {
        this.mValueTextField.setEnabled(bl);
        this.mValueTextField.setOpaque(bl);
        this.mSizeValueLabel.setEnabled(bl);
        this.mDefineButton.setEnabled(bl2);
        this.mTargetReadValueArrowButton.setEnabled(bl3);
        this.mTargetReadValueList.setEnabled(bl3);
        this.mTargetReadValueList.setOpaque(bl3);
        this.mSrcVariableList.setEnabled(bl3);
        this.mVariablesLabel.setEnabled(bl3);
    }

    private void setDefaults() {
        this.mSrcVariableList.setSelectedIndex(0);
        this.mValueRadio.setSelected(true);
        this.mTargetReadValueList.setEnabled(false);
        this.mTargetReadValueList.setOpaque(false);
        this.mTargetReadValueArrowButton.setEnabled(false);
        this.mSrcVariableList.setEnabled(false);
        this.mVariablesLabel.setEnabled(false);
    }

    private void addComponentsToSampleSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariablesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupControlsPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void addListeners() {
        this.mUnitsComboBox.addItemListener(this);
        this.mValueRadio.addItemListener(this);
        this.mUnequalValuesRadio.addItemListener(this);
        this.mReadValuesFromVarRadio.addItemListener(this);
        this.mTargetReadValueList.getModel().addListDataListener(this);
    }

    private void removeListeners() {
        this.mUnitsComboBox.removeItemListener(this);
        this.mValueRadio.removeItemListener(this);
        this.mUnequalValuesRadio.removeItemListener(this);
        this.mReadValuesFromVarRadio.removeItemListener(this);
        this.mTargetReadValueList.getModel().removeListDataListener(this);
    }

    private JPanel setupUnitsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUnitslabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUnitsComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupControlsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0, 0);
        JPanel jPanel2 = this.setupUnitsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1, n, insets);
        JSeparator jSeparator = new JSeparator();
        n = 10;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 1, 1, 2, 1, n, insets);
        n = 25;
        gridBagConstraints.fill = 0;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValueRadio, gridBagConstraints, 1, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        n = 10;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 6, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mValueTextField), gridBagConstraints, 1, 3, 1, 1, n, insets);
        n = 23;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mSizeValueLabel, gridBagConstraints, 2, 3, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUnequalValuesRadio, gridBagConstraints, 1, 4, 2, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 6, 0, DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mDefineButton, gridBagConstraints, 1, 5, 2, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mReadValuesFromVarRadio, gridBagConstraints, 1, 6, 2, 1, n, insets);
        n = 20;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets.set(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mTargetReadValueArrowButton, gridBagConstraints, 0, 6, 1, 2, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin() * 6, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetReadValueScrollPane, gridBagConstraints, 1, 7, 2, 1, n, insets);
        return jPanel;
    }

    protected void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.getStageTitle());
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString("IDS_PFA_SIZE_PAGE_FIRST_LABEL"));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(this.mWizardDialog.getResString("IDS_PFA_SIZE_PAGE_SECOND_LABEL"));
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToSampleSizePanel();
        this.addListeners();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_anal_wiz_size";
    }

    protected void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        this.mVariablesLabel = DialogUtil.createLabel(this.mWizardDialog, VARIABLES_LABEL);
        this.mVariablesLabel.setLabelFor(this.mSrcVariableList);
        this.mUnitslabel = DialogUtil.createLabel(this.mWizardDialog, UNITS_LABEL_COLON);
        String[] stringArray = this.mWizardDialog.getResStringArray(UNITS_COMBO_VALUES);
        this.mUnitsComboBox = new JComboBox<String>(stringArray);
        this.mUnitsComboBox.setAction(new ComboboxAction(this.mWizardDialog, UNIT_COMBO_ACTION));
        this.mUnitsComboBox.setSelectedIndex(1);
        this.mUnitslabel.setLabelFor(this.mUnitsComboBox);
        this.mButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, VALUE_RADIO_KEY);
        this.mValueRadio = new JRadioButton(toggleButtonAction);
        this.mButtonGroup.add(this.mValueRadio);
        this.mValueTextField = new StringTextField(10);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, UNEQUAL_VALUE_RADIO_KEY);
        this.mUnequalValuesRadio = new JRadioButton(toggleButtonAction);
        this.mButtonGroup.add(this.mUnequalValuesRadio);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, READ_VALUES_FROM_VAR_RADIO_KEY);
        this.mReadValuesFromVarRadio = new JRadioButton(toggleButtonAction);
        this.mButtonGroup.add(this.mReadValuesFromVarRadio);
        this.mDefineButton = new JButton(this.getDefineSubDialogAction());
        this.mDefineButton.setEnabled(false);
        this.mTargetReadValueList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mTargetReadValueList.addVarFilter(spssVarFilter);
        this.mTargetReadValueScrollPane = new JScrollPane(this.mTargetReadValueList);
        this.mTargetReadValueScrollPane.setPreferredSize(this.mTargetReadValueList.getMinimumSize());
        this.mTargetReadValueScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetReadValueScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetReadValueArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetReadValueArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetReadValueArrowButton.registerVariableList(this.mTargetReadValueList, SpssArrowButton.ButtonOrientation.left);
        this.mValueIntegerDocument = new FixedLengthNumericDocument(Integer.MAX_VALUE, true, false);
        this.mValueFloatDocument = new FixedLengthNumericDocument(Integer.MAX_VALUE, true, true);
        this.mSizeValueLabel = new JLabel();
        this.mEditMatrixMap = new HashMap<String, Vector<Object>>();
        this.mColumnVector = new Vector();
        this.mExcludeListVect = new Vector();
        this.mTableColData = new Vector();
    }

    protected abstract Action getDefineSubDialogAction();

    protected abstract String getStageTitle();

    private void aboutToShowPanelForStage1() {
        PFAWelcomePage pFAWelcomePage;
        PFAStage1DesignPage pFAStage1DesignPage = (PFAStage1DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_DESIGN_PAGE_ID");
        if (pFAStage1DesignPage != null) {
            this.mSrcVariableList.setModel(pFAStage1DesignPage.getSrcVarList().getModel());
            this.mSrcVariableList.setSelectedIndex(0);
            this.mUnequalValuesRadio.setEnabled(pFAStage1DesignPage.getStrataTargetList().getModel().getSize() > 0);
            this.mDefineButton.setEnabled(pFAStage1DesignPage.getStrataTargetList().getModel().getSize() > 0 && this.mUnequalValuesRadio.isSelected());
            if (pFAStage1DesignPage.getStrataTargetList().getModel().getSize() <= 0 && this.mUnequalValuesRadio.isSelected()) {
                this.mValueRadio.setSelected(true);
            }
        }
        if ((pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID")).isEditPlanFileRadioSelected() && !((PFAWizardDlg)this.mWizardDialog).isPlanFileModified()) {
            this.loadPageFromPlanFile();
        } else if (this.mUnitsComboBox.getSelectedIndex() == 0) {
            this.mValueTextField.setDocument(this.mValueIntegerDocument);
        } else if (this.mUnitsComboBox.getSelectedIndex() == 1) {
            this.mValueTextField.setDocument(this.mValueFloatDocument);
        }
    }

    private void aboutToShowPanelForStage2() {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            if (this.mFirstVisit && !((PFAWizardDlg)this.mWizardDialog).isPlanFileModified()) {
                this.loadPageFromPlanFile();
                this.mFirstVisit = false;
            } else if (this.mUnitsComboBox.getSelectedIndex() == 0) {
                this.mValueTextField.setDocument(this.mValueIntegerDocument);
            } else if (this.mUnitsComboBox.getSelectedIndex() == 1) {
                this.mValueTextField.setDocument(this.mValueFloatDocument);
            }
        } else if (this.mUnitsComboBox.getSelectedIndex() == 0) {
            this.mValueTextField.setDocument(this.mValueIntegerDocument);
        } else if (this.mUnitsComboBox.getSelectedIndex() == 1) {
            this.mValueTextField.setDocument(this.mValueFloatDocument);
        }
        PFAStage1DesignPage pFAStage1DesignPage = (PFAStage1DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_DESIGN_PAGE_ID");
        if (pFAStage1DesignPage != null) {
            this.mSrcVariableList.setModel(pFAStage1DesignPage.getSrcVarList().getModel());
            this.mSrcVariableList.setSelectedIndex(0);
        }
    }

    private void aboutToShowPanelForStage3() {
        this.aboutToShowPanelForStage2();
    }

    void loadPageFromPlanFile() {
        StageInformation stageInformation;
        this.removeListeners();
        Specification specification = ((PFAWizardDlg)this.mWizardDialog).getSpecification();
        if (specification != null && (stageInformation = specification.getStage(this.mStageNum)) != null) {
            DecimalFormat decimalFormat;
            if (stageInformation.getKeySubcommand().equals((Object)StageInformation.KeySubcommandType.INCLPROB)) {
                this.mUnitsComboBox.setSelectedIndex(1);
                this.mValueTextField.setDocument(this.mValueFloatDocument);
                decimalFormat = new DecimalFormat("###.###############", new DecimalFormatSymbols(ComponentState.getSPSSLocale()));
                this.mValueTextField.setText(decimalFormat.format(stageInformation.getParameterValue()));
            } else if (stageInformation.getKeySubcommand().equals((Object)StageInformation.KeySubcommandType.POPSIZE)) {
                this.mUnitsComboBox.setSelectedIndex(0);
                this.mValueTextField.setDocument(this.mValueIntegerDocument);
                this.mValueTextField.setText(Integer.toString((int)stageInformation.getParameterValue()));
            }
            if (stageInformation.getParameterGiven().equals((Object)StageInformation.ParameterGivenType.BY_VALUE)) {
                this.mValueRadio.setSelected(true);
                this.setEnabled(true, false, false);
            } else if (stageInformation.getParameterGiven().equals((Object)StageInformation.ParameterGivenType.BY_VARCATLIST)) {
                this.mUnequalValuesRadio.setSelected(true);
                this.setEnabled(false, true, false);
                this.populateEditTableContents();
                this.setContinuePressedOnDefine(true);
            } else if (stageInformation.getParameterGiven().equals((Object)StageInformation.ParameterGivenType.BY_VARNAME)) {
                this.mReadValuesFromVarRadio.setSelected(true);
                this.setEnabled(false, false, true);
                decimalFormat = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource((LocallyUniqueId)decimalFormat);
                int n = iSpssDataSrc.findVarIndex(stageInformation.getParameterVariable());
                if (n != -1) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
                    this.mTargetReadValueList.getModel().addElement(iSpssVariable);
                }
            }
        }
        this.addListeners();
    }

    private Object getValue(Object object, String string) {
        PFAStage1DesignPage pFAStage1DesignPage = (PFAStage1DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_DESIGN_PAGE_ID");
        Map<String, Map<String, String>> map = pFAStage1DesignPage.getValueLabelMap();
        Map<String, String> map2 = map.get(string);
        String string2 = object.toString();
        Locale locale = ComponentState.getSPSSLocale();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (decimalFormatSymbols.getDecimalSeparator() == ',') {
            string2 = string2.replace('.', ',');
        }
        if (map2 != null && map2.get(string2) != null) {
            return map2.get(string2);
        }
        return string2;
    }

    protected abstract Map<String, Map<String, String>> getDesignVarPageValueLabelMap();

    public void populateEditTableContents() {
        VariableCategoryList variableCategoryList;
        StageInformation stageInformation;
        PFAStage1DesignPage pFAStage1DesignPage = (PFAStage1DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE1_DESIGN_PAGE_ID");
        Specification specification = ((PFAWizardDlg)this.mWizardDialog).getSpecification();
        if (specification != null && (stageInformation = specification.getStage(this.mStageNum)) != null && (variableCategoryList = stageInformation.getVariableCategoryList()) != null && variableCategoryList.getVariableListSize() > 0L) {
            Object object;
            this.mEditMatrixMap.clear();
            this.mColumnVector.clear();
            ISpssDataSrc iSpssDataSrc = null;
            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            if (spssFrame instanceof DataFrame) {
                object = ((DataFrame)spssFrame).getDatasetId();
                iSpssDataSrc = DataMgr.getDataMgr().getDataSource((LocallyUniqueId)object);
            }
            object = new Vector();
            Vector<Vector<String>> vector = new Vector<Vector<String>>();
            Vector<Double> vector2 = new Vector<Double>();
            long l = variableCategoryList.getVariableListSize();
            int n = 0;
            while ((long)n < l) {
                ((Vector)object).add(n, variableCategoryList.getVariable(n));
                this.mColumnVector.add(n, variableCategoryList.getVariable(n));
                ++n;
            }
            vector.add((Vector<String>)object);
            variableCategoryList.copyCategoryKeysValues(vector, vector2, iSpssDataSrc);
            Vector vector3 = new Vector();
            if (vector2.size() > 0) {
                Object object2;
                Vector<Object> vector5;
                int n2 = 0;
                l = this.mColumnVector.size();
                int n3 = 0;
                while ((long)n3 < l) {
                    int n4 = vector.size();
                    vector5 = new Vector<Object>();
                    for (int i = 0; i < n4; ++i) {
                        Vector<String> vector42 = vector.get(i);
                        if (n2 >= vector42.size()) continue;
                        object2 = this.getValue(vector42.get(n2), this.mColumnVector.get(n2));
                        vector5.add(object2);
                    }
                    ++n2;
                    vector5.add("");
                    vector5.add("");
                    vector5.add("");
                    vector3.add(vector5);
                    ++n3;
                }
                for (n3 = 0; n3 < this.mColumnVector.size(); ++n3) {
                    this.mEditMatrixMap.put(this.mColumnVector.get(n3), (Vector<Object>)vector3.get(n3));
                }
                String string = this.getUnitsValue();
                Vector<String> vector6 = new Vector<String>(this.mColumnVector);
                this.mColumnVector.add(string);
                vector5 = new Vector();
                for (Double d : vector2) {
                    object2 = d.toString();
                    vector5.add(object2);
                }
                vector5.add("");
                vector5.add("");
                vector5.add("");
                this.mEditMatrixMap.put(string, vector5);
                this.setRowSize(((Vector)vector3.get(0)).size());
                this.mExcludeListVect.clear();
                PFAStage2DesignPage pFAStage2DesignPage = (PFAStage2DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE2_DESIGN_PAGE_ID");
                PFAStage3DesignPage pFAStage3DesignPage = (PFAStage3DesignPage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("STAGE3_DESIGN_PAGE_ID");
                switch (this.mStageNum) {
                    case 1: {
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage1DesignPage.getStrataVarList()));
                        pFAStage1DesignPage.setEditPlanFileStage1Updated(false);
                        break;
                    }
                    case 2: {
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage1DesignPage.getStrataVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage1DesignPage.getClusterVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage2DesignPage.getStrataVarList()));
                        pFAStage1DesignPage.setEditPlanFileStage1Updated(false);
                        pFAStage2DesignPage.setEditPlanFileStage2Updated(false);
                        break;
                    }
                    case 3: {
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage1DesignPage.getStrataVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage1DesignPage.getClusterVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage2DesignPage.getStrataVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage2DesignPage.getClusterVarList()));
                        this.mExcludeListVect.addAll(new Vector<String>(pFAStage3DesignPage.getStrataVarList()));
                        pFAStage1DesignPage.setEditPlanFileStage1Updated(false);
                        pFAStage2DesignPage.setEditPlanFileStage2Updated(false);
                        pFAStage3DesignPage.setEditPlanFileStage3Updated(false);
                    }
                }
                this.mExcludeListVect.removeAll(vector6);
            }
        }
    }

    protected int showMessage(String string) {
        int n = this.mStageNum == 2 ? SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) : SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        return n;
    }
}

