/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATree;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFATreeNode;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWelcomePage;
import com.spss.java_client.ui.dialogs.complex_samples.prepare_for_analysis.PFAWizardDlg;
import com.spss.shared.core_tools.format.CellValueFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;

public abstract class BasePFAStageDesignPage
extends AbstractWizardPage
implements ListDataListener,
DocumentListener,
IVarMoveHandler,
FocusListener {
    private static final String PREPARE_FOR_ANALYSIS_WIZARD_TITLE = "IDS_PFA_PREPARE_FOR_ANALYSIS_WIZARD";
    static final String STAGE_ONE = "IDS_PFA_STAGE1";
    static final String STAGE_TWO = "IDS_PFA_STAGE2";
    static final String STAGE_THREE = "IDS_PFA_STAGE3";
    private static final String VARIABLES_LABEL = "IDS_PFA_VARIABLES_LABEL";
    private static final String STRATA_LABEL = "IDS_PFA_STRATIFY_LABEL";
    private static final String CLUSTERS_LABEL = "IDS_PFA_CLUSTERS_LABEL";
    private static final String STAGE_LABEL = "IDS_PFA_STAGE_LABEL";
    static final String DESIGN_VAR_PAGE_FIRST_LABEL = "IDS_PFA_DESIGN_VAR_PAGE_FIRST_LABEL";
    static final String DESIGN_VAR_PAGE_SECOND_LABEL = "IDS_PFA_DESIGN_VAR_PAGE_SECOND_LABEL";
    protected JLabel mVariablesLabel;
    protected SrcVariableList mSrcVariableList;
    protected JScrollPane mSrcScrollPane;
    protected JLabel mStrataLabel;
    protected JScrollPane mStrataScrollPane;
    protected JLabel mClustersLabel;
    protected TargetVariableList mClustersTargetVarList;
    protected JScrollPane mClusterScrollPane;
    protected boolean mFirstVisit;
    protected PFATree mMenuTree;
    protected TargetVariableList mStrataVarList;
    protected JLabel mSampleWtLabel;
    protected TargetVariableList mSampleWtTargetVarList;
    protected JScrollPane mSampleWtScrollPane;
    protected JLabel mStageLabel;
    protected StringTextField mStageTextField;
    protected ArrowButton mStrataArrowButton;
    protected ArrowButton mClusterArrowButton;
    protected ArrowButton mSampleWtArrowButton;
    protected Map<String, Map<String, String>> mValueLabelMap;
    protected int mStageNum = 0;
    protected boolean isStageUpdatedFlag;

    BasePFAStageDesignPage(String string, BaseWizardDialog baseWizardDialog, PFATree pFATree, int n) {
        super(string, baseWizardDialog.getResString(PREPARE_FOR_ANALYSIS_WIZARD_TITLE), baseWizardDialog, true);
        this.mMenuTree = pFATree;
        this.mFirstVisit = true;
        this.mStageNum = n;
        assert (this.mStageNum != 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_anal_wiz_design";
    }

    public abstract Map<String, Vector<String>> getStrataVariablesWithMissingVals();

    public abstract Map<String, Vector<String>> getStrataVariablesWithVals();

    @Override
    public abstract boolean preMoveVariables(ISpssVariable[] var1, VariableList var2);

    protected abstract String getStageTitle();

    public Vector<String> getStrataVarList() {
        Vector<String> vector = new Vector<String>();
        int n = this.mStrataVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string = this.mStrataVarList.getModel().getElementAt(i).getName();
            vector.add(string);
        }
        return vector;
    }

    public Vector<String> getClusterVarList() {
        Vector<String> vector = new Vector<String>();
        int n = this.mClustersTargetVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string = this.mClustersTargetVarList.getModel().getElementAt(i).getName();
            vector.add(string);
        }
        return vector;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mStageTextField)) {
            this.setStageLabel();
            this.mMenuTree.updateUI();
        }
    }

    public String getStageLabel() {
        return this.mStageTextField.getText();
    }

    public SrcVariableList getSrcVarList() {
        return this.mSrcVariableList;
    }

    public TargetVariableList getStrataTargetList() {
        return this.mStrataVarList;
    }

    public TargetVariableList getClusterList() {
        return this.mClustersTargetVarList;
    }

    public Map<String, Map<String, String>> getValueLabelMap() {
        return this.mValueLabelMap;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(this.mStageNum, true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(1, true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(1, true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)((PFAWizardDlg)this.mWizardDialog).getWizardModel().getPage("WELCOME_PAGE_ID");
        if (pFAWelcomePage.isEditPlanFileRadioSelected()) {
            ((PFAWizardDlg)this.mWizardDialog).setPlanFileModified(1, true);
        }
    }

    protected void initVars() {
        this.mSrcVariableList = new SrcVariableList();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        this.mVariablesLabel = DialogUtil.createLabel(this.mWizardDialog, VARIABLES_LABEL);
        this.mVariablesLabel.setLabelFor(this.mSrcVariableList);
        this.mSrcVariableList.setSelectedIndex(0);
        this.mStrataVarList = new TargetVariableList();
        this.mStrataVarList.getModel().addListDataListener(this);
        this.mStrataScrollPane = new JScrollPane(this.mStrataVarList);
        this.mStrataVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mStrataVarList.getFixedCellHeight() * 3 + 2));
        this.mStrataScrollPane.setPreferredSize(this.mStrataVarList.getMinimumSize());
        this.mStrataLabel = DialogUtil.createLabel(this.mWizardDialog, STRATA_LABEL);
        this.mStrataLabel.setLabelFor(this.mStrataVarList);
        this.mClustersTargetVarList = new TargetVariableList();
        this.mClustersTargetVarList.getModel().addListDataListener(this);
        this.mClusterScrollPane = new JScrollPane(this.mClustersTargetVarList);
        this.mClustersTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mClustersTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mClusterScrollPane.setPreferredSize(this.mClustersTargetVarList.getMinimumSize());
        this.mClustersLabel = DialogUtil.createLabel(this.mWizardDialog, CLUSTERS_LABEL);
        this.mClustersLabel.setLabelFor(this.mClustersTargetVarList);
        this.mClusterArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mClusterArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mClusterArrowButton.registerVariableList(this.mClustersTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mStrataArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStrataArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mStrataArrowButton.registerVariableList(this.mStrataVarList, SpssArrowButton.ButtonOrientation.left);
        this.mStrataArrowButton.setVarMoveHandler(this);
        this.mStageTextField = new StringTextField(12);
        this.mStageLabel = DialogUtil.createLabel(this.mWizardDialog, STAGE_LABEL);
        this.mStageLabel.setLabelFor((Component)((Object)this.mStageTextField));
        this.mStageTextField.addFocusListener(this);
        this.mValueLabelMap = new HashMap<String, Map<String, String>>();
    }

    protected void addListeners() {
        this.mStrataVarList.getModel().addListDataListener(this);
        this.mClustersTargetVarList.getModel().addListDataListener(this);
        this.mStageTextField.getDocument().addDocumentListener(this);
    }

    protected void removeListeners() {
        this.mStrataVarList.getModel().removeListDataListener(this);
        this.mClustersTargetVarList.getModel().removeListDataListener(this);
        this.mStageTextField.getDocument().removeDocumentListener(this);
    }

    protected int showMessage(String string) {
        return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
    }

    protected Vector<String> getVIMap(SpssVariable spssVariable) {
        Vector<String> vector = new Vector<String>();
        IValueLabelMap iValueLabelMap = spssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            vector.add((String)entry.getValue());
        }
        return vector;
    }

    protected Vector<String> getSampleValues(SpssVariable spssVariable) {
        Vector<String> vector = new Vector<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IValueLabelMap iValueLabelMap = spssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        if (set.size() > 0) {
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                String string = (String)entry.getValue();
                vector.add(CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)spssVariable.getFormat()));
                hashMap.put(CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)spssVariable.getFormat()), string);
            }
            this.mValueLabelMap.put(spssVariable.getName(), hashMap);
        }
        return vector;
    }

    protected FocusTraversalPolicy getTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVariableList);
        vector.add(this.mStrataArrowButton);
        vector.add(this.mClusterArrowButton);
        vector.add(this.mStrataVarList);
        vector.add(this.mClustersTargetVarList);
        vector.add(this.mStageTextField);
        if (this.mStageNum == 1) {
            vector.add(this.mSampleWtArrowButton);
            vector.add(this.mSampleWtTargetVarList);
        }
        Vector<Object> vector2 = ((PFAWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        return new DialogFocusTraversalPolicy(vector2, false);
    }

    protected void setTreeNodeSelected() {
        this.mMenuTree.removeTreeSelectionListener(this.mMenuTree);
        PFATreeNode pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap(this.getID());
        pFATreeNode.setIsVisited(true);
        int n = 0;
        if (this.mStageNum == 1) {
            n = 0;
        } else if (this.mStageNum == 2) {
            n = 5;
        } else if (this.mStageNum == 3) {
            n = 9;
        }
        this.mMenuTree.setSelectionPath(this.mMenuTree.getNextMatch(pFATreeNode.getMenuName(), n, Position.Bias.Forward));
        this.mMenuTree.addTreeSelectionListener(this.mMenuTree);
        if (this.mStageNum == 1) {
            pFATreeNode = ((PFAWizardDlg)this.mWizardDialog).getFromPageNodeMap("WELCOME_PAGE_ID");
            pFATreeNode.setIsVisited(true);
        }
    }

    protected void setupLabelPanel() {
        if (PFAWizardDlg.sLabelPanel.getComponentCount() > 0) {
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(0)).setText(this.getStageTitle());
            ((JTextArea)PFAWizardDlg.sLabelPanel.getComponent(1)).setText(this.mWizardDialog.getResString(DESIGN_VAR_PAGE_FIRST_LABEL));
            ((JLabel)PFAWizardDlg.sLabelPanel.getComponent(2)).setText(this.mWizardDialog.getResString(DESIGN_VAR_PAGE_SECOND_LABEL));
        }
        DialogUtil.normalizeLabelWidths(PFAWizardDlg.sLabelPanel);
    }

    protected JPanel setupStagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        DialogUtil.applyTopBorder(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(15, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mStageTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    protected void setStageLabel() {
        String string = "";
        int n = 0;
        int n2 = 0;
        if (this.mStageNum == 1) {
            n = 2;
            n2 = 1;
            string = STAGE_ONE;
        } else if (this.mStageNum == 2) {
            n = 3;
            n2 = 2;
            string = STAGE_TWO;
        } else if (this.mStageNum == 3) {
            n = 4;
            n2 = 3;
            string = STAGE_THREE;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mMenuTree.getModel();
        PFAWelcomePage pFAWelcomePage = (PFAWelcomePage)this.mWizardDialog.getWizardModel().getPage("WELCOME_PAGE_ID");
        PFATreeNode pFATreeNode = pFAWelcomePage.isEditPlanFileRadioSelected() ? (PFATreeNode)((PFATreeNode)defaultTreeModel.getRoot()).getChildAt(n) : (PFATreeNode)((PFATreeNode)defaultTreeModel.getRoot()).getChildAt(n2);
        if (this.mStageTextField.getText().length() > 0) {
            pFATreeNode.setUserObject(this.mWizardDialog.getResString(string) + ": " + this.mStageTextField.getText());
            pFATreeNode.setMenuName(this.mWizardDialog.getResString(string) + ": " + this.mStageTextField.getText());
        } else {
            pFATreeNode.setUserObject(this.mWizardDialog.getResString(string));
        }
    }
}

