/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OrdinalRegressionStatistics
extends BaseSubDialog {
    private SpssButtonGroup mButtonGroup;
    private JCheckBox mEstimateCheckBox;
    private JCheckBox mExponentiatedCheckBox;
    private JCheckBox mStdErrorCheckBox;
    private JCheckBox mConfidenceIntervalCheckBox;
    private JCheckBox mTCheckBox;
    private JCheckBox mCovarianceCheckBox;
    private JCheckBox mCorrelationsCheckBox;
    private JCheckBox mDesignCheckBox;
    private JCheckBox mSquareRootCheckBox;
    private JCheckBox mPseudoCheckBox;
    private JCheckBox mClassificationCheckBox;
    private JCheckBox mSummaryCheckBox;
    private JCheckBox mSampleDesignCheckBox;
    private GridBagConstraints mConstraints;
    private JCheckBox mWaldCheck;
    private JCheckBox mParameterCheck;
    private JCheckBox mCovGeneralizedCheck;

    public OrdinalRegressionStatistics(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csord_stats";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        JPanel jPanel2 = this.setupParametersPanel();
        JPanel jPanel3 = this.setupModelFitPanel();
        JPanel jPanel4 = this.setupPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupParallelPanel(), this.mConstraints, 0, 2, 1, 1, n, insets);
        this.mConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mConstraints, 0, 3, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPseudoCheckBox);
        vector.add(this.mClassificationCheckBox);
        vector.add(this.mEstimateCheckBox);
        vector.add(this.mExponentiatedCheckBox);
        vector.add(this.mStdErrorCheckBox);
        vector.add(this.mConfidenceIntervalCheckBox);
        vector.add(this.mTCheckBox);
        vector.add(this.mCovarianceCheckBox);
        vector.add(this.mCorrelationsCheckBox);
        vector.add(this.mDesignCheckBox);
        vector.add(this.mSquareRootCheckBox);
        vector.add(this.mWaldCheck);
        vector.add(this.mParameterCheck);
        vector.add(this.mCovGeneralizedCheck);
        vector.add(this.mSummaryCheckBox);
        vector.add(this.mSampleDesignCheckBox);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mPseudoCheckBox.setSelected(true);
        this.mSummaryCheckBox.setSelected(true);
        this.mSampleDesignCheckBox.setSelected(true);
    }

    private void initVars() {
        this.mEstimateCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_ESTIMATE_CHECKBOX"));
        this.mExponentiatedCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_STATISTICS_EXP_ESTIMATE_CHECKBOX"));
        this.mStdErrorCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_STD_ERROR_CHECKBOX"));
        this.mConfidenceIntervalCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CONFIDENCE_INTERVAL_CHECKBOX"));
        this.mTCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_T_TEST_CHECKBOX"));
        this.mCovarianceCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_COVARIANCE_CHECKBOX"));
        this.mCorrelationsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CORRELATION_CHECKBOX"));
        this.mDesignCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_DESIGN_CHECKBOX"));
        this.mSquareRootCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_SQUAREROOT_CHECKBOX"));
        this.mPseudoCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_STATISTICS_PSEUDO_CHECKBOX"));
        this.mClassificationCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_STATISTICS_CLASSIFICATION_CHECKBOX"));
        this.mSummaryCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_STATISTICS_SUMMARY_CHECKBOX"));
        this.mSampleDesignCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_STATISTICS_SAMPLE_CHECKBOX"));
        this.mConstraints = new GridBagConstraints();
        this.mWaldCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_CS_ORDINAL_STATISTICS_WALD_CHECKBOX"));
        this.mParameterCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_CS_ORDINAL_STATISTICS_PARAMETER_CHECKBOX"));
        this.mCovGeneralizedCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_CS_ORDINAL_STATISTICS_GENERALIZED_CHECKBOX"));
        this.mButtonGroup = new SpssButtonGroup();
    }

    private JPanel setupModelFitPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPseudoCheckBox, this.mClassificationCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_LOGISTIC_REGRESSION_STATISTICS_MODEL_FIT_LABEL"), 2);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupParametersPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mEstimateCheckBox, this.mExponentiatedCheckBox, this.mStdErrorCheckBox, this.mConfidenceIntervalCheckBox, this.mTCheckBox, this.mCovarianceCheckBox, this.mCorrelationsCheckBox, this.mDesignCheckBox, this.mSquareRootCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_LOGISTIC_REGRESSION_STATISTICS_PARAMETERS_LABEL"), 5);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupParallelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mWaldCheck, this.mParameterCheck, this.mCovGeneralizedCheck};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_CS_ORDINAL_STATISTICS_PARALLEL_PANEL_LABEL"), 3);
        this.mButtonGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSummaryCheckBox, this.mSampleDesignCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, "", 2);
        this.mButtonGroup.add(this.mSummaryCheckBox);
        this.mButtonGroup.add(this.mSampleDesignCheckBox);
        return jPanel;
    }
}

