/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionWarningDialog;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class OrdinalRegressionSaveDialog
extends BaseSubDialog
implements ItemListener,
FocusListener {
    public static final String REPLACE_EXIXTING_CHECK = "IDS_CS_ORDINAL_SAVE_REPLACE_CHECK";
    public static final String EXPORT_DATA_CHECK = "IDS_CS_ORDINAL_SAVE_EXPORT_MODEL_CHECK";
    public static final String EXPORT_XML_CHECK = "IDS_CS_ORDINAL_SAVE_EXPORT_XML_CHECK";
    public static final String CREATE_DATA_RADIO = "IDS_CS_ORDINAL_SAVE_CREATE_DATA_RADIO";
    public static final String WRITE_DATA_RADIO = "IDS_CS_ORDINAL_SAVE_WRITE_DATA_RADIO";
    public static final String COVARIANCE_RADIO = "IDS_CS_ORDINAL_SAVE_COVARIANCE_RADIO";
    public static final String CORRELATION_RADIO = "IDS_CS_ORDINAL_SAVE_CORRELATION_RADIO";
    public static final String XML_COVARIANCE_RADIO = "IDS_CS_ORDINAL_SAVE_XML_COVARIANCE_RADIO";
    public static final String PARAMETER_ONLY_RADIO = "IDS_CS_ORDINAL_SAVE_PARAMETER_ONLY_RADIO";
    public static final String DATASET_FILE_BUTTON = "IDS_CS_ORDINAL_SAVE_DATASET_FILE_BUTTON";
    public static final String XML_FILE_BUTTON = "IDS_CS_ORDINAL_SAVE_XML_FILE_BUTTON";
    public static final String XML_FILE_FIELD = "IDS_CS_ORDINAL_SAVE_DATA_FILE_PATH";
    public static final String DATASET_FILE_TEXT_FIELD = "IDS_DATASET_FILE_TEXT_FIELD";
    public static final String SAVE_TEXT_FIELD0 = "IDS_ORDINAL_SAVE_TEXT_FIELD0";
    public static final String SAVE_TEXT_FIELD1 = "IDS_ORDINAL_SAVE_TEXT_FIELD1";
    public static final String SAVE_TEXT_FIELD2 = "IDS_ORDINAL_SAVE_TEXT_FIELD2";
    public static final String SAVE_TEXT_FIELD3 = "IDS_ORDINAL_SAVE_TEXT_FIELD3";
    public static final String SAVE_TEXT_FIELD4 = "IDS_ORDINAL_SAVE_TEXT_FIELD4";
    public static final String DATA_SET_TEXT_FIELD = "IDS_DATA_SET_TEXT_FIELD";
    private JCheckBox[] mSaveVarsCheck;
    private StringTextField[] mSaveTextField;
    private JLabel[] mSaveLabels;
    private StringTextField mDataSetField;
    private JCheckBox mReplaceCheck;
    private JCheckBox mExportModelCheck;
    private JCheckBox mExportXMLCheck;
    private JRadioButton mCreateDataRadio;
    private JRadioButton mWriteDataRadio;
    private JRadioButton mCovarianceRadio;
    private JRadioButton mCorrelationRadio;
    private JRadioButton mXMLCovarianceRadio;
    private JRadioButton mParameterOnlyRadio;
    private JButton mDataFileButton;
    private JButton mXMLFileButton;
    private SpssButtonGroup mDataSetRadioGroup;
    private SpssButtonGroup mDataCovarianceGroup;
    private SpssButtonGroup mXMLCovarianceGroup;
    private JLabel mDataNameLabel;
    private FileTextField mFilePath;
    private FileTextField mSaveFilePath;
    private boolean mIsDataSetFileButtonPressed;

    public OrdinalRegressionSaveDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csord_save";
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.mSaveFilePath.getText().trim().equals("")) {
            this.mSaveFilePath.setEnabled(true);
            this.mSaveFilePath.setText(this.mSaveFilePath.getText());
        }
        if (!this.mFilePath.getText().trim().equals("")) {
            this.mFilePath.setEnabled(true);
            this.mFilePath.setText(this.mFilePath.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        StringTextField stringTextField = (StringTextField)focusEvent.getSource();
        for (StringTextField stringTextField2 : this.mSaveTextField) {
            if (stringTextField != stringTextField2) continue;
            stringTextField2.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        for (int i = 0; i < this.mSaveVarsCheck.length; ++i) {
            if (itemEvent.getSource() != this.mSaveVarsCheck[i]) continue;
            this.mSaveLabels[i].setEnabled(this.mSaveVarsCheck[i].isSelected());
            this.mSaveTextField[i].setEditable(this.mSaveVarsCheck[i].isSelected());
            this.mSaveTextField[i].setEnabled(this.mSaveVarsCheck[i].isSelected());
            this.mSaveTextField[i].setOpaque(this.mSaveVarsCheck[i].isSelected());
        }
        if (itemEvent.getSource() == this.mExportModelCheck) {
            this.canEnableExportDataPanel();
            this.mSaveFilePath.setEnabled(this.mExportModelCheck.isSelected() && !this.mCreateDataRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mExportXMLCheck) {
            this.mXMLFileButton.setEnabled(this.mExportXMLCheck.isSelected());
            this.mXMLCovarianceRadio.setEnabled(this.mExportXMLCheck.isSelected());
            this.mParameterOnlyRadio.setEnabled(this.mExportXMLCheck.isSelected());
            this.mFilePath.setEnabled(this.mExportXMLCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mCreateDataRadio || itemEvent.getSource() == this.mWriteDataRadio) {
            this.mDataNameLabel.setEnabled(this.mCreateDataRadio.isSelected());
            this.mSaveFilePath.setEnabled(this.mExportModelCheck.isSelected() && !this.mCreateDataRadio.isSelected());
        }
        this.mDataFileButton.setEnabled(this.mExportModelCheck.isSelected() && !this.mCreateDataRadio.isSelected());
        this.mDataSetField.setEnabled(this.mCreateDataRadio.isSelected() && this.mExportModelCheck.isSelected());
        this.mDataSetField.setOpaque(this.mCreateDataRadio.isSelected() && this.mExportModelCheck.isSelected());
    }

    @Override
    public boolean continuePressed() {
        CharSequence charSequence;
        int n;
        int n2;
        for (n2 = 0; n2 < this.mSaveTextField.length; ++n2) {
            if (!this.mSaveVarsCheck[n2].isSelected() || (n = VarNameValidator.validateSPSSName((String)this.mSaveTextField[n2].getText(), (boolean)true).asInt()) <= 0 || n == 100) continue;
            DialogUtil.showBadSpssVarNameWarning(n, this);
            this.mSaveTextField[n2].requestFocus();
            return false;
        }
        if (this.isDuplicateTextFieldValue(0, 1) || this.isDuplicateTextFieldValue(0, 2) || this.isDuplicateTextFieldValue(1, 2)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_ORDINAL_DUPLICATE_FIELD_VALUE_ERROR"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mExportModelCheck.isSelected() && this.mCreateDataRadio.isSelected() && DatasetNameValidator.validateDatasetName((String)this.mDataSetField.getText(), (Component)((Object)this)) != 1) {
            this.mDataSetField.requestFocus();
            return false;
        }
        n2 = this.mDataFileButton.isEnabled() && this.mSaveFilePath.getText() != null && this.mSaveFilePath.getText().length() == 0 ? 1 : 0;
        int n3 = n = this.mXMLFileButton.isEnabled() && this.mFilePath.getText() != null && this.mFilePath.getText().length() == 0 ? 1 : 0;
        if (n2 != 0 || n != 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CS_ORDINAL_SAVE_FILE_FILED_EMPTY_ERROR"), VersionInfo.getAppVersionString());
            return false;
        }
        if (!this.mReplaceCheck.isSelected() && (charSequence = this.getReplaceString("\n")).length() > 0) {
            OrdinalRegressionWarningDialog ordinalRegressionWarningDialog = new OrdinalRegressionWarningDialog(this, charSequence.toString());
            if (!ordinalRegressionWarningDialog.mIsOkPressed) {
                return false;
            }
            this.mReplaceCheck.setSelected(true);
        }
        n2 = 1;
        n = 1;
        if (this.mExportModelCheck.isSelected() && this.mWriteDataRadio.isSelected()) {
            charSequence = String.format(this.getResString("ERR_CS_ORDINAL_SAVE_FILE_ALREADY_EXISTS"), this.mSaveFilePath.getText());
            n2 = this.showFileAlreadyExistError((String)charSequence, this.mSaveFilePath.getText()) ? 1 : 0;
        }
        if (n2 != 0 && this.mExportXMLCheck.isSelected()) {
            charSequence = String.format(this.getResString("ERR_CS_ORDINAL_SAVE_FILE_ALREADY_EXISTS"), this.mSaveFilePath.getText());
            n = this.showFileAlreadyExistError((String)charSequence, this.mFilePath.getText()) ? 1 : 0;
        }
        return n2 != 0 && n != 0;
    }

    public StringBuffer getReplaceString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mSaveTextField.length; ++i) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (!this.mSaveVarsCheck[i].isSelected() || iSpssDataSrc.findVarIndex(this.mSaveTextField[i].getText()) == -1) continue;
            stringBuffer.append(this.mSaveTextField[i].getText()).append(string);
        }
        return stringBuffer;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setMainPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void canEnableExportDataPanel() {
        this.mCreateDataRadio.setEnabled(this.mExportModelCheck.isSelected());
        this.mDataNameLabel.setEnabled(this.mExportModelCheck.isSelected());
        this.mWriteDataRadio.setEnabled(this.mExportModelCheck.isSelected());
        this.mCovarianceRadio.setEnabled(this.mExportModelCheck.isSelected());
        this.mCorrelationRadio.setEnabled(this.mExportModelCheck.isSelected());
        this.mDataSetField.setEnabled(this.mExportModelCheck.isSelected());
        this.mDataSetField.setOpaque(this.mExportModelCheck.isSelected());
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < this.mSaveLabels.length; ++n) {
            vector.add(this.mSaveVarsCheck[n]);
            vector.add(this.mSaveTextField[n]);
        }
        vector.add(this.mReplaceCheck);
        vector.add(this.mExportModelCheck);
        vector.add(this.mDataSetRadioGroup);
        vector.add(this.mDataSetField);
        vector.add(this.mDataFileButton);
        vector.add(this.mDataCovarianceGroup);
        vector.add(this.mExportXMLCheck);
        vector.add(this.mXMLFileButton);
        vector.add(this.mXMLCovarianceGroup);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        Object[] objectArray;
        int n;
        this.mSaveVarsCheck = new JCheckBox[5];
        for (n = 0; n < this.mSaveVarsCheck.length; ++n) {
            objectArray = "IDS_CS_ORDINAL_SAVE_CHECK" + n;
            this.mSaveVarsCheck[n] = new JCheckBox(new ToggleButtonAction(this, (String)objectArray));
        }
        this.mSaveTextField = new StringTextField[5];
        for (n = 0; n < this.mSaveTextField.length; ++n) {
            this.mSaveTextField[n] = new StringTextField();
            objectArray = "SAVE_TEXT_FIELD" + n;
            this.mSaveTextField[n].setAction(new TextFieldAction(this, (String)objectArray));
        }
        this.mSaveLabels = new JLabel[5];
        this.mReplaceCheck = new JCheckBox(new ToggleButtonAction(this, REPLACE_EXIXTING_CHECK));
        this.mExportModelCheck = new JCheckBox(new ToggleButtonAction(this, EXPORT_DATA_CHECK));
        this.mExportXMLCheck = new JCheckBox(new ToggleButtonAction(this, EXPORT_XML_CHECK));
        this.mDataSetField = new StringTextField();
        this.mDataSetField.setAction(new TextFieldAction(this, DATA_SET_TEXT_FIELD));
        this.mCreateDataRadio = new JRadioButton(new ToggleButtonAction(this, CREATE_DATA_RADIO));
        this.mWriteDataRadio = new JRadioButton(new ToggleButtonAction(this, WRITE_DATA_RADIO));
        this.mCovarianceRadio = new JRadioButton(new ToggleButtonAction(this, COVARIANCE_RADIO));
        this.mCorrelationRadio = new JRadioButton(new ToggleButtonAction(this, CORRELATION_RADIO));
        this.mXMLCovarianceRadio = new JRadioButton(new ToggleButtonAction(this, XML_COVARIANCE_RADIO));
        this.mParameterOnlyRadio = new JRadioButton(new ToggleButtonAction(this, PARAMETER_ONLY_RADIO));
        this.mFilePath = new FileTextField();
        ControlAction controlAction = new TextFieldAction(this, XML_FILE_FIELD);
        this.mFilePath.setAction(controlAction);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.setText("");
        this.mIsDataSetFileButtonPressed = false;
        this.mSaveFilePath = new FileTextField();
        controlAction = new TextFieldAction(this, DATASET_FILE_TEXT_FIELD);
        this.mSaveFilePath.setAction(controlAction);
        this.mSaveFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mSaveFilePath.setText("");
        controlAction = new ToggleButtonAction(this, DATASET_FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionSaveDialog.this.mIsDataSetFileButtonPressed = true;
                OrdinalRegressionSaveDialog.this.openFileDialog(OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_FILE_DIALOG_TITLE"), OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_FILTER_NAME_TYPE"), OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_FILE_EXTENSION"));
            }
        };
        this.mDataFileButton = new JButton(controlAction);
        controlAction = new ToggleButtonAction(this, XML_FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionSaveDialog.this.mIsDataSetFileButtonPressed = false;
                OrdinalRegressionSaveDialog.this.openFileDialog(OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_XML_FILE_DIALOG_TITLE"), OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_XML_FILTER_NAME_TYPE"), OrdinalRegressionSaveDialog.this.getResString("IDS_CS_ORDINAL_XML_FILE_EXTENSION"));
            }
        };
        this.mXMLFileButton = new JButton(controlAction);
        this.mSaveLabels[0] = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_NAME_LABEL1");
        this.mSaveLabels[1] = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_NAME_LABEL2");
        this.mSaveLabels[2] = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_NAME_LABEL3");
        this.mSaveLabels[3] = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_ROOT_LABEL1");
        this.mSaveLabels[4] = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_ROOT_LABEL2");
        for (JCheckBox object : this.mSaveVarsCheck) {
            object.addItemListener(this);
        }
        this.mDataSetRadioGroup = new SpssButtonGroup();
        this.mXMLCovarianceGroup = new SpssButtonGroup();
        this.mDataCovarianceGroup = new SpssButtonGroup();
        this.mDataSetRadioGroup.add(this.mCreateDataRadio);
        this.mDataSetRadioGroup.add(this.mWriteDataRadio);
        this.mDataCovarianceGroup.add(this.mCovarianceRadio);
        this.mDataCovarianceGroup.add(this.mCorrelationRadio);
        this.mXMLCovarianceGroup.add(this.mXMLCovarianceRadio);
        this.mXMLCovarianceGroup.add(this.mParameterOnlyRadio);
        this.mExportModelCheck.addItemListener(this);
        this.mExportXMLCheck.addItemListener(this);
        this.mCreateDataRadio.addItemListener(this);
        this.mWriteDataRadio.addItemListener(this);
        for (StringTextField stringTextField : this.mSaveTextField) {
            stringTextField.addFocusListener(this);
        }
    }

    private boolean showFileAlreadyExistError(String string, String string2) {
        boolean bl;
        boolean bl2 = false;
        RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string2);
        boolean bl3 = bl = !remoteFileStatus.errorOccurred();
        if (bl) {
            boolean bl4 = bl2 = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
        }
        if (bl2) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            return n == 0;
        }
        return true;
    }

    private void openFileDialog(String string, String string2, String string3) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string4 = remoteFileChooser.getSelectedFilePath();
            if (!string3.regionMatches(true, 0, string4, string4.length() - string3.length(), string3.length())) {
                string4 = string4 + string3;
            }
            if (this.mIsDataSetFileButtonPressed) {
                this.mSaveFilePath.setText(string4);
            } else {
                this.mFilePath.setText(string4);
            }
        }
    }

    private void setDefaults() {
        this.mSaveTextField[0].setText(this.getResString("IDS_CS_ORDINAL_OPTIONS_TEXT_FIELD0"));
        this.mSaveTextField[1].setText(this.getResString("IDS_CS_ORDINAL_OPTIONS_TEXT_FIELD1"));
        this.mSaveTextField[2].setText(this.getResString("IDS_CS_ORDINAL_OPTIONS_TEXT_FIELD2"));
        this.mSaveTextField[3].setText(this.getResString("IDS_CS_ORDINAL_OPTIONS_TEXT_FIELD3"));
        this.mSaveTextField[4].setText(this.getResString("IDS_CS_ORDINAL_OPTIONS_TEXT_FIELD4"));
        for (JCheckBox object : this.mSaveVarsCheck) {
            object.setSelected(false);
        }
        for (JComponent jComponent : this.mSaveLabels) {
            jComponent.setEnabled(false);
        }
        for (StringTextField stringTextField : this.mSaveTextField) {
            stringTextField.setEnabled(false);
            stringTextField.setEditable(false);
            stringTextField.setOpaque(false);
        }
        this.mExportModelCheck.setSelected(false);
        this.mCreateDataRadio.setSelected(true);
        this.mCovarianceRadio.setSelected(true);
        this.mExportXMLCheck.setSelected(false);
        this.mXMLCovarianceRadio.setSelected(true);
        this.mXMLFileButton.setEnabled(false);
        this.canEnableExportDataPanel();
        this.mXMLCovarianceRadio.setEnabled(false);
        this.mParameterOnlyRadio.setEnabled(false);
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setFocusable(false);
        this.mSaveFilePath.setFocusable(false);
        this.mDataFileButton.setEnabled(false);
        this.mSaveFilePath.setOpaque(false);
        this.mSaveFilePath.setEditable(false);
    }

    private boolean isDuplicateTextFieldValue(int n, int n2) {
        if (this.mSaveVarsCheck[n].isSelected() && this.mSaveVarsCheck[n2].isSelected() && this.mSaveTextField[n].getText().equals(this.mSaveTextField[n2].getText())) {
            this.mSaveTextField[n].requestFocus();
            return true;
        }
        return false;
    }

    private void setMainPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setSavePanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.setupExportPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setSavePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.setupSaveVariablesPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_SAVE_VARIABLES_LABEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 3;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, 0);
        JSeparator jSeparator = new JSeparator(0);
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(n2, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.setupTextFieldPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jSeparator, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mReplaceCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel2;
    }

    private JPanel setupSaveVariablesPanel() {
        JPanel jPanel = PanelFactory.getBasicPanel(this.mSaveVarsCheck, PanelFactory.PanelType.yaxis, null);
        DialogUtil.createButtonGroup(jPanel);
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            ((JCheckBox)jPanel.getComponent(i)).addItemListener(this);
        }
        return jPanel;
    }

    private JPanel setupTextFieldPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        for (int i = 0; i < this.mSaveLabels.length; ++i) {
            this.mSaveLabels[i].setLabelFor((Component)((Object)this.mSaveTextField[i]));
        }
        DialogUtil.addUsingGBL(jPanel, this.mSaveLabels[0], gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSaveLabels[1], gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSaveLabels[2], gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSaveLabels[3], gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSaveLabels[4], gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveTextField[0]), gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveTextField[1]), gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveTextField[2]), gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveTextField[3]), gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveTextField[4]), gridBagConstraints, 1, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_EXPORT_MODEL_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupExportDataPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        JSeparator jSeparator = new JSeparator(1);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupExportXMLPanel(), gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupExportDataPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mDataNameLabel = DialogUtil.createLabel(this, "IDS_CS_ORDINAL_SAVE_DATA_NAME_LABEL");
        this.mDataNameLabel.setLabelFor((Component)((Object)this.mDataSetField));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExportModelCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, insets.left + 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDataRadio, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        insets2 = new Insets(0, insets.left + 60, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDataNameLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataSetField), gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2 = new Insets(0, insets.left + 30, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mWriteDataRadio, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        insets2 = new Insets(0, insets.left + 60, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButton, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSaveFilePath), gridBagConstraints, 1, 4, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        insets2 = new Insets(insets.top + 20, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceRadio, gridBagConstraints, 0, 5, 3, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationRadio, gridBagConstraints, 0, 6, 3, 1, n, insets);
        return jPanel;
    }

    private JPanel setupExportXMLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExportXMLCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets = new Insets(insets2.top + 5, insets2.left + 30, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mXMLFileButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(insets2.top + 5, insets2.left + 3, insets2.bottom + 1, insets2.right + 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePath), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets = new Insets(insets2.top + 20, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mXMLCovarianceRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mParameterOnlyRadio, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }
}

