/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OrdinalRegressionResponseProbability
extends BaseSubDialog {
    static final String LOWEST_RADIO = "IDS_CS_ORDINAL_LOWEST_RADIO";
    static final String HIGHEST_RADIO = "IDS_CS_ORDINAL_HIGHEST_RADIO";
    private JRadioButton mLowestRadio;
    private JRadioButton mHighestRadio;
    private SpssButtonGroup mRadioButtongroup;

    public OrdinalRegressionResponseProbability(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csord_resprob";
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        dialogDataModel.putBoolean("IDS_LOGISTIC_PROBABILITY_VALUE", this.mLowestRadio.isSelected());
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getBoolean("IDS_LOGISTIC_PROBABILITY_VALUE") != null) {
            this.mLowestRadio.setSelected(dialogDataModel.getBoolean("IDS_LOGISTIC_PROBABILITY_VALUE"));
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupProbabilityPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LOWEST_RADIO);
        this.mLowestRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HIGHEST_RADIO);
        this.mHighestRadio = new JRadioButton(toggleButtonAction);
        this.mRadioButtongroup = new SpssButtonGroup();
        this.mRadioButtongroup.add(this.mLowestRadio);
        this.mRadioButtongroup.add(this.mHighestRadio);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtongroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mLowestRadio.setSelected(true);
    }

    private JPanel setupProbabilityPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PROBABILITY_PANEL_TITLE")));
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLowestRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mHighestRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }
}

