/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonOptionsPanel;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OrdinalRegressionOptions
extends BaseSubDialog
implements ItemListener {
    public static final String MAX_ITERATION_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL";
    public static final String MAX_STEP_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL";
    public static final String MIN_PARAMETER_KEY = "MIN_CHANGE_PARAMETER_KEY";
    public static final String MIN_LOG_KEY = "MIN_CHANGE_LOG_KEY";
    public static final String TYPE_PARAMETER_KEY = "TYPE_PARAMETER_KEY";
    public static final String TYPE_LOG_KEY = "TYPE_LOG_KEY";
    public static final String START_ITERATION_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_START_ITERATION_LABEL";
    public static final String INCREMENT_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL";
    public static final String LIMIT_PARA_CHECKBOX_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_PARA_ESTIMATES_CHECKBOX";
    public static final String LIMIT_LOG_CHECKBOX_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_LOG_CHECKBOX";
    public static final String CHECK_DATA_POINTS_CHECKBOX = "IDS_LOGISTIC_REGRESSION_OPTIONS_CHECK_DATAPOINTS_CHECKBOX";
    public static final String BEFORE_SWITCHING_TEXT_FIELD = "IDS_CS_ORDINAL_BEFORE_SWITCHING_FIELD";
    public static final String ORDINAL_NEWTON_RADIO = "IDS_CS_ORDINAL_NEWTON_RADIO";
    public static final int MAX_ITERATIONS = 100;
    public static final int MAX_STEP_ITERATIONS = 5;
    public static final String MIN_PARAMETER = "0.000001";
    public static final int START_ITERATION = 20;
    public static final int INCREMENT = 1;
    private IntTextField mMaxIterationTextfield;
    private IntTextField mMaxStepTextfield;
    private JLabel mMinChangeParameterLabel;
    private FloatTextField mMinChangeParameterTextfield;
    private JLabel mTypeParameterLabel;
    private JComboBox mTypeParameterComboBox;
    private JLabel mMinChangeLogLabel;
    private FloatTextField mMinChangeLogTextfield;
    private JLabel mTypeLogLabel;
    private JComboBox mTypeLogComboBox;
    private JCheckBox mCheckDataPointsCheckBox;
    private JLabel mStartIterationLabel;
    private IntTextField mStartIterationTextField;
    private JCheckBox mDisplayHistoryCheckBox;
    private JLabel mIncrementLabel;
    private IntTextField mIncrementTextField;
    private ComplexSamplesCommonOptionsPanel mMissingValuesPanel;
    private JCheckBox mLimitParameterEstimatesCheckBox;
    private JCheckBox mLimitLogLikelihoodCheckBox;
    private JRadioButton mNewtonRadio;
    private JRadioButton mFisherRadio;
    private JRadioButton mNewFisherRadio;
    private IntTextField mMaxBeforeSwitchField;
    private SpssButtonGroup mNewRaphsonGroup;

    public OrdinalRegressionOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csord_options";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mLimitParameterEstimatesCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mMinChangeParameterTextfield, this.mTypeParameterLabel, this.mTypeParameterComboBox};
            DialogUtil.enableHTMLComponent(this.mMinChangeParameterLabel, this.mLimitParameterEstimatesCheckBox.isSelected());
            this.setStateOfComponents(jComponentArray, this.mLimitParameterEstimatesCheckBox);
        } else if (itemEvent.getSource() == this.mLimitLogLikelihoodCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mMinChangeLogTextfield, this.mTypeLogLabel, this.mTypeLogComboBox};
            DialogUtil.enableHTMLComponent(this.mMinChangeLogLabel, this.mLimitLogLikelihoodCheckBox.isSelected());
            this.setStateOfComponents(jComponentArray, this.mLimitLogLikelihoodCheckBox);
        } else if (itemEvent.getSource() == this.mCheckDataPointsCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mStartIterationLabel, this.mStartIterationTextField};
            this.setStateOfComponents(jComponentArray, this.mCheckDataPointsCheckBox);
        } else if (itemEvent.getSource() == this.mDisplayHistoryCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mIncrementLabel, this.mIncrementTextField};
            this.setStateOfComponents(jComponentArray, this.mDisplayHistoryCheckBox);
        }
        if (itemEvent.getSource() == this.mNewFisherRadio) {
            this.mMaxBeforeSwitchField.setOpaque(this.mNewFisherRadio.isSelected());
            this.mMaxBeforeSwitchField.setEnabled(this.mNewFisherRadio.isSelected());
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mMaxIterationTextfield.getText().trim().equals("")) {
            return this.popUpEmptyErrorMessage((JComponent)this.mMaxIterationTextfield);
        }
        if (this.mMaxStepTextfield.getText().trim().equals("")) {
            return this.popUpEmptyErrorMessage((JComponent)this.mMaxStepTextfield);
        }
        if (this.mMinChangeParameterTextfield.getText().trim().equals("") && this.mLimitParameterEstimatesCheckBox.isSelected()) {
            return this.popUpEmptyErrorMessage((JComponent)this.mMinChangeParameterTextfield);
        }
        if (this.mMinChangeLogTextfield.getText().trim().equals("") && this.mLimitLogLikelihoodCheckBox.isSelected()) {
            return this.popUpEmptyErrorMessage((JComponent)this.mMinChangeLogTextfield);
        }
        if (this.mStartIterationTextField.getText().trim().equals("") && this.mCheckDataPointsCheckBox.isSelected()) {
            return this.popUpEmptyErrorMessage((JComponent)this.mStartIterationTextField);
        }
        if (this.mIncrementTextField.getText().trim().equals("") && this.mDisplayHistoryCheckBox.isSelected()) {
            return this.popUpEmptyErrorMessage((JComponent)this.mIncrementTextField);
        }
        if (this.mMaxBeforeSwitchField.getText().trim().equals("") && this.mNewFisherRadio.isSelected()) {
            return this.popUpEmptyErrorMessage((JComponent)this.mMaxBeforeSwitchField);
        }
        if (this.mMissingValuesPanel.getConfidenceTextField().getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_CS_ORDINAL_OPTIONS_CONFI_EMPTY_FIELD_ERROR"), VersionInfo.getAppVersionString());
            this.mMissingValuesPanel.getConfidenceTextField().requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        JPanel jPanel2 = this.setupEstimationCriteriaPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.setupEstimationMethodPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 2, n, insets);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesPanel.setupConfidencePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNewRaphsonGroup);
        vector.add(this.mMaxBeforeSwitchField);
        vector.addAll(this.mMissingValuesPanel.getTabTraversalComponents());
        vector.add(this.mMaxIterationTextfield);
        vector.add(this.mMaxStepTextfield);
        vector.add(this.mLimitParameterEstimatesCheckBox);
        vector.add(this.mMinChangeParameterTextfield);
        vector.add(this.mTypeParameterComboBox);
        vector.add(this.mLimitLogLikelihoodCheckBox);
        vector.add(this.mMinChangeLogTextfield);
        vector.add(this.mTypeLogComboBox);
        vector.add(this.mCheckDataPointsCheckBox);
        vector.add(this.mStartIterationTextField);
        vector.add(this.mDisplayHistoryCheckBox);
        vector.add(this.mIncrementTextField);
        vector.add(this.mMissingValuesPanel.getConfidenceTextField());
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mMaxIterationTextfield.setText("100");
        this.mMaxStepTextfield.setText("5");
        this.mMinChangeParameterTextfield.setText(MIN_PARAMETER);
        this.mStartIterationTextField.setText("20");
        this.mIncrementTextField.setText("1");
        this.mLimitParameterEstimatesCheckBox.setSelected(true);
        this.mCheckDataPointsCheckBox.setSelected(true);
        this.mMinChangeLogTextfield.setEnabled(false);
        this.mMinChangeLogTextfield.setOpaque(false);
        this.mTypeLogLabel.setEnabled(false);
        DialogUtil.enableHTMLComponent(this.mMinChangeLogLabel, false);
        this.mTypeLogComboBox.setEnabled(false);
        this.mIncrementLabel.setEnabled(false);
        this.mIncrementTextField.setEnabled(false);
        this.mIncrementTextField.setOpaque(false);
        this.enableContinue(true);
        this.mNewtonRadio.setSelected(true);
        this.mMaxBeforeSwitchField.setText("1");
        this.mMaxBeforeSwitchField.setOpaque(false);
        this.mMaxBeforeSwitchField.setEnabled(false);
        this.mLimitLogLikelihoodCheckBox.setSelected(false);
    }

    private void initVars() {
        this.mMissingValuesPanel = new ComplexSamplesCommonOptionsPanel(ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION, this, this.mParentDlg.getDialogDataModel());
        this.mMaxIterationTextfield = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxIterationTextfield.setAction((Action)new TextFieldAction(this, MAX_ITERATION_KEY));
        this.mMaxIterationTextfield.setColumns(5);
        this.mMaxIterationTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMaxStepTextfield = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxStepTextfield.setAction((Action)new TextFieldAction(this, MAX_STEP_KEY));
        this.mMaxStepTextfield.setColumns(5);
        this.mMaxStepTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mLimitParameterEstimatesCheckBox = new JCheckBox(new ToggleButtonAction(this, LIMIT_PARA_CHECKBOX_KEY));
        this.mLimitParameterEstimatesCheckBox.addItemListener(this);
        this.mMinChangeParameterLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_PARA_LABEL");
        this.mMinChangeParameterTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeParameterTextfield.setAction((Action)new TextFieldAction(this, MIN_PARAMETER_KEY));
        this.mMinChangeParameterTextfield.setColumns(5);
        this.mMinChangeParameterTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMinChangeParameterLabel.setLabelFor((Component)this.mMinChangeParameterTextfield);
        this.mTypeParameterLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE1_LABEL");
        this.mTypeParameterComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeParameterComboBox.setAction(new ComboboxAction(this, TYPE_PARAMETER_KEY));
        this.mTypeParameterLabel.setLabelFor(this.mTypeParameterComboBox);
        this.mLimitLogLikelihoodCheckBox = new JCheckBox(new ToggleButtonAction(this, LIMIT_LOG_CHECKBOX_KEY));
        this.mLimitLogLikelihoodCheckBox.addItemListener(this);
        this.mMinChangeLogLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_LOG_LABEL");
        this.mMinChangeLogTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeLogTextfield.setAction((Action)new TextFieldAction(this, MIN_LOG_KEY));
        this.mMinChangeLogTextfield.setColumns(5);
        this.mMinChangeLogTextfield.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mMinChangeLogLabel.setLabelFor((Component)this.mMinChangeLogTextfield);
        this.mTypeLogLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE2_LABEL");
        this.mTypeLogComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeLogComboBox.setAction(new ComboboxAction(this, TYPE_LOG_KEY));
        this.mTypeLogLabel.setLabelFor(this.mTypeLogComboBox);
        this.mCheckDataPointsCheckBox = new JCheckBox(new ToggleButtonAction(this, CHECK_DATA_POINTS_CHECKBOX));
        this.mCheckDataPointsCheckBox.addItemListener(this);
        this.mStartIterationLabel = DialogUtil.createLabel(this, START_ITERATION_KEY);
        this.mStartIterationTextField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mStartIterationTextField.setAction((Action)new TextFieldAction(this, START_ITERATION_KEY));
        this.mStartIterationTextField.setColumns(5);
        this.mStartIterationTextField.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mStartIterationLabel.setLabelFor((Component)this.mStartIterationTextField);
        this.mDisplayHistoryCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_DISPLAY_ITERATION_CHECKBOX"));
        this.mDisplayHistoryCheckBox.addItemListener(this);
        this.mIncrementLabel = DialogUtil.createLabel(this, INCREMENT_KEY);
        this.mIncrementTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mIncrementTextField.setAction((Action)new TextFieldAction(this, INCREMENT_KEY));
        this.mIncrementTextField.setColumns(5);
        this.mIncrementTextField.addFocusListener((FocusListener)new textFieldFocusAdapter());
        this.mIncrementLabel.setLabelFor((Component)this.mIncrementTextField);
        this.mNewtonRadio = new JRadioButton(new ToggleButtonAction(this, ORDINAL_NEWTON_RADIO));
        this.mFisherRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CS_ORDINAL_FISHER_RADIO"));
        this.mNewFisherRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_CS_ORDINAL_NEW_FISHER_RADIO"));
        this.mNewFisherRadio.addItemListener(this);
        this.mNewRaphsonGroup = new SpssButtonGroup();
        this.mNewRaphsonGroup.add(this.mNewtonRadio);
        this.mNewRaphsonGroup.add(this.mFisherRadio);
        this.mNewRaphsonGroup.add(this.mNewFisherRadio);
        this.mMaxBeforeSwitchField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxBeforeSwitchField.setAction((Action)new TextFieldAction(this, BEFORE_SWITCHING_TEXT_FIELD));
    }

    private boolean popUpEmptyErrorMessage(JComponent jComponent) {
        String string = "";
        string = jComponent == this.mMaxBeforeSwitchField ? this.getResString("ERR_CS_ORDINAL_OPTIONS_EMPTY_FIELD_ERROR2") : this.getResString("ERR_CS_ORDINAL_OPTIONS_EMPTY_FIELD_ERROR1");
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        jComponent.requestFocus();
        return false;
    }

    private JPanel setupEstimationCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CS_ORDINAL_OPTIONS_ESTIMATION_CRITERIA_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, MAX_ITERATION_KEY);
        jLabel.setLabelFor((Component)this.mMaxIterationTextfield);
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationTextfield, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, MAX_STEP_KEY);
        jLabel2.setLabelFor((Component)this.mMaxStepTextfield);
        insets2.set(15, n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(15, insets.left, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxStepTextfield, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(15, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLimitParameterEstimatesCheckBox, gridBagConstraints, 0, 2, 3, 1, n, insets2);
        JPanel jPanel2 = this.setupMinChangeParameterEstimatesPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 3, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLimitLogLikelihoodCheckBox, gridBagConstraints, 0, 4, 3, 1, n, insets2);
        JPanel jPanel3 = this.setupMinChangeLogLikelihoodPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 3, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCheckDataPointsCheckBox, gridBagConstraints, 0, 6, 3, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(n2, 22, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStartIterationLabel, gridBagConstraints, 0, 7, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStartIterationTextField, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        insets2.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayHistoryCheckBox, gridBagConstraints, 0, 8, 3, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(n2, 22, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIncrementLabel, gridBagConstraints, 0, 9, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIncrementTextField, gridBagConstraints, 1, 9, 1, 1, n, insets2);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupEstimationMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CS_ORDINAL_OPTIONS_METHOD_PANEL")));
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNewtonRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFisherRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNewFisherRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupMaxIterationPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMaxIterationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createMultiLineLabel(this, "IDS_CS_ORDINAL_MAX_ITERATION_LABEL", 150);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 13, 1, 3);
        jLabel.setLabelFor((Component)this.mMaxBeforeSwitchField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxBeforeSwitchField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinChangeParameterEstimatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(n2, 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeParameterLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeParameterTextfield, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterComboBox, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinChangeLogLikelihoodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, 0);
        insets.set(n2, 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeLogLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeLogTextfield, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogComboBox, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setStateOfComponents(JComponent[] jComponentArray, JCheckBox jCheckBox) {
        boolean bl = jCheckBox.isSelected();
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setEnabled(bl);
            if (!(jComponentArray[i] instanceof JTextField)) continue;
            jComponentArray[i].setOpaque(bl);
        }
    }

    private class textFieldFocusAdapter
    extends FocusAdapter {
        private textFieldFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof JTextField) {
                ((JTextField)object).selectAll();
            }
        }
    }
}

