/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonHypothesisTests;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonMainDialogPanel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonModel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOddsRatios;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesUtils;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionOptions;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionSaveDialog;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionStatistics;
import com.spss.java_client.ui.dialogs.complex_samples.ordinal_regression.OrdinalRegressionWarningDialog;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OrdinalRegressionDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private ComplexSamplesCommonMainDialogPanel mainPanel;
    private JButton mModelButton;
    private JButton mOddsRatiosButton;
    private OrdinalRegressionSaveDialog mOrdinalSaveDialog;

    public OrdinalRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CS_ORDINAL_COMMON_MAIN_DIALOG_TITLE"));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putBoolean("IDS_LOGISTIC_PROBABILITY_VALUE", true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mOddsRatiosButton.setEnabled(this.mainPanel.mLinkCombo.getSelectedIndex() == 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csord_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mainPanel.setDefaults();
        this.getDialogDataModel().putString("IDS_ORDINAL_REG_REPLACE_STRING", null);
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_ordinal_regr_main";
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE", this.mainPanel.mComboValue);
        this.getDialogDataModel().putString("IDS_CS_ORD_REG_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* " + this.getResString("IDS_CS_PLAN_ORDINAL_SYNTAX_TITLE") + ".");
        String string2 = this.mOrdinalSaveDialog != null || this.getDialogDataModel().getString("IDS_ORDINAL_REG_REPLACE_STRING") != null ? (this.mOrdinalSaveDialog != null ? this.mOrdinalSaveDialog.getReplaceString(" ").toString() : this.getDialogDataModel().getString("IDS_ORDINAL_REG_REPLACE_STRING")) : this.existingVarString(" ");
        if (string2.length() > 0) {
            stringBuffer.append("\nDELETE VARIABLES " + string2.trim() + ".");
        }
        stringBuffer.append("\n");
        Boolean bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_EXPORT_MODEL_CHECK");
        if (bl != null && bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_CREATE_DATA_RADIO")).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(dialogDataModel.getString("IDS_DATA_SET_TEXT_FIELD")));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("CSORDINAL "));
        String string3 = this.mainPanel.getVariablesOfDependentList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string3) + " (");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_LOGISTIC_PROBABILITY_VALUE");
        if (bl2 == null || bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("ASCENDING");
        } else {
            stringBuffer.append("DESCENDING");
        }
        stringBuffer.append(")");
        String string4 = this.mainPanel.getVariablesOfFactorsList();
        if (string4.trim().length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string4);
        }
        if ((string = this.mainPanel.getVariablesOfCovariatesList()).trim().length() > 0) {
            stringBuffer.append(" WITH ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLAN FILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        String string5 = ComplexSamplesPlan.getJointProbalityValue();
        if (string5 != null) {
            if (string5.endsWith("\n")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            stringBuffer.append("\n");
            stringBuffer.append(string5);
        }
        int n = this.mainPanel.mLinkCombo.getSelectedIndex();
        String string6 = "LOGIT";
        if (n == 1) {
            string6 = "CAUCHIT";
        } else if (n == 2) {
            string6 = "CLOGLOG";
        } else if (n == 3) {
            string6 = "NLOGLOG";
        } else if (n == 4) {
            string6 = "PROBIT";
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/LINK FUNCTION=") + string6 + "\n");
        string3 = this.mainPanel.getVariablesOfVariableList();
        if (string3.trim().length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DOMAIN VARIABLE="));
            stringBuffer.append(string3);
            stringBuffer.append("(");
            stringBuffer.append(this.mainPanel.getSelectedValueOfCategoryCombo());
            stringBuffer.append(")\n");
        }
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateModelSyntax(dialogDataModel, string4, string, ComplexSamplesCommonDialogType.ORDINAL_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateStatisticSyntax(dialogDataModel, ComplexSamplesCommonDialogType.ORDINAL_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateHypothesisTestSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.getOrdinalSaveDialogSyntax(dialogDataModel));
        if (this.mOddsRatiosButton.isEnabled()) {
            boolean bl3 = this.mainPanel.getFactorList().getModel().getShowVarLabels();
            stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateLogisticOddsRatiosSyntax(dialogDataModel, this, bl3));
        }
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateMissingValuesSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateOptionsSyntax(dialogDataModel, ComplexSamplesCommonDialogType.ORDINAL_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateLogisticPrintSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.commonPerAttributesSyntax());
        return stringBuffer.toString();
    }

    private String existingVarString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < 5; ++i) {
            String string2;
            Boolean bl = dialogDataModel.getBoolean("IDS_CS_ORDINAL_SAVE_CHECK" + i);
            if (bl == null || !bl.booleanValue() || (string2 = dialogDataModel.getString("SAVE_TEXT_FIELD" + i)) == null || iSpssDataSrc.findVarIndex(string2) == -1) continue;
            stringBuffer.append(string2).append(string);
        }
        return stringBuffer.toString();
    }

    public void enableModelButton(boolean bl) {
        this.mModelButton.setEnabled(bl);
    }

    public void enableOkPasteButtons(boolean bl) {
        this.enableOkPaste(bl);
    }

    @Override
    public boolean okPastePressed() {
        if (this.mainPanel.getVariablesOfVariableList().trim().length() > 0 && this.mainPanel.isSubpopulationCategoryEmpty()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (!this.mainPanel.isCategoryValueValid()) {
            return false;
        }
        String string = this.existingVarString("\n");
        if (string.length() > 0) {
            OrdinalRegressionWarningDialog ordinalRegressionWarningDialog = new OrdinalRegressionWarningDialog(this, string.toString());
            if (!ordinalRegressionWarningDialog.mIsOkPressed) {
                return false;
            }
            this.getDialogDataModel().putBoolean("IDS_CS_ORDINAL_SAVE_REPLACE_CHECK", true);
        }
        return super.okPastePressed();
    }

    public ComplexSamplesCommonMainDialogPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_ORD_REG_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_ORD_REG_PLAN_FILE_NAME"))) {
            super.loadDialogState();
            Object object = this.getDialogDataModel().getObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE");
            if (object != null) {
                this.mainPanel.mCategoryCombo.setSelectedItem(object);
            } else {
                this.mainPanel.mCategoryCombo.setEnabled(false);
            }
        } else {
            this.setVisible(true);
        }
        this.mainPanel.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ArrayList<ISpssVariable> arrayList = ComplexSamplesUtils.getValidVariables(dialogDataModel, "OddsRatioFactor", "IDS_FACTORS_LIST_LOGI");
        ArrayList<ISpssVariable> arrayList2 = ComplexSamplesUtils.getValidVariables(dialogDataModel, "OddsRatioCovariate", "IDS_COVAR_LIST_LOGI");
        if (arrayList.size() == 0) {
            dialogDataModel.putVarArray("OddsRatioFactor", null);
        } else {
            dialogDataModel.putVarArray("OddsRatioFactor", arrayList.toArray(new ISpssVariable[arrayList.size()]));
        }
        if (arrayList2.size() == 0) {
            dialogDataModel.putVarArray("OddsRatioCovariate", null);
        } else {
            dialogDataModel.putVarArray("OddsRatioCovariate", arrayList2.toArray(new ISpssVariable[arrayList2.size()]));
        }
        ComplexSamplesUtils.validateTableContents(dialogDataModel, "FACTOR_TABLE_ID", "OddsRatioFactor", "FactorTableData");
        ComplexSamplesUtils.validateTableContents(dialogDataModel, "COVARIATE_TABLE_ID", "OddsRatioCovariate", "CovariateTableData");
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mainPanel.mTargetDependentList);
        vector.add(this.mainPanel.getFactorList());
        vector.add(this.mainPanel.getCovariateList());
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ARROW_BUTTON_VALID_MSG"), vector);
        this.pack();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runModelsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runSubDialog(new OrdinalRegressionStatistics(OrdinalRegressionDlg.this, OrdinalRegressionDlg.this.getResString("IDS_ORDINAL_REGRESSION_STATISTICS_TITLE"), true));
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_HYPOTHESIS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runSubDialog(new ComplexSamplesCommonHypothesisTests(OrdinalRegressionDlg.this, OrdinalRegressionDlg.this.getResString("IDS_CS_ORDINAL_HYPO_TEXT_TITLE"), true));
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ODDS_RATIOS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runOddsRatiosSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.mOrdinalSaveDialog = new OrdinalRegressionSaveDialog(OrdinalRegressionDlg.this, OrdinalRegressionDlg.this.getResString("IDS_CS_ORDINAL_SAVE_DIALOG_TITLE"), true);
                OrdinalRegressionDlg.this.runSubDialog(OrdinalRegressionDlg.this.mOrdinalSaveDialog);
            }
        };
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runSubDialog(new OrdinalRegressionOptions(OrdinalRegressionDlg.this, OrdinalRegressionDlg.this.getResString("IDS_CS_ORDINAL_OPTIONS_TITLE"), true));
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        JButton jButton = new JButton(toggleButtonAction2);
        JButton jButton2 = new JButton(toggleButtonAction3);
        this.mOddsRatiosButton = new JButton(toggleButtonAction4);
        JButton jButton3 = new JButton(toggleButtonAction5);
        JButton jButton4 = new JButton(toggleButtonAction6);
        this.addOptionsPanelButton(jPanel, this.mModelButton);
        this.addOptionsPanelButton(jPanel, jButton);
        this.addOptionsPanelButton(jPanel, jButton2);
        this.addOptionsPanelButton(jPanel, this.mOddsRatiosButton);
        this.addOptionsPanelButton(jPanel, jButton3);
        this.addOptionsPanelButton(jPanel, jButton4);
        return jPanel;
    }

    private void setDefaults() {
        this.mModelButton.setEnabled(false);
        this.mainPanel.getDependentVariableList().getModel().addListDataListener(this);
        this.mainPanel.mCategoryCombo.setSelectedItem("");
        this.mainPanel.mLinkCombo.setSelectedIndex(0);
    }

    private void initVars() {
        this.mainPanel = new ComplexSamplesCommonMainDialogPanel(this, ComplexSamplesCommonDialogType.ORDINAL_REGRESSION);
        String[] stringArray = new String[]{"IDS_SRC_LIST_LOGI", "IDS_DEPENDENT_LIST_LOGI", "IDS_FACTORS_LIST_LOGI", "IDS_COVAR_LIST_LOGI", "IDS_VAR_LIST_LOGI", "IDS_CAT_COMBO_LOGI"};
        this.mainPanel.setIdentifiersForComponents(stringArray);
        this.mainPanel.mLinkCombo.addItemListener(this);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = this.mainPanel.setTabTraversal();
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.elementAt(n));
        }
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void runModelsSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonModel(this, this.getResString("IDS_CS_ORDINAL_MODEL_TITLE"), this.mainPanel.getFactorList().getModel(), this.mainPanel.getCovariateList().getModel(), null, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_MAINEFFECTS_RADIOBUTTON"));
    }

    private void runOddsRatiosSubDialog() {
        this.runSubDialog(new ComplexSamplesOddsRatios(this, this.getResString("IDS_CS_ORDINAL_ODDS_RATIOS_TITLE"), true));
    }
}

