/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.logistic_regression;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.CommonReferenceCategory;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionDlg;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class LogisticRegressionReferenceCategory
extends BaseSubDialog {
    CommonReferenceCategory mRefPanel;

    public LogisticRegressionReferenceCategory(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cslr_refcat";
    }

    @Override
    public boolean continuePressed() {
        if (this.mRefPanel.isCustomRadioSelected()) {
            String string = ((JTextField)((BasicComboBoxEditor)this.mRefPanel.getValueComboBox().getEditor()).getEditorComponent()).getText();
            if (string == null || string.trim().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LOGISTIC_REGRESSION_REF_CAT_WARNING_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
            ISpssVariable iSpssVariable = ((LogisticRegressionDlg)this.mParentDlg).getMainPanel().getDependentVariableList().getModel().getElementAt(0);
            OBS oBS = new OBS();
            if (!CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                this.displayErrorDialog(0);
                return false;
            }
            OBS oBS2 = new OBS();
            OBS oBS3 = new OBS();
            OBS oBS4 = new OBS();
            ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS2, oBS3, oBS4);
            double d = oBS.getNum();
            if (rule.value() == ISpssVariable.Rule.range_plus.value()) {
                double d2 = oBS2.getNum();
                double d3 = oBS3.getNum();
                double d4 = oBS4.getNum();
                boolean bl = true;
                if (Double.compare(d4, d) == 0) {
                    bl = false;
                }
                for (double d5 = d2; d5 <= d3 && bl; d5 += 1.0) {
                    if (Double.compare(d, d5) != 0) continue;
                    bl = false;
                }
                if (!bl) {
                    this.displayErrorDialog(1);
                    return false;
                }
            } else if (rule.value() == ISpssVariable.Rule.range.value()) {
                double d6 = oBS2.getNum();
                double d7 = oBS3.getNum();
                for (double d8 = d6; d8 <= d7; d8 += 1.0) {
                    if (Double.compare(d, d8) != 0) continue;
                    this.displayErrorDialog(1);
                    return false;
                }
            } else if (rule.value() == ISpssVariable.Rule.three.value()) {
                if (Double.compare(d, oBS2.getNum()) == 0 || Double.compare(d, oBS3.getNum()) == 0 || Double.compare(d, oBS4.getNum()) == 0) {
                    this.displayErrorDialog(1);
                    return false;
                }
            } else if (rule.value() == ISpssVariable.Rule.two.value()) {
                if (Double.compare(d, oBS2.getNum()) == 0 || Double.compare(d, oBS3.getNum()) == 0) {
                    this.displayErrorDialog(1);
                    return false;
                }
            } else if (rule.value() == ISpssVariable.Rule.one.value() && Double.compare(d, oBS2.getNum()) == 0) {
                this.displayErrorDialog(1);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        String string = ((JTextField)((BasicComboBoxEditor)this.mRefPanel.getValueComboBox().getEditor()).getEditorComponent()).getText();
        dialogDataModel.putString("IDS_LOGISTIC_REF_CAT_COMBO_VALUE", UIToolResUtil.removeLocale((String)string));
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String string = dialogDataModel.getString("IDS_LOGISTIC_REF_CAT_COMBO_VALUE");
        ((JTextField)((BasicComboBoxEditor)this.mRefPanel.getValueComboBox().getEditor()).getEditorComponent()).setText(UIToolResUtil.addLocale((String)string));
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.mRefPanel = new CommonReferenceCategory(this.mParentDlg, ((LogisticRegressionDlg)this.mParentDlg).getMainPanel().getDependentVariableList());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRefPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        Vector<Object> vector = this.mRefPanel.getSubDialogFocusTraversalPolicy();
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void displayErrorDialog(int n) {
        String string = n == 0 ? this.getResString("ERR_LOGISTIC_REGRESSION_REF_CAT_WARNING_MESSAGE_1") : this.getResString("ERR_LOGISTIC_REGRESSION_REF_CAT_WARNING_MESSAGE_2");
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        this.mRefPanel.getValueComboBox().requestFocus();
        ((JTextField)this.mRefPanel.getValueComboBox().getEditor().getEditorComponent()).selectAll();
    }
}

