/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.logistic_regression;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonOptionsPanel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogisticRegressionOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String MAX_ITERATION_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL";
    public static final String MAX_STEP_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL";
    public static final String MIN_PARAMETER_KEY = "MIN_CHANGE_PARAMETER_KEY";
    public static final String MIN_LOG_KEY = "MIN_CHANGE_LOG_KEY";
    public static final String TYPE_PARAMETER_KEY = "TYPE_PARAMETER_KEY";
    public static final String TYPE_LOG_KEY = "TYPE_LOG_KEY";
    public static final String START_ITERATION_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_START_ITERATION_LABEL";
    public static final String INCREMENT_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL";
    public static final String LIMIT_PARA_CHECKBOX_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_PARA_ESTIMATES_CHECKBOX";
    public static final String LIMIT_LOG_CHECKBOX_KEY = "IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_LOG_CHECKBOX";
    public static final String CHECK_DATA_POINTS_CHECKBOX = "IDS_LOGISTIC_REGRESSION_OPTIONS_CHECK_DATAPOINTS_CHECKBOX";
    public static final int MAX_ITERATIONS = 100;
    public static final int MAX_STEP_ITERATIONS = 5;
    public static final String MIN_PARAMETER = "0.000001";
    public static final int START_ITERATION = 20;
    public static final int INCREMENT = 1;
    private IntTextField mMaxIterationTextfield;
    private IntTextField mMaxStepTextfield;
    private JLabel mMinChangeParameterLabel;
    private FloatTextField mMinChangeParameterTextfield;
    private JLabel mTypeParameterLabel;
    private JComboBox mTypeParameterComboBox;
    private JLabel mMinChangeLogLabel;
    private FloatTextField mMinChangeLogTextfield;
    private JLabel mTypeLogLabel;
    private JComboBox mTypeLogComboBox;
    private JCheckBox mCheckDataPointsCheckBox;
    private JLabel mStartIterationLabel;
    private IntTextField mStartIterationTextField;
    private JCheckBox mDisplayHistoryCheckBox;
    private JLabel mIncrementLabel;
    private IntTextField mIncrementTextField;
    private ComplexSamplesCommonOptionsPanel mMissingValuesPanel;
    private JCheckBox mLimitParameterEstimatesCheckBox;
    private JCheckBox mLimitLogLikelihoodCheckBox;
    private GridBagConstraints mConstraints;
    private Insets mInsets;

    public LogisticRegressionOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cslr_options";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
        if (jCheckBox == this.mLimitParameterEstimatesCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mMinChangeParameterTextfield, this.mTypeParameterLabel, this.mTypeParameterComboBox};
            DialogUtil.enableHTMLComponent(this.mMinChangeParameterLabel, this.mLimitParameterEstimatesCheckBox.isSelected());
            this.setStateOfComponents(jComponentArray, this.mLimitParameterEstimatesCheckBox);
        } else if (jCheckBox == this.mLimitLogLikelihoodCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mMinChangeLogTextfield, this.mTypeLogLabel, this.mTypeLogComboBox};
            DialogUtil.enableHTMLComponent(this.mMinChangeLogLabel, this.mLimitLogLikelihoodCheckBox.isSelected());
            this.setStateOfComponents(jComponentArray, this.mLimitLogLikelihoodCheckBox);
        } else if (jCheckBox == this.mCheckDataPointsCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mStartIterationLabel, this.mStartIterationTextField};
            this.setStateOfComponents(jComponentArray, this.mCheckDataPointsCheckBox);
        } else if (jCheckBox == this.mDisplayHistoryCheckBox) {
            JComponent[] jComponentArray = new JComponent[]{this.mIncrementLabel, this.mIncrementTextField};
            this.setStateOfComponents(jComponentArray, this.mDisplayHistoryCheckBox);
        }
        this.enableContinueButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        JPanel jPanel2 = this.setupEstimationPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 2, n, null);
        int n2 = DialogUtil.getComponentGroupGap();
        this.mInsets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesPanel, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesPanel.setupConfidencePanel(), this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMaxIterationTextfield);
        vector.add(this.mMaxStepTextfield);
        vector.add(this.mLimitParameterEstimatesCheckBox);
        vector.add(this.mMinChangeParameterTextfield);
        vector.add(this.mTypeParameterComboBox);
        vector.add(this.mLimitLogLikelihoodCheckBox);
        vector.add(this.mMinChangeLogTextfield);
        vector.add(this.mTypeLogComboBox);
        vector.add(this.mCheckDataPointsCheckBox);
        vector.add(this.mStartIterationTextField);
        vector.add(this.mDisplayHistoryCheckBox);
        vector.add(this.mIncrementTextField);
        vector.addAll(this.mMissingValuesPanel.getTabTraversalComponents());
        vector.add(this.mMissingValuesPanel.getConfidenceTextField());
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void setDefaults() {
        this.mMaxIterationTextfield.setText("100");
        this.mMaxIterationTextfield.selectAll();
        this.mMaxStepTextfield.setText("5");
        this.mMinChangeParameterTextfield.setText(MIN_PARAMETER);
        this.mStartIterationTextField.setText("20");
        this.mIncrementTextField.setText("1");
        this.mLimitParameterEstimatesCheckBox.setSelected(true);
        this.mCheckDataPointsCheckBox.setSelected(true);
        this.mMinChangeLogTextfield.setEnabled(false);
        this.mMinChangeLogTextfield.setOpaque(false);
        this.mTypeLogLabel.setEnabled(false);
        DialogUtil.enableHTMLComponent(this.mMinChangeLogLabel, false);
        this.mTypeLogComboBox.setEnabled(false);
        this.mIncrementLabel.setEnabled(false);
        this.mIncrementTextField.setEnabled(false);
        this.mIncrementTextField.setOpaque(false);
        this.enableContinue(true);
    }

    private void initVars() {
        this.mMissingValuesPanel = new ComplexSamplesCommonOptionsPanel(ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION, this, this.mParentDlg.getDialogDataModel());
        this.mMissingValuesPanel.getConfidenceTextField().getDocument().addDocumentListener(this);
        this.mMaxIterationTextfield = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxIterationTextfield.setAction((Action)new TextFieldAction(this, MAX_ITERATION_KEY));
        this.mMaxIterationTextfield.setColumns(5);
        this.mMaxIterationTextfield.getDocument().addDocumentListener(this);
        this.mMaxStepTextfield = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxStepTextfield.setAction((Action)new TextFieldAction(this, MAX_STEP_KEY));
        this.mMaxStepTextfield.setColumns(5);
        this.mMaxStepTextfield.getDocument().addDocumentListener(this);
        this.mLimitParameterEstimatesCheckBox = new JCheckBox(new ToggleButtonAction(this, LIMIT_PARA_CHECKBOX_KEY));
        this.mLimitParameterEstimatesCheckBox.addItemListener(this);
        this.mMinChangeParameterLabel = DialogUtil.createMultiLineLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_PARA_LABEL", 70);
        this.mMinChangeParameterTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeParameterTextfield.setAction((Action)new TextFieldAction(this, MIN_PARAMETER_KEY));
        this.mMinChangeParameterTextfield.setColumns(5);
        this.mMinChangeParameterTextfield.getDocument().addDocumentListener(this);
        this.mMinChangeParameterLabel.setLabelFor((Component)this.mMinChangeParameterTextfield);
        this.mTypeParameterLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE1_LABEL");
        this.mTypeParameterComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeParameterComboBox.setAction(new ComboboxAction(this, TYPE_PARAMETER_KEY));
        this.mTypeParameterLabel.setLabelFor(this.mTypeParameterComboBox);
        this.mLimitLogLikelihoodCheckBox = new JCheckBox(new ToggleButtonAction(this, LIMIT_LOG_CHECKBOX_KEY));
        this.mLimitLogLikelihoodCheckBox.addItemListener(this);
        this.mMinChangeLogLabel = DialogUtil.createMultiLineLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_MIN_CHANGE_LOG_LABEL", 70);
        this.mMinChangeLogTextfield = new FloatTextField(0.0, Double.MAX_VALUE, Integer.MAX_VALUE, true);
        this.mMinChangeLogTextfield.setAction((Action)new TextFieldAction(this, MIN_LOG_KEY));
        this.mMinChangeLogTextfield.setColumns(5);
        this.mMinChangeLogTextfield.getDocument().addDocumentListener(this);
        this.mMinChangeLogLabel.setLabelFor((Component)this.mMinChangeLogTextfield);
        this.mTypeLogLabel = DialogUtil.createLabel(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE2_LABEL");
        this.mTypeLogComboBox = new JComboBox<String>(this.getResStringArray("IDS_LOGISTIC_REGRESSION_OPTIONS_TYPE_COMBO"));
        this.mTypeLogComboBox.setAction(new ComboboxAction(this, TYPE_LOG_KEY));
        this.mTypeLogLabel.setLabelFor(this.mTypeLogComboBox);
        this.mCheckDataPointsCheckBox = new JCheckBox(new ToggleButtonAction(this, CHECK_DATA_POINTS_CHECKBOX));
        this.mCheckDataPointsCheckBox.addItemListener(this);
        this.mStartIterationLabel = DialogUtil.createLabel(this, START_ITERATION_KEY);
        this.mStartIterationTextField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mStartIterationTextField.setAction((Action)new TextFieldAction(this, START_ITERATION_KEY));
        this.mStartIterationTextField.setColumns(5);
        this.mStartIterationTextField.getDocument().addDocumentListener(this);
        this.mStartIterationLabel.setLabelFor((Component)this.mStartIterationTextField);
        this.mDisplayHistoryCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC_REGRESSION_OPTIONS_DISPLAY_ITERATION_CHECKBOX"));
        this.mDisplayHistoryCheckBox.addItemListener(this);
        this.mIncrementLabel = DialogUtil.createLabel(this, INCREMENT_KEY);
        this.mIncrementTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mIncrementTextField.setAction((Action)new TextFieldAction(this, INCREMENT_KEY));
        this.mIncrementTextField.setColumns(5);
        this.mIncrementTextField.getDocument().addDocumentListener(this);
        this.mIncrementLabel.setLabelFor((Component)this.mIncrementTextField);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
    }

    private JPanel setupEstimationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOGISTIC_REGRESSION_OPTIONS_ESTIMATION_LABEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, MAX_ITERATION_KEY);
        jLabel.setLabelFor((Component)this.mMaxIterationTextfield);
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, insets.left, 0, n2);
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationTextfield, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        JLabel jLabel2 = DialogUtil.createLabel(this, MAX_STEP_KEY);
        jLabel2.setLabelFor((Component)this.mMaxStepTextfield);
        this.mInsets.set(15, n2, 0, 0);
        this.mConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(15, insets.left, 0, n2);
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxStepTextfield, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        this.mInsets.set(15, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLimitParameterEstimatesCheckBox, this.mConstraints, 0, 2, 3, 1, n, this.mInsets);
        JPanel jPanel2 = this.setupMinChangeParameterEstimatesPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 3, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLimitLogLikelihoodCheckBox, this.mConstraints, 0, 4, 3, 1, n, this.mInsets);
        JPanel jPanel3 = this.setupMinChangeLogLikelihoodPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 5, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCheckDataPointsCheckBox, this.mConstraints, 0, 6, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mInsets.set(n2, 22, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mStartIterationLabel, this.mConstraints, 0, 7, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStartIterationTextField, this.mConstraints, 1, 7, 1, 1, n, this.mInsets);
        this.mInsets.set(10, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayHistoryCheckBox, this.mConstraints, 0, 8, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(n2, 22, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIncrementLabel, this.mConstraints, 0, 9, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIncrementTextField, this.mConstraints, 1, 9, 1, 1, n, this.mInsets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupMinChangeParameterEstimatesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mMinChangeParameterTextfield.setColumns(8);
        this.mInsets.set(0, 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeParameterLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeParameterTextfield, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterLabel, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeParameterComboBox, this.mConstraints, 3, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupMinChangeLogLikelihoodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mMinChangeLogTextfield.setColumns(8);
        this.mInsets.set(0, 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinChangeLogLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinChangeLogTextfield, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogLabel, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, 10, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLogComboBox, this.mConstraints, 3, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private void setStateOfComponents(JComponent[] jComponentArray, JCheckBox jCheckBox) {
        boolean bl = jCheckBox.isSelected();
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setEnabled(bl);
            if (!(jComponentArray[i] instanceof JTextField)) continue;
            jComponentArray[i].setOpaque(bl);
        }
    }

    private void enableContinueButton() {
        if (this.mMaxIterationTextfield.getText().length() > 0 && this.mMaxStepTextfield.getText().length() > 0 && this.mMissingValuesPanel.getConfidenceTextField().getText().length() > 0) {
            if (this.mLimitParameterEstimatesCheckBox.isSelected() && ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mMinChangeParameterTextfield) || this.mLimitLogLikelihoodCheckBox.isSelected() && ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mMinChangeLogTextfield) || this.mCheckDataPointsCheckBox.isSelected() && ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mStartIterationTextField) || this.mDisplayHistoryCheckBox.isSelected() && ComplexSamplesCommonSyntaxUtils.isEnabledTextFieldEmpty((JTextField)this.mIncrementTextField)) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        } else {
            this.enableContinue(false);
        }
    }
}

