/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.logistic_regression;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.CommonReferenceCategory;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonHypothesisTests;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonMainDialogPanel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonModel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSave;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOddsRatios;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesUtils;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionOptions;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.LogisticRegressionStatistics;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LogisticRegressionDlg
extends BaseProcedureDialog {
    static boolean sMakeReferenceCatButtonVisible = true;
    private ComplexSamplesCommonMainDialogPanel mainPanel;
    private JButton mModelButton;
    private JButton mStatsButton;
    private JButton mHypoButton;
    private JButton mOddsRatiosButton;
    private JButton mSaveButton;
    private JButton mOptionsButton;

    public LogisticRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_TITLE_REGRESSION"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_cslr_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mainPanel.setDefaults();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_logit_regr_main";
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE", this.mainPanel.mComboValue);
        this.getDialogDataModel().putString("IDS_LOG_REG_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* " + this.getResString("IDS_COMPLEX_SAMPLES_LOGISTICS_REGRESSION_SYNTAX_TITLE") + ".");
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("CSLOGISTIC "));
        String string3 = this.mainPanel.getVariablesOfDependentList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string3) + "(");
        Boolean bl = dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_HIGHEST_VALUE_RADIOBUTTON");
        if (bl == null || bl != null && bl.booleanValue()) {
            stringBuffer.append("HIGH");
        } else {
            bl = dialogDataModel.getBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_LOWEST_VALUE_RADIOBUTTON");
            if (bl.booleanValue()) {
                stringBuffer.append("LOW");
            } else {
                string2 = dialogDataModel.getString("IDS_LOGISTIC_REF_CAT_COMBO_VALUE");
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append(")");
        string2 = this.mainPanel.getVariablesOfFactorsList();
        if (string2.trim().length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string2);
        }
        if ((string = this.mainPanel.getVariablesOfCovariatesList()).trim().length() > 0) {
            stringBuffer.append(" WITH ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLAN FILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        stringBuffer.append(" ");
        String string4 = ComplexSamplesPlan.getJointProbalityValue();
        if (string4 != null) {
            if (string4.endsWith("\n")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            stringBuffer.append("\n");
            stringBuffer.append(string4);
        }
        if ((string3 = this.mainPanel.getVariablesOfVariableList()).trim().length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DOMAIN VARIABLE="));
            stringBuffer.append(string3);
            stringBuffer.append("(");
            stringBuffer.append(this.mainPanel.getSelectedValueOfCategoryCombo());
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateModelSyntax(dialogDataModel, string2, string, ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateStatisticSyntax(dialogDataModel, ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateHypothesisTestSyntax(dialogDataModel));
        boolean bl2 = this.mainPanel.getFactorList().getModel().getShowVarLabels();
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateLogisticOddsRatiosSyntax(dialogDataModel, this, bl2));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateLogisticSaveSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateMissingValuesSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateOptionsSyntax(dialogDataModel, ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateLogisticPrintSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.commonPerAttributesSyntax());
        return stringBuffer.toString();
    }

    public void enableModelButton(boolean bl) {
        this.mModelButton.setEnabled(bl);
    }

    public void enableOkPasteButtons(boolean bl) {
        this.enableOkPaste(bl);
    }

    @Override
    public boolean okPastePressed() {
        if (this.mainPanel.getVariablesOfVariableList().trim().length() > 0 && this.mainPanel.isSubpopulationCategoryEmpty()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (!this.mainPanel.isCategoryValueValid()) {
            return false;
        }
        return super.okPastePressed();
    }

    public ComplexSamplesCommonMainDialogPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_DEPENDENT_LIST_LOGI");
        if (iSpssVariableArray == null) {
            dialogDataModel.putInteger(CommonReferenceCategory.VALUE_KEY, null);
            dialogDataModel.putString("IDS_LOGISTIC_REF_CAT_COMBO_VALUE", null);
            dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_HIGHEST_VALUE_RADIOBUTTON", true);
            dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_LOWEST_VALUE_RADIOBUTTON", null);
            dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_CUSTOM_RADIOBUTTON", null);
            this.mainPanel.getRefCatButton().setEnabled(false);
        }
        ArrayList<ISpssVariable> arrayList = ComplexSamplesUtils.getValidVariables(dialogDataModel, "OddsRatioFactor", "IDS_FACTORS_LIST_LOGI");
        ArrayList<ISpssVariable> arrayList2 = ComplexSamplesUtils.getValidVariables(dialogDataModel, "OddsRatioCovariate", "IDS_COVAR_LIST_LOGI");
        if (arrayList.size() == 0) {
            dialogDataModel.putVarArray("OddsRatioFactor", null);
        } else {
            dialogDataModel.putVarArray("OddsRatioFactor", arrayList.toArray(new ISpssVariable[arrayList.size()]));
        }
        if (arrayList2.size() == 0) {
            dialogDataModel.putVarArray("OddsRatioCovariate", null);
        } else {
            dialogDataModel.putVarArray("OddsRatioCovariate", arrayList2.toArray(new ISpssVariable[arrayList2.size()]));
        }
        ComplexSamplesUtils.validateTableContents(dialogDataModel, "FACTOR_TABLE_ID", "OddsRatioFactor", "FactorTableData");
        ComplexSamplesUtils.validateTableContents(dialogDataModel, "COVARIATE_TABLE_ID", "OddsRatioCovariate", "CovariateTableData");
        return true;
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_LOG_REG_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_LOG_REG_PLAN_FILE_NAME"))) {
            super.loadDialogState();
            Object object = this.getDialogDataModel().getObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE");
            if (object != null) {
                this.mainPanel.mCategoryCombo.setSelectedItem(object);
            } else {
                this.mainPanel.mCategoryCombo.setEnabled(false);
            }
        } else {
            this.setVisible(true);
        }
        this.mainPanel.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mainPanel.mTargetDependentList);
        vector.add(this.mainPanel.getFactorList());
        vector.add(this.mainPanel.getCovariateList());
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ARROW_BUTTON_VALID_MSG"), vector);
        this.pack();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runModelsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runStatSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_HYPOTHESIS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runHypoSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ODDS_RATIOS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runOddsRatiosSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runSaveSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogisticRegressionDlg.this.runOptionSubDialog();
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        this.mStatsButton = new JButton(toggleButtonAction2);
        this.mHypoButton = new JButton(toggleButtonAction3);
        this.mOddsRatiosButton = new JButton(toggleButtonAction4);
        this.mSaveButton = new JButton(toggleButtonAction5);
        this.mOptionsButton = new JButton(toggleButtonAction6);
        this.addOptionsPanelButton(jPanel, this.mModelButton);
        this.addOptionsPanelButton(jPanel, this.mStatsButton);
        this.addOptionsPanelButton(jPanel, this.mHypoButton);
        this.addOptionsPanelButton(jPanel, this.mOddsRatiosButton);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void setDefaults() {
        this.mModelButton.setEnabled(false);
        this.mainPanel.mCategoryCombo.setSelectedItem("");
    }

    private void initVars() {
        this.mainPanel = new ComplexSamplesCommonMainDialogPanel(this, ComplexSamplesCommonDialogType.LOGLINEAR_REGRESSION);
        String[] stringArray = new String[]{"IDS_SRC_LIST_LOGI", "IDS_DEPENDENT_LIST_LOGI", "IDS_FACTORS_LIST_LOGI", "IDS_COVAR_LIST_LOGI", "IDS_VAR_LIST_LOGI", "IDS_CAT_COMBO_LOGI"};
        this.mainPanel.setIdentifiersForComponents(stringArray);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = this.mainPanel.setTabTraversal();
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.elementAt(n));
        }
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void runModelsSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonModel(this, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_TITLE"), this.mainPanel.getFactorList().getModel(), this.mainPanel.getCovariateList().getModel(), null, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_MAINEFFECTS_RADIOBUTTON"));
    }

    private void runStatSubDialog() {
        this.runSubDialog(new LogisticRegressionStatistics(this, this.getResString("IDS_LOGISTIC_REGRESSION_STATISTICS_TITLE"), true));
    }

    private void runHypoSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonHypothesisTests(this, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_TITLE"), true));
    }

    private void runOddsRatiosSubDialog() {
        this.runSubDialog(new ComplexSamplesOddsRatios(this, this.getResString("IDS_LOGISTIC_REGRESSION_ODDS_RATIOS_TITLE"), true));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonSave(this, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_SAVE_TITLE"), true));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new LogisticRegressionOptions(this, this.getResString("IDS_LOGISTIC_REGRESSION_OPTIONS_TITLE"), true));
    }
}

