/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonDialogType;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonHypothesisTests;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonMainDialogPanel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonModel;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSave;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model.ComplexSamplesGLMEstimatedMeans;
import com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model.ComplexSamplesGLMOptions;
import com.spss.java_client.ui.dialogs.complex_samples.gen_lin_model.ComplexSamplesGLMStatistics;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ComplexSamplesGLMDlg
extends BaseProcedureDialog {
    protected ComplexSamplesCommonMainDialogPanel mainPanel;
    private JButton mModelButton;
    private JButton mStatsButton;
    private JButton mHypoButton;
    private JButton mEstimateButton;
    private JButton mSaveButton;
    private JButton mOptionsButton;

    public ComplexSamplesGLMDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_TITLE_GLM"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csgl_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mainPanel.setDefaults();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_glm_main";
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE", this.mainPanel.mComboValue);
        this.getDialogDataModel().putString("IDS_CS_GLM_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* " + this.getResString("IDS_COMPLEX_SAMPLES_GLM_SYNTAX_TITLE") + ".");
        stringBuffer.append("\n" + SyntaxUtil.getMainCommand("CSGLM "));
        String string2 = this.mainPanel.getVariablesOfDependentList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string2));
        String string3 = this.mainPanel.getVariablesOfFactorsList();
        if (string3.trim().length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string3);
        }
        if ((string = this.mainPanel.getVariablesOfCovariatesList()).trim().length() > 0) {
            stringBuffer.append(" WITH ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLAN FILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        stringBuffer.append("\n");
        String string4 = ComplexSamplesPlan.getJointProbalityValue();
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        if ((string2 = this.mainPanel.getVariablesOfVariableList()).trim().length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DOMAIN VARIABLE="));
            stringBuffer.append(string2);
            stringBuffer.append("(");
            stringBuffer.append(this.mainPanel.getSelectedValueOfCategoryCombo());
            stringBuffer.append(")\n");
        }
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateModelSyntax(dialogDataModel, string3, string, ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateStatisticSyntax(dialogDataModel, ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateGLMPrintSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateHypothesisTestSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesGLMEstimatedMeans.getEmMeansSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateGeneralSaveSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateMissingValuesSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.generateCriteriaSyntax(dialogDataModel));
        stringBuffer.append(ComplexSamplesCommonSyntaxUtils.commonPerAttributesSyntax());
        return stringBuffer.toString();
    }

    public void enableModelButton(boolean bl) {
        this.mModelButton.setEnabled(bl);
    }

    public void enableOkPasteButtons(boolean bl) {
        this.enableOkPaste(bl);
    }

    @Override
    public boolean okPastePressed() {
        if (this.mainPanel.getVariablesOfVariableList().trim().length() > 0 && this.mainPanel.isSubpopulationCategoryEmpty()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return this.mainPanel.isCategoryValueValid();
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_GLM_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_GLM_PLAN_FILE_NAME"))) {
            super.loadDialogState();
            this.mainPanel.mComboValue = this.getDialogDataModel().getObject("IDS_LOG_REG_CATEGORY_COMBO_VALUE");
            if (this.mainPanel.mComboValue == null) {
                this.mainPanel.mCategoryCombo.setEnabled(false);
            }
        } else {
            this.setVisible(true);
        }
        this.mainPanel.mSrcVarList.setSelectedIndex(0);
        this.mainPanel.mSrcVarList.requestFocus();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mainPanel.mTargetDependentList);
        vector.add(this.mainPanel.getFactorList());
        vector.add(this.mainPanel.getCovariateList());
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ARROW_BUTTON_VALID_MSG"), vector);
        this.pack();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runModelsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runStatSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_HYPOTHESIS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runHypoSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_ESTIMATED_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runEstimateSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runSaveSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComplexSamplesGLMDlg.this.runOptionSubDialog();
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        this.mStatsButton = new JButton(toggleButtonAction2);
        this.mHypoButton = new JButton(toggleButtonAction3);
        this.mEstimateButton = new JButton(toggleButtonAction4);
        this.mSaveButton = new JButton(toggleButtonAction5);
        this.mOptionsButton = new JButton(toggleButtonAction6);
        this.addOptionsPanelButton(jPanel, this.mModelButton);
        this.addOptionsPanelButton(jPanel, this.mStatsButton);
        this.addOptionsPanelButton(jPanel, this.mHypoButton);
        this.addOptionsPanelButton(jPanel, this.mEstimateButton);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    protected Vector<String> getModelString(String string) {
        Vector<String> vector = new Vector();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (string.trim().length() == 0) {
            return null;
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_MODEL_CUSTOM_RADIOBUTTON");
        if (bl != null && bl.booleanValue()) {
            TargetVariableList targetVariableList = this.mainPanel.getCovariateList();
            Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    int n;
                    String string2 = objectArray[i].toString();
                    if (targetVariableList.getModel() != null && targetVariableList.getModel().getSize() > 0) {
                        for (n = 0; n < targetVariableList.getModel().getSize() && !this.doesModelContainCovariateTerms(string2, (String)(object = targetVariableList.getModel().getElementAt(n).getName())); ++n) {
                            if (n != targetVariableList.getModel().getSize() - 1) continue;
                            vector.add(string2);
                        }
                        continue;
                    }
                    if (string2.contains("*")) {
                        object = new StringTokenizer(string2.toString(), "*");
                        n = 1;
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            String string3 = ((StringTokenizer)object).nextToken().toString();
                            if (this.isItemPresent(string3)) continue;
                            n = 0;
                        }
                        if (n == 0) continue;
                        vector.add(string2);
                        continue;
                    }
                    if (!this.isItemPresent(string2)) continue;
                    vector.add(string2);
                }
            }
        } else {
            vector = this.getFactorVector();
        }
        return vector;
    }

    private boolean isItemPresent(String string) {
        return this.getFactorVector().contains(string);
    }

    private Vector<String> getFactorVector() {
        Vector<String> vector = new Vector<String>();
        TargetVariableList targetVariableList = this.mainPanel.getFactorList();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            vector.add(targetVariableList.getModel().getElementAt(i).getName());
        }
        return vector;
    }

    protected boolean doesModelContainCovariateTerms(String string, String string2) {
        if (string.contains("*")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
            while (stringTokenizer.hasMoreElements()) {
                if (!stringTokenizer.nextElement().equals(string2)) continue;
                return true;
            }
            return false;
        }
        return string.equals(string2);
    }

    private void setDefaults() {
        this.mModelButton.setEnabled(false);
        this.mainPanel.mCategoryCombo.setSelectedItem("");
    }

    private void initVars() {
        this.mainPanel = new ComplexSamplesCommonMainDialogPanel(this, ComplexSamplesCommonDialogType.GENERAL_LINEAR_MODEL);
        String[] stringArray = new String[]{"IDS_SRC_LIST_GLM", "IDS_DEPENDENT_LIST_GLM", "IDS_FACTORS_LIST_GLM", "IDS_COVAR_LIST_GLM", "IDS_VAR_LIST_GLM", "IDS_CAT_COMBO_GLM"};
        this.mainPanel.setIdentifiersForComponents(stringArray);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = this.mainPanel.setTabTraversal();
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.elementAt(n));
        }
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void runModelsSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonModel(this, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_GLM_TITLE"), this.mainPanel.getFactorList().getModel(), this.mainPanel.getCovariateList().getModel(), null, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_MAINEFFECTS_RADIOBUTTON"));
    }

    private void runStatSubDialog() {
        this.runSubDialog(new ComplexSamplesGLMStatistics(this, this.getResString("IDS_GENERAL_LINEAR_MODEL_STATISTIC_TITLE"), true));
    }

    private void runHypoSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonHypothesisTests(this, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_GLM_HYPOTHESIS_TITLE"), true));
    }

    private void runEstimateSubDialog() {
        new ComplexSamplesGLMEstimatedMeans(this, false);
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new ComplexSamplesCommonSave(this, this.getResString("IDS_COMPLEX_SAMPLES_GLM_SAVE_TITLE"), true));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new ComplexSamplesGLMOptions(this, this.getResString("IDS_GENERAL_LINEAR_MODEL_OPTIONS_TITLE"), true));
    }
}

