/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.frequencies;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOptions;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.frequencies.FreqMissing;
import com.spss.java_client.ui.dialogs.complex_samples.frequencies.FreqStatistics;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FrequenciesDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final int MAX_LIMIT = 16;
    private ArrowButton mTableArrowButton;
    private ArrowButton mPopArrowButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetTableVarList;
    private TargetVariableList mTargetPopVarList;
    private JButton mStatisticsButton;
    private JButton mMissingButton;
    private JButton mOptionsButton;

    public FrequenciesDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CS_FREQUENCY_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* ").append(this.getResString("IDS_CS_FREQUENCY_GENERATE_SYNTAX")).append(".\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("CSTABULATE"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLAN FILE=")).append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName())).append("\n");
        if (ComplexSamplesPlan.getJointProbalityValue() != null) {
            stringBuffer.append(ComplexSamplesPlan.getJointProbalityValue());
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/TABLES VARIABLES=")).append(this.mTargetTableVarList.getVariablesStringList()).append("\n");
        if (this.mOptionsButton.isEnabled()) {
            stringBuffer.append(SyntaxUtil.getMultiValueSubCommand("SUBPOP TABLE", this.getPopulationTableElement(), false));
            stringBuffer.append(SyntaxUtil.getCommand(" DISPLAY=", false));
            bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_RADIO_SAME_TABLE");
            if (bl == null || bl.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getCommand("LAYERED"));
            } else {
                stringBuffer.append(SyntaxUtil.getCommand("SEPARATE"));
            }
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS "));
        bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_POPULATION");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("POPSIZE ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_TABLE")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("TABLEPCT", false));
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/STATISTICS "));
        bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_STANDARD");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("SE ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_COEFFICIENT")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("CV ", false));
        }
        bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_CONFIDENCE");
        String string = dialogDataModel.getString("IDS_LEVEL_FLOAT_TEXTFIELD");
        if (bl != null && bl.booleanValue()) {
            string = ComplexSamplesCommonSyntaxUtils.formattedSyntaxString(string);
            stringBuffer.append(SyntaxUtil.getCommand("CIN(" + string + ") ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_UNWEIGHTED")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("COUNT ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_DESIGN")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("DEFF ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_SQUARE")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("DEFFSQRT ", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_CUMULATIVE")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("CUMULATIVE", false));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_CHECK_TEST")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEST HOMOGENEITY"));
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_RADIO_USE_TABLE");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("TABLE", false));
        } else {
            stringBuffer.append(SyntaxUtil.getCommand("LISTWISE", false));
        }
        stringBuffer.append(SyntaxUtil.getCommand(" CLASSMISSING=", false));
        bl = dialogDataModel.getBoolean("IDS_CS_FREQUENCY_RADIO_USE_USER_INVALID");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getCommand("EXCLUDE", false));
        } else {
            stringBuffer.append(SyntaxUtil.getCommand("INCLUDE", false));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_frequency_main";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_freq_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetTableVarList.getModel().removeAll();
        this.mTargetPopVarList.getModel().removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetPopVarList.getModel()) {
            this.mOptionsButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mTargetTableVarList.getModel()) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetPopVarList.getModel().getSize() <= 0) {
            this.mOptionsButton.setEnabled(false);
        }
        if (this.mTargetTableVarList.getModel().getSize() <= 0) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_FREQ_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_FREQ_PLAN_FILE_NAME"))) {
            super.loadDialogState();
        } else {
            this.setVisible(true);
        }
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("IDS_CS_FREQ_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mTargetTableVarList);
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_CS_FREQUENCY_TARGET_LIST_ERROR"), vector);
        this.pack();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mTargetTableVarList = new TargetVariableList();
        this.mTargetTableVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetTableVarList.getModel().addListDataListener(this);
        this.mTargetTableVarList.setIdentifier("Table");
        this.mTargetPopVarList = new TargetVariableList();
        this.mTargetPopVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetPopVarList.getModel().addListDataListener(this);
        this.mTargetPopVarList.setIdentifier("Population");
        this.mTargetPopVarList.setMaxLimitOfList(16);
        this.mTableArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTableArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTableArrowButton.registerVariableList(this.mTargetTableVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTableArrowButton.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_CS_FREQUENCY_TARGET_LIST_ERROR")));
        this.mPopArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPopArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPopArrowButton.registerVariableList(this.mTargetPopVarList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mStatisticsButton = new JButton();
        this.mStatisticsButton.setAction(new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runStatisticsSubDialog();
            }
        });
        this.mMissingButton = new JButton();
        this.mMissingButton.setAction(new ToggleButtonAction("IDS_COMMON_MISS_VALUE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runMissingSubDialog();
            }
        });
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mStatisticsButton);
        this.addOptionsPanelButton(jPanel, this.mMissingButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void runStatisticsSubDialog() {
        new FreqStatistics(this);
    }

    private void runMissingSubDialog() {
        new FreqMissing(this);
    }

    private void runOptionsSubDialog() {
        new ComplexSamplesOptions(this, this.getResString("IDS_CS_FREQUENCY_OPTIONS_TITLE"));
    }

    private ArrayList<String> getPopulationTableElement() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        for (int i = 0; i < this.mTargetPopVarList.getModel().getSize(); ++i) {
            arrayList.add(this.mTargetPopVarList.getModel().getElementAt(i).getName());
            if (i >= this.mTargetPopVarList.getModel().getSize() - 1) continue;
            arrayList.add("BY");
        }
        return arrayList;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTableArrowButton);
        vector.add(this.mPopArrowButton);
        vector.add(this.mTargetTableVarList);
        vector.add(this.mTargetPopVarList);
        vector.add(this.mStatisticsButton);
        vector.add(this.mMissingButton);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private void setDefaults() {
        this.mOptionsButton.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void setUpUI(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetTableVarList);
        this.mTargetTableVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetTableVarList.getFixedCellHeight() * 7 + 2));
        jScrollPane2.setPreferredSize(this.mTargetTableVarList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mTargetPopVarList);
        jScrollPane3.setPreferredSize(this.mTargetPopVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CS_FREQUENCY_TARGET_LIST1_LABEL");
        jLabel.setLabelFor(this.mTargetTableVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CS_FREQUENCY_TARGET_LIST2_LABEL");
        jLabel2.setLabelFor(this.mTargetPopVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_CS_FREQUENCY_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_CS_FREQUENCY_EACH_COMBINATIONS"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTableArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 2, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(DialogUtil.getStandardControlInsets().top + 15, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPopArrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 4, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(DialogUtil.getStandardControlInsets().top + 5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 5, 1, 1, n, insets2);
    }
}

