/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.frequencies;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.frequencies.FrequenciesDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FreqStatistics
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String POPULATION_KEY = "IDS_CS_FREQUENCY_CHECK_POPULATION";
    static final String TABLE_KEY = "IDS_CS_FREQUENCY_CHECK_TABLE";
    static final String STANDARD_KEY = "IDS_CS_FREQUENCY_CHECK_STANDARD";
    static final String CONFIDENCE_KEY = "IDS_CS_FREQUENCY_CHECK_CONFIDENCE";
    static final String COEFFICIENT_KEY = "IDS_CS_FREQUENCY_CHECK_COEFFICIENT";
    static final String TEST_KEY = "IDS_CS_FREQUENCY_CHECK_TEST";
    static final String UNWEIGHTED_KEY = "IDS_CS_FREQUENCY_CHECK_UNWEIGHTED";
    static final String DESIGN_KEY = "IDS_CS_FREQUENCY_CHECK_DESIGN";
    static final String SQUARE_KEY = "IDS_CS_FREQUENCY_CHECK_SQUARE";
    static final String CUMULATIVE_KEY = "IDS_CS_FREQUENCY_CHECK_CUMULATIVE";
    static final String LEVEL_FLOAT_KEY = "IDS_LEVEL_FLOAT_TEXTFIELD";
    static final String CONFIDENCELEVEL_TEXT = "95";
    private JCheckBox mPopulationCheck;
    private JCheckBox mTableCheck;
    private JCheckBox mStandardCheck;
    private JCheckBox mConfidenceCheck;
    private JCheckBox mCoefficientCheck;
    private JCheckBox mTestCheck;
    private JCheckBox mUnweightedCheck;
    private JCheckBox mDesignCheck;
    private JCheckBox mSquareCheck;
    private JCheckBox mCumulativeCheck;
    private JLabel mLevel;
    static final float MCONFIDENCELEVEL_MIN_VALUE = 0.0f;
    static final float MCONFIDENCELEVEL_MAX_VALUE = 100.0f;
    static final int MCONFIDENCELEVEL_PRECISION = -1;
    private FloatTextField mConfidenceLevel;

    public FreqStatistics(FrequenciesDlg frequenciesDlg) {
        super(frequenciesDlg, frequenciesDlg.getResString("IDS_CS_FREQUENCY_STATISTICS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_freq_Stat";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = true;
        if (this.mConfidenceCheck.isSelected()) {
            this.mLevel.setEnabled(true);
            this.mConfidenceLevel.setEnabled(true);
            this.mConfidenceLevel.setOpaque(true);
            if (this.mConfidenceLevel.getText().length() <= 0) {
                bl = false;
            }
        } else {
            this.mLevel.setEnabled(false);
            this.mConfidenceLevel.setEnabled(false);
            this.mConfidenceLevel.setOpaque(false);
        }
        this.enableContinue(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mConfidenceLevel.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mConfidenceLevel.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean continuePressed() {
        String string = "";
        if (this.checkCellsPanel() && this.checkStatisticsPanel()) {
            return true;
        }
        string = !this.checkCellsPanel() ? this.getResString("ERR_CS_FREQUENCY_STATISTICS_CELLS_ERROR") : this.getResString("ERR_CS_FREQUENCY_STATISTICS_STATISTICS_ERROR");
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupCellsPanel();
        JPanel jPanel3 = this.setupStatisticsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, DialogUtil.getStandardControlInsets().left + 15, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTestCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel3);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mPopulationCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, POPULATION_KEY));
        this.mTableCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, TABLE_KEY));
        this.mStandardCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, STANDARD_KEY));
        this.mConfidenceCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CONFIDENCE_KEY));
        this.mCoefficientCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, COEFFICIENT_KEY));
        this.mTestCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, TEST_KEY));
        this.mUnweightedCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, UNWEIGHTED_KEY));
        this.mDesignCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, DESIGN_KEY));
        this.mSquareCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SQUARE_KEY));
        this.mCumulativeCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CUMULATIVE_KEY));
        this.mLevel = DialogUtil.createLabel(this, "IDS_CS_FREQUENCY_LEVEL_LABEL");
        this.mConfidenceLevel = new FloatTextField(0.0, 100.0, -1, true);
        this.mConfidenceLevel.setIncludeMinRange(false);
        this.mConfidenceLevel.setIncludeMaxRange(false);
        this.mConfidenceLevel.setAction((Action)new TextFieldAction(this, LEVEL_FLOAT_KEY));
        this.mConfidenceLevel.getDocument().addDocumentListener(this);
        this.mLevel.setLabelFor((Component)this.mConfidenceLevel);
        this.mConfidenceLevel.setMinimumSize(new Dimension(2, 2));
        this.mConfidenceCheck.addItemListener(this);
    }

    private JPanel setupCellsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CS_FREQUENCY_CELL_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top + 5, insets.left + 10, insets.bottom + 5, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mPopulationCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(insets.top + 5, insets.left + 105, insets.bottom + 5, insets.right);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTableCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CS_FREQUENCY_STATISTICS_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        Insets insets2 = new Insets(insets.top + 5, insets.left + 10, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStandardCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceCheck, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        insets2 = new Insets(insets.top + 5, insets.left + 28, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLevel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceLevel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(insets.top + 5, insets.left + 10, insets.bottom + 5, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCoefficientCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        insets2 = new Insets(insets.top + 5, insets.left + 70, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mUnweightedCheck, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDesignCheck, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSquareCheck, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(insets.top + 5, insets.left + 70, insets.bottom + 5, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCumulativeCheck, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.mLevel.setEnabled(false);
        this.mConfidenceLevel.setEnabled(false);
        this.mConfidenceLevel.setOpaque(false);
        this.mStandardCheck.setSelected(true);
        this.mPopulationCheck.setSelected(true);
        this.mConfidenceLevel.setText(CONFIDENCELEVEL_TEXT);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPopulationCheck);
        vector.add(this.mTableCheck);
        vector.add(this.mStandardCheck);
        vector.add(this.mConfidenceCheck);
        vector.add(this.mConfidenceLevel);
        vector.add(this.mCoefficientCheck);
        vector.add(this.mUnweightedCheck);
        vector.add(this.mDesignCheck);
        vector.add(this.mSquareCheck);
        vector.add(this.mCumulativeCheck);
        vector.add(this.mTestCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    private boolean checkCellsPanel() {
        return this.mPopulationCheck.isSelected() || this.mTableCheck.isSelected();
    }

    private boolean checkStatisticsPanel() {
        return this.mStandardCheck.isSelected() || this.mConfidenceCheck.isSelected() || this.mCoefficientCheck.isSelected() || this.mUnweightedCheck.isSelected() || this.mDesignCheck.isSelected() || this.mSquareCheck.isSelected() || this.mCumulativeCheck.isSelected();
    }
}

