/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.descriptive;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.descriptive.DescriptivesDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DescriptivesStatistics
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final int DOCUMENT_LENGTH = 20;
    static final int CONFIDENCELEVELTEXT_WIDTH = 2;
    static final int CONFIDENCELEVELTEXT_HEIGHT = 2;
    static final String DEFAULT_VALUE = "95";
    static final String MEAN_KEY = "IDS_COMP_SAMP_DESC_MEAN_CHECK";
    static final String SUM_KEY = "IDS_COMP_SAMP_DESC_SUM_CHECK";
    static final String STANDARD_KEY = "IDS_COMP_SAMP_DESC_STANDARD_CHECK";
    static final String CONFIDENCE_KEY = "IDS_COMP_SAMP_DESC_CONFIDENCE_CHECK";
    static final String COEFFICIENT_KEY = "IDS_COMP_SAMP_DESC_COEFFICIENT_CHECK";
    static final String UNWEIGHTED_KEY = "IDS_COMP_SAMP_DESC_UNWEIGHTED_CHECK";
    static final String DESIGN_KEY = "IDS_COMP_SAMP_DESC_DESIGN_CHECK";
    static final String SQUARE_KEY = "IDS_COMP_SAMP_DESC_SQUARE_CHECK";
    static final String POPULATION_KEY = "IDS_COMP_SAMP_DESC_POPULATION_CHECK";
    static final String LEVEL_FLOAT_KEY = "IDS_DESC_LEVEL_FLOAT_TEXTFIELD";
    static final float MCONFIDENCELEVEL_MIN_VALUE = 0.0f;
    static final float MCONFIDENCELEVEL_MAX_VALUE = 100.0f;
    static final int MCONFIDENCELEVEL_PRECISION = 5;
    static final String MEAN_TEST_KEY = "IDS_COMP_SAMP_DESC_MEAN_TEST_CHECK";
    static final String MEAN_VALUE_TEXT = "IDS_DESC_MEAN_VALUE_TEXT";
    static final String SUM_VALUE_TEXT = "IDS_DESC_SUM_VALUE_TEXT";
    static final String SUM_TEST_KEY = "IDS_COMP_SAMP_DESC_SUM_TEST_CHECK";
    private JCheckBox mMeanCheck;
    private JCheckBox mSumCheck;
    private JCheckBox mStandardCheck;
    private JCheckBox mConfidenceCheck;
    private JCheckBox mCoefficientCheck;
    private JCheckBox mUnweightedCheck;
    private JCheckBox mPopulationCheck;
    private JCheckBox mDesignCheck;
    private JCheckBox mSquareCheck;
    private JLabel mLevel;
    private FloatTextField mConfidenceLevelText;
    private JCheckBox mMeanTestCheck;
    private JCheckBox mSumTestCheck;
    private JLabel mMeanTestLabel;
    private JLabel mSumTestLabel;
    private FloatTextField mMeanValueText;
    private FloatTextField mSumValueText;
    private SpssButtonGroup mMeanGroup;
    private SpssButtonGroup mSumGroup;
    private SpssButtonGroup mStandGroup;
    private SpssButtonGroup mCoefGroup;

    public DescriptivesStatistics(DescriptivesDlg descriptivesDlg) {
        super(descriptivesDlg, descriptivesDlg.getResString("IDS_COMP_SAMP_DESC_STATISTICS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_desc_Stat";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMeanValueText)) {
            this.mMeanValueText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mSumValueText)) {
            this.mSumValueText.selectAll();
        }
        if (focusEvent.getSource().equals(this.mConfidenceLevelText)) {
            this.mConfidenceLevelText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setEnable();
        this.enableContinue(this.isValidate());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.isValidate());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.isValidate());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean continuePressed() {
        String string = "";
        if (this.checkSummariesPanel() && this.checkStatisticsPanel()) {
            return true;
        }
        string = !this.checkSummariesPanel() ? this.getResString("ERR_COMP_SAMP_FREQ_STATISTICS_CELLS_ERROR") : this.getResString("ERR_COMP_SAMP_FREQ_STATISTICS_STATISTICS_ERROR");
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupSummPanel();
        JPanel jPanel3 = this.setupStatisticsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void initVars() {
        this.mMeanCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, MEAN_KEY));
        this.mMeanCheck.addItemListener(this);
        this.mSumCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SUM_KEY));
        this.mSumCheck.addItemListener(this);
        this.mStandardCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, STANDARD_KEY));
        this.mConfidenceCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CONFIDENCE_KEY));
        this.mCoefficientCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, COEFFICIENT_KEY));
        this.mUnweightedCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, UNWEIGHTED_KEY));
        this.mDesignCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, DESIGN_KEY));
        this.mSquareCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SQUARE_KEY));
        this.mPopulationCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, POPULATION_KEY));
        this.mConfidenceLevelText = new FloatTextField(0.0, 100.0, -1, true);
        this.mConfidenceLevelText.setIncludeMinRange(false);
        this.mConfidenceLevelText.setIncludeMaxRange(false);
        this.mConfidenceLevelText.setAction((Action)new TextFieldAction(this, LEVEL_FLOAT_KEY));
        this.mConfidenceLevelText.getDocument().addDocumentListener(this);
        this.mConfidenceLevelText.addFocusListener((FocusListener)this);
        Dimension dimension = new Dimension(2, 2);
        this.mConfidenceLevelText.setMinimumSize(dimension);
        this.mConfidenceCheck.addItemListener(this);
        this.mLevel = DialogUtil.createLabel(this, "IDS_COMP_SAMP_DESC_LEVEL_LABEL");
        this.mLevel.setLabelFor((Component)this.mConfidenceLevelText);
        this.mMeanValueText = new FloatTextField();
        this.mMeanValueText.setDocument((Document)new FixedLengthNumericDocument(20, false, true));
        this.mMeanValueText.setAction((Action)new TextFieldAction(this, MEAN_VALUE_TEXT));
        this.mMeanValueText.getDocument().addDocumentListener(this);
        this.mMeanValueText.addFocusListener((FocusListener)this);
        this.mSumValueText = new FloatTextField();
        this.mSumValueText.setAction((Action)new TextFieldAction(this, SUM_VALUE_TEXT));
        this.mSumValueText.setDocument((Document)new FixedLengthNumericDocument(20, false, true));
        this.mSumValueText.getDocument().addDocumentListener(this);
        this.mSumValueText.addFocusListener((FocusListener)this);
        this.mMeanTestCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, MEAN_TEST_KEY));
        this.mMeanTestCheck.addItemListener(this);
        this.mMeanTestLabel = DialogUtil.createMultiLineLabel(this, "IDS_COMP_SAMP_DESC_MEAN_TEST_LABEL", 40);
        this.mSumTestCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SUM_TEST_KEY));
        this.mSumTestCheck.addItemListener(this);
        this.mSumTestLabel = DialogUtil.createMultiLineLabel(this, "IDS_COMP_SAMP_DESC_SUM_TEST_LABEL", 40);
        this.mSumTestLabel.setLabelFor((Component)this.mSumValueText);
        this.mMeanGroup = new SpssButtonGroup();
        this.mMeanGroup.add(this.mMeanCheck);
        this.mMeanGroup.add(this.mMeanTestCheck);
        this.mSumGroup = new SpssButtonGroup();
        this.mSumGroup.add(this.mSumCheck);
        this.mSumGroup.add(this.mSumTestCheck);
        this.mStandGroup = new SpssButtonGroup();
        this.mStandGroup.add(this.mStandardCheck);
        this.mStandGroup.add(this.mConfidenceCheck);
        this.mCoefGroup = new SpssButtonGroup();
        this.mCoefGroup.add(this.mCoefficientCheck);
        this.mCoefGroup.add(this.mUnweightedCheck);
        this.mCoefGroup.add(this.mPopulationCheck);
        this.mCoefGroup.add(this.mDesignCheck);
        this.mCoefGroup.add(this.mSquareCheck);
    }

    private JPanel setupSummPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COMP_SAMP_DESC_SUM_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top + 5, n2, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMeanCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(insets.top + 5, 4 * n2, n2, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSumCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        JComponent[] jComponentArray = new JComponent[]{this.mMeanTestCheck, this.mMeanTestLabel, this.mMeanValueText};
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(0, 3 * n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupMeanTestPanel(jComponentArray), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JComponent[] jComponentArray2 = new JComponent[]{this.mSumTestCheck, this.mSumTestLabel, this.mSumValueText};
        insets2.set(0, 6 * n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupMeanTestPanel(jComponentArray2), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMeanTestPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 0, 1, 2, n, null);
        Insets insets2 = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(4 * insets.top, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 2, 0, 1, 6, n, insets2);
        return jPanel;
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COMP_SAMP_DESC_STATISTICS_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top + 5, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mStandardCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceCheck, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        insets2.set(insets.top + 7, insets.left + 28, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLevel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(insets.top + 7, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceLevelText, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top + 5, insets.left + 10, insets.bottom + 5, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCoefficientCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets.top + 5, 6 * n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mUnweightedCheck, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPopulationCheck, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDesignCheck, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(insets.top + 5, 6 * n2, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSquareCheck, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.mLevel.setEnabled(false);
        this.mConfidenceLevelText.setEnabled(false);
        this.mStandardCheck.setSelected(true);
        this.mMeanCheck.setSelected(true);
        this.mConfidenceLevelText.setText(DEFAULT_VALUE);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMeanCheck);
        vector.add(this.mMeanTestCheck);
        vector.add(this.mMeanValueText);
        vector.add(this.mSumCheck);
        vector.add(this.mSumTestCheck);
        vector.add(this.mSumValueText);
        vector.add(this.mStandardCheck);
        vector.add(this.mConfidenceCheck);
        vector.add(this.mConfidenceLevelText);
        vector.add(this.mCoefficientCheck);
        vector.add(this.mUnweightedCheck);
        vector.add(this.mPopulationCheck);
        vector.add(this.mDesignCheck);
        vector.add(this.mSquareCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setEnable() {
        if (this.mMeanCheck.isSelected()) {
            this.mMeanTestCheck.setEnabled(true);
            if (this.mMeanTestCheck.isSelected()) {
                DialogUtil.enableHTMLComponent(this.mMeanTestLabel, true);
                this.mMeanValueText.setEnabled(true);
                this.mMeanValueText.setOpaque(true);
            } else {
                DialogUtil.enableHTMLComponent(this.mMeanTestLabel, false);
                this.mMeanValueText.setEnabled(false);
                this.mMeanValueText.setOpaque(false);
            }
        } else {
            DialogUtil.enableHTMLComponent(this.mMeanTestLabel, false);
            this.mMeanTestCheck.setEnabled(false);
            this.mMeanValueText.setEnabled(false);
            this.mMeanValueText.setOpaque(false);
        }
        if (this.mSumCheck.isSelected()) {
            this.mSumTestCheck.setEnabled(true);
            if (this.mSumTestCheck.isSelected()) {
                DialogUtil.enableHTMLComponent(this.mSumTestLabel, true);
                this.mSumValueText.setEnabled(true);
                this.mSumValueText.setOpaque(true);
            } else {
                DialogUtil.enableHTMLComponent(this.mSumTestLabel, false);
                this.mSumValueText.setEnabled(false);
                this.mSumValueText.setOpaque(false);
            }
        } else {
            this.mSumTestCheck.setEnabled(false);
            DialogUtil.enableHTMLComponent(this.mSumTestLabel, false);
            this.mSumValueText.setEnabled(false);
            this.mSumValueText.setOpaque(false);
        }
        if (this.mConfidenceCheck.isSelected()) {
            this.mLevel.setEnabled(true);
            this.mConfidenceLevelText.setEnabled(true);
            this.mConfidenceLevelText.setOpaque(true);
        } else {
            this.mLevel.setEnabled(false);
            this.mConfidenceLevelText.setEnabled(false);
            this.mConfidenceLevelText.setOpaque(false);
        }
    }

    private boolean isValidate() {
        boolean bl = true;
        if (this.mConfidenceLevelText.isEnabled() && this.mConfidenceLevelText.getText().length() <= 0) {
            return false;
        }
        if (this.mMeanValueText.isEnabled() && (this.mMeanValueText.getText().length() <= 0 || this.isNotValidText(this.mMeanValueText))) {
            return false;
        }
        if (this.mSumValueText.isEnabled() && (this.mSumValueText.getText().length() <= 0 || this.isNotValidText(this.mSumValueText))) {
            return false;
        }
        bl = true;
        return bl;
    }

    private boolean isNotValidText(FloatTextField floatTextField) {
        if (floatTextField.getText().length() > 0) {
            if (floatTextField.getText().length() == 1 && !Character.isDigit(floatTextField.getText().charAt(0))) {
                return true;
            }
            if (floatTextField.getText().length() == 2 && !Character.isDigit(floatTextField.getText().charAt(0)) && !Character.isDigit(floatTextField.getText().charAt(1))) {
                return true;
            }
        }
        return false;
    }

    private boolean checkSummariesPanel() {
        return this.mMeanCheck.isSelected() || this.mSumCheck.isSelected();
    }

    private boolean checkStatisticsPanel() {
        return this.mStandardCheck.isSelected() || this.mConfidenceCheck.isSelected() || this.mCoefficientCheck.isSelected() || this.mUnweightedCheck.isSelected() || this.mDesignCheck.isSelected() || this.mSquareCheck.isSelected() || this.mPopulationCheck.isSelected();
    }
}

