/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.descriptive;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOptions;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.descriptive.DescriptivesMissingValues;
import com.spss.java_client.ui.dialogs.complex_samples.descriptive.DescriptivesStatistics;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DescriptivesDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final int MAX_LIMIT_OF_SUBPOPULATIONS_LIST = 17;
    static final String MEASURE_TARGET_KEY = "IDS_COMP_SAMP_DESC_MEASURES_TARGET";
    static final String SUBPOPULATION_TARGET_KEY = "IDS_COMP_SAMP_DESC_SUBPOPULATION_TARGET";
    final String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    final String MISSING_BUTTON = "IDS_COMMON_MISS_VALUE_BUTTON";
    final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private ArrowButton mMesureArrowButton;
    private ArrowButton mPopArrowButton;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mMeasureTargetList;
    private TargetVariableList mTargetPopVarList;
    private JButton mStatisticsButton;
    private JButton mMissingButton;
    private JButton mOptionsButton;

    public DescriptivesDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMP_SAMP_DESC_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* ").append(this.getResString("IDS_CS_DESC_SYNTAX_TITLE")).append(".");
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getCommand("CSDESCRIPTIVES", true));
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PLAN FILE", CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()), true));
        if (ComplexSamplesPlan.getJointProbalityValue() != null) {
            stringBuffer.append(ComplexSamplesPlan.getJointProbalityValue());
        }
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("SUMMARY VARIABLES", this.mMeasureTargetList.getVariablesStringList(), false));
        if (this.mOptionsButton.isEnabled()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("SUBPOP TABLE", this.getPopulationTableElement().toString(), false));
            stringBuffer.append(" DISPLAY=");
            bl = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_RADIO_SAME_TABLE");
            if (bl == null || bl.booleanValue()) {
                stringBuffer.append("LAYERED");
            } else {
                stringBuffer.append("SEPARATE");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_MEAN_CHECK")) == null || bl.booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MEAN"));
            bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_MEAN_TEST_CHECK");
            if (bl != null && bl.booleanValue()) {
                if (Double.valueOf(dialogDataModel.getString("IDS_DESC_MEAN_VALUE_TEXT")) == 0.0) {
                    stringBuffer.append(" TTEST=0");
                } else {
                    stringBuffer.append(" TTEST=").append(dialogDataModel.getString("IDS_DESC_MEAN_VALUE_TEXT"));
                }
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_SUM_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SUM"));
            bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_SUM_TEST_CHECK");
            if (bl != null && bl.booleanValue()) {
                if (Double.valueOf(dialogDataModel.getString("IDS_DESC_SUM_VALUE_TEXT")) == 0.0) {
                    stringBuffer.append(" TTEST=0");
                } else {
                    stringBuffer.append(" TTEST=").append(dialogDataModel.getString("IDS_DESC_SUM_VALUE_TEXT"));
                }
            }
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/STATISTICS"));
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_STANDARD_CHECK");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append(" SE");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_COEFFICIENT_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" CV");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_UNWEIGHTED_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" COUNT");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_POPULATION_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" POPSIZE");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_DESIGN_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" DEFF");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_SQUARE_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append(" DEFFSQRT");
        }
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_CONFIDENCE_CHECK");
        String string = dialogDataModel.getString("IDS_DESC_LEVEL_FLOAT_TEXTFIELD");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(" CIN(").append(string).append(")");
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_RADIO_USE_ALL_VARIABLE");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("ANALYSIS");
        } else {
            stringBuffer.append("LISTWISE");
        }
        stringBuffer.append(" CLASSMISSING=");
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_DESC_RADIO_USE_USER_INVALID");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("EXCLUDE");
        } else {
            stringBuffer.append("INCLUDE");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_desc_main";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_desc_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.mMeasureTargetList.getModel().removeAll();
        this.mTargetPopVarList.getModel().removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetPopVarList.getModel()) {
            this.mOptionsButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mMeasureTargetList.getModel()) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetPopVarList.getModel().getSize() <= 0) {
            this.mOptionsButton.setEnabled(false);
        }
        if (this.mMeasureTargetList.getModel().getSize() <= 0) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mMeasureTargetList);
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMP_SAMP_DESC_MEASURES_MSG"), vector);
        this.pack();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_DESCRIPTIVES_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_DESCRIPTIVES_PLAN_FILE_NAME"))) {
            super.loadDialogState();
        } else {
            this.setVisible(true);
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("IDS_CS_DESCRIPTIVES_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mStatisticsButton = new JButton();
        this.mStatisticsButton.setAction(new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptivesDlg.this.runStatisticsButton();
            }
        });
        this.mMissingButton = new JButton();
        this.mMissingButton.setAction(new ToggleButtonAction("IDS_COMMON_MISS_VALUE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptivesDlg.this.runMissingButton();
            }
        });
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptivesDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mStatisticsButton);
        this.addOptionsPanelButton(jPanel, this.mMissingButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mMeasureTargetList = new TargetVariableList();
        this.mMeasureTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mMeasureTargetList.getModel().addListDataListener(this);
        this.mMeasureTargetList.setIdentifier(MEASURE_TARGET_KEY);
        this.mMeasureTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mMeasureTargetList.getFixedCellHeight() * 7 + 2));
        this.mMeasureTargetList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mMeasureTargetList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetPopVarList = new TargetVariableList();
        this.mTargetPopVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetPopVarList.getModel().addListDataListener(this);
        this.mTargetPopVarList.setIdentifier(SUBPOPULATION_TARGET_KEY);
        this.mTargetPopVarList.setMaxLimitOfList(17);
        this.mTargetPopVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetPopVarList.getFixedCellHeight() * 3 + 2));
        this.mTargetPopVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mMesureArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMesureArrowButton.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMP_SAMP_DESC_MEASURES_MSG")));
        this.mMesureArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mMesureArrowButton.registerVariableList(this.mMeasureTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mPopArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPopArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPopArrowButton.registerVariableList(this.mTargetPopVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void runStatisticsButton() {
        new DescriptivesStatistics(this);
    }

    private void runMissingButton() {
        new DescriptivesMissingValues(this);
    }

    private void runOptionsSubDialog() {
        new ComplexSamplesOptions(this, this.getResString("IDS_COMP_SAMP_DESC_OPTIONS_TITLE"));
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mMesureArrowButton);
        vector.add(this.mPopArrowButton);
        vector.add(this.mMeasureTargetList);
        vector.add(this.mTargetPopVarList);
        vector.add(this.mStatisticsButton);
        vector.add(this.mMissingButton);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mOptionsButton.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private StringBuffer getPopulationTableElement() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mTargetPopVarList.getModel().getSize(); ++i) {
            stringBuffer.append(this.mTargetPopVarList.getModel().getElementAt(i).getName());
            if (i >= this.mTargetPopVarList.getModel().getSize() - 1) continue;
            stringBuffer.append(" BY ");
        }
        return stringBuffer;
    }

    private void setUpUI(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mMeasureTargetList);
        jScrollPane2.setMinimumSize(this.mMeasureTargetList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mTargetPopVarList);
        jScrollPane3.setPreferredSize(this.mTargetPopVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COMP_SAMP_DESC_TARGET_LIST1_LABEL");
        jLabel.setLabelFor(this.mMeasureTargetList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_COMP_SAMP_DESC_TARGET_LIST2_LABEL");
        jLabel2.setLabelFor(this.mTargetPopVarList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_COMP_SAMP_DESC_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_CS_FREQUENCY_EACH_COMBINATIONS"));
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mMesureArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 2, n, null);
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(DialogUtil.getStandardControlInsets().top + 15, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPopArrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 4, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets2 = new Insets(DialogUtil.getStandardControlInsets().top + 5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 5, 1, 1, n, insets2);
    }
}

