/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.crosstabs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.crosstabs.CrosstabsDlg;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CrosstabsStats
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String LEVEL_TEXTFIELD_DEFAULT_VALUE = "95";
    static final String POPULATION_KEY = "IDS_COMP_SAMP_CROSSTABS_POPULATION_CHECK";
    static final String TABLE_KEY = "IDS_COMP_SAMP_CROSSTABS_TABLE_PERCENT_CHECK";
    static final String STANDARD_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_STANDARD";
    static final String CONFIDENCE_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_CONFIDENCE";
    static final String COEFFICIENT_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_COEFFICIENT";
    static final String TEST_KEY = "IDS_COMP_SAMP_CROSSTABS_TEST_INDEPENDENCE_CHECK";
    static final String UNWEIGHTED_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_UNWEIGHTED";
    static final String DESIGN_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_DESIGN";
    static final String SQUARE_KEY = "IDS_COMP_SAMP_CROSSTABS_CHECK_SQUARE";
    static final String LEVEL_FLOAT_KEY = "IDS_COMPLEX_SAMPLES_CROSSTABS_LEVEL_FLOAT_TEXTFIELD";
    static final String ROW_PRECENT_CHECK = "IDS_COMP_SAMP_CROSSTABS_ROW_PERCENT_CHECK";
    static final String COLUMN_PRECENT_CHECK = "IDS_COMP_SAMP_CROSSTABS_COLUMN_PERCENT_CHECK";
    static final String RESIDUALS_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_RESIDUALS_CHECK";
    static final String EXPECTED_VALS_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_EXPECTED_VALUES_CHECK";
    static final String ADJUSTED_RESIDUALS_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_ADJUSTED_RESIDUALS_CHECK";
    static final String ODDS_RATIO_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_ODDS_RATIO_CHECK";
    static final String RISK_DIFFERENCE_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_RISK_DIFF_CHECK";
    static final String RELATIVE_RISK_CHECKBOX = "IDS_COMP_SAMP_CROSSTABS_RELATIVE_RISK_CHECK";
    static final float MCONFIDENCELEVEL_MIN_VALUE = 0.0f;
    static final float MCONFIDENCELEVEL_MAX_VALUE = 100.0f;
    static final int MCONFIDENCELEVEL_PRECISION = 5;
    private JCheckBox mRowPercentCheck;
    private JCheckBox mColPercentCheck;
    private JCheckBox mResidualsCheck;
    private JCheckBox mExpectedCheck;
    private JCheckBox mAdjResidualsCheck;
    private JCheckBox mOddsRatioCheck;
    private JCheckBox mRiskDiffCheck;
    private JCheckBox mRelativeRiskCheck;
    private JCheckBox mPopulationCheck;
    private JCheckBox mTableCheck;
    private JCheckBox mStandardCheck;
    private JCheckBox mConfidenceCheck;
    private JCheckBox mCoefficientCheck;
    private JCheckBox mTestCheck;
    private JCheckBox mUnweightedCheck;
    private JCheckBox mDesignCheck;
    private JCheckBox mSquareCheck;
    private JLabel mLevel;
    private FloatTextField mConfidenceLevel;

    public CrosstabsStats(CrosstabsDlg crosstabsDlg) {
        super(crosstabsDlg, crosstabsDlg.getResString("IDS_COMP_SAMP_CROSSTABS_STATISTICS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_tabs_stat";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = true;
        if (itemEvent.getSource() == this.mConfidenceCheck) {
            if (this.mConfidenceCheck.isSelected()) {
                this.mLevel.setEnabled(true);
                this.mConfidenceLevel.setEnabled(true);
                this.mConfidenceLevel.setOpaque(true);
                if (this.mConfidenceLevel.getText().length() <= 0) {
                    bl = false;
                }
            } else {
                this.mLevel.setEnabled(false);
                this.mConfidenceLevel.setEnabled(false);
                this.mConfidenceLevel.setOpaque(false);
            }
            this.enableContinue(bl);
        }
        if (itemEvent.getSource() == this.mTableCheck) {
            this.mResidualsCheck.setEnabled(this.mTableCheck.isSelected());
            this.mExpectedCheck.setEnabled(this.mTableCheck.isSelected());
            this.mAdjResidualsCheck.setEnabled(this.mTableCheck.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mConfidenceLevel.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mConfidenceLevel.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mConfidenceLevel.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public boolean continuePressed() {
        String string = "";
        if (this.isCellsPanelCheckboxChecked() && this.isStatisticsPanelCheckboxChecked()) {
            return true;
        }
        string = !this.isCellsPanelCheckboxChecked() ? this.getResString("ERR_COMP_SAMP_CROSSTABS_STATISTICS_CELLS_ERROR") : this.getResString("ERR_COMP_SAMP_CROSSTABS_STATISTICS_STATISTICS_ERROR");
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupCellsPanel();
        JPanel jPanel3 = this.setupStatisticsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.createButtonGroup(jPanel3);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.setupSummariesPanel();
        DialogUtil.createButtonGroup(jPanel4);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getStandardControlInsets().left, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTestCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void initVars() {
        this.mPopulationCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, POPULATION_KEY));
        this.mTableCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, TABLE_KEY));
        this.mTableCheck.addItemListener(this);
        this.mRowPercentCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, ROW_PRECENT_CHECK));
        this.mColPercentCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, COLUMN_PRECENT_CHECK));
        this.mStandardCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, STANDARD_KEY));
        this.mConfidenceCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CONFIDENCE_KEY));
        this.mCoefficientCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, COEFFICIENT_KEY));
        this.mTestCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, TEST_KEY));
        this.mUnweightedCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, UNWEIGHTED_KEY));
        this.mDesignCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, DESIGN_KEY));
        this.mSquareCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SQUARE_KEY));
        this.mResidualsCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, RESIDUALS_CHECKBOX));
        this.mExpectedCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, EXPECTED_VALS_CHECKBOX));
        this.mAdjResidualsCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, ADJUSTED_RESIDUALS_CHECKBOX));
        this.mOddsRatioCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, ODDS_RATIO_CHECKBOX));
        this.mRiskDiffCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, RISK_DIFFERENCE_CHECKBOX));
        this.mRelativeRiskCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, RELATIVE_RISK_CHECKBOX));
        this.mLevel = DialogUtil.createLabel(this, "IDS_COMP_SAMP_CROSSTABS_LEVEL_LABEL");
        this.mConfidenceLevel = new FloatTextField(0.0, 100.0, 5, true);
        this.mConfidenceLevel.setAction((Action)new TextFieldAction(this, LEVEL_FLOAT_KEY));
        this.mConfidenceLevel.getDocument().addDocumentListener(this);
        this.mConfidenceLevel.setAllowMinMax(false, false);
        this.mConfidenceCheck.addItemListener(this);
        this.mLevel.setLabelFor((Component)this.mConfidenceLevel);
    }

    private JPanel setupCellsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COMP_SAMP_CROSSTABS_CELL_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mPopulationCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowPercentCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mColPercentCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTableCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COMP_SAMP_CROSSTABS_STATISTICS_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStandardCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupLevelEditPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCoefficientCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExpectedCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mUnweightedCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDesignCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSquareCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mResidualsCheck, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAdjResidualsCheck, gridBagConstraints, 1, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLevelEditPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLevel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceLevel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSummariesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COMP_SAMP_CROSSTABS_SUMMARIES_PANEL_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mOddsRatioCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRelativeRiskCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRiskDiffCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mLevel.setEnabled(false);
        this.mConfidenceLevel.setEnabled(false);
        this.mConfidenceLevel.setOpaque(false);
        this.mStandardCheck.setSelected(true);
        this.mPopulationCheck.setSelected(true);
        this.mConfidenceLevel.setText(LEVEL_TEXTFIELD_DEFAULT_VALUE);
        this.mResidualsCheck.setEnabled(false);
        this.mExpectedCheck.setEnabled(false);
        this.mAdjResidualsCheck.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPopulationCheck);
        vector.add(this.mRowPercentCheck);
        vector.add(this.mColPercentCheck);
        vector.add(this.mTableCheck);
        vector.add(this.mStandardCheck);
        vector.add(this.mConfidenceCheck);
        vector.add(this.mConfidenceLevel);
        vector.add(this.mCoefficientCheck);
        vector.add(this.mExpectedCheck);
        vector.add(this.mUnweightedCheck);
        vector.add(this.mDesignCheck);
        vector.add(this.mSquareCheck);
        vector.add(this.mResidualsCheck);
        vector.add(this.mAdjResidualsCheck);
        vector.add(this.mOddsRatioCheck);
        vector.add(this.mRelativeRiskCheck);
        vector.add(this.mRiskDiffCheck);
        vector.add(this.mTestCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean isCellsPanelCheckboxChecked() {
        return this.mPopulationCheck.isSelected() || this.mTableCheck.isSelected() || this.mRowPercentCheck.isSelected() || this.mColPercentCheck.isSelected();
    }

    private boolean isStatisticsPanelCheckboxChecked() {
        return this.mStandardCheck.isSelected() || this.mConfidenceCheck.isSelected() || this.mCoefficientCheck.isSelected() || this.mUnweightedCheck.isSelected() || this.mDesignCheck.isSelected() || this.mSquareCheck.isSelected() || this.mResidualsCheck.isSelected() || this.mExpectedCheck.isSelected() || this.mAdjResidualsCheck.isSelected();
    }
}

