/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.crosstabs;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesOptions;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.crosstabs.CrosstabsMissingVals;
import com.spss.java_client.ui.dialogs.complex_samples.crosstabs.CrosstabsStats;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CrosstabsDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final int SUBPOPULATION_LIST_MAX_LIMIT = 16;
    static final String ROWS_LIST = "IDS_COMPLEX_SAMPLES_CROSSTABS_ROWS_LIST";
    static final String COLUMNS_LIST = "IDS_COMPLEX_SAMPLES_CROSSTABS_COLUMNS_LIST";
    static final String SUPPOPULATION_LIST = "IDS_COMPLEX_SAMPLES_CROSSTABS_SUBPOPULATIONS_LIST";
    static String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    static String MISSING_BUTTON = "IDS_COMMON_MISS_VALUE_BUTTON";
    static String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private TargetVariableList mRowsList;
    private TargetVariableList mColumnList;
    private TargetVariableList mSubPopulationsList;
    private ArrowButton mRowListArrow;
    private ArrowButton mColumnListArrow;
    private ArrowButton mSubPopulationsListArrow;
    private SrcVariableList mSrcVarList;
    private JButton mStatisticsButton;
    private JButton mMissingButton;
    private JButton mOptionsButton;

    public CrosstabsDlg(JFrame jFrame) {
        super(jFrame, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_COMP_SAMP_CROSSTABS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableButtons();
        if (listDataEvent.getSource() == this.mSubPopulationsList.getModel()) {
            this.mOptionsButton.setEnabled(this.mSubPopulationsList.getModel().getSize() > 0);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableButtons();
        if (listDataEvent.getSource() == this.mSubPopulationsList.getModel()) {
            this.mOptionsButton.setEnabled(this.mSubPopulationsList.getModel().getSize() > 0);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableButtons();
        if (listDataEvent.getSource() == this.mSubPopulationsList.getModel()) {
            this.mOptionsButton.setEnabled(this.mSubPopulationsList.getModel().getSize() > 0);
        }
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("* ");
        stringBuffer.append(this.getResString("IDS_COMP_SAMP_CROSSTABS_TITLE")).append(".");
        stringBuffer.append("\n").append(SyntaxUtil.getMainCommand("CSTABULATE"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/PLAN FILE=")).append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        if (ComplexSamplesPlan.getJointProbalityValue() != null) {
            String string2 = ComplexSamplesPlan.getJointProbalityValue();
            if (string2.endsWith("\n")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TABLES VARIABLES=")).append(this.mRowsList.getVariablesStringList());
        stringBuffer.append(" BY ").append(this.mColumnList.getVariablesStringList());
        int n = this.mSubPopulationsList.getModel().getSize();
        if (n > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SUBPOP TABLE="));
            if (n == 1) {
                stringBuffer.append(this.mSubPopulationsList.getVariablesStringList());
            } else {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(this.mSubPopulationsList.getModel().getElementAt(i).getName());
                    if (i >= n - 1) continue;
                    stringBuffer.append(" BY ");
                }
            }
            stringBuffer.append(" DISPLAY=");
            object = dialogDataModel.getBoolean("IDS_COMPLEX_SAMPLES_RADIO_SAME_TABLE");
            if (object == null || ((Boolean)object).booleanValue()) {
                stringBuffer.append("LAYERED");
            } else {
                stringBuffer.append("SEPARATE");
            }
        }
        object = "";
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/CELLS"));
        Boolean bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_POPULATION_CHECK");
        if (bl != null && bl.booleanValue()) {
            object = (String)object + " POPSIZE";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_ROW_PERCENT_CHECK")) != null && bl.booleanValue()) {
            object = (String)object + " ROWPCT";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_COLUMN_PERCENT_CHECK")) != null && bl.booleanValue()) {
            object = (String)object + " COLPCT";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_TABLE_PERCENT_CHECK")) != null && bl.booleanValue()) {
            object = (String)object + " TABLEPCT";
        }
        if (((String)object).equals("")) {
            stringBuffer.append(" POPSIZE");
        } else {
            stringBuffer.append((String)object);
        }
        String string3 = "";
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/STATISTICS "));
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_STANDARD");
        if (bl != null && bl.booleanValue()) {
            string3 = string3 + "SE ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_COEFFICIENT")) != null && bl.booleanValue()) {
            string3 = string3 + "CV ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_CONFIDENCE")) != null && bl.booleanValue()) {
            string3 = string3 + "CIN(";
            string = dialogDataModel.getString("IDS_COMPLEX_SAMPLES_CROSSTABS_LEVEL_FLOAT_TEXTFIELD");
            string3 = string != null && !string.equals("") ? string3 + string : string3 + "95";
            string3 = string3 + ") ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_TABLE_PERCENT_CHECK")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_EXPECTED_VALUES_CHECK");
            if (bl != null && bl.booleanValue()) {
                string3 = string3 + "EXPECTED ";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_RESIDUALS_CHECK")) != null && bl.booleanValue()) {
                string3 = string3 + "RESID ";
            }
            if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_ADJUSTED_RESIDUALS_CHECK")) != null && bl.booleanValue()) {
                string3 = string3 + "ASRESID ";
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_UNWEIGHTED")) != null && bl.booleanValue()) {
            string3 = string3 + "COUNT ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_DESIGN")) != null && bl.booleanValue()) {
            string3 = string3 + "DEFF ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_CHECK_SQUARE")) != null && bl.booleanValue()) {
            string3 = string3 + "DEFFSQRT ";
        }
        if ((string3 = string3.trim()).equals("")) {
            stringBuffer.append("SE");
        } else {
            stringBuffer.append(string3);
        }
        string = "";
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_ODDS_RATIO_CHECK");
        if (bl != null && bl.booleanValue()) {
            string = string + "ODDSRATIO ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_RELATIVE_RISK_CHECK")) != null && bl.booleanValue()) {
            string = string + "RELRISK ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_RISK_DIFF_CHECK")) != null && bl.booleanValue()) {
            string = string + "RISKDIFF ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_TEST_INDEPENDENCE_CHECK")) != null && bl.booleanValue()) {
            string = string + "INDEPENDENCE ";
        }
        if (!(string = string.trim()).equals("")) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TEST ")).append(string);
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_RADIO_USE_LISTWISE");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("LISTWISE ");
        } else {
            stringBuffer.append("TABLE ");
        }
        stringBuffer.append("CLASSMISSING=");
        bl = dialogDataModel.getBoolean("IDS_COMP_SAMP_CROSSTABS_RADIO_USE_USER_VALID");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("INCLUDE");
        } else {
            stringBuffer.append("EXCLUDE");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_crosstab_main";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_csan_tabs_main";
    }

    @Override
    public void reset() {
        super.reset();
        this.mRowsList.removeAll();
        this.mColumnList.removeAll();
        this.mSubPopulationsList.removeAll();
        this.setDefaults();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        Vector<VariableList> vector = new Vector<VariableList>();
        vector.add(this.mRowsList);
        vector.add(this.mColumnList);
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("ERR_COMP_SAMP_CROSSTABS_PLAN_VAR_NOT_ALLOWED_IN_ROWS_LIST_MSG"));
        vector2.add(this.getResString("ERR_COMP_SAMP_CROSSTABS_PLAN_VAR_NOT_ALLOWED_IN_COLUMN_LIST_MSG"));
        this.mVarMoveHandler = new ComplexSamplesPlan.varTargetMoveHandler(vector, vector2);
        this.pack();
        this.setDefaults();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mRowsList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mRowsList.setIdentifier(ROWS_LIST);
        this.mRowsList.getModel().addListDataListener(this);
        this.mRowsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mRowsList.getFixedCellHeight() * 4 + 2));
        this.mColumnList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mColumnList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mColumnList.setIdentifier(COLUMNS_LIST);
        this.mColumnList.getModel().addListDataListener(this);
        this.mSubPopulationsList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mSubPopulationsList.addVarFilter(new ComplexSamplesPlan.sourceListWtFilter());
        this.mSubPopulationsList.setIdentifier(SUPPOPULATION_LIST);
        this.mSubPopulationsList.getModel().addListDataListener(this);
        this.mSubPopulationsList.setMaxLimitOfList(16);
        this.mRowListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubPopulationsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowListArrow.registerVariableList(this.mRowsList, SpssArrowButton.ButtonOrientation.left);
        this.mColumnListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnListArrow.registerVariableList(this.mColumnList, SpssArrowButton.ButtonOrientation.left);
        this.mRowListArrow.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMP_SAMP_CROSSTABS_PLAN_VAR_NOT_ALLOWED_IN_ROWS_LIST_MSG")));
        this.mColumnListArrow.setVarMoveHandler(new ComplexSamplesPlan.varTargetMoveHandler(this.getResString("ERR_COMP_SAMP_CROSSTABS_PLAN_VAR_NOT_ALLOWED_IN_COLUMN_LIST_MSG")));
        this.mSubPopulationsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubPopulationsListArrow.registerVariableList(this.mSubPopulationsList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mStatisticsButton = new JButton();
        this.mStatisticsButton.setAction(new ToggleButtonAction(STATISTICS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrosstabsDlg.this.runStatisticsButton();
            }
        });
        this.mMissingButton = new JButton();
        this.mMissingButton.setAction(new ToggleButtonAction(MISSING_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrosstabsDlg.this.runMissingButton();
            }
        });
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrosstabsDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mStatisticsButton);
        this.addOptionsPanelButton(jPanel, this.mMissingButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        if (this.getDialogDataModel().getString("IDS_CS_CROSSTABS_PLAN_FILE_NAME") != null && ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName().equals(this.getDialogDataModel().getString("IDS_CS_CROSSTABS_PLAN_FILE_NAME"))) {
            super.loadDialogState();
        } else {
            this.setVisible(true);
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("IDS_CS_CROSSTABS_PLAN_FILE_NAME", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRowListArrow);
        vector.add(this.mColumnListArrow);
        vector.add(this.mSubPopulationsListArrow);
        vector.add(this.mRowsList);
        vector.add(this.mColumnList);
        vector.add(this.mSubPopulationsList);
        vector.add(this.mStatisticsButton);
        vector.add(this.mMissingButton);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableButtons() {
        this.enableOkPaste(this.mRowsList.getModel().getSize() > 0 && this.mColumnList.getModel().getSize() > 0);
    }

    private void setDefaults() {
        this.mOptionsButton.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mRowsList);
        jScrollPane2.setMinimumSize(this.mRowsList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mColumnList);
        jScrollPane3.setPreferredSize(this.mColumnList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane4 = new JScrollPane(this.mSubPopulationsList);
        jScrollPane4.setPreferredSize(this.mSubPopulationsList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COMP_SAMP_CROSSTABS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_COMP_SAMP_CROSSTABS_ROW_LIST_LABEL");
        jLabel2.setLabelFor(this.mRowsList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_COMP_SAMP_CROSSTABS_COLUMN_LIST_LABEL");
        jLabel3.setLabelFor(this.mColumnList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_COMP_SAMP_CROSSTABS_SUBPOPULATION_LIST_LABEL");
        jLabel4.setLabelFor(this.mSubPopulationsList);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_COMP_SAMP_CROSSTABS_EACH_COMBINATIONS"));
        jTextArea.setFont(jLabel3.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        jTextArea.setRows(2);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRowListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mColumnListArrow, gridBagConstraints, 1, 2, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 10;
        insets2.set(DialogUtil.getComponentGroupGap() * 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 5, 1, 1, n, insets2);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSubPopulationsListArrow, gridBagConstraints, 1, 6, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 6, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        Insets insets4 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 7, 1, 1, n, insets4);
        return jPanel;
    }

    private void runStatisticsButton() {
        new CrosstabsStats(this);
    }

    private void runMissingButton() {
        new CrosstabsMissingVals(this);
    }

    private void runOptionsSubDialog() {
        new ComplexSamplesOptions(this, this.getResString("IDS_COMP_SAMP_CROSSTABS_OPTIONS_TITLE"));
    }
}

