/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderDescArea;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.FunctionObject;
import com.spss.java_client.ui.controls.IDoubleClickListener;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.TextHighlighter;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSPlanCoxRegDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class DefineTimeDepPredictorsDlg
extends BaseSubDialog
implements DocumentListener,
ItemListener,
MouseListener {
    static final String DISPLAY_KEY = "IDS_COX_REG_TDP_DISPLAY_KEY";
    public static final String TDP_VARIABLE = "IDS_COX_REG_TDP_VARIABLE";
    private final int NAME_WIDTH = 300;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private StringTextField mTargetTextField;
    private ExpressionBuilderTextArea mNumericTextArea;
    private ExpressionBuilderDescArea mDescriptionTextArea;
    private SrcVariableList mSrcList;
    private ExpressionAreaArrowButton mNumericArrowButton;
    private CalcWidget mCalcPanel;
    private JList mSpecialVariableList;
    private FunctionListControls mFunctionControls;
    private JComboBox mDisplayCombo;
    private JButton mInsertButton;
    private TextHighlighter mHighlightHelper;
    private ISpssVariable mTimeDependentVariable;
    private Hashtable<String, TimeDependentPredictors> mTDPVariables = new Hashtable();
    private Set<String> mPlanVariables = new HashSet<String>();
    private String mVarNameToEdit = null;

    public DefineTimeDepPredictorsDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CSCOX_PREDICTOR_TDP_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
        this.mVarNameToEdit = string;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mDisplayCombo) {
            int n = this.mDisplayCombo.getSelectedIndex();
            if (n >= 16) {
                ++n;
            }
            this.mFunctionControls.updateFunctionListModel(n);
            this.mInsertButton.setEnabled(false);
        }
    }

    public ISpssVariable getNewTimeVar() {
        TimeDependentPredictors timeDependentPredictors;
        if (this.mVarNameToEdit != null) {
            timeDependentPredictors = this.mTDPVariables.get(this.mVarNameToEdit.toUpperCase());
        } else {
            timeDependentPredictors = new TimeDependentPredictors();
            timeDependentPredictors.setName(this.mTargetTextField.getText());
            timeDependentPredictors.setExpression(this.mNumericTextArea.getText());
        }
        SPSS_Format sPSS_Format = new SPSS_Format();
        sPSS_Format.setFormatType(FormatType.TIME);
        timeDependentPredictors.setFormat(sPSS_Format);
        return timeDependentPredictors;
    }

    public void setSelectedTDP(String string) {
        TimeDependentPredictors timeDependentPredictors = this.mTDPVariables.get(string.toUpperCase());
        if (timeDependentPredictors != null) {
            this.mTargetTextField.setText(string);
            this.mNumericTextArea.setText(timeDependentPredictors.getExpression());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JList) {
            this.mInsertButton.setEnabled(true);
        }
        if (object == this.mTargetTextField || object == this.mNumericTextArea) {
            this.updateContinue();
        }
    }

    public void updateContinue() {
        if (this.mTargetTextField.getText().length() > 0 && this.mNumericTextArea.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    public String getIActionKey() {
        return "transform_compute_variable";
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (!this.mNumericTextArea.validateContents() || !this.mTargetTextField.validateContents()) {
            return false;
        }
        String string = this.mNumericTextArea.getText();
        String string2 = this.mTargetTextField.getText();
        if (VarNameValidator.validateSPSSName((String)string2, (boolean)true) != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_CSCOX_TDP_MESG1"), VersionInfo.getAppVersionString());
            return false;
        }
        for (n = 0; n < this.mSrcList.getModel().getSize(); ++n) {
            if (!this.mSrcList.getModel().getElementAt(n).getName().equalsIgnoreCase(string2)) continue;
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_CSCOX_TDP_MESG2"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mPlanVariables.contains(string2.toUpperCase())) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_CSCOX_TDP_MESG2"), VersionInfo.getAppVersionString());
            return false;
        }
        n = this.isValidExpression(string, string2, false) ? 1 : 0;
        if (n == 0) {
            return false;
        }
        if (this.mVarNameToEdit != null) {
            if (!this.mVarNameToEdit.equals(string2)) {
                this.mTDPVariables.remove(this.mVarNameToEdit);
                TimeDependentPredictors timeDependentPredictors = new TimeDependentPredictors();
                timeDependentPredictors.setName(string2);
                timeDependentPredictors.setExpression(string);
                this.mTDPVariables.put(string2.toUpperCase(), timeDependentPredictors);
                this.mVarNameToEdit = string2;
            } else {
                TimeDependentPredictors timeDependentPredictors = this.mTDPVariables.get(this.mVarNameToEdit.toUpperCase());
                timeDependentPredictors.setExpression(string);
                this.mTDPVariables.put(this.mVarNameToEdit.toUpperCase(), timeDependentPredictors);
            }
        } else {
            if (this.mTDPVariables.containsKey(string2.toUpperCase())) {
                SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_CSCOX_TDP_MESG2"), VersionInfo.getAppVersionString());
                return false;
            }
            TimeDependentPredictors timeDependentPredictors = new TimeDependentPredictors();
            timeDependentPredictors.setName(string2);
            timeDependentPredictors.setExpression(string);
            this.mTDPVariables.put(string2.toUpperCase(), timeDependentPredictors);
            this.mTargetTextField.requestFocus();
            this.mTargetTextField.selectAll();
        }
        return super.continuePressed();
    }

    public void reset() {
        this.setDefaults();
        this.mTargetTextField.setText("");
        this.mFunctionControls.reset();
        this.mTDPVariables.clear();
        if (this.mNumericArrowButton != null) {
            this.mNumericArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mNumericArrowButton.setEnabled(true);
        }
        this.mVarNameToEdit = null;
    }

    public SrcVariableList getSourceList() {
        return this.mSrcList;
    }

    public boolean isValidExpression(String string, String string2, boolean bl) {
        boolean bl2;
        if (!this.checkExpression(string)) {
            this.mNumericTextArea.requestFocus();
            this.mNumericTextArea.selectAll();
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_CSCOX_TDP_MESG3"), VersionInfo.getAppVersionString());
            return false;
        }
        ExpressionValidator expressionValidator = new ExpressionValidator();
        if (!string.equals("T_") && !(bl2 = expressionValidator.validateComputeExpressionWithTime(string, string2, false))) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), expressionValidator.checkError(), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_define_timedep";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mNumericTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mSpecialVariableList);
        }
        this.setDefaults();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.populateSourceList();
        Object[] objectArray = dialogDataModel.getArray(TDP_VARIABLE);
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (!(object instanceof TimeDependentPredictors)) continue;
                this.mTDPVariables.put(((TimeDependentPredictors)object).getName().toUpperCase(), (TimeDependentPredictors)object);
            }
        }
        this.mFunctionControls.loadFunctionState(dialogDataModel);
        if (this.mVarNameToEdit != null) {
            this.setSelectedTDP(this.mVarNameToEdit);
        } else {
            this.mTargetTextField.setText("");
            this.mNumericTextArea.setText("");
        }
        this.mTargetTextField.requestFocus();
        this.mTargetTextField.selectAll();
        this.updateContinue();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString("IDS_COMPUTE_NUMERIC_EXPRESSION_LABEL", this.mNumericTextArea.getText());
        dialogDataModel.putArray(TDP_VARIABLE, this.mTDPVariables.values().toArray());
        this.mFunctionControls.saveFunctionState(dialogDataModel);
        return super.saveState(dialogDataModel);
    }

    private boolean checkExpression(String string) {
        int n = string.indexOf("T_");
        return string.contains("T_") && (n > 0 && n + 2 < string.length() ? !Character.isLetter(string.charAt(n - 1)) && !Character.isLetter(string.charAt(n + 2)) : (n > 0 ? !Character.isLetter(string.charAt(n - 1)) : (n + 2 < string.length() ? !Character.isLetter(string.charAt(n + 2)) : string.equals("T_"))));
    }

    private void initVars() {
        this.mFunctionControls = new FunctionListControls(true, true);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mTargetTextField = new StringTextField(20);
        this.mTargetTextField.setValidateOnFocusLost(false);
        this.mTargetTextField.setAction(new TextFieldAction(this, "IDS_COMPUTE_TARGET_VARIABLE_LABEL"));
        this.mTargetTextField.getDocument().addDocumentListener(this);
        this.mTargetTextField.setMinimumSize(new Dimension(300, this.mTargetTextField.getPreferredSize().height));
        this.mNumericTextArea = new ExpressionBuilderTextArea(3, 30);
        this.mNumericTextArea.setLineWrap(true);
        this.mHighlightHelper = new TextHighlighter((JTextComponent)((Object)this.mNumericTextArea));
        this.mDescriptionTextArea = (ExpressionBuilderDescArea)this.mFunctionControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setBackground(this.getBackground());
        this.mSrcList = new SrcVariableList();
        this.mSrcList.setModel(new SrcListModel(this.mSrcList));
        this.mSrcList.setIdentifier("SourceList");
        this.mSrcList.setSelectionMode(0);
        this.mSrcList.addDoubleClickListener(new ComputeDoubleClickListener());
        this.mTimeDependentVariable = new SpssCalculatedScaleVar();
        this.mTimeDependentVariable.setName("T_");
        this.mTimeDependentVariable.setLabel("Time");
        SPSS_Format sPSS_Format = new SPSS_Format();
        sPSS_Format.setFormatType(FormatType.TIME);
        this.mTimeDependentVariable.setFormat(sPSS_Format);
        this.mNumericArrowButton = new ExpressionAreaArrowButton();
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mNumericTextArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mSpecialVariableList = this.mFunctionControls.getFunctionList();
        this.mSpecialVariableList.setSelectionMode(0);
        this.mSpecialVariableList.addMouseListener(this);
        this.mFunctionControls.setExpressionArea((JTextArea)((Object)this.mNumericTextArea));
        this.mFunctionControls.setSrcList(this.mSrcList);
        this.mFunctionControls.setFunctionGroupIdentifier("Function Grp");
        this.mFunctionControls.setFunctionListIdentifier("Function list");
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mNumericTextArea.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mNumericTextArea), this, dialogFocusTraversalPolicy, true));
        this.mNumericTextArea.getDocument().addDocumentListener(this);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        this.mNumericArrowButton.registerComponents(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mNumericArrowButton.registerComponents((JComponent)((Object)this.mNumericTextArea), SpssArrowButton.ButtonOrientation.left);
        this.mInsertButton = new JButton(new InsertAction());
        List<String> list = FunctionList.getInstance().getFunctionGroups();
        this.mDisplayCombo = new JComboBox();
        this.mDisplayCombo.addItemListener(this);
        this.mDisplayCombo.setAction(new ComboboxAction(this, DISPLAY_KEY));
        for (String string : list) {
            if (string.equals(ResUtil.getCommonDlgString("IDS_COMP_GROUP_STRING"))) continue;
            this.mDisplayCombo.addItem(string);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTargetTextField);
        vector.add(this.mSrcList);
        vector.add(this.mNumericArrowButton);
        vector.add((Object)this.mNumericTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mSpecialVariableList);
        vector.add(this.mDisplayCombo);
        vector.add(this.mInsertButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setDefaults() {
        this.mNumericTextArea.setText("");
        this.mDisplayCombo.setSelectedIndex(1);
        this.mInsertButton.setEnabled(false);
        this.mSrcList.setSelectedIndex(0);
        this.mTargetTextField.requestFocus();
        this.mTargetTextField.setText("");
        this.updateContinue();
    }

    private void setUpUI(JPanel jPanel) {
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CSCOX_PREDICTOR_TDP_NUMERIC_EXPR");
        jLabel.setLabelFor((Component)((Object)this.mNumericTextArea));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mNumericTextArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(70, 70));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_COMPSAMP_VARIABLES_LABEL");
        jLabel2.setLabelFor(this.mSrcList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSrcList);
        jScrollPane2.setPreferredSize(this.mSrcList.getMinimumSize());
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupNamePanel(), this.mConstraints, 0, 0, 3, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(n2, n2, 0, 0);
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, this.mConstraints, 0, 2, 1, 3, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mNumericArrowButton, this.mConstraints, 1, 2, 1, 1, 19, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2, insets.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 2, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 2, 1, 1, n, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupCalculatorPanel(), this.mConstraints, 2, 3, 1, 1, n, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupFunctionsAndVariablesPanel(), this.mConstraints, 2, 4, 1, 1, n, null);
    }

    private JPanel setupNamePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_TIME_DEPENDENT_VAR_IMAGE")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CSCOX_PREDICTOR_TDP_NAME");
        jLabel.setIcon(imageIcon);
        jLabel.setLabelFor((Component)((Object)this.mTargetTextField));
        Insets insets = new Insets(0, n2, 0, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2 * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTargetTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFunctionsAndVariablesPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_CSCOX_PREDICTOR_TDP_FUNCTIONS_LIST"));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CSCOX_PREDICTOR_TDP_DESCRIPTION");
        jLabel.setLabelFor(this.mDescriptionTextArea);
        JScrollPane jScrollPane = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CSCOX_PREDICTOR_TDP_FUNCTION");
        jLabel2.setLabelFor(this.mSpecialVariableList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSpecialVariableList);
        jScrollPane2.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, this.mConstraints, 0, 1, 1, 1, n2, this.mInsets);
        this.mConstraints.fill = 0;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 1, 0, 1, 1, n2, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(0, 0, 0, n);
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 1, 1, 1, 1, n2, this.mInsets);
        JPanel jPanel2 = this.setupFunctionDisplayPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n, n, n / 2, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 2, 2, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupCalculatorPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_CSCOX_PREDICTOR_TDP_CALCULATOR_TITLE"));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        this.mInsets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupFunctionDisplayPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CSCOX_PREDICTOR_TDP_DISPLAY");
        jLabel.setLabelFor(this.mDisplayCombo);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCombo, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        this.mInsertButton.setMinimumSize(new Dimension(this.mInsertButton.getPreferredSize().width, this.mInsertButton.getPreferredSize().height));
        DialogUtil.addUsingGBL(jPanel, this.mInsertButton, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        jPanel.setMinimumSize(new Dimension(jPanel.getPreferredSize().width, jPanel.getPreferredSize().height));
        return jPanel;
    }

    private void populateSourceList() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            if (locallyUniqueId == null || locallyUniqueId.isNull()) {
                return;
            }
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc != null) {
                VarListModel varListModel = this.mSrcList.getModel();
                varListModel.removeAll();
                int n = iSpssDataSrc.columnCount();
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    if (!CSPlanCoxRegDlg.isPlanVariable(iSpssVariable.getName())) {
                        varListModel.addElement(iSpssVariable, false);
                        continue;
                    }
                    this.mPlanVariables.add(iSpssVariable.getName().toUpperCase());
                }
                varListModel.sort();
                this.mSrcList.setModel(varListModel);
            }
        }
    }

    protected class InsertAction
    extends AbstractAction {
        protected InsertAction() {
            this.putValue("Name", DefineTimeDepPredictorsDlg.this.getResString("IDS_CSCOX_PREDICTOR_TDP_INSERT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DefineTimeDepPredictorsDlg.this.mInsertButton) {
                int n = DefineTimeDepPredictorsDlg.this.mNumericTextArea.getCaretPosition();
                String string = DefineTimeDepPredictorsDlg.this.mNumericTextArea.getSelectedText();
                String string2 = ((FunctionObject)DefineTimeDepPredictorsDlg.this.mSpecialVariableList.getSelectedValue()).getInsertString();
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n2 = string2.indexOf(63);
                if (string != null && n2 != -1) {
                    stringBuffer.replace(n2, n2 + 1, string);
                }
                int n3 = DefineTimeDepPredictorsDlg.this.mNumericTextArea.getSelectionStart();
                int n4 = DefineTimeDepPredictorsDlg.this.mNumericTextArea.getSelectionEnd();
                if (n == n4) {
                    n = n3;
                }
                DefineTimeDepPredictorsDlg.this.mHighlightHelper.resetHighlighting();
                DefineTimeDepPredictorsDlg.this.mNumericTextArea.replaceRange(stringBuffer.toString(), n3, n4);
                n2 = stringBuffer.toString().indexOf(63);
                DefineTimeDepPredictorsDlg.this.mNumericTextArea.select(n + n2, n + n2 + 1);
                if (n2 == -1) {
                    DefineTimeDepPredictorsDlg.this.mNumericTextArea.setCaretPosition(DefineTimeDepPredictorsDlg.this.mNumericTextArea.getText().length());
                }
                DefineTimeDepPredictorsDlg.this.mNumericTextArea.requestFocus();
            }
        }
    }

    private class ComputeDoubleClickListener
    implements IDoubleClickListener {
        private ComputeDoubleClickListener() {
        }

        @Override
        public void doDoubleClickAction() {
            DefineTimeDepPredictorsDlg.this.mNumericArrowButton.insertTextIntoTargetArea((JTextComponent)((Object)DefineTimeDepPredictorsDlg.this.mNumericTextArea), DefineTimeDepPredictorsDlg.this.mSrcList.getSelectedValue());
        }
    }

    class SrcListModel
    extends VarListModel {
        protected SrcListModel(VariableList variableList) {
            super(variableList);
        }

        @Override
        public void sort() {
            super.sort();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.getSize()];
            for (int i = iSpssVariableArray.length - 1; i >= 0; --i) {
                iSpssVariableArray[i] = this.getElementAt(i);
            }
            this.removeAll();
            this.addElement(DefineTimeDepPredictorsDlg.this.mTimeDependentVariable, false);
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getName().equals("T_")) continue;
                this.addElement(iSpssVariable, false);
            }
        }
    }
}

