/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CSDefineEventDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    public static final String MIN_COMBO_BOX = "CSCOX_REG_VALUE_LABEL_MIN";
    public static final String MAX_COMBO_BOX = "CSCOX_REG_VALUE_LABEL_MAX";
    public static final String COMBO_BOX = "CSCOX_REG_VALUE_LABEL";
    public static final String MIN_VALUE = "CSCOX_REG_MIN_VALUE";
    public static final String MAX_VALUE = "CSCOX_REG_MAX_VALUE";
    public static final String INDIVIDUAL_VALUE = "CSCOX_REG_SINGLE_VALUE";
    public static final String STATUS_VARIABLE = "CSCOX_REG_DEFINE_EVENT_STATUS_VAR";
    public static final String SELECTED_VALUES = "CSCOX_REG_DEFINE_EVENT_SELECTED_VALUES";
    public static final String MIN_SELECTED_VALUES = "CSCOX_REG_DEFINE_EVENT_MIN_SELECTED_VALUES";
    public static final String MAX_SELECTED_VALUES = "CSCOX_REG_DEFINE_EVENT_MAX_SELECTED_VALUES";
    static final int DEFAULT_ROWS = 100;
    private JRadioButton mIndividualRadio;
    private JRadioButton mRangeRadio;
    private JLabel mSpecify;
    private JLabel mMinValueLabel;
    private JComboBox mMinValueCombo;
    private JLabel mMaxValueLabel;
    private JComboBox mMaxValueCombo;
    private Vector<JComboBox> mValueLabelPair;
    private boolean mIncludeMissing;
    private ISpssVariable mStatusVar;
    private JPanel mIndividualPanel;
    private DefaultComboBoxModel mComboModel = new DefaultComboBoxModel();
    private Hashtable<String, String> mValueLabelTable = new Hashtable();
    private int mCellHeight = 0;

    public CSDefineEventDlg(BaseProcedureDialog baseProcedureDialog, ISpssVariable iSpssVariable, boolean bl) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_CSCOX_DEFINE_EVENT_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
        this.mStatusVar = iSpssVariable;
        this.mIncludeMissing = bl;
        this.fillComboBoxModel();
        int n = this.mComboModel.getSize();
        if (n > 512) {
            n = 512;
        }
        if (n > 100) {
            this.mIndividualPanel.removeAll();
            this.setupSingleValuePanel(n);
            this.validate();
            this.repaint();
        }
        for (int i = 0; i < n; ++i) {
            this.mValueLabelPair.get(i).setModel(this.CreateComboBoxModel());
        }
        this.mMinValueCombo.setModel(this.CreateComboBoxModel());
        this.mMaxValueCombo.setModel(this.CreateComboBoxModel());
        this.setDefaults();
        this.updateContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        boolean bl;
        Object object = itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mIndividualRadio && bl) {
            this.mSpecify.setEnabled(true);
            this.mMinValueLabel.setEnabled(false);
            this.mMinValueCombo.setEnabled(false);
            this.mMaxValueLabel.setEnabled(false);
            this.mMaxValueCombo.setEnabled(false);
            for (JComboBox jComboBox : this.mValueLabelPair) {
                jComboBox.setEnabled(true);
            }
        }
        if (object == this.mRangeRadio && bl) {
            this.mMinValueLabel.setEnabled(true);
            this.mMinValueCombo.setEnabled(true);
            this.mMaxValueLabel.setEnabled(true);
            this.mMaxValueCombo.setEnabled(true);
            this.mSpecify.setEnabled(false);
            for (JComboBox jComboBox : this.mValueLabelPair) {
                jComboBox.setEnabled(false);
            }
        }
        if (this.mIndividualRadio.isSelected() && this.mValueLabelPair != null) {
            for (JComboBox jComboBox : this.mValueLabelPair) {
                if (object != jComboBox) continue;
                string = this.getSelectedItemValue((String)jComboBox.getSelectedItem());
                if (string.length() <= 0) break;
                jComboBox.setSelectedItem(string);
                break;
            }
        }
        if (this.mRangeRadio.isSelected() && object == this.mMinValueCombo && (string = this.getSelectedItemValue((String)this.mMinValueCombo.getSelectedItem())).length() > 0) {
            this.mMinValueCombo.setSelectedItem(string);
        }
        if (this.mRangeRadio.isSelected() && object == this.mMaxValueCombo && (string = this.getSelectedItemValue((String)this.mMaxValueCombo.getSelectedItem())).length() > 0) {
            this.mMaxValueCombo.setSelectedItem(string);
        }
        this.updateContinueButton();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_define_event";
    }

    @Override
    public boolean continuePressed() {
        boolean bl = super.continuePressed();
        boolean bl2 = false;
        boolean bl3 = true;
        if (bl) {
            Object object;
            if (this.mIndividualRadio.isSelected() && this.mValueLabelPair != null) {
                for (int i = 0; i < this.mValueLabelPair.size(); ++i) {
                    object = (String)this.mValueLabelPair.get(i).getSelectedItem();
                    if (object == null || ((String)object).length() == 0) continue;
                    OBS oBS = new OBS();
                    if (!this.isValueValid((JTextField)this.mValueLabelPair.get(i).getEditor().getEditorComponent(), oBS)) {
                        return false;
                    }
                    for (int j = 0; j < this.mValueLabelPair.size(); ++j) {
                        JComboBox jComboBox;
                        if (i == j || (object = (String)(jComboBox = this.mValueLabelPair.get(j)).getSelectedItem()) == null || ((String)object).length() == 0) continue;
                        OBS oBS2 = new OBS();
                        if (!this.isValueValid((JTextField)this.mValueLabelPair.get(j).getEditor().getEditorComponent(), oBS2)) {
                            return false;
                        }
                        if (!oBS.equals((Object)oBS2)) continue;
                        if (!bl2) {
                            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_CSCOX_DEFINE_EVENT_MESG1"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                            bl2 = true;
                            boolean bl4 = bl3 = n == 1;
                        }
                        if (bl3) {
                            this.mValueLabelPair.get(j).setSelectedItem("");
                            continue;
                        }
                        this.mValueLabelPair.get(i).requestFocusInWindow();
                        ((JTextField)this.mValueLabelPair.get(i).getEditor().getEditorComponent()).selectAll();
                        return false;
                    }
                }
            }
            if (this.mRangeRadio.isEnabled() && this.mRangeRadio.isSelected()) {
                OBS oBS = new OBS();
                object = new OBS();
                if (!this.isValueValid((JTextField)this.mMinValueCombo.getEditor().getEditorComponent(), oBS)) {
                    return false;
                }
                if (!this.isValueValid((JTextField)this.mMaxValueCombo.getEditor().getEditorComponent(), (OBS)object)) {
                    return false;
                }
                if (oBS.compareTo(object) >= 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CSCOX_DEFINE_EVENT_MESG2"), VersionInfo.getAppVersionString());
                    this.mMinValueCombo.requestFocusInWindow();
                    ((JTextField)this.mMinValueCombo.getEditor().getEditorComponent()).selectAll();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField && focusEvent.getOppositeComponent() != null && focusEvent.getOppositeComponent() instanceof JTextField && ((JTextField)focusEvent.getSource()).getText().length() > 0) {
            OBS oBS = new OBS();
            if (!this.isValueValid((JTextField)focusEvent.getSource(), oBS)) {
                this.enableContinue(false);
            } else {
                this.updateContinueButton();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putObject(STATUS_VARIABLE, this.mStatusVar);
            dialogDataModel.putArray(SELECTED_VALUES, this.mValueLabelPair.toArray());
            dialogDataModel.putString(MIN_SELECTED_VALUES, (String)this.mMinValueCombo.getSelectedItem());
            dialogDataModel.putString(MAX_SELECTED_VALUES, (String)this.mMaxValueCombo.getSelectedItem());
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        boolean bl = true;
        if (dialogDataModel.getString(MIN_SELECTED_VALUES) != null) {
            this.mMinValueCombo.setSelectedItem(dialogDataModel.getString(MIN_SELECTED_VALUES));
        } else {
            bl = false;
        }
        if (dialogDataModel.getString(MAX_SELECTED_VALUES) != null) {
            this.mMaxValueCombo.setSelectedItem(dialogDataModel.getString(MAX_SELECTED_VALUES));
        } else {
            bl = false;
        }
        if (!bl) {
            this.mMinValueCombo.setSelectedItem("");
            this.mMaxValueCombo.setSelectedItem("");
        }
        for (JComboBox jComboBox : this.mValueLabelPair) {
            jComboBox.setSelectedItem("");
        }
        Object[] objectArray = dialogDataModel.getArray(SELECTED_VALUES);
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                JComboBox jComboBox = (JComboBox)objectArray[i];
                if (jComboBox == null) continue;
                this.mValueLabelPair.get(i).setSelectedItem(jComboBox.getSelectedItem());
            }
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIndividualRadio);
        vector.add(this.mRangeRadio);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private DefaultComboBoxModel CreateComboBoxModel() {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        for (int i = 0; i < this.mComboModel.getSize(); ++i) {
            defaultComboBoxModel.addElement(this.mComboModel.getElementAt(i));
        }
        return defaultComboBoxModel;
    }

    private void fillComboBoxModel() {
        this.mComboModel.removeAllElements();
        IValueLabelMap iValueLabelMap = this.mStatusVar.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        SPSS_Format sPSS_Format = this.mStatusVar.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl = formatType.isStringFormat();
        if (set.size() > 0) {
            for (Map.Entry entry : set) {
                String string;
                OBS oBS = (OBS)entry.getKey();
                if (this.mStatusVar.isMissing(oBS) && !this.mIncludeMissing) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl) {
                    string = CharacterUtil.rightTrim((String)oBS.getString());
                    stringBuffer.append(string);
                } else {
                    string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                    stringBuffer.append(string);
                }
                stringBuffer.append(" ");
                stringBuffer.append((String)entry.getValue());
                this.mValueLabelTable.put(stringBuffer.toString(), string);
                this.mComboModel.addElement(stringBuffer.toString());
            }
        }
    }

    private void setupSingleValuePanel(int n) {
        Serializable serializable;
        for (int i = 100; i < n; ++i) {
            ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, COMBO_BOX + i);
            serializable = new JComboBox();
            ((JComboBox)serializable).setEditable(true);
            ((JComboBox)serializable).addItemListener(this);
            ((JComboBox)serializable).setAction(comboboxAction);
            ((JComboBox)serializable).setEnabled(true);
            ((JComponent)((JComboBox)serializable).getEditor().getEditorComponent()).setOpaque(true);
            Dimension dimension = ((JComponent)serializable).getPreferredSize();
            dimension.width = 180;
            ((JComponent)serializable).setPreferredSize(dimension);
            this.mValueLabelPair.addElement((JComboBox)serializable);
        }
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).fill = 2;
        int n2 = 23;
        for (int i = 0; i < this.mValueLabelPair.size(); ++i) {
            DialogUtil.addUsingGBL(this.mIndividualPanel, this.mValueLabelPair.get(i), (GridBagConstraints)serializable, 0, i, 1, 1, n2, null);
        }
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(0, 0, n, n);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CSCOX_DEFINE_EVENT_PANEL_TITLE")));
        DialogUtil.addUsingGBL(jPanel, this.mIndividualRadio, gridBagConstraints, 0, 0, 1, 2, n2, insets);
        insets.set(n - 4, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mSpecify, gridBagConstraints, 1, 0, 2, 1, n2, insets);
        this.setupSingleValuePanel(0);
        JScrollPane jScrollPane = new JScrollPane(this.mIndividualPanel);
        Dimension dimension = this.mIndividualPanel.getPreferredSize();
        dimension.width += 20;
        dimension.height = this.mCellHeight * 7 + 2;
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        insets.set(0, n, n * 2, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 2, 1, n2, insets);
        insets.set(n * 2, n, n, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRangeRadio, gridBagConstraints, 0, 2, 1, 2, n2, insets);
        insets.set(n * 2 + 4, n, 0, n);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMinValueLabel, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        insets.set(n * 2 + 4, n, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMinValueCombo, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxValueLabel, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxValueCombo, gridBagConstraints, 2, 3, 1, 1, n2, insets);
    }

    private void initVars() {
        this.mIndividualPanel = PanelFactory.getEmptyPanel("");
        ControlAction controlAction = new ToggleButtonAction(this, "IDS_CSCOX_DEFINE_EVENT_INDIVIDUAL_VALUE");
        this.mIndividualRadio = new JRadioButton(controlAction);
        this.mIndividualRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_CSCOX_DEFINE_EVENT_RANGE_VALUE");
        this.mRangeRadio = new JRadioButton(controlAction);
        this.mRangeRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mIndividualRadio);
        spssButtonGroup.add(this.mRangeRadio);
        this.mSpecify = DialogUtil.createLabel(this.mParentDlg, "IDS_CSCOX_DEFINE_EVENT_SPECIFY_VALUE");
        this.mMinValueLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CSCOX_DEFINE_EVENT_MIN");
        this.mMaxValueLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CSCOX_DEFINE_EVENT_MAX");
        controlAction = new ComboboxAction(this.mParentDlg, MIN_COMBO_BOX);
        this.mMinValueCombo = new JComboBox();
        this.mMinValueCombo.setEditable(true);
        this.mMinValueCombo.addItemListener(this);
        this.mMinValueCombo.setAction(controlAction);
        this.mMinValueCombo.setEnabled(true);
        ((JTextField)this.mMinValueCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.mMinValueCombo.addFocusListener(this);
        ((JComponent)this.mMinValueCombo.getEditor().getEditorComponent()).setOpaque(false);
        this.mMinValueLabel.setLabelFor(this.mMinValueCombo);
        controlAction = new ComboboxAction(this.mParentDlg, MAX_COMBO_BOX);
        this.mMaxValueCombo = new JComboBox();
        this.mMaxValueCombo.setEditable(true);
        this.mMaxValueCombo.addItemListener(this);
        this.mMaxValueCombo.addFocusListener(this);
        this.mMaxValueCombo.setAction(controlAction);
        this.mMaxValueCombo.setEnabled(true);
        ((JTextField)this.mMaxValueCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        ((JComponent)this.mMaxValueCombo.getEditor().getEditorComponent()).setOpaque(false);
        this.mMaxValueLabel.setLabelFor(this.mMaxValueCombo);
        this.mValueLabelPair = new Vector();
        for (int i = 0; i < 100; ++i) {
            controlAction = new ComboboxAction(this.mParentDlg, COMBO_BOX + i);
            JComboBox jComboBox = new JComboBox();
            jComboBox.setEditable(true);
            jComboBox.addItemListener(this);
            jComboBox.setAction(controlAction);
            jComboBox.setEnabled(true);
            ((JComponent)jComboBox.getEditor().getEditorComponent()).setOpaque(true);
            ((JTextField)jComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            Dimension dimension = jComboBox.getPreferredSize();
            if (this.mCellHeight == 0) {
                this.mCellHeight = dimension.height;
            }
            dimension.width = 180;
            jComboBox.setPreferredSize(dimension);
            this.mValueLabelPair.addElement(jComboBox);
        }
    }

    private void setDefaults() {
        this.mIndividualRadio.setSelected(true);
        if (this.mStatusVar.getType() > 0) {
            this.mRangeRadio.setEnabled(false);
        }
        if (this.mIndividualRadio.isSelected()) {
            this.mSpecify.setEnabled(true);
            this.mMinValueLabel.setEnabled(false);
            this.mMinValueCombo.setEnabled(false);
            this.mMaxValueLabel.setEnabled(false);
            this.mMaxValueCombo.setEnabled(false);
            for (JComboBox jComboBox : this.mValueLabelPair) {
                jComboBox.setEnabled(true);
            }
        }
        if (this.mRangeRadio.isSelected()) {
            this.mMinValueLabel.setEnabled(true);
            this.mMinValueCombo.setEnabled(true);
            this.mMaxValueLabel.setEnabled(true);
            this.mMaxValueCombo.setEnabled(true);
            this.mSpecify.setEnabled(false);
            for (JComboBox jComboBox : this.mValueLabelPair) {
                jComboBox.setEnabled(false);
            }
        }
    }

    private String getSelectedItemValue(String string) {
        String string2 = "";
        if (string != null && string.trim().length() > 0 && (string2 = this.mValueLabelTable.get(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    private boolean isValueValid(JTextField jTextField, OBS oBS) {
        if (CellValueFormatter.stringToObs((String)jTextField.getText(), (SPSS_Format)this.mStatusVar.getFormat(), (OBS)oBS)) {
            return true;
        }
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_CSCOX_DEFINE_EVENT_MESG3"), VersionInfo.getAppVersionString());
        jTextField.requestFocus();
        jTextField.selectAll();
        return false;
    }

    private void updateContinueButton() {
        boolean bl = false;
        if (this.mIndividualRadio.isSelected() && this.mValueLabelPair != null) {
            for (JComboBox jComboBox : this.mValueLabelPair) {
                String string = ((JTextField)jComboBox.getEditor().getEditorComponent()).getText();
                if (string == null || string.length() <= 0) continue;
                bl = true;
                break;
            }
        } else if (this.mRangeRadio.isSelected()) {
            String string = ((JTextField)this.mMinValueCombo.getEditor().getEditorComponent()).getText();
            String string2 = ((JTextField)this.mMaxValueCombo.getEditor().getEditorComponent()).getText();
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                bl = true;
            }
        }
        this.enableContinue(bl);
    }
}

