/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegExportTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegHTestsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegModelTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegOptionsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegPlotsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegPredictorsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegStatsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSubgroupsTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSyntax;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegTimeEventTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSPlanCoxRegDlg;
import com.spss.java_client.ui.dialogs.complex_samples.logistic_regression.ComplexSamplesPlanLogisticRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.res.ComplexSamplesResBundle;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class CSCoxRegressionDlg
extends BaseTabbedDialog {
    private CSCoxRegTimeEventTab tabTimeEvent;
    private CSCoxRegPredictorsTab tabPredictors;
    private CSCoxRegSubgroupsTab tabSubgroups;
    private CSCoxRegModelTab tabModel;
    private CSCoxRegStatsTab tabStats;
    private CSCoxRegPlotsTab tabPlots;
    private CSCoxRegHTestsTab tabHTests;
    private CSCoxRegSaveTab tabSave;
    private CSCoxRegExportTab tabExport;
    private CSCoxRegOptionsTab tabOptions;

    public CSCoxRegressionDlg(JFrame jFrame) {
        super(jFrame, false, ComplexSamplesResBundle.getDefaultResourceBundleName(), ComplexSamplesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CS_COXREG_MAIN_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    public static void setSelectionText(JComponent jComponent) {
        jComponent.requestFocusInWindow();
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setSelectionStart(0);
            ((JTextField)jComponent).setSelectionEnd(((JTextField)jComponent).getText().length());
        }
    }

    @Override
    public void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        BaseProcedureDialog.NameLabelOption nameLabelOption = this.getNameLabelOverride();
        if (dialogDataModel == null || nameLabelOption == null) {
            return;
        }
        super.loadDialogState();
        String string = dialogDataModel.getString("IDS_CS_COXREG_PLAN_FILE");
        if (string != null && CSPlanCoxRegDlg.getSelectedPlanFileName().equals(string)) {
            this.tabTimeEvent.loadTabState(dialogDataModel, nameLabelOption);
            this.tabSubgroups.loadTabState(dialogDataModel, nameLabelOption);
            this.tabPlots.loadTabState(dialogDataModel, nameLabelOption);
            this.tabSave.loadTabState(dialogDataModel, nameLabelOption);
            this.tabPredictors.loadTabState(dialogDataModel, nameLabelOption);
            this.selectTabs();
        }
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel == null) {
            return;
        }
        dialogDataModel.putString("IDS_CS_COXREG_PLAN_FILE", ComplexSamplesPlanLogisticRegressionDlg.getSelectedPlanFileName());
        this.tabTimeEvent.saveTabState(dialogDataModel);
        this.tabSubgroups.saveTabState(dialogDataModel);
        this.tabPlots.saveTabState(dialogDataModel);
        this.tabSave.saveTabState(dialogDataModel);
        this.tabPredictors.saveTabState(dialogDataModel);
    }

    @Override
    public String generateSyntax() {
        CSCoxRegSyntax cSCoxRegSyntax = new CSCoxRegSyntax(this);
        return cSCoxRegSyntax.generateSyntax();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.tabTimeEvent.validateTab()) {
            return false;
        }
        if (!this.tabSubgroups.validateTab()) {
            return false;
        }
        if (!this.tabPlots.validateTab()) {
            return false;
        }
        if (!this.tabHTests.validateTab()) {
            return false;
        }
        if (!this.tabSave.validateTab()) {
            return false;
        }
        if (!this.tabExport.validateTab()) {
            return false;
        }
        return this.tabOptions.validateTab();
    }

    @Override
    public String getIActionKey() {
        return "analyze_complex_samples_coxreg_main";
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_CSCOX_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_CSCOX_RESET_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[2]);
        if (n != 2) {
            if (n == 0) {
                super.reset();
                this.tabTimeEvent.reset();
                this.tabPredictors.reset();
                this.tabSubgroups.reset();
                this.tabModel.reset();
                this.tabStats.reset();
                this.tabPlots.reset();
                this.tabHTests.reset();
                this.tabSave.reset();
                this.tabExport.reset();
                this.tabOptions.reset();
            } else {
                Component component = this.mTabbedPane.getSelectedComponent();
                if (component instanceof BaseProcedureTab) {
                    ((BaseProcedureTab)component).reset();
                }
            }
        }
    }

    public boolean getEnableByTDP() {
        return !this.tabModel.isTdpInModel();
    }

    public boolean isTdpInPredictors() {
        return this.tabPredictors.isTdpInPredictors();
    }

    public boolean getEnableBySubjectId() {
        return this.tabTimeEvent.getSubjectVar() != null;
    }

    public boolean isUserMissingIncluded() {
        return this.tabOptions.isUserMissingIncluded();
    }

    public VarListModel getSrcListModel() {
        return this.tabTimeEvent.getSrcListModel();
    }

    public ListModel getFactorsListModel() {
        return this.tabPredictors.getFactorsListModel();
    }

    public ListModel getCovariatesListModel() {
        return this.tabPredictors.getCovariatesListModel();
    }

    public CSCoxRegModelTab getModelTab() {
        return this.tabModel;
    }

    public CSCoxRegTimeEventTab getTimeEventTab() {
        return this.tabTimeEvent;
    }

    public boolean isEventMisValPresent() {
        return this.tabTimeEvent.isMisValuePresent();
    }

    public boolean isSubgroupsMisValPresent() {
        return this.tabSubgroups.isMisValuePresent();
    }

    public boolean isPlotsMisValPresent() {
        return this.tabPlots.isMisValuePresent();
    }

    public void resetMisValue(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.tabTimeEvent.resetMisValue();
        }
        if (bl2) {
            this.tabSubgroups.resetMisValue();
        }
        if (bl3) {
            this.tabPlots.resetMisValue();
        }
    }

    public boolean isUserMissingValue(ISpssVariable iSpssVariable, String string) {
        boolean bl = false;
        if (iSpssVariable != null && string != null) {
            if (iSpssVariable.getType() == 0) {
                double d;
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (iSpssVariable.isMissing(d)) {
                    bl = true;
                }
            } else if (iSpssVariable.isMissing(string)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.tabTimeEvent = new CSCoxRegTimeEventTab(this);
        this.tabPredictors = new CSCoxRegPredictorsTab(this);
        this.tabSubgroups = new CSCoxRegSubgroupsTab(this);
        this.tabModel = new CSCoxRegModelTab(this);
        this.tabStats = new CSCoxRegStatsTab(this);
        this.tabPlots = new CSCoxRegPlotsTab(this);
        this.tabHTests = new CSCoxRegHTestsTab(this);
        this.tabSave = new CSCoxRegSaveTab(this);
        this.tabExport = new CSCoxRegExportTab(this);
        this.tabOptions = new CSCoxRegOptionsTab(this);
        this.addTab(this.getResString("IDS_CSCOX_TIME_EVENT_TAB"), this.tabTimeEvent);
        this.addTab(this.getResString("IDS_CSCOX_PREDICTORS_TAB"), this.tabPredictors);
        this.addTab(this.getResString("IDS_CSCOX_SUBGROUPS_TAB"), this.tabSubgroups);
        this.addTab(this.getResString("IDS_CSCOX_MODEL_TAB"), this.tabModel);
        this.addTab(this.getResString("IDS_COMPSAMP_STATS"), this.tabStats);
        this.addTab(this.getResString("IDS_CSCOX_PLOTS_TAB"), this.tabPlots);
        this.addTab(this.getResString("IDS_CSCOX_HTESTS_TAB"), this.tabHTests);
        this.addTab(this.getResString("IDS_PFA_SPSS_DATAFILE_SAVE"), this.tabSave);
        this.addTab(this.getResString("IDS_CSCOX_EXPORT_TAB"), this.tabExport);
        this.addTab(this.getResString("IDS_CSCOX_OPTIONS_TAB"), this.tabOptions);
        this.pack();
    }

    protected void selectAllTabs() {
        int n = this.mTabbedPane.getSelectedIndex();
        for (int i = 0; i < this.mTabbedPane.getTabCount(); ++i) {
            this.mTabbedPane.setSelectedIndex(i);
        }
        this.mTabbedPane.setSelectedIndex(n);
    }

    protected void selectTabs() {
        int n = this.mTabbedPane.getSelectedIndex();
        this.mTabbedPane.setSelectedIndex(3);
        this.mTabbedPane.setSelectedIndex(5);
        this.mTabbedPane.setSelectedIndex(n);
    }
}

