/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.CalculateTheNumberPage2Of3;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.CalculateTheNumberPage3Of3;
import com.spss.java_client.ui.dialogs.base.transform.date_time_wizard.DateAndTimeWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSyntax;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSDefineEventDlg;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSPlanCoxRegDlg;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CSCoxRegTimeEventTab
extends BaseProcedureTab
implements ItemListener,
FocusListener,
ListDataListener,
MouseListener {
    public static final String SRC_VAR_LIST = "IDS_CSCOX_TIME_EVENT_SRC_VARLIST";
    public static final String START_TARGET_LIST_KEY = "IDS_CSCOX_TIME_EVENT_START_TARGET_LIST";
    public static final String END_TARGET_LIST_KEY = "IDS_CSCOX_TIME_EVENT_END_TARGET_LIST";
    public static final String STATUS_TARGET_LIST_KEY = "IDS_CSCOX_TIME_EVENT_STATUS_TARGET_LIST";
    public static final String SUBJECT_TARGET_LIST_KEY = "IDS_CSCOX_TIME_EVENT_SUBJECT_TARGET_LIST";
    public static final String TIME_EVENT_STRING_KEY = "IDS_CSCOX_TIME_EVENT_STRING_KEY";
    public static final String TIME_EVENT_SYNTAX_KEY = "IDS_CSCOX_TIME_EVENT_SYNTAX_KEY";
    public static final String TIME_EVENT_VALUE_KEY = "IDS_CSCOX_TIME_EVENT_VALUE_KEY";
    public static final int EVENT_STRING_LENGTH = 37;
    private SrcVariableList mSrcVarList;
    private JRadioButton mTime0Button;
    private JRadioButton mVariesButton;
    private JLabel mStartVarLabel;
    private TargetVariableList mTargetStartVariableList;
    private ArrowButton mStartVarArrowButton;
    private TargetVariableList mTargetEndVariableList;
    private ArrowButton mEndVarArrowButton;
    private TargetVariableList mTargetStatusVariableList;
    private ArrowButton mStatusVarArrowButton;
    private StringTextField mEventField;
    private JTextArea mInfoArea;
    private StringBuffer mEventValue = new StringBuffer();
    private StringBuffer mEventString = new StringBuffer();
    private StringBuffer mSynEventString = new StringBuffer();
    private JButton mDefineEventButton;
    private boolean mMisValuePresent = false;
    private TargetVariableList mTargetSubjectVariableList;
    private ArrowButton mSubjectVarArrowButton;
    private IVarMoveHandler mMoveHandler;

    public CSCoxRegTimeEventTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public ISpssVariable getEndVar() {
        if (this.mTargetEndVariableList == null) {
            return null;
        }
        if (this.mTargetEndVariableList.getModel().getSize() == 1) {
            return this.mTargetEndVariableList.getModel().getElementAt(0);
        }
        return null;
    }

    public ISpssVariable getStatusVar() {
        if (this.mTargetStatusVariableList == null) {
            return null;
        }
        if (this.mTargetStatusVariableList.getModel().getSize() == 1) {
            return this.mTargetStatusVariableList.getModel().getElementAt(0);
        }
        return null;
    }

    public String getEventString() {
        return this.mEventString.toString();
    }

    public String getSynEventString() {
        return this.mSynEventString.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_time_event";
    }

    public ISpssVariable getStartVar() {
        if (this.mTargetStartVariableList == null) {
            return null;
        }
        if (this.mTargetStartVariableList.getModel().getSize() == 1) {
            return this.mTargetStartVariableList.getModel().getElementAt(0);
        }
        return null;
    }

    public ISpssVariable getSubjectVar() {
        if (this.mTargetSubjectVariableList == null) {
            return null;
        }
        if (this.mTargetSubjectVariableList.getModel().getSize() == 1) {
            return this.mTargetSubjectVariableList.getModel().getElementAt(0);
        }
        return null;
    }

    public VarListModel getSrcListModel() {
        return this.mSrcVarList.getModel();
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        String string = dialogDataModel.getString(TIME_EVENT_STRING_KEY);
        if (string != null) {
            this.mEventString.append(string);
        }
        if ((string = dialogDataModel.getString(TIME_EVENT_SYNTAX_KEY)) != null) {
            this.mSynEventString.append(string);
        }
        if ((string = dialogDataModel.getString(TIME_EVENT_VALUE_KEY)) != null) {
            this.mEventValue.append(string);
        }
        this.setEnabledOkPaste();
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        if (dialogDataModel == null) {
            return;
        }
        if (this.mEventString != null) {
            dialogDataModel.putString(TIME_EVENT_STRING_KEY, this.mEventString.toString());
        }
        if (this.mSynEventString != null) {
            dialogDataModel.putString(TIME_EVENT_SYNTAX_KEY, this.mSynEventString.toString());
        }
        if (this.mEventValue != null) {
            dialogDataModel.putString(TIME_EVENT_VALUE_KEY, this.mEventValue.toString());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof TargetVariableList) {
            TargetVariableList targetVariableList = (TargetVariableList)object;
            if (targetVariableList == this.mTargetStatusVariableList) {
                this.mDefineEventButton.setEnabled(true);
            } else {
                this.mDefineEventButton.setEnabled(false);
            }
        } else if (object instanceof SrcVariableList && this.mTargetStartVariableList.getModel().getSize() > 0) {
            this.mDefineEventButton.setEnabled(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mTime0Button) {
            this.mStartVarLabel.setEnabled(false);
            this.mTargetStartVariableList.setEnabled(false);
        }
        if (object == this.mVariesButton) {
            this.mStartVarLabel.setEnabled(true);
            this.mTargetStartVariableList.setEnabled(true);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object.equals(this.mTargetStatusVariableList.getModel()) && this.mTargetStatusVariableList.getModel().getSize() > 0) {
            this.mDefineEventButton.setEnabled(true);
        }
        if (object.equals(this.mTargetStatusVariableList.getModel()) || object.equals(this.mTargetEndVariableList.getModel())) {
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object.equals(this.mTargetStatusVariableList.getModel())) {
            this.mDefineEventButton.setEnabled(false);
            this.mInfoArea.setEnabled(false);
            this.mEventField.setEnabled(false);
            this.mEventField.setText("");
            this.mEventString.delete(0, this.mEventString.length());
            this.mSynEventString.delete(0, this.mSynEventString.length());
            this.mEventValue.delete(0, this.mEventValue.length());
            ((CSCoxRegressionDlg)this.mParent).getDialogDataModel().putString("CSCOX_REG_DEFINE_EVENT_MIN_SELECTED_VALUES", null);
            ((CSCoxRegressionDlg)this.mParent).getDialogDataModel().putString("CSCOX_REG_DEFINE_EVENT_MAX_SELECTED_VALUES", null);
            ((CSCoxRegressionDlg)this.mParent).getDialogDataModel().putArray("CSCOX_REG_DEFINE_EVENT_SELECTED_VALUES", null);
        }
        if (object.equals(this.mTargetStatusVariableList.getModel()) || object.equals(this.mTargetEndVariableList.getModel())) {
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        Component component = ((CSCoxRegressionDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetEndVariableList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetStartVariableList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetStatusVariableList, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetSubjectVariableList, this.mMoveHandler));
        }
        if (this.mEventValue.length() > 0) {
            this.mInfoArea.setEnabled(true);
            this.mEventField.setEnabled(true);
            this.setEventStringField();
            this.mDefineEventButton.setEnabled(true);
        }
        this.setFocusTraversalPolicy();
        this.setEnabledOkPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetEndVariableList.removeAll();
        this.mTargetStartVariableList.removeAll();
        this.mTargetStatusVariableList.removeAll();
        this.mTargetSubjectVariableList.removeAll();
        this.mEventString.delete(0, this.mEventString.length());
        this.mSynEventString.delete(0, this.mSynEventString.length());
        this.mEventValue.delete(0, this.mEventValue.length());
        this.setDefaults();
    }

    public boolean isMisValuePresent() {
        if (this.mEventValue.length() > 0) {
            return this.mMisValuePresent;
        }
        return false;
    }

    public void resetMisValue() {
        int n = this.mTargetStatusVariableList.getModel().getSize();
        if (n == 1) {
            this.mSrcVarList.getModel().addElement(this.mTargetStatusVariableList.getModel().getElementAt(0));
            this.mTargetStatusVariableList.removeAll();
            if (this.mEventValue.length() > 0) {
                this.mEventValue.delete(0, this.mEventValue.length());
            }
            this.mEventString.delete(0, this.mEventString.length());
            this.mSynEventString.delete(0, this.mSynEventString.length());
            this.mEventField.setText(this.getResString("IDS_CSCOX_TIME_EVENT_INFO_DEF_VALUE"));
        }
    }

    @Override
    protected boolean validateTab() {
        if (this.mVariesButton.isSelected() && this.mTargetStartVariableList.getModel().getSize() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_CSCOX_TIME_EVENT_MESG1"), VersionInfo.getAppVersionString());
            this.mTargetStartVariableList.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void setEnabledOkPaste() {
        boolean bl = false;
        if (this.mTargetEndVariableList.getModel().getSize() > 0 && this.mTargetStatusVariableList.getModel().getSize() > 0 && this.mEventValue.length() > 0) {
            bl = true;
        }
        ((CSCoxRegressionDlg)this.mParent).enableOkPaste(bl);
    }

    private void initializePanel() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(UIToolDialogUtil.getStandardDialogInsets().top, UIToolDialogUtil.getStandardDialogInsets().left, 0, 15);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupListPanel(), gridBagConstraints, 0, 0, 1, 3, n, insets);
        insets.set(10, UIToolDialogUtil.getStandardDialogInsets().left + 5, 0, 40);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.setupSurvivalPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(0, UIToolDialogUtil.getStandardDialogInsets().left + 5, 0, 40);
        DialogUtil.addUsingGBL(this, this.setupEventPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.setupsubjectPanel(), gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTime0Button);
        vector.add(this.mVariesButton);
        vector.add(this.mStartVarArrowButton);
        vector.add(this.mTargetStartVariableList);
        vector.add(this.mEndVarArrowButton);
        vector.add(this.mStatusVarArrowButton);
        vector.add(this.mTargetStatusVariableList);
        vector.add(this.mSubjectVarArrowButton);
        vector.add(this.mTargetSubjectVariableList);
        vector.add(this.mDefineEventButton);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        this.mMoveHandler = new CSCoxMoveHandler();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(SRC_VAR_LIST);
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.addVarFilter(new ComplexSamplesPlan.sourceCsCoxRegFilter());
        this.mStartVarLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_TIME_EVENT_TIME_START_VAR");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_CSCOX_TIME_EVENT_TIME_0");
        this.mTime0Button = new JRadioButton(toggleButtonAction);
        this.mTime0Button.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_CSCOX_TIME_EVENT_TIME_VARIES");
        this.mVariesButton = new JRadioButton(toggleButtonAction);
        this.mVariesButton.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mTime0Button);
        spssButtonGroup.add(this.mVariesButton);
        this.mTargetStartVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetStartVariableList.getModel().addListDataListener(this);
        this.mTargetStartVariableList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetStartVariableList.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStartVariableList.getFixedCellHeight()));
        this.mTargetStartVariableList.setMaximumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStartVariableList.getFixedCellHeight()));
        this.mTargetStartVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetStartVariableList.setIdentifier(START_TARGET_LIST_KEY);
        this.mStartVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStartVarArrowButton.setVarMoveHandler(this.mMoveHandler);
        this.mStartVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStartVarArrowButton.registerVariableList(this.mTargetStartVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetEndVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetEndVariableList.getModel().addListDataListener(this);
        this.mTargetEndVariableList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetEndVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetEndVariableList.setMaximumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetEndVariableList.getFixedCellHeight()));
        this.mTargetEndVariableList.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStartVariableList.getFixedCellHeight()));
        this.mTargetEndVariableList.setIdentifier(END_TARGET_LIST_KEY);
        this.mEndVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mEndVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mEndVarArrowButton.registerVariableList(this.mTargetEndVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mEndVarArrowButton.setVarMoveHandler(this.mMoveHandler);
        this.mTargetStatusVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetStatusVariableList.getModel().addListDataListener(this);
        this.mTargetStatusVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetStatusVariableList.setMaximumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStatusVariableList.getFixedCellHeight()));
        this.mTargetStatusVariableList.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStartVariableList.getFixedCellHeight()));
        this.mTargetStatusVariableList.setIdentifier(STATUS_TARGET_LIST_KEY);
        this.mStatusVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStatusVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStatusVarArrowButton.registerVariableList(this.mTargetStatusVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mStatusVarArrowButton.setVarMoveHandler(this.mMoveHandler);
        this.mEventField = new StringTextField();
        this.mEventField.setText(this.getResString("IDS_CSCOX_TIME_EVENT_INFO_DEF_VALUE"));
        this.mEventField.setOpaque(false);
        this.mEventField.setEditable(false);
        this.mEventField.setBorder(null);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParent, "IDS_CSCOX_TIME_EVENT_DEFINE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CSCoxRegTimeEventTab.this.mTargetStatusVariableList.getModel().getSize() > 0) {
                    ISpssVariable iSpssVariable = CSCoxRegTimeEventTab.this.mTargetStatusVariableList.getModel().getElementAt(0);
                    CSDefineEventDlg cSDefineEventDlg = new CSDefineEventDlg((BaseProcedureDialog)CSCoxRegTimeEventTab.this.mParent, iSpssVariable, ((CSCoxRegressionDlg)CSCoxRegTimeEventTab.this.mParent).isUserMissingIncluded());
                    cSDefineEventDlg.pack();
                    cSDefineEventDlg.setVisible(true);
                    if (cSDefineEventDlg.wasContinuePressed()) {
                        CSCoxRegTimeEventTab.this.mEventValue.delete(0, CSCoxRegTimeEventTab.this.mEventValue.length());
                        CSCoxRegTimeEventTab.this.mEventString.delete(0, CSCoxRegTimeEventTab.this.mEventString.length());
                        CSCoxRegTimeEventTab.this.mSynEventString.delete(0, CSCoxRegTimeEventTab.this.mSynEventString.length());
                        CSCoxRegTimeEventTab.this.mMisValuePresent = false;
                        DialogDataModel dialogDataModel = ((CSCoxRegressionDlg)CSCoxRegTimeEventTab.this.mParent).getDialogDataModel();
                        Boolean bl = dialogDataModel.getBoolean("IDS_CSCOX_DEFINE_EVENT_INDIVIDUAL_VALUE");
                        if (bl != null && bl.booleanValue()) {
                            Object[] objectArray;
                            for (Object object : objectArray = dialogDataModel.getArray("CSCOX_REG_DEFINE_EVENT_SELECTED_VALUES")) {
                                JComboBox jComboBox = (JComboBox)object;
                                String string = (String)jComboBox.getSelectedItem();
                                if (string == null || string.length() <= 0) continue;
                                CSCoxRegTimeEventTab.this.mEventString.append(string).append(",");
                                CSCoxRegTimeEventTab.this.mSynEventString.append(CSCoxRegSyntax.quoteValue(iSpssVariable, string)).append(",");
                                CSCoxRegTimeEventTab.this.mEventValue.append(CSCoxRegTimeEventTab.this.getVarLabel(string)).append(",");
                                if (CSCoxRegTimeEventTab.this.mMisValuePresent) continue;
                                CSCoxRegTimeEventTab.this.mMisValuePresent = ((CSCoxRegressionDlg)CSCoxRegTimeEventTab.this.mParent).isUserMissingValue(iSpssVariable, string);
                            }
                        } else {
                            String string = dialogDataModel.getString("CSCOX_REG_DEFINE_EVENT_MIN_SELECTED_VALUES");
                            CSCoxRegTimeEventTab.this.mEventValue.append(CSCoxRegTimeEventTab.this.getVarLabel(string));
                            CSCoxRegTimeEventTab.this.mEventString.append(string);
                            CSCoxRegTimeEventTab.this.mSynEventString.append(CSCoxRegSyntax.quoteValue(iSpssVariable, string));
                            CSCoxRegTimeEventTab.this.mEventValue.append(" THRU ");
                            CSCoxRegTimeEventTab.this.mEventString.append(" THRU ");
                            CSCoxRegTimeEventTab.this.mSynEventString.append(" THRU ");
                            string = dialogDataModel.getString("CSCOX_REG_DEFINE_EVENT_MAX_SELECTED_VALUES");
                            CSCoxRegTimeEventTab.this.mEventString.append(string);
                            CSCoxRegTimeEventTab.this.mSynEventString.append(CSCoxRegSyntax.quoteValue(iSpssVariable, string));
                            CSCoxRegTimeEventTab.this.mEventValue.append(CSCoxRegTimeEventTab.this.getVarLabel(dialogDataModel.getString("CSCOX_REG_DEFINE_EVENT_MAX_SELECTED_VALUES")));
                        }
                        if (CSCoxRegTimeEventTab.this.mEventValue.lastIndexOf(",") == CSCoxRegTimeEventTab.this.mEventValue.length() - 1) {
                            CSCoxRegTimeEventTab.this.mEventValue.deleteCharAt(CSCoxRegTimeEventTab.this.mEventValue.length() - 1);
                            CSCoxRegTimeEventTab.this.mEventString.deleteCharAt(CSCoxRegTimeEventTab.this.mEventString.length() - 1);
                            CSCoxRegTimeEventTab.this.mSynEventString.deleteCharAt(CSCoxRegTimeEventTab.this.mSynEventString.length() - 1);
                        }
                        CSCoxRegTimeEventTab.this.setEventStringField();
                        CSCoxRegTimeEventTab.this.mEventField.setEnabled(true);
                        CSCoxRegTimeEventTab.this.mInfoArea.setEnabled(true);
                        CSCoxRegTimeEventTab.this.setEnabledOkPaste();
                        cSDefineEventDlg.dispose();
                    }
                }
            }
        };
        this.mDefineEventButton = new JButton(toggleButtonAction2);
        this.mInfoArea = new JTextArea(this.getResString("IDS_CSCOX_TIME_EVENT_INFO"));
        this.mInfoArea.setLineWrap(true);
        this.mInfoArea.setWrapStyleWord(true);
        this.mInfoArea.setBorder(null);
        this.mInfoArea.setOpaque(false);
        this.mInfoArea.setFocusable(false);
        this.mInfoArea.setRows(2);
        this.mInfoArea.setMinimumSize(new Dimension(100, this.mInfoArea.getPreferredSize().height));
        this.mInfoArea.setPreferredSize(new Dimension(100, this.mInfoArea.getPreferredSize().height));
        this.mTargetSubjectVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetSubjectVariableList.getModel().addListDataListener(this);
        this.mTargetSubjectVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetSubjectVariableList.setMaximumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetSubjectVariableList.getFixedCellHeight()));
        this.mTargetSubjectVariableList.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetStartVariableList.getFixedCellHeight()));
        this.mTargetSubjectVariableList.setIdentifier(SUBJECT_TARGET_LIST_KEY);
        this.mSubjectVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubjectVarArrowButton.setVarMoveHandler(this.mMoveHandler);
        this.mSubjectVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubjectVarArrowButton.registerVariableList(this.mTargetSubjectVariableList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mTime0Button.setSelected(true);
        if (this.mTime0Button.isSelected()) {
            this.mStartVarLabel.setEnabled(false);
            this.mTargetStartVariableList.setEnabled(false);
        }
        if (this.mVariesButton.isSelected()) {
            this.mStartVarLabel.setEnabled(true);
            this.mTargetStartVariableList.setEnabled(true);
        }
        this.mDefineEventButton.setEnabled(false);
        this.mInfoArea.setEnabled(false);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPSAMP_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupSurvivalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CSCOX_TIME_EVENT_SURVIVAL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupStartOfIntervalPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupEndIntervalPanel(), gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupOneTargetListPanel(ArrowButton arrowButton, TargetVariableList targetVariableList, String string, JLabel jLabel) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        JLabel jLabel2 = jLabel;
        if (jLabel2 == null) {
            jLabel2 = DialogUtil.createLabel(this.mParent, string);
        }
        jLabel2.setLabelFor(targetVariableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(n, insets.left, n, insets.right + 5);
        DialogUtil.addUsingGBL(jPanel, arrowButton, gridBagConstraints, 0, 0, 1, 2, n2, insets2);
        insets2.set(0, insets.left + 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, insets.left + 5, n, insets.right);
        JScrollPane jScrollPane = new JScrollPane(targetVariableList);
        jScrollPane.setPreferredSize(targetVariableList.getMinimumSize());
        jScrollPane.setMinimumSize(targetVariableList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupStartOfIntervalPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CSCOX_TIME_EVENT_START_INTERVALL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTime0Button, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVariesButton, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = this.setupOneTargetListPanel(this.mStartVarArrowButton, this.mTargetStartVariableList, "IDS_CSCOX_TIME_EVENT_TIME_START_VAR", this.mStartVarLabel);
        insets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupEndIntervalPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_CSCOX_TIME_EVENT_END_INTERVALL_TITLE"));
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        Insets insets = new Insets(0, n, n, n);
        JPanel jPanel2 = this.setupOneTargetListPanel(this.mEndVarArrowButton, this.mTargetEndVariableList, "IDS_CSCOX_TIME_EVENT_TIME_END_VAR", null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupEventPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_CSCOX_TIME_EVENT_EVENT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, n * 2 - 2, n, n * 2);
        JPanel jPanel2 = this.setupOneTargetListPanel(this.mStatusVarArrowButton, this.mTargetStatusVariableList, "IDS_CSCOX_TIME_EVENT_STATUS_VAR", null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n2, insets2);
        insets2.set(0, n * 2, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left + 12, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mInfoArea, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, n, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mEventField), gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        JLabel jLabel = new JLabel(" ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, n, n, n * 3);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        insets2.set(0, n * 3, n, insets.right * 2 + 4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n2 = 13;
        DialogUtil.addUsingGBL(jPanel, this.mDefineEventButton, gridBagConstraints, 1, 2, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupsubjectPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, n * 2 + 3, 0, n * 3);
        JPanel jPanel2 = this.setupOneTargetListPanel(this.mSubjectVarArrowButton, this.mTargetSubjectVariableList, "IDS_CSCOX_TIME_EVENT_SUBJECT_ID", null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_CSCOX_TIME_EVENT_INFO1"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        jTextArea.setMinimumSize(new Dimension(70, 30));
        jTextArea.setRows(2);
        jTextArea.setPreferredSize(new Dimension(70, jTextArea.getHeight()));
        insets2.set(n, insets.left + 12, n, insets.right);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        return jPanel;
    }

    private String getVarLabel(String string) {
        ISpssVariable iSpssVariable = this.mTargetStatusVariableList.getModel().getElementAt(0);
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        if (set.size() > 0) {
            OBS oBS = new OBS();
            CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS);
            for (Map.Entry entry : set) {
                OBS oBS2 = (OBS)entry.getKey();
                if (!oBS2.equals((Object)oBS)) continue;
                return ((String)entry.getValue()).trim();
            }
        }
        return string;
    }

    private void setEventStringField() {
        String string = this.mEventValue.toString();
        if (string.length() > 37) {
            string = string.substring(0, 37) + " ...";
        }
        this.mEventField.setText(string);
        this.mEventField.setToolTipText(this.mEventValue.toString());
    }

    class CSCoxMoveHandler
    implements IVarMoveHandler {
        CSCoxMoveHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            if (!variableList.equals(CSCoxRegTimeEventTab.this.mTargetEndVariableList) && !variableList.equals(CSCoxRegTimeEventTab.this.mTargetStartVariableList) && !variableList.equals(CSCoxRegTimeEventTab.this.mTargetStatusVariableList) && !variableList.equals(CSCoxRegTimeEventTab.this.mTargetSubjectVariableList)) return true;
            if (iSpssVariableArray == null) return false;
            if (iSpssVariableArray.length != 1) return false;
            ISpssVariable iSpssVariable = iSpssVariableArray[0];
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            if (variableList.equals(CSCoxRegTimeEventTab.this.mTargetEndVariableList) || variableList.equals(CSCoxRegTimeEventTab.this.mTargetStartVariableList)) {
                if (iSpssVariable.getType() > 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(CSCoxRegTimeEventTab.this, CSCoxRegTimeEventTab.this.getResString("ERR_CSCOX_TIME_EVENT_MESG3"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (iSpssVariable.getType() == 0 && sPSS_Format.getFormatType().isDateOrTimeFormat()) {
                    Object[] objectArray = CSCoxRegTimeEventTab.this.getResStringArray("IDS_CSCOX_TIME_EVENT_ARRAY");
                    int n = SpssAlertOptionPane.showOptionDialog(CSCoxRegTimeEventTab.this, CSCoxRegTimeEventTab.this.getResString("ERR_CSCOX_TIME_EVENT_MESG2"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
                    if (n != 0) return false;
                    try {
                        DateAndTimeWizardDlg dateAndTimeWizardDlg = new DateAndTimeWizardDlg(SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC));
                        dateAndTimeWizardDlg.getWizardModel().clearPageMap();
                        CalculateTheNumberPage3Of3 calculateTheNumberPage3Of3 = new CalculateTheNumberPage3Of3(dateAndTimeWizardDlg);
                        Vector<AbstractWizardPage> vector = new Vector<AbstractWizardPage>();
                        vector.add(calculateTheNumberPage3Of3);
                        dateAndTimeWizardDlg.getWizardModel().resetStackForTreeTraversal(vector);
                        CalculateTheNumberPage2Of3 calculateTheNumberPage2Of3 = new CalculateTheNumberPage2Of3(dateAndTimeWizardDlg);
                        dateAndTimeWizardDlg.registerPage(calculateTheNumberPage2Of3);
                        dateAndTimeWizardDlg.registerPage(calculateTheNumberPage3Of3);
                        dateAndTimeWizardDlg.showWizardPage(null, calculateTheNumberPage2Of3);
                        calculateTheNumberPage3Of3.setPage2(calculateTheNumberPage2Of3);
                        dateAndTimeWizardDlg.setVisible(true);
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return false;
                }
            }
            if (!CSPlanCoxRegDlg.isPlanVariable(iSpssVariable.getName())) return true;
            SpssAlertOptionPane.showWarningMessageDialog(CSCoxRegTimeEventTab.this, CSCoxRegTimeEventTab.this.getResString("ERR_CSCOX_TIME_EVENT_MESG4"), VersionInfo.getAppVersionString());
            return false;
        }
    }
}

