/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.TimeDependentPredictors;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesCommonSyntaxUtils;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegModelTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveVariable;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegTimeEventTab;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class CSCoxRegSyntax {
    private DialogDataModel mData;
    private CSCoxRegressionDlg mCoxRegDlg;
    private String mDatasetDeclare;
    private String mDeleteVariables;
    private StringBuffer mComputeBuffer;
    private StringBuffer mByWithBuf;
    private String mStrata;
    private int mPrecision = 13;
    private ISpssDataSrc mDataSrc;
    private Set<String> mVarNames = new HashSet<String>();
    private boolean mResult = true;
    private String mExportModelDataFile = null;
    private String mExportFunctionDataFile = null;
    private String mExportModelXMLFile = null;

    public CSCoxRegSyntax(CSCoxRegressionDlg cSCoxRegressionDlg) {
        this.mCoxRegDlg = cSCoxRegressionDlg;
        this.mData = cSCoxRegressionDlg.getDialogDataModel();
        this.mResult = true;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        this.mDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mVarNames.clear();
        for (int i = 0; i < this.mDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable = this.mDataSrc.getVariable(i);
            if (iSpssVariable == null) continue;
            this.mVarNames.add(iSpssVariable.getName().toLowerCase());
        }
    }

    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ");
        stringBuffer.append(this.mCoxRegDlg.getResString("IDS_CS_COXREG_MAIN_TITLE"));
        stringBuffer.append(".");
        String string = this.getExportSyntax();
        String string2 = this.getSaveSyntax();
        this.getPredictorsSyntax();
        String string3 = this.getSubgroupsSyntax();
        if (!this.mResult) {
            return "";
        }
        stringBuffer.append(this.mDeleteVariables);
        stringBuffer.append(this.mDatasetDeclare);
        if (this.mComputeBuffer.length() > 0) {
            stringBuffer.append("\nCLEAR TIME PROGRAM.");
            stringBuffer.append("\nTIME PROGRAM.");
        }
        stringBuffer.append(this.mComputeBuffer);
        stringBuffer.append("\nCSCOXREG ");
        stringBuffer.append(this.getTimeEventSyntax());
        stringBuffer.append(string3);
        stringBuffer.append(this.getModelSyntax());
        stringBuffer.append(this.getStatisticsSyntax());
        stringBuffer.append(this.getPlotsSyntax());
        stringBuffer.append(this.getHTestsSyntax());
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(this.getOptionsSyntax());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(this.getPerAttributesSyntax());
        return stringBuffer.toString();
    }

    private String getPerAttributesSyntax() {
        String string;
        String string2 = "";
        PesFile pesFile = PES_Repository.getPesFile((String)this.mExportModelDataFile);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mExportFunctionDataFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mExportModelXMLFile)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    private String getTimeEventSyntax() {
        ISpssVariable iSpssVariable;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        CSCoxRegTimeEventTab cSCoxRegTimeEventTab = this.mCoxRegDlg.getTimeEventTab();
        if (this.mData.getBoolean("IDS_CSCOX_TIME_EVENT_TIME_VARIES").booleanValue() && (iSpssVariable = cSCoxRegTimeEventTab.getStartVar()) != null) {
            stringBuffer2.append(iSpssVariable.getName()).append(" ");
        }
        if ((iSpssVariable = cSCoxRegTimeEventTab.getEndVar()) != null) {
            stringBuffer2.append(iSpssVariable.getName()).append(" ");
        }
        stringBuffer2.append(this.mByWithBuf);
        stringBuffer2.append(this.getPlanFileSyntax());
        stringBuffer2.append(SyntaxUtil.getSubCommand("/VARIABLES"));
        iSpssVariable = cSCoxRegTimeEventTab.getStatusVar();
        if (iSpssVariable != null) {
            stringBuffer2.append(" STATUS=").append(iSpssVariable.getName());
            stringBuffer2.append("(");
            stringBuffer2.append(cSCoxRegTimeEventTab.getSynEventString());
            stringBuffer2.append(") ");
        }
        if ((iSpssVariable = cSCoxRegTimeEventTab.getSubjectVar()) != null) {
            stringBuffer2.append(" ID=").append(iSpssVariable.getName());
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(this.mStrata);
        return stringBuffer.toString();
    }

    private void getPredictorsSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        this.mComputeBuffer = SyntaxUtil.startSyntax();
        this.mByWithBuf = SyntaxUtil.startSyntax();
        ListModel listModel = this.mCoxRegDlg.getFactorsListModel();
        this.getSyntaxByModel(stringBuffer, listModel);
        if (!this.mResult) {
            return;
        }
        if (stringBuffer.length() > 0) {
            this.mByWithBuf.append(" BY");
            this.mByWithBuf.append(stringBuffer);
        }
        listModel = this.mCoxRegDlg.getCovariatesListModel();
        stringBuffer.delete(0, stringBuffer.length());
        this.getSyntaxByModel(stringBuffer, listModel);
        if (!this.mResult) {
            return;
        }
        if (stringBuffer.length() > 0) {
            this.mByWithBuf.append(" WITH");
            this.mByWithBuf.append(stringBuffer);
        }
    }

    private void getSyntaxByModel(StringBuffer stringBuffer, ListModel listModel) {
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)listModel.getElementAt(i);
            if (!(iSpssVariable instanceof TimeDependentPredictors)) {
                stringBuffer.append(" ");
                stringBuffer.append(iSpssVariable.getName());
                continue;
            }
            String string = iSpssVariable.getName();
            TimeDependentPredictors timeDependentPredictors = (TimeDependentPredictors)iSpssVariable;
            if ((string = VarNameValidator.generateUniqueSpssName((String)string, this.mVarNames, (boolean)true)) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mCoxRegDlg), CoreResUtil.getString((String)"ERR_NO_UNIQUE_VAR"), VersionInfo.getAppVersionString());
                this.mResult = false;
                return;
            }
            stringBuffer.append(" ");
            stringBuffer.append(string);
            this.mComputeBuffer.append(SyntaxUtil.getMainCommand("\nCOMPUTE "));
            this.mComputeBuffer.append(string);
            this.mComputeBuffer.append(" = ");
            this.mComputeBuffer.append(timeDependentPredictors.getExpression());
            this.mComputeBuffer.append(".");
        }
    }

    private String getSubgroupsSyntax() {
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        this.mStrata = "";
        String string = "";
        ISpssVariable[] iSpssVariableArray = this.mData.getVarArray("IDS_CSCOX_SBG_STRATA_LST");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0 && (object = iSpssVariableArray[0]) != null) {
            string = object.getName();
            this.mStrata = " BASELINESTRATA=" + string;
        }
        iSpssVariableArray = this.mData.getVarArray("IDS_CSCOX_SBG_SUBPOP_LST");
        object = this.mData.getString("IDS_CSCOX_SBG_SUBPOP_VAL");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0 && object != null && ((String)object).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DOMAIN VARIABLE="));
            ISpssVariable iSpssVariable = iSpssVariableArray[0];
            if (iSpssVariable != null) {
                string = iSpssVariable.getName();
            }
            stringBuffer.append(string);
            object = ((String)object).replace(",", ".");
            stringBuffer.append("(");
            stringBuffer.append((String)object);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getModelSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        CSCoxRegModelTab cSCoxRegModelTab = this.mCoxRegDlg.getModelTab();
        VarListModel varListModel = cSCoxRegModelTab.getFactorsAndCovariates();
        if (varListModel.getSize() > 0) {
            if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_MODEL_MAINEFFECTS_RADIOBUTTON").booleanValue()) {
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    stringBuffer2.append(varListModel.getElementAt(i).getName()).append(" ");
                }
            } else {
                DefaultListModel defaultListModel = cSCoxRegModelTab.getModelTerms();
                for (int i = 0; i < defaultListModel.size(); ++i) {
                    stringBuffer2.append((String)defaultListModel.get(i)).append(" ");
                }
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL "));
                stringBuffer.append(stringBuffer2);
            }
        }
        return stringBuffer.toString();
    }

    private String getStatisticsSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT"));
        Boolean bl = this.mData.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_SAMPLE_CHECKBOX");
        if (bl.booleanValue()) {
            stringBuffer2.append(" SAMPLEINFO");
        }
        if ((bl = this.mData.getBoolean("IDS_CSCOX_STAT_EVENT_CHECK")).booleanValue()) {
            stringBuffer2.append(" EVENTINFO");
        }
        if ((bl = this.mData.getBoolean("IDS_CSCOX_STAT_RISKSET_CHECK")).booleanValue()) {
            stringBuffer2.append(" RISKINFO");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_COVARIANCE_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" COVB");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CORRELATION_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" CORB");
        }
        if ((bl = this.mData.getBoolean("IDS_CSCOX_STAT_BASELINE_CHECK")).booleanValue()) {
            stringBuffer2.append(" BASELINE");
        }
        if (this.mData.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_DISPLAY_ITERATION_CHECKBOX").booleanValue()) {
            stringBuffer2.append(" HISTORY(");
            stringBuffer2.append(this.mData.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_INCREMENT_LABEL"));
            stringBuffer2.append(")");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append(" NONE");
        }
        stringBuffer2.delete(0, stringBuffer2.length());
        bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_ESTIMATE_CHECKBOX");
        if (bl.booleanValue()) {
            stringBuffer2.append(" PARAMETER");
        }
        if ((bl = this.mData.getBoolean("IDS_LOGISTIC_REGRESSION_STATISTICS_EXP_ESTIMATE_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" EXP");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_STD_ERROR_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" SE");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CONFIDENCE_INTERVAL_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" CINTERVAL");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_T_TEST_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" TTEST");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_DESIGN_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" DEFF");
        }
        if ((bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_SQUAREROOT_CHECKBOX")).booleanValue()) {
            stringBuffer2.append(" DEFFSQRT");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
            stringBuffer.append(stringBuffer2);
        }
        if ((bl = this.mData.getBoolean("IDS_CSCOX_STAT_PROPHAZ_CHECK")).booleanValue()) {
            String[] stringArray = new String[]{"KM", "IDENTITY", "LOG", "RANK"};
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TESTASSUMPTIONS"));
            stringBuffer.append(" PROPHAZARD=");
            int n = this.mData.getInteger("TIMEFUNC_COMBO");
            if (n < 0 || n > 3) {
                n = 0;
            }
            stringBuffer.append(stringArray[n]);
            bl = this.mData.getBoolean("IDS_CSCOX_STAT_PARESTIM_CHECK");
            if (bl.booleanValue()) {
                stringBuffer.append(" PARAMETER");
            }
            if ((bl = this.mData.getBoolean("IDS_CSCOX_STAT_COVMATRIX_CHECK")).booleanValue()) {
                stringBuffer.append(" COVB");
            }
        }
        return stringBuffer.toString();
    }

    private String getPlotsSyntax() {
        String string;
        String string2;
        ISpssVariable iSpssVariable;
        int n;
        Comparable<StringBuffer> comparable;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        if (this.mData.getBoolean("IDS_CSCOX_PLOT_SURV_CHECK").booleanValue()) {
            stringBuffer2.append(" SURVIVAL");
        }
        if (this.mData.getBoolean("IDS_CSCOX_PLOT_HAZ_CHECK").booleanValue()) {
            stringBuffer2.append(" CUMHAZARD");
        }
        if (this.mData.getBoolean("IDS_CSCOX_PLOT_LGM_CHECK").booleanValue()) {
            stringBuffer2.append(" LML");
        }
        if (this.mData.getBoolean("IDS_CSCOX_PLOT_ONE_CHECK").booleanValue()) {
            stringBuffer2.append(" OMS");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT"));
            stringBuffer.append(stringBuffer2);
            comparable = this.mData.getBoolean("IDS_CSCOX_PLOT_DISP_CHECK");
            if (comparable != null && ((Boolean)comparable).booleanValue()) {
                stringBuffer.append(" CI=YES");
            } else {
                stringBuffer.append(" CI=NO");
            }
        }
        if (this.mCoxRegDlg.isTdpInPredictors()) {
            return stringBuffer.toString();
        }
        comparable = SyntaxUtil.startSyntax();
        String string3 = this.mData.getString("DM_CSCOX_PLOT_CH_FACTOR");
        String string4 = "";
        HashMap hashMap = (HashMap)this.mData.getObject("DM_CSCOX_PLOT_FACTORS");
        HashMap hashMap2 = (HashMap)this.mData.getObject("DM_CSCOX_PLOT_COVARS");
        String string5 = this.mCoxRegDlg.getResString("IDS_CSCOX_PLOT_HLVL");
        String string6 = this.mCoxRegDlg.getResString("IDS_CSCOX_PLOT_MEAN");
        ListModel listModel = this.mCoxRegDlg.getFactorsListModel();
        int n2 = listModel.getSize();
        for (n = 0; n < n2; ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            string2 = iSpssVariable.getName();
            string = (String)hashMap.get(string2);
            if (string2.equals(string3)) {
                string4 = " BY " + string2;
                continue;
            }
            if (string == null || (string = string.trim()).equals(string5)) continue;
            ((StringBuffer)comparable).append(" ");
            ((StringBuffer)comparable).append(string2);
            ((StringBuffer)comparable).append("(");
            ((StringBuffer)comparable).append(this.quoteValue(string2, string, true));
            ((StringBuffer)comparable).append(")");
        }
        listModel = this.mCoxRegDlg.getCovariatesListModel();
        n2 = listModel.getSize();
        for (n = 0; n < n2; ++n) {
            iSpssVariable = (ISpssVariable)listModel.getElementAt(n);
            string2 = iSpssVariable.getName();
            string = (String)hashMap2.get(string2);
            if (string == null || (string = string.trim()).equals(string6)) continue;
            ((StringBuffer)comparable).append(" ");
            ((StringBuffer)comparable).append(string2);
            ((StringBuffer)comparable).append("(");
            ((StringBuffer)comparable).append(this.quoteValue(string2, string, false));
            ((StringBuffer)comparable).append(")");
        }
        if (((StringBuffer)comparable).length() > 0 || string4.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PATTERN"));
            stringBuffer.append((StringBuffer)comparable);
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    private String getHTestsSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TEST TYPE="));
        if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_F_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("F");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_F_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("ADJF");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_CHISQUARE_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("CHISQUARE");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_ADJUSTED_CHISQUARE_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("ADJCHISQUARE");
        }
        stringBuffer.append(" PADJUST=");
        if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_LEAST_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("LSD");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_SIDAK_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("SEQSIDAK");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SEQUENTIAL_BONFERRONI_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("SEQBONFERRONI");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_SIDAK_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("SIDAK");
        } else if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_BONFERRONI_RADIOBUTTON").booleanValue()) {
            stringBuffer.append("BONFERRONI");
        }
        return stringBuffer.toString();
    }

    private String getSaveSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        this.mDeleteVariables = "";
        boolean bl = this.mCoxRegDlg.getEnableByTDP();
        boolean bl2 = this.mCoxRegDlg.getEnableBySubjectId();
        boolean bl3 = this.mData.getBoolean("IDS_CSCOX_SAV_CUSTOM_RADIO");
        if (bl) {
            StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
            StringBuffer stringBuffer3 = SyntaxUtil.startSyntax();
            Object[] objectArray = this.mData.getSerializableArray("CSCOX_SAV_TABLE");
            if (objectArray != null) {
                int n;
                for (n = 0; n < 13; ++n) {
                    this.addSaveVariable(objectArray, n, stringBuffer2, stringBuffer3, bl3);
                }
                if (bl2) {
                    for (n = 13; n < 18; ++n) {
                        this.addSaveVariable(objectArray, n, stringBuffer2, stringBuffer3, bl3);
                    }
                }
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE"));
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3.length() > 0) {
                StringBuffer stringBuffer4 = SyntaxUtil.startSyntax();
                stringBuffer4.append("\nDELETE VARIABLES");
                stringBuffer4.append(stringBuffer3);
                stringBuffer4.append(".");
                this.mDeleteVariables = stringBuffer4.toString();
            }
        }
        return stringBuffer.toString();
    }

    private void addSaveVariable(Object[] objectArray, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        CSCoxRegSaveVariable cSCoxRegSaveVariable = (CSCoxRegSaveVariable)objectArray[n];
        if (cSCoxRegSaveVariable.isSelected()) {
            stringBuffer.append(" ");
            stringBuffer.append(cSCoxRegSaveVariable.getKeyword());
            if (bl) {
                String string = cSCoxRegSaveVariable.getName().trim();
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(")");
                if (this.mDataSrc.findVarIndex(string) > -1) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string);
                }
                Vector<String> vector = DocUtil.findVariablesWithRootName(string);
                for (String string2 : vector) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string2);
                }
                this.mVarNames.add(string.toLowerCase());
            } else {
                this.mVarNames.add(cSCoxRegSaveVariable.getName().trim().toLowerCase());
            }
        }
    }

    private String getExportSyntax() {
        String string;
        this.mExportModelDataFile = null;
        this.mExportFunctionDataFile = null;
        this.mExportModelXMLFile = null;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer3 = SyntaxUtil.startSyntax();
        if (this.mData.getBoolean("IDS_CSCOX_EXPORT_MODEL_CHECK").booleanValue()) {
            if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_SAVE_PARAMETER_COVARIANCE_SPSS_RADIOBUTTON").booleanValue()) {
                stringBuffer2.append(" COVB=");
            } else {
                stringBuffer2.append(" CORB=");
            }
            if (this.mData.getBoolean("IDS_CSCOX_EXPORT_NEWDS_MOD_RADIO").booleanValue()) {
                string = this.mData.getString("IDS_DATASET_MODEL");
                stringBuffer2.append(CharacterUtil.smartQuote((String)string));
                stringBuffer3.append("\nDATASET DECLARE ");
                stringBuffer3.append(string);
                stringBuffer3.append(".");
            } else {
                this.mExportModelDataFile = this.mData.getString("FILE_PATH_MODEL");
                stringBuffer2.append(CharacterUtil.smartQuote((String)this.mExportModelDataFile));
            }
        }
        if (this.mData.getBoolean("IDS_CSCOX_EXPORT_FUNC_CHECK").booleanValue()) {
            stringBuffer2.append(" SURVIVAL=");
            if (this.mData.getBoolean("IDS_CSCOX_EXPORT_NEWDS_FUNC_RADIO").booleanValue()) {
                string = this.mData.getString("IDS_DATASET_FUNC");
                stringBuffer2.append(CharacterUtil.smartQuote((String)string));
                stringBuffer3.append("\nDATASET DECLARE ");
                stringBuffer3.append(string);
                stringBuffer3.append(".");
            } else {
                this.mExportFunctionDataFile = this.mData.getString("FILE_PATH_FUNC");
                stringBuffer2.append(CharacterUtil.smartQuote((String)this.mExportFunctionDataFile));
            }
        }
        if (this.mData.getBoolean("IDS_CSCOX_EXPORT_XML_CHECK").booleanValue()) {
            stringBuffer2.append(" MODEL=");
            this.mExportModelXMLFile = this.mData.getString("FILE_PATH_XML");
            stringBuffer2.append(CharacterUtil.smartQuote((String)this.mExportModelXMLFile));
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
            stringBuffer.append(stringBuffer2);
        }
        this.mDatasetDeclare = stringBuffer3.toString();
        return stringBuffer.toString();
    }

    private String getOptionsSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String[] stringArray = new String[]{" RELATIVE]", " ABSOLUTE]"};
        String[] stringArray2 = new String[]{"LOG", "LML"};
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        Boolean bl = this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_FIXED_RADIOBUTTON");
        String string2 = this.mData.getString("IDS_COMPLEX_SAMPLES_COMMON_HYPOTHESIS_VALUE_LABEL");
        if (bl != null && bl.booleanValue() && string2 != null) {
            stringBuffer.append(" DF=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(" MXITER=");
        stringBuffer.append(this.mData.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_ITERATION_LABEL"));
        stringBuffer.append(" MXSTEP=");
        stringBuffer.append(this.mData.getString("IDS_LOGISTIC_REGRESSION_OPTIONS_MAX_STEP_LABEL"));
        stringBuffer.append(" PCONVERGE=[");
        if (this.mData.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_PARA_ESTIMATES_CHECKBOX").booleanValue()) {
            string = this.mData.getString("MIN_CHANGE_PARAMETER_KEY");
            stringBuffer.append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString(string, this.mPrecision));
            stringBuffer.append(stringArray[this.mData.getInteger("TYPE_PARAMETER_KEY")]);
        } else {
            stringBuffer.append("0]");
        }
        stringBuffer.append(" LCONVERGE=[");
        if (this.mData.getBoolean("IDS_LOGISTIC_REGRESSION_OPTIONS_LIMIT_ITERATIONS_LOG_CHECKBOX").booleanValue()) {
            string = this.mData.getString("MIN_CHANGE_LOG_KEY");
            stringBuffer.append(ComplexSamplesCommonSyntaxUtils.formattedSyntaxString(string, this.mPrecision));
            stringBuffer.append(stringArray[this.mData.getInteger("TYPE_LOG_KEY")]);
        } else {
            stringBuffer.append("0]");
        }
        if (this.mData.getBoolean("IDS_CSCOX_OPT_TIE_EFRON_RADIO").booleanValue()) {
            stringBuffer.append(" TIES=EFRON");
        } else {
            stringBuffer.append(" TIES=BRESLOW");
        }
        stringBuffer.append(" CILEVEL=");
        stringBuffer.append(this.mData.getString("CONFIDENCE_TEXT_KEY"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/SURVIVALMETHOD"));
        stringBuffer.append(" BASELINE=");
        if (this.mData.getBoolean("IDS_CSCOX_OPT_MET_EFRON_RADIO").booleanValue()) {
            stringBuffer.append("EFRON");
        } else if (this.mData.getBoolean("IDS_CSCOX_OPT_MET_BRESLOW_RADIO").booleanValue()) {
            stringBuffer.append("BRESLOW");
        } else {
            stringBuffer.append("PRODUCTLIMIT");
        }
        stringBuffer.append(" CI=");
        if (this.mData.getBoolean("IDS_CSCOX_OPT_CONF_TRANS_RADIO").booleanValue()) {
            stringBuffer.append(stringArray2[this.mData.getInteger("CONF_TRANSFORMATION")]);
        } else {
            stringBuffer.append("ORIGINAL");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING"));
        if (this.mData.getBoolean("IDS_COMPLEX_SAMPLES_COMMON_OPTIONS_INVALID_RADIOBUTTON").booleanValue()) {
            stringBuffer.append(" CLASSMISSING=EXCLUDE");
        } else {
            stringBuffer.append(" CLASSMISSING=INCLUDE");
        }
        return stringBuffer.toString();
    }

    private String getPlanFileSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLAN FILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)ComplexSamplesPlan.getSelectedPlanFileName()));
        String string = ComplexSamplesPlan.getJointProbalityValue();
        if (string != null) {
            stringBuffer.append("\n");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String quoteValue(String string, String string2, boolean bl) {
        ISpssVariable iSpssVariable = this.mDataSrc.getVariable(this.mDataSrc.findVarIndex(string));
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        string2 = string2.replace(",", ".");
        if (iSpssVariable.getType() > 0 && bl || formatType.isCurrencyFormat() || formatType.isDateOrTimeFormat()) {
            return CharacterUtil.smartQuote((String)string2);
        }
        return string2;
    }

    public static String quoteValue(ISpssVariable iSpssVariable, String string) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        string = string.replace(",", ".");
        if (iSpssVariable.getType() > 0 || formatType.isCurrencyFormat() || formatType.isDateOrTimeFormat()) {
            return CharacterUtil.smartQuote((String)string);
        }
        return string;
    }
}

