/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSPlanCoxRegDlg;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CSCoxRegSubgroupsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener,
ListDataListener {
    private SrcVariableList mSrcVarList;
    public TargetVariableList mTargetListStrata;
    private TargetVariableList mTargetListSubpop;
    public JComboBox mCategoryCombo;
    public Object mComboValue = null;
    private HashMap<String, String> mCategoryMap = new HashMap();
    private ArrowButton mStrataArrowButton;
    private ArrowButton mSubpopArrowButton;
    private JTextArea mStrataTextArea;
    private JTextArea mSubpopTextArea;
    private IVarMoveHandler mMoveHandler;

    public CSCoxRegSubgroupsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetListSubpop.getModel()) {
            this.mCategoryCombo.setEnabled(true);
            ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSCoxRegSubgroupsTab.this.mCategoryCombo.setModel(CSCoxRegSubgroupsTab.this.fillCategoryCombo());
                    ISpssVariable iSpssVariable = (ISpssVariable)CSCoxRegSubgroupsTab.this.mTargetListSubpop.getSelectedValue();
                    if (iSpssVariable.getType() >= 1) {
                        short s = iSpssVariable.getFormat().getWidth();
                        FixedLengthDocument fixedLengthDocument = new FixedLengthDocument(s);
                        ((JTextField)CSCoxRegSubgroupsTab.this.mCategoryCombo.getEditor().getEditorComponent()).setDocument(fixedLengthDocument);
                    }
                    CSCoxRegSubgroupsTab.this.mCategoryCombo.setSelectedItem(CSCoxRegSubgroupsTab.this.mComboValue);
                }
            });
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetListSubpop.getModel()) {
            ((DefaultComboBoxModel)this.mCategoryCombo.getModel()).removeAllElements();
            this.mCategoryCombo.setSelectedItem("");
            this.mComboValue = null;
            this.mCategoryCombo.setEnabled(false);
            ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(false);
            ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).setDocument(new JTextField().getDocument());
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.mCategoryCombo.getSelectedItem();
        if (string != null && string.trim().length() > 0) {
            this.mComboValue = this.mCategoryCombo.getSelectedItem();
            String string2 = this.mCategoryMap.get(string);
            if (string2 != null) {
                this.mCategoryCombo.setSelectedItem(string2);
            }
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_subgroups";
    }

    @Override
    public boolean validateTab() {
        if (this.mTargetListSubpop.getModel().getSize() > 0) {
            String string = ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).getText();
            if (string == null || string.length() < 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_MSG"), VersionInfo.getAppVersionString());
                this.mCategoryCombo.requestFocus();
                return false;
            }
            OBS oBS = new OBS();
            ISpssVariable iSpssVariable = this.mTargetListSubpop.getModel().getElementAt(0);
            if (!CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_INCONSISTENT_CATEGORY_VALUE"), VersionInfo.getAppVersionString());
                this.mCategoryCombo.requestFocus();
                ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).selectAll();
                return false;
            }
        }
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    public boolean isMisValuePresent() {
        boolean bl = false;
        if (this.mTargetListSubpop.getModel().getSize() > 0) {
            this.mTargetListSubpop.setSelectedIndex(0);
            ISpssVariable iSpssVariable = (ISpssVariable)this.mTargetListSubpop.getSelectedValue();
            String string = ((JTextField)this.mCategoryCombo.getEditor().getEditorComponent()).getText();
            bl = ((CSCoxRegressionDlg)this.mParent).isUserMissingValue(iSpssVariable, string);
        }
        return bl;
    }

    public void resetMisValue() {
        int n = this.mTargetListSubpop.getModel().getSize();
        if (n == 1) {
            this.mSrcVarList.getModel().addElement(this.mTargetListSubpop.getModel().getElementAt(0));
            this.mTargetListSubpop.removeAll();
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        if (this.mTargetListSubpop.getModel().getSize() > 0) {
            dialogDataModel.putString("IDS_CSCOX_SBG_SUBPOP_VAL", this.getSelectedValueOfCategoryCombo());
            dialogDataModel.putString("IDS_CSCOX_SBG_SUBPOP_COMVAL", (String)this.mCategoryCombo.getSelectedItem());
        }
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        if (dialogDataModel.getString("IDS_CSCOX_SBG_SUBPOP_COMVAL") != null) {
            this.mComboValue = dialogDataModel.getString("IDS_CSCOX_SBG_SUBPOP_COMVAL");
        }
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        Component component = ((CSCoxRegressionDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetListStrata, this.mMoveHandler));
            dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTargetListSubpop, this.mMoveHandler));
        }
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        int n3 = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_VARIABLES_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_SBG_STRATA_TITLE");
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_SBG_SUBPOP_TITLE");
        JLabel jLabel4 = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MAIN_DIALOG_SUBPOPULATION_CATEGORY_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        jLabel2.setLabelFor(this.mTargetListStrata);
        JScrollPane jScrollPane = new JScrollPane(this.mTargetListStrata);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mTargetListStrata.getMinimumSize());
        jLabel3.setLabelFor(this.mTargetListSubpop);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetListSubpop);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mTargetListSubpop.getMinimumSize());
        jLabel4.setLabelFor(this.mCategoryCombo);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSrcVarList);
        jScrollPane3.setPreferredSize(this.mSrcVarList.getMinimumSize());
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(n2, 0, 0, 0);
        insets2.set(n * 2, insets.left, 0, insets.right);
        Insets insets3 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(insets3.top, insets3.left, insets3.bottom, n * 2);
        DialogUtil.addUsingGBL(this, jScrollPane3, gridBagConstraints, 0, 1, 1, 10, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n * 2, insets3.left, 0, n * 2);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets3.top, insets3.left, n, n * 3);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n3, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n, insets3.left, 0, n * 2);
        DialogUtil.addUsingGBL(this, jLabel3, gridBagConstraints, 2, 3, 1, 1, n3, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets3.top, insets3.left, n, n * 3);
        DialogUtil.addUsingGBL(this, jScrollPane2, gridBagConstraints, 2, 4, 1, 1, n3, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n, insets3.left, 0, n * 2);
        DialogUtil.addUsingGBL(this, jLabel4, gridBagConstraints, 2, 5, 1, 1, n3, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets3.top, insets3.left, n * 2, n * 3);
        DialogUtil.addUsingGBL(this, this.mCategoryCombo, gridBagConstraints, 2, 6, 1, 1, n3, insets2);
        insets2.set(n * 3, n * 3, n, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.mStrataArrowButton, gridBagConstraints, 1, 0, 1, 2, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(n, n * 3, n, insets.right);
        DialogUtil.addUsingGBL(this, this.mStrataTextArea, gridBagConstraints, 1, 2, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(n * 2, n * 3, n, insets.right);
        DialogUtil.addUsingGBL(this, this.mSubpopArrowButton, gridBagConstraints, 1, 3, 1, 2, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(n, n * 3, n, insets.right);
        DialogUtil.addUsingGBL(this, this.mSubpopTextArea, gridBagConstraints, 1, 7, 2, 1, n3, insets2);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mStrataArrowButton);
        vector.add(this.mTargetListStrata);
        vector.add(this.mSubpopArrowButton);
        vector.add(this.mTargetListSubpop);
        vector.add(this.mCategoryCombo);
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new srcSubListFilter());
        this.mTargetListStrata = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetListStrata.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetListStrata.getFixedCellHeight() + 1));
        this.mTargetListStrata.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetListStrata.getFixedCellHeight() + 1));
        this.mTargetListStrata.getModel().addListDataListener(this);
        this.mTargetListSubpop = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetListSubpop.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetListSubpop.getFixedCellHeight() + 1));
        this.mTargetListSubpop.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetListSubpop.getFixedCellHeight() + 1));
        this.mTargetListSubpop.getModel().addListDataListener(this);
        this.mCategoryCombo = new JComboBox();
        this.mCategoryCombo.setEditable(true);
        this.mCategoryCombo.addItemListener(this);
        this.mCategoryCombo.setPreferredSize(this.mTargetListSubpop.getMinimumSize());
        this.mStrataArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStrataArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStrataArrowButton.registerVariableList(this.mTargetListStrata, SpssArrowButton.ButtonOrientation.left);
        this.mMoveHandler = new TargetMoveHandler(this.mParent);
        this.mStrataArrowButton.setVarMoveHandler(this.mMoveHandler);
        this.mSubpopArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubpopArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubpopArrowButton.registerVariableList(this.mTargetListSubpop, SpssArrowButton.ButtonOrientation.left);
        this.mStrataTextArea = new JTextArea(this.getResString("IDS_CSCOX_SBG_STRATA_NOTE"));
        this.mSubpopTextArea = new JTextArea(this.getResString("IDS_CSCOX_SBG_SUBPOP_NOTE"));
        this.mStrataTextArea.setOpaque(false);
        this.mStrataTextArea.setLineWrap(true);
        this.mStrataTextArea.setWrapStyleWord(true);
        this.mStrataTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mStrataTextArea.setBackground(this.getBackground());
        this.mStrataTextArea.setEditable(false);
        this.mStrataTextArea.setRows(2);
        this.mStrataTextArea.setFocusable(false);
        this.mStrataTextArea.setPreferredSize(new Dimension(this.mTargetListStrata.getPreferredSize().width, this.mStrataTextArea.getHeight()));
        this.mSubpopTextArea.setOpaque(false);
        this.mSubpopTextArea.setLineWrap(true);
        this.mSubpopTextArea.setWrapStyleWord(true);
        this.mSubpopTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.mSubpopTextArea.setBackground(this.getBackground());
        this.mSubpopTextArea.setEditable(false);
        this.mSubpopTextArea.setRows(2);
        this.mSubpopTextArea.setFocusable(false);
        this.mSubpopTextArea.setPreferredSize(new Dimension(this.mTargetListStrata.getPreferredSize().width, this.mSubpopTextArea.getHeight()));
        this.setIdentifiers();
    }

    public void setIdentifiers() {
        this.mSrcVarList.setIdentifier("IDS_CSCOX_SBG_SRC_LST");
        this.mTargetListStrata.setIdentifier("IDS_CSCOX_SBG_STRATA_LST");
        this.mTargetListSubpop.setIdentifier("IDS_CSCOX_SBG_SUBPOP_LST");
    }

    public String getSelectedValueOfCategoryCombo() {
        String string = UIToolResUtil.removeLocale((String)((String)this.mCategoryCombo.getSelectedItem()));
        if (this.mTargetListSubpop.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = (ISpssVariable)this.mTargetListSubpop.getSelectedValue();
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            FormatType formatType = sPSS_Format.getFormatType();
            if (iSpssVariable.getType() > 0 || iSpssVariable.getType() == 0 && formatType.isCurrencyFormat() || iSpssVariable.getType() == 0 && formatType.isDateOrTimeFormat()) {
                if (string.trim().length() > 0) {
                    StringBuffer stringBuffer = new StringBuffer("''");
                    stringBuffer.insert(1, string);
                    return stringBuffer.toString();
                }
                return "";
            }
            return string;
        }
        return "";
    }

    private void setDefaults() {
        ((DefaultComboBoxModel)this.mCategoryCombo.getModel()).removeAllElements();
        this.mCategoryCombo.setEnabled(false);
        ((JComponent)this.mCategoryCombo.getEditor().getEditorComponent()).setOpaque(false);
        this.mTargetListStrata.removeAll();
        this.mTargetListSubpop.removeAll();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setModel(((CSCoxRegressionDlg)this.mParent).getSrcListModel());
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    private DefaultComboBoxModel fillCategoryCombo() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        if (this.mTargetListSubpop.getModel().getSize() > 0) {
            this.mTargetListSubpop.setSelectedIndex(0);
            this.mCategoryMap.clear();
            ISpssVariable iSpssVariable = (ISpssVariable)this.mTargetListSubpop.getSelectedValue();
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            FormatType formatType = sPSS_Format.getFormatType();
            boolean bl = formatType.isStringFormat();
            Set set = iValueLabelMap.getValueLabelEntries();
            if (set.size() > 0) {
                boolean bl2 = !((CSCoxRegressionDlg)this.mParent).isUserMissingIncluded();
                for (Map.Entry entry : set) {
                    OBS oBS = (OBS)entry.getKey();
                    if (bl2 && iSpssVariable.isMissing(oBS)) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = bl ? CharacterUtil.rightTrim((String)oBS.getString()) : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                    stringBuffer.append((String)entry.getValue());
                    defaultComboBoxModel.addElement(stringBuffer.toString());
                    this.mCategoryMap.put(stringBuffer.toString(), string);
                }
            }
        }
        return defaultComboBoxModel;
    }

    class CSCoxRegSubgroupsMoveHandler
    implements IVarMoveHandler {
        CSCoxRegSubgroupsMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            return true;
        }
    }

    public static class TargetMoveHandler
    implements IVarMoveHandler {
        private BaseDialog mParent;

        public TargetMoveHandler(BaseDialog baseDialog) {
            this.mParent = baseDialog;
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                String string = iSpssVariableArray[i].getName();
                if (!CSPlanCoxRegDlg.isPlanVariable(string)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.mParent.getResString("ERR_CSCOX_SBG_PLAN_ERR"), VersionInfo.getAppVersionString());
                return false;
            }
            return true;
        }
    }

    private class srcSubListFilter
    implements IVarFilter {
        private srcSubListFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            return true;
        }
    }
}

