/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.complex_samples.cox_reg;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegressionDlg;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CSCoxRegStatsTab
extends BaseProcedureTab
implements ItemListener {
    public static final String TIME_FUNCTION = "TIMEFUNC_COMBO";
    private JCheckBox mSampleDesignCheckBox;
    private JCheckBox mEventCheckBox;
    private JCheckBox mRiskSetCheckBox;
    private JCheckBox mEstimateCheckBox;
    private JCheckBox mExponentiatedCheckBox;
    private JCheckBox mStdErrorCheckBox;
    private JCheckBox mConfIntervalCheckBox;
    private JCheckBox mTCheckBox;
    private JCheckBox mCovarianceCheckBox;
    private JCheckBox mCorrelationsCheckBox;
    private JCheckBox mDesignCheckBox;
    private JCheckBox mSquareRootCheckBox;
    private JPanel mModelAssumPanel;
    private JCheckBox mTestOfHazardsCheckBox;
    private JLabel mTimeFunctionLabel;
    private JComboBox mTimeFunctionCombo;
    private JCheckBox mParEstimatesCheckBox;
    private JCheckBox mCovMatrixCheckBox;
    private JCheckBox mBaselineCheckBox;
    private Vector<Object> mFocus;

    public CSCoxRegStatsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mTestOfHazardsCheckBox)) {
            boolean bl = this.mTestOfHazardsCheckBox.isSelected();
            this.mTimeFunctionLabel.setEnabled(bl);
            this.mTimeFunctionCombo.setEnabled(bl);
            this.mParEstimatesCheckBox.setEnabled(bl);
            this.mCovMatrixCheckBox.setEnabled(bl);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cscoxreg_statistics";
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSampleDesignCheckBox;
    }

    private void initializePanel() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(this, this.setupUpperPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupParametersPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupModelAssumPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, this.setupBottomPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupUpperPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSampleDesignCheckBox, this.mEventCheckBox, this.mRiskSetCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, "", 3);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupParametersPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mEstimateCheckBox, this.mExponentiatedCheckBox, this.mStdErrorCheckBox, this.mConfIntervalCheckBox, this.mTCheckBox, this.mCovarianceCheckBox, this.mCorrelationsCheckBox, this.mDesignCheckBox, this.mSquareRootCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_LOGISTIC_REGRESSION_STATISTICS_PARAMETERS_LABEL"), 5);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupModelAssumPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2 + n3, 0, 0);
        Insets insets3 = new Insets(insets.top, n2 + n3, 0, 0);
        this.mTimeFunctionLabel.setLabelFor(this.mTimeFunctionCombo);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        jPanel.add(this.mTimeFunctionLabel);
        jPanel.add(Box.createHorizontalStrut(DialogUtil.getMainButtonGap()));
        jPanel.add(this.mTimeFunctionCombo);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mModelAssumPanel, this.mTestOfHazardsCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelAssumPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mModelAssumPanel, this.mParEstimatesCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mModelAssumPanel, this.mCovMatrixCheckBox, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return this.mModelAssumPanel;
    }

    private JPanel setupBottomPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mBaselineCheckBox};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, "", 1);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        this.mFocus.add(this.mSampleDesignCheckBox);
        this.mFocus.add(this.mEventCheckBox);
        this.mFocus.add(this.mRiskSetCheckBox);
        this.mFocus.add(this.mEstimateCheckBox);
        this.mFocus.add(this.mExponentiatedCheckBox);
        this.mFocus.add(this.mStdErrorCheckBox);
        this.mFocus.add(this.mConfIntervalCheckBox);
        this.mFocus.add(this.mTCheckBox);
        this.mFocus.add(this.mCovarianceCheckBox);
        this.mFocus.add(this.mCorrelationsCheckBox);
        this.mFocus.add(this.mDesignCheckBox);
        this.mFocus.add(this.mSquareRootCheckBox);
        this.mFocus.add(this.mTestOfHazardsCheckBox);
        this.mFocus.add(this.mTimeFunctionCombo);
        this.mFocus.add(this.mParEstimatesCheckBox);
        this.mFocus.add(this.mCovMatrixCheckBox);
        this.mFocus.add(this.mBaselineCheckBox);
        JPanel jPanel = ((CSCoxRegressionDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mFocus.add(component);
        }
        this.setComponentOrder(this.mFocus);
    }

    private void initVars() {
        this.mFocus = new Vector();
        this.mSampleDesignCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_LOGISTIC_REGRESSION_STATISTICS_SAMPLE_CHECKBOX", null);
        this.mEventCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_EVENT_CHECK", null);
        this.mRiskSetCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_RISKSET_CHECK", null);
        this.mEstimateCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_ESTIMATE_CHECKBOX", null);
        this.mExponentiatedCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_LOGISTIC_REGRESSION_STATISTICS_EXP_ESTIMATE_CHECKBOX", null);
        this.mStdErrorCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_STD_ERROR_CHECKBOX", null);
        this.mConfIntervalCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CONFIDENCE_INTERVAL_CHECKBOX", null);
        this.mTCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_T_TEST_CHECKBOX", null);
        this.mCovarianceCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_COVARIANCE_CHECKBOX", null);
        this.mCorrelationsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_CORRELATION_CHECKBOX", null);
        this.mDesignCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_DESIGN_CHECKBOX", null);
        this.mSquareRootCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_STATISTICS_SQUAREROOT_CHECKBOX", null);
        this.mModelAssumPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_CSCOX_STAT_MODEL_LABEL"));
        this.mTestOfHazardsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_PROPHAZ_CHECK", null);
        this.mTestOfHazardsCheckBox.addItemListener(this);
        this.mTimeFunctionLabel = DialogUtil.createLabel(this.mParent, "IDS_CSCOX_STAT_TIMEFUNC_LABEL");
        ComboboxAction comboboxAction = new ComboboxAction(this.mParent, TIME_FUNCTION);
        this.mTimeFunctionCombo = new JComboBox<String>(this.getResStringArray("IDS_CSCOX_STAT_TIMEFUNC_COMBO"));
        this.mTimeFunctionCombo.setAction(comboboxAction);
        this.mParEstimatesCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_PARESTIM_CHECK", null);
        this.mCovMatrixCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_COVMATRIX_CHECK", null);
        this.mBaselineCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_CSCOX_STAT_BASELINE_CHECK", null);
    }

    private void setDefaults() {
        this.mSampleDesignCheckBox.setSelected(true);
        this.mEventCheckBox.setSelected(true);
        this.mTimeFunctionLabel.setEnabled(false);
        this.mTimeFunctionCombo.setSelectedIndex(0);
        this.mTimeFunctionCombo.setEnabled(false);
        this.mParEstimatesCheckBox.setEnabled(false);
        this.mCovMatrixCheckBox.setEnabled(false);
        this.mRiskSetCheckBox.setSelected(false);
        this.mEstimateCheckBox.setSelected(false);
        this.mExponentiatedCheckBox.setSelected(false);
        this.mStdErrorCheckBox.setSelected(false);
        this.mConfIntervalCheckBox.setSelected(false);
        this.mTCheckBox.setSelected(false);
        this.mCovarianceCheckBox.setSelected(false);
        this.mCorrelationsCheckBox.setSelected(false);
        this.mDesignCheckBox.setSelected(false);
        this.mSquareRootCheckBox.setSelected(false);
        this.mTestOfHazardsCheckBox.setSelected(false);
        this.mParEstimatesCheckBox.setSelected(false);
        this.mCovMatrixCheckBox.setSelected(false);
        this.mBaselineCheckBox.setSelected(false);
    }
}

